/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.config;

import com.google.common.collect.Lists;
import jackiecrazy.footwork.config.DisplayConfigUtils;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.client.ClientEvents;
import jackiecrazy.wardance.config.GeneralConfig;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfig {
    public static final ClientConfig CONFIG;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static int spiritColor;
    public static int mightColor;
    public static int autoCombat;
    public static ResourceLocation shout;
    public final DisplayConfigUtils.DisplayData might;
    public final DisplayConfigUtils.DisplayData mightNumber;
    public final DisplayConfigUtils.DisplayData spirit;
    public final DisplayConfigUtils.DisplayData spiritNumber;
    public final DisplayConfigUtils.DisplayData combo;
    public final DisplayConfigUtils.DisplayData playerAfflict;
    public final DisplayConfigUtils.DisplayData enemyAfflict;
    public final DisplayConfigUtils.DisplayData stealth;
    public final PostureData playerPosture;
    public final PostureData enemyPosture;
    private final ForgeConfigSpec.IntValue _autoCombat;
    private final ForgeConfigSpec.ConfigValue<String> _mightColor;
    private final ForgeConfigSpec.ConfigValue<String> _spiritColor;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> _customPosture;

    public ClientConfig(ForgeConfigSpec.Builder b) {
        b.push("convenience");
        this._autoCombat = b.translation("wardance.config.autoCombat").comment("combat mode will be automatically engaged once you attack or get attacked by an entity if it is not already on, for this number of ticks before turning itself off. Set to 0 to disable this feature.").defineInRange("auto combat mode", 260, 0, Integer.MAX_VALUE);
        b.pop();
        b.push("might");
        this.might = new DisplayConfigUtils.DisplayData(b, "might", DisplayConfigUtils.AnchorPoint.BOTTOMLEFT, 64, -16);
        this.mightNumber = new DisplayConfigUtils.DisplayData(b, "might number", DisplayConfigUtils.AnchorPoint.BOTTOMLEFT, 64, -38);
        this._mightColor = b.translation("wardance.config.mightC").comment("might color in hexadecimal").define("might color", (Object)"ccac00");
        b.pop();
        b.push("spirit");
        this.spirit = new DisplayConfigUtils.DisplayData(b, "spirit", DisplayConfigUtils.AnchorPoint.BOTTOMRIGHT, -64, -16);
        this.spiritNumber = new DisplayConfigUtils.DisplayData(b, "spirit number", DisplayConfigUtils.AnchorPoint.BOTTOMRIGHT, -64, -38);
        this._spiritColor = b.translation("wardance.config.spiritC").comment("spirit color in hexadecimal").define("spirit color", (Object)"00e3e3");
        b.pop();
        b.push("combo");
        this.combo = new DisplayConfigUtils.DisplayData(b, "combo", DisplayConfigUtils.AnchorPoint.MIDDLERIGHT, -40, -32);
        b.pop();
        b.push("player posture");
        this.playerPosture = new PostureData(b, "player posture", DisplayConfigUtils.AnchorPoint.BOTTOMCENTER, 0, -57);
        b.pop();
        b.push("enemy posture");
        this.enemyPosture = new PostureData(b, "target posture", DisplayConfigUtils.AnchorPoint.TOPCENTER, 0, 20);
        b.pop();
        b.push("your afflictions");
        this.playerAfflict = new DisplayConfigUtils.DisplayData(b, "your marks", DisplayConfigUtils.AnchorPoint.CROSSHAIR, 0, 18);
        b.pop();
        b.push("target afflictions");
        this.enemyAfflict = new DisplayConfigUtils.DisplayData(b, "target marks", DisplayConfigUtils.AnchorPoint.CROSSHAIR, 0, -18);
        b.pop();
        b.push("stealth");
        this.stealth = new DisplayConfigUtils.DisplayData(b, "stealth", DisplayConfigUtils.AnchorPoint.CROSSHAIR, 0, 0);
        b.pop();
        this._customPosture = b.translation("wardance.config.postureMobs").comment("whether a mob is rotated when it is staggered.").defineList("mob stagger rotation", (List)Lists.newArrayList((Object[])new String[]{"example:dragon, false", "example:ghast, true"}), String.class::isInstance);
    }

    public static void bake() {
        ClientConfig.CONFIG.might.bake();
        ClientConfig.CONFIG.spiritNumber.bake();
        ClientConfig.CONFIG.spirit.bake();
        ClientConfig.CONFIG.mightNumber.bake();
        ClientConfig.CONFIG.combo.bake();
        ClientConfig.CONFIG.playerPosture.bake();
        ClientConfig.CONFIG.enemyAfflict.bake();
        ClientConfig.CONFIG.enemyPosture.bake();
        ClientConfig.CONFIG.playerAfflict.bake();
        ClientConfig.CONFIG.stealth.bake();
        spiritColor = Integer.parseInt((String)ClientConfig.CONFIG._spiritColor.get(), 16);
        mightColor = Integer.parseInt((String)ClientConfig.CONFIG._mightColor.get(), 16);
        autoCombat = (Integer)ClientConfig.CONFIG._autoCombat.get();
        ClientEvents.updateList((List)ClientConfig.CONFIG._customPosture.get());
    }

    @SubscribeEvent
    public static void loadConfig(ModConfig.ModConfigEvent e) {
        if (e.getConfig().getSpec() == CONFIG_SPEC) {
            if (GeneralConfig.debug) {
                WarDance.LOGGER.debug("loading client config!");
            }
            ClientConfig.bake();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CONFIG = (ClientConfig)specPair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public static class PostureData
    extends DisplayConfigUtils.DisplayData {
        private final ForgeConfigSpec.EnumValue<BarType> _bar;
        public BarType bar;

        private PostureData(ForgeConfigSpec.Builder b, String s, DisplayConfigUtils.AnchorPoint ap, int defX, int defY) {
            super(b, s, ap, defX, defY);
            this._bar = b.translation("wardance.config." + s + "Type").comment("Determine which type of posture bar will be rendered. Valid values are 'classic' (ugly), 'amo' (minimalist), and 'darkmega' (default).").defineEnum(s + " style", (Enum)BarType.DARKMEGA);
        }

        public void bake() {
            super.bake();
            this.bar = (BarType)((Object)this._bar.get());
        }
    }

    public static enum BarType {
        CLASSIC,
        AMO,
        DARKMEGA;

    }
}

