/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.config;

import com.google.common.collect.Lists;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.config.GeneralConfig;
import jackiecrazy.wardance.utils.CombatUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="wardance", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ItemConfig {
    public static final ItemConfig CONFIG;
    public static final ForgeConfigSpec CONFIG_SPEC;
    private static final String[] THANKS_DARKMEGA;
    private static final String[] UNARMED;
    private static final String[] ARMOR;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> _combatItems;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> _customArmor;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> _unarmed;

    public ItemConfig(ForgeConfigSpec.Builder b) {
        this._combatItems = b.translation("wardance.config.combatItems").comment("Items eligible for parrying. Format should be name, attack posture consumption, defense multiplier, is shield. If the item is a shield, the next two numbers are their barrier cooldown and barrier size (as a decimal percentage of max posture); if the item is a weapon, the next two numbers are distracted stab damage bonus and unaware stab damage bonus. Set defense multiplier to a negative value to disable parrying with that item, and attack posture to a negative value to have it deal that posture while ignoring parries. Default values provided graciously by DarkMega, thank you!").defineList("combat items", Arrays.asList(THANKS_DARKMEGA), String.class::isInstance);
        this._customArmor = b.translation("wardance.config.armorItems").comment("define protective stats of armor here. Format is item, absorption, deflection, shatter, stealth (generally negative).").defineList("custom protection attributes", (List)Lists.newArrayList((Object[])ARMOR), String.class::isInstance);
        this._unarmed = b.translation("wardance.config.unarmedItems").comment("Items added to this list will count as unarmed for combat purposes.").defineList("unarmed items", (List)Lists.newArrayList((Object[])UNARMED), String.class::isInstance);
    }

    private static void bake() {
        CombatUtils.updateItems((List)ItemConfig.CONFIG._combatItems.get(), (List)ItemConfig.CONFIG._customArmor.get(), (List)ItemConfig.CONFIG._unarmed.get());
    }

    @SubscribeEvent
    public static void loadConfig(ModConfig.ModConfigEvent e) {
        if (e.getConfig().getSpec() == CONFIG_SPEC) {
            if (GeneralConfig.debug) {
                WarDance.LOGGER.debug("loading item config!");
            }
            ItemConfig.bake();
        }
    }

    static {
        THANKS_DARKMEGA = new String[]{"example:sword, 3.5, 1.5, false, 1.25, 1.5", "example:shield, 0.3, 0.6, true, 20, 1", "minecraft:bow, 1.2, 1.6, false, 1.0, 1.0", "minecraft:crossbow, 2.0, 1.5, true, 20, 0.1", "minecraft:diamond_axe, 3.6, 0.8, false, 1.1, 1.2", "minecraft:diamond_hoe, 0.35, 1.4, false, 1.4, 2", "minecraft:diamond_pickaxe, 1.6, 1, false, 1.4, 2", "minecraft:diamond_shovel, 2.6, 0.9, false, 1.1, 1.2", "minecraft:diamond_sword, 1.5, 1, false, 1.25, 1.5", "minecraft:end_rod, 0.7, 1.0, false, 1.0, 1.0", "minecraft:flint_and_steel, 0.5, 2.0, false, 1.0, 1.0", "minecraft:golden_axe, 3.4, 0.8, false, 1.1, 1.2", "minecraft:golden_hoe, 0.3, 1.4, false, 1.4, 2", "minecraft:golden_pickaxe, 1.4, 1, false, 1.4, 2", "minecraft:golden_shovel, 2.0, 0.9, false, 1.1, 1.2", "minecraft:golden_sword, 1.4, 1, false, 1.25, 1.5", "minecraft:iron_axe, 3.4, 0.8, false, 1.1, 1.2", "minecraft:iron_hoe, 0.3, 1.4, false, 1.4, 2", "minecraft:iron_pickaxe, 1.5, 1, false, 1.4, 2", "minecraft:iron_shovel, 2.4, 0.9, false, 1.1, 1.2", "minecraft:iron_sword, 1.4, 1, false, 1.25, 1.5", "minecraft:lantern, 1.2, 0.9, false, 1.0, 1.0", "minecraft:netherite_axe, 3.8, 0.8, false, 1.1, 1.2", "minecraft:netherite_hoe, 0.4, 1.4, false, 1.4, 2.0", "minecraft:netherite_pickaxe, 1.7, 1, false, 1.4, 2.0", "minecraft:netherite_shovel, 2.8, 0.9, false, 1.1, 1.2", "minecraft:netherite_sword, 1.6, 1, false, 1.25, 1.5", "minecraft:redstone_torch, 0.5, 1.2, false, 1.0, 1.0", "minecraft:shield, 2.5, 0.8, true, 50, 0.3", "minecraft:soul_lantern, 1.2, 0.8, false, 1.0, 1.0", "minecraft:stone_axe, 3.2, 0.9, false, 1.1, 1.2", "minecraft:stone_hoe, 0.25, 1.4, false, 1.4, 2", "minecraft:stone_pickaxe, 1.4, 1, false, 1.4, 2", "minecraft:stone_shovel, 2.2, 0.9, false, 1.1, 1.2", "minecraft:stone_sword, 1.3, 1, false, 1.25, 1.5", "minecraft:torch, 0.5, 1.2, false, 1.0, 1.0", "minecraft:trident, 1.5, 1.6, false, 1.2, 1.4", "minecraft:wooden_axe, 3, 1, false, 1.1, 1.2", "minecraft:wooden_hoe, 0.2, 1.4, false, 1.4, 2", "minecraft:wooden_pickaxe, 1.3, 1, false, 1.4, 2", "minecraft:wooden_shovel, 2, 0.9, false, 1.4, 2", "minecraft:wooden_sword, 1.2, 1, false, 1.25, 1.5", "adhooks:pudge_launcher, 2.0, 1.0, false, 1.1, 1.2", "adhooks:spear_launcher, 2.0, 1.0, false, 1.4, 2.0", "adhooks:web_launcher, 1.5, 1.0, false, 1.1, 1.2", "akashictome:tome, 1, 2, true, 20, 0.1", "alexsmobs:falconry_glove, 1.0, 1.5, false, 1.0, 1.0", "alexsmobs:shield_of_the_deep, 3.0, 0.5, true, 60, 0.4", "aquaculture:diamond_fillet_knife, 0.7, 1.3, false, 1.5, 2.5", "aquaculture:gold_fillet_knife, 0.6, 1.4, false, 1.5, 2.5", "aquaculture:iron_fillet_knife, 0.6, 1.3, false, 1.5, 2.5", "aquaculture:neptunium_axe, 4.3, 0.8, false, 1.1, 1.2", "aquaculture:neptunium_bow, 1.5, 1.7, false, 1.0, 1.0", "aquaculture:neptunium_fillet_knife, 0.7, 1.1, false, 1.5, 2.5", "aquaculture:neptunium_hoe, 0.3, 1.4, false, 1.4, 2", "aquaculture:neptunium_pickaxe, 1.7, 1, false, 1.4, 2", "aquaculture:neptunium_shovel, 2.8, 0.9, false, 1.1, 1.2", "aquaculture:neptunium_sword, 1.8, 1, false, 1.25, 1.5", "aquaculture:stone_fillet_knife, 0.5, 1.4, false, 1.5, 2.5", "aquaculture:wooden_fillet_knife, 0.5, 1.4, false, 1.5, 2.5", "ars_nouveau:apprentice_spell_book, 1.3, 2.0, true, 30, 0.1", "ars_nouveau:archmage_spell_book, 1.6, 2.0, true, 20, 0.15", "ars_nouveau:caster_tome, 1, 2.0, true, 30, 0.1", "ars_nouveau:dominion_wand, 1.5, 1.4, false, 1.2, 1.4", "ars_nouveau:enchanters_mirror, 2, 1.5, true, 20, 0.15", "ars_nouveau:enchanters_shield, 3, 0.7, true, 40, 0.3", "ars_nouveau:enchanters_sword, 2.0, 1.2, false, 1.3, 1.6", "ars_nouveau:novice_spell_book, 1, 2.0, true, 40, 0.05", "ars_nouveau:spell_bow, 1.5, 1.5, false, 1.0, 1.0", "ars_nouveau:wand, 1.8, 1.2, false, 1.2, 1.4", "ars_nouveau:wilden_spike, 0.5, 1.5, false, 1.5, 2.5", "arsenal_core:diamond_ancient_sword,1.3,1.0,false,1.4,1.8", "arsenal_core:diamond_arming_sword,1.8,0.9,false,1.25,1.5", "arsenal_core:diamond_chinese_sword,1.3,1.0,false,1.4,1.8", "arsenal_core:diamond_longsword,1.8,0.9,false,1.25,1.5", "arsenal_core:diamond_rapier,0.8,1.2,false,1.6,2.4", "arsenal_core:diamond_smallsword,0.8,1.2,false,1.6,2.4", "arsenal_core:golden_ancient_sword,1.2,1.2,false,1.4,1.8", "arsenal_core:golden_arming_sword,1.7,0.9,false,1.25,1.5", "arsenal_core:golden_chinese_sword,1.2,1.2,false,1.4,1.8", "arsenal_core:golden_longsword,1.7,0.9,false,1.25,1.5", "arsenal_core:golden_rapier,0.6,1.2,false,1.6,2.4", "arsenal_core:golden_smallsword,0.6,1.2,false,1.6,2.4", "arsenal_core:iron_ancient_sword,1.2,1.1,false,1.4,1.8", "arsenal_core:iron_arming_sword,1.7,0.9,false,1.25,1.5", "arsenal_core:iron_chinese_sword,1.2,1.1,false,1.4,1.8", "arsenal_core:iron_longsword,1.7,0.9,false,1.25,1.5", "arsenal_core:iron_rapier,0.7,1.2,false,1.6,2.4", "arsenal_core:iron_smallsword,0.7,1.2,false,1.6,2.4", "arsenal_core:netherite_ancient_sword,1.4,0.9,false,1.4,1.8", "arsenal_core:netherite_arming_sword,1.9,0.9,false,1.25,1.5", "arsenal_core:netherite_chinese_sword,1.4,0.9,false,1.4,1.8", "arsenal_core:netherite_longsword,1.9,0.9,false,1.25,1.5", "arsenal_core:netherite_rapier,0.9,1.2,false,1.6,2.4", "arsenal_core:netherite_smallsword,0.9,1.2,false,1.6,2.4", "arsenal_core:stone_ancient_sword,1.1,1.2,false,1.4,1.8", "arsenal_core:stone_arming_sword,1.6,0.9,false,1.25,1.5", "arsenal_core:stone_chinese_sword,1.1,1.2,false,1.4,1.8", "arsenal_core:stone_longsword,1.6,0.9,false,1.25,1.5", "arsenal_core:stone_rapier,0.6,1.2,false,1.6,2.4", "arsenal_core:stone_smallsword,0.6,1.2,false,1.6,2.4", "arsenal_core:wooden_ancient_sword,1.0,1.2,false,1.4,1.8", "arsenal_core:wooden_arming_sword,1.5,0.9,false,1.25,1.5", "arsenal_core:wooden_chinese_sword,1.0,1.2,false,1.4,1.8", "arsenal_core:wooden_longsword,1.5,0.9,false,1.25,1.5", "arsenal_core:wooden_rapier,0.5,1.2,false,1.6,2.4", "arsenal_core:wooden_smallsword,0.5,1.2,false,1.6,2.4", "arsenal_core:xuanyuanjian,2.5,0.7,false,1.5,2.0", "artifacts:umbrella, 1.0, 0.8, true, 40, 0.3", "astral:phantasmal_axe, 3.2, 0.9, false, 1.1, 1.2", "astral:phantasmal_hoe, 0.3, 1.5, false, 1.4, 2", "astral:phantasmal_pickaxe, 1.4, 1, false, 1.4, 2", "astral:phantasmal_shovel, 2.4, 0.9, false, 1.1, 1.2", "astral:phantasmal_sword, 1.6, 1, false, 1.25, 1.5", "atum:anputs_hunger, 1.0, 1, false, 2, 2.5", "atum:anubis_wrath, 1.2, 1, false, 1.5, 2", "atum:atems_protection, 2.5, 0.4, true, 50, 0.4", "atum:atems_will, 1.8, 1, false, 1.25, 1.5", "atum:brigand_shield, 2.2, 0.9, true, 40, 0.2", "atum:dagger_poison, 0.6, 1, false, 2, 2.5", "atum:gebs_might, 11.8, 0.8, false, 1.1, 1.2", "atum:horus_ascension, 1.0, 1, false, 2, 2.5", "atum:iron_club, 7.9, 1.0, false, 1.1, 1.2", "atum:iron_dagger, 0.6, 1, false, 2, 2.5", "atum:iron_greatsword, 4.5, 0.8, false, 1.1, 1.2", "atum:iron_khopesh, 1.2, 1, false, 1.5, 2", "atum:iron_scimitar, 1.6, 1, false, 1.25, 1.5", "atum:limestone_sword, 1.5, 1, false, 1.25, 1.5", "atum:montus_strike, 3.8, 0.8, false, 1.1, 1.2", "atum:nepthys_banishing, 1.8, 1, false, 1.25, 1.5", "atum:nuits_ire, 1.3, 1.0, false, 1.4, 2", "atum:nuits_quarter, 1.3, 1.0, false, 1.4, 2", "atum:seths_sting, 1.0, 1, false, 2, 2.5", "atum:shus_exile, 3.8, 0.8, false, 1.1, 1.2", "atum:stoneguard_club, 7.9, 1.0, false, 1.1, 1.2", "atum:stoneguard_greatsword, 4.5, 0.8, false, 1.1, 1.2", "atum:stoneguard_khopesh, 1.2, 1, false, 1.5, 2", "atum:stoneguard_shield, 2.7, 0.7, true, 60, 0.5", "atum:stoneguard_sword, 1.6, 1, false, 1.25, 1.5", "atum:tefnuts_call, 1.2, 1.6, false, 1.2, 1.4", "betterendforge:aeternium_axe, 3.8, 0.8, false, 1.1, 1.2", "betterendforge:aeternium_hammer, 4.0, 1.0, false, 1.1, 1.2", "betterendforge:aeternium_hoe, 0.5, 1.4, false, 1.4, 2.0", "betterendforge:aeternium_pickaxe, 1.6, 1.0, false, 1.4, 2.0", "betterendforge:aeternium_shovel, 2.8, 0.9, false, 1.1, 1.2", "betterendforge:aeternium_sword, 1.6, 1.0, false, 1.25, 1.5", "betterendforge:diamond_hammer, 3.8, 0.8, false, 1.1, 1.2", "betterendforge:golden_hammer, 3.6, 0.8, false, 1.1, 1.2", "betterendforge:iron_hammer, 3.6, 0.9, false, 1.1, 1.2", "betterendforge:netherite_hammer, 4.0, 0.8, false, 1.1, 1.2", "betterendforge:terminite_axe, 3.6, 0.8, false, 1.1, 1.2", "betterendforge:terminite_hammer, 3.8, 1.0, false, 1.1, 1.2", "betterendforge:terminite_hoe, 0.45, 1.4, false, 1.4, 2.0", "betterendforge:terminite_pickaxe, 1.5, 1.0, false, 1.4, 2.0", "betterendforge:terminite_shovel, 2.8, 0.9, false, 1.1, 1.2", "betterendforge:terminite_sword, 1.5, 1.0, false, 1.25, 1.5", "betterendforge:thallasium_axe, 3.4, 0.8, false, 1.1, 1.2", "betterendforge:thallasium_hammer, 3.6, 0.9, false, 1.1, 1.2", "betterendforge:thallasium_hoe, 0.3, 1.4, false, 1.4, 2.0", "betterendforge:thallasium_pickaxe, 1.4, 1.0, false, 1.4, 2.0", "betterendforge:thallasium_shovel, 2.4, 0.9, false, 1.1, 1.2", "betterendforge:thallasium_sword, 1.4, 1.0, false, 1.25, 1.5", "betternether:cincinnasite_axe, 3.4, 0.8, false, 1.1, 1.2", "betternether:cincinnasite_axe_diamond, 3.4, 0.8, false, 1.1, 1.2", "betternether:cincinnasite_hoe, 0.3, 1.4, false, 1.4, 2", "betternether:cincinnasite_hoe_diamond, 0.3, 1.4, false, 1.4, 2", "betternether:cincinnasite_pickaxe, 1.4, 1, false, 1.4, 2", "betternether:cincinnasite_pickaxe_diamond, 1.4, 1, false, 1.4, 2", "betternether:cincinnasite_shovel, 2.0, 0.9, false, 1.1, 1.2", "betternether:cincinnasite_shovel_diamond, 2.0, 0.9, false, 1.1, 1.2", "betternether:cincinnasite_sword, 1.2, 1, false, 1.25, 1.5", "betternether:cincinnasite_sword_diamond, 1.2, 1, false, 1.25, 1.5", "betternether:nether_ruby_axe, 3.6, 0.8, false, 1.1, 1.2", "betternether:nether_ruby_hoe, 0.35, 1.4, false, 1.4, 2", "betternether:nether_ruby_pickaxe, 1.6, 1, false, 1.4, 2", "betternether:nether_ruby_shovel, 2.6, 0.9, false, 1.1, 1.2", "betternether:nether_ruby_sword, 1.5, 1, false, 1.25, 1.5", "bigbrain:buckler, 1, 0.8, true, 20, 0.2", "biomancy:boomling_hive_gun, 2.2, 1.5, false, 1.0, 1.0", "biomancy:fleshborn_axe, 3.4, 0.8, false, 1.1, 1.2", "biomancy:fleshborn_guan_dao, 1.7, 1.3, false, 1.2, 1.4", "biomancy:fleshborn_pickaxe, 1.5, 1, false, 1.4, 2", "biomancy:fleshborn_shovel, 2.4, 0.9, false, 1.1, 1.2", "biomancy:fleshborn_war_axe, 3.8, 0.8, false, 1.1, 1.2", "biomancy:leech_claw, 1.2, 1.4, false, 1.5, 2.0", "biomancy:long_range_claw, 1.2, 1.5, false, 1.5, 2.0", "biomancy:sharp_bone, 0.5, 2.1, false, 1.5, 2.5", "biomancy:tooth_gun, 2.2, 1.5, false, 1.0, 1.0", "biomancy:withershot, 2.2, 1.5, false, 1.0, 1.0", "bloodmagic:soulaxe, 4.0, 0.8, false, 1.1, 1.2", "bloodmagic:soulpickaxe, 1.5, 1, false, 1.4, 2", "bloodmagic:soulscythe, 1.5, 1.4, false, 1.4, 2", "bloodmagic:soulshovel, 2.4, 0.9, false, 1.1, 1.2", "bloodmagic:soulsword, 2.7, 1, false, 1.25, 1.5", "blue_skies:alchemy_scroll, 1, 2.0, true, 20, 0.1", "blue_skies:aquite_axe, 3.4, 0.8, false, 1.1, 1.2", "blue_skies:aquite_hoe, 0.4, 1.4, false, 1.25, 1.5", "blue_skies:aquite_pickaxe, 1.5, 1.0, false, 1.4, 2.0", "blue_skies:aquite_shovel, 2.4, 0.9, false, 1.1, 1.2", "blue_skies:aquite_sword, 1.3, 1.0, false, 1.25, 1.5", "blue_skies:bluebright_axe, 3, 1, false, 1.1, 1.2", "blue_skies:bluebright_hoe, 0.2, 1.4, false, 1.25, 1.5", "blue_skies:bluebright_pickaxe, 1.3, 1.0, false, 1.4, 2.0", "blue_skies:bluebright_shovel, 2, 0.9, false, 1.1, 1.2", "blue_skies:bluebright_spear, 1.25, 1.6, false, 1.25, 1.5", "blue_skies:bluebright_sword, 1.2, 1.0, false, 1.25, 1.5", "blue_skies:charoite_axe, 3.6, 0.8, false, 1.1, 1.2", "blue_skies:charoite_hoe, 0.5, 1.4, false, 1.25, 1.5", "blue_skies:charoite_pickaxe, 1.4, 1.0, false, 1.4, 2.0", "blue_skies:charoite_shovel, 2.6, 0.9, false, 1.1, 1.2", "blue_skies:charoite_sword, 1.4, 1.0, false, 1.25, 1.5", "blue_skies:cherry_axe, 3, 1, false, 1.1, 1.2", "blue_skies:cherry_hoe, 0.2, 1.4, false, 1.25, 1.5", "blue_skies:cherry_pickaxe, 1.3, 1.0, false, 1.4, 2.0", "blue_skies:cherry_shovel, 2, 0.9, false, 1.1, 1.2", "blue_skies:cherry_spear, 1.25, 1.6, false, 1.25, 1.5", "blue_skies:cherry_sword, 1.2, 1.0, false, 1.25, 1.5", "blue_skies:crushing_hammer, 7, 0.7, false, 1.2, 1.4", "blue_skies:different_sword, 1.3, 1.0, false, 1.3, 1.6", "blue_skies:diopside_axe, 4.2, 0.7, false, 1.1, 1.2", "blue_skies:diopside_hoe, 0.6, 1.2, false, 1.25, 1.5", "blue_skies:diopside_pickaxe, 1.8, 1.0, false, 1.4, 2.0", "blue_skies:diopside_shovel, 2.8, 0.9, false, 1.1, 1.2", "blue_skies:diopside_sword, 1.6, 1.0, false, 1.25, 1.5", "blue_skies:dusk_axe, 3, 1, false, 1.1, 1.2", "blue_skies:dusk_hoe, 0.2, 1.4, false, 1.25, 1.5", "blue_skies:dusk_pickaxe, 1.3, 1.0, false, 1.4, 2.0", "blue_skies:dusk_shovel, 2, 0.9, false, 1.1, 1.2", "blue_skies:dusk_spear, 1.25, 1.6, false, 1.25, 1.5", "blue_skies:dusk_sword, 1.2, 1.0, false, 1.25, 1.5", "blue_skies:frostbright_axe, 3, 1, false, 1.1, 1.2", "blue_skies:frostbright_hoe, 0.2, 1.4, false, 1.25, 1.5", "blue_skies:frostbright_pickaxe, 1.3, 1.0, false, 1.4, 2.0", "blue_skies:frostbright_shovel, 2, 0.9, false, 1.1, 1.2", "blue_skies:frostbright_spear, 1.25, 1.6, false, 1.25, 1.5", "blue_skies:frostbright_sword, 1.2, 1.0, false, 1.25, 1.5", "blue_skies:horizonite_axe, 1, 1.0, false, 1.1, 1.2", "blue_skies:horizonite_hoe, 0.4, 1.4, false, 1.25, 1.5", "blue_skies:horizonite_pickaxe, 1.5, 1.0, false, 1.4, 2.0", "blue_skies:horizonite_shovel, 2.4, 0.9, false, 1.1, 1.2", "blue_skies:horizonite_sword, 1.3, 1.0, false, 1.25, 1.5", "blue_skies:infused_arc_sword,1.6, 0.9, false, 1.3, 1.6 ", "blue_skies:lunar_axe,3,1,false,1.1,1.2", "blue_skies:lunar_hoe,0.2,1.4,false,1.25,1.5", "blue_skies:lunar_pickaxe,1.3,1.0,false,1.4,2.0", "blue_skies:lunar_shovel,2,0.9,false,1.1,1.2", "blue_skies:lunar_spear,1.25,1.6,false,1.25,1.5", "blue_skies:lunar_stone_axe,3.2,0.9,false,1.1,1.2", "blue_skies:lunar_stone_hoe,0.3,1.4,false,1.25,1.5", "blue_skies:lunar_stone_pickaxe,1.4,1.0,false,1.4,2.0", "blue_skies:lunar_stone_shovel,2.2,0.9,false,1.1,1.2", "blue_skies:lunar_stone_sword,1.3,1.0,false,1.25,1.5", "blue_skies:lunar_sword,1.2,1.0,false,1.25,1.5", "blue_skies:maple_axe,3,1,false,1.1,1.2", "blue_skies:maple_hoe,0.2,1.4,false,1.25,1.5", "blue_skies:maple_pickaxe,1.3,1.0,false,1.4,2.0", "blue_skies:maple_shovel,2,0.9,false,1.1,1.2", "blue_skies:maple_spear,1.25,1.6,false,1.25,1.5", "blue_skies:maple_sword,1.2,1.0,false,1.25,1.5", "blue_skies:moonstone_shield,2.5,0.7,true,60,0.4", "blue_skies:pyrope_axe,3.2,0.9,false,1.1,1.2", "blue_skies:pyrope_hoe,0.2,1.4,false,1.25,1.5", "blue_skies:pyrope_pickaxe,1.4,1.0,false,1.4,2.0", "blue_skies:pyrope_shovel,2,0.9,false,1.1,1.2", "blue_skies:pyrope_sword,1.2,1.0,false,1.25,1.5", "blue_skies:soulbound_spear,1.5,1.4,false,1.3,1.6", "blue_skies:spike_shield,3,0.7,true,40,0.4", "blue_skies:starlit_axe,3,1,false,1.1,1.2", "blue_skies:starlit_hoe,0.2,1.4,false,1.25,1.5", "blue_skies:starlit_pickaxe,1.3,1.0,false,1.4,2.0", "blue_skies:starlit_shovel,2,0.9,false,1.1,1.2", "blue_skies:starlit_spear,1.25,1.6,false,1.25,1.5", "blue_skies:starlit_sword,1.2,1.0,false,1.25,1.5", "blue_skies:summoning_tome,1,2.0,true,20,0.1", "blue_skies:turquoise_stone_axe,3.2,0.9,false,1.1,1.2", "blue_skies:turquoise_stone_hoe,0.3,1.4,false,1.25,1.5", "blue_skies:turquoise_stone_pickaxe,1.4,1.0,false,1.4,2.0", "blue_skies:turquoise_stone_shovel,2.2,0.9,false,1.1,1.2", "blue_skies:turquoise_stone_sword,1.3,1.0,false,1.25,1.5", "blue_skies:zeal_lighter,0.5,2.0,false,1.25,1.5", "bountifulbaubles:shield_ankh,3.5,0.7,true,60,0.4", "bountifulbaubles:shield_cobalt,3.5,0.7,true,60,0.4", "bountifulbaubles:shield_obsidian,3.5,0.7,true,60,0.4", "bountifulbaubles:shield_obsidian,3.5,0.7,true,60,0.4", "byg:pendorite_axe,4.3,0.8,false,1.1,1.2", "byg:pendorite_battleaxe,5.0,0.9,false,1.1,1.2", "byg:pendorite_hoe,0.5,1.4,false,1.4,2", "byg:pendorite_pickaxe,1.7,1,false,1.4,2", "byg:pendorite_shovel,3.0,0.9,false,1.1,1.2", "byg:pendorite_sword,1.9,1,false,1.25,1.5", "coldsclaws:diamond_claw,1.2,1.4,false,1.5,2.0", "coldsclaws:golden_claw,1.0,1.5,false,1.5,2.0", "coldsclaws:iron_claw,1.1,1.5,false,1.5,2.0", "coldsclaws:netherite_claw,1.3,1.4,false,1.5,2.0", "coldsclaws:stone_claw,1.0,1.6,false,1.5,2.0", "coldsclaws:wooden_claw,0.9,1.6,false,1.5,2.0", "comfortable_nether:axe_of_rectitude,3.8,0.8,false,1.1,1.2", "comfortable_nether:crystalline_saber,1.6,1,false,1.25,1.5", "comfortable_nether:pummeler_club,3.5,1.2,false,1.2,1.4", "consecration:fire_stick,2,1.2,false,1.1,1.2", "create:deforester,5.3,0.8,false,1.1,1.2", "cyclic:crystal_axe,4,1,false,1.1,1.2", "cyclic:crystal_hoe,0.4,1.4,false,1.4,2", "cyclic:crystal_pickaxe,1.7,1,false,1.4,2", "cyclic:crystal_shovel,2.8,1,false,1.1,1.2", "cyclic:crystal_sword,1.6,1,false,1.25,1.5", "cyclic:emerald_axe,4,1,false,1.1,1.2", "cyclic:emerald_hoe,0.35,1.4,false,1.4,2", "cyclic:emerald_pickaxe,1.7,1,false,1.4,2", "cyclic:emerald_shovel,2.8,1,false,1.1,1.2", "cyclic:emerald_sword,1.5,1,false,1.25,1.5", "cyclic:netherbrick_axe,3.4,1,false,1.1,1.2", "cyclic:netherbrick_hoe,0.25,1.5,false,1.4,2", "cyclic:netherbrick_pickaxe,1.5,1,false,1.4,2", "cyclic:netherbrick_shovel,2.2,1,false,1.1,1.2", "cyclic:netherbrick_sword,1.4,1,false,1.25,1.5", "cyclic:sandstone_axe,3,1,false,1.1,1.2", "cyclic:sandstone_hoe,0.25,1.6,false,1.4,2", "cyclic:sandstone_pickaxe,1.4,1,false,1.4,2", "cyclic:sandstone_shovel,2.2,1,false,1.1,1.2", "cyclic:sandstone_sword,1.3,1,false,1.25,1.5", "druidcraft:bone_axe,3.6,0.8,false,1.1,1.2", "druidcraft:bone_hoe,0.45,1.4,false,1.4,2", "druidcraft:bone_pickaxe,1.4,1.0,false,1.4,2", "druidcraft:bone_shield,1.0,0.8,true,40,0.3", "druidcraft:bone_shovel,2.4,0.9,false,1.1,1.2", "druidcraft:bone_sword,1.3,1.0,false,1.25,1.5", "druidcraft:chitin_shield,2.0,0.8,true,60,0.3", "druidcraft:moonstone_axe,3.6,0.8,false,1.1,1.2", "druidcraft:moonstone_hoe,0.5,1.4,false,1.4,2", "druidcraft:moonstone_pickaxe,1.5,1.0,false,1.4,2", "druidcraft:moonstone_shield,2.0,0.7,true,70,0.4", "druidcraft:moonstone_shovel,2.6,0.9,false,1.1,1.2", "druidcraft:moonstone_sword,1.3,1.0,false,1.25,1.5", "dungeons_gear:anchor,5,0.9,false,1.1,1.2", "dungeons_gear:ancient_bow,1.2,1.6,false,1.0,1.0", "dungeons_gear:auto_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:axe,3.4,0.8,false,1.1,1.2", "dungeons_gear:azure_seeker,2.0,1.5,true,20,0.1", "dungeons_gear:battlestaff,1.7,0.8,false,1.2,1.4", "dungeons_gear:battlestaff_of_terror,1.7,0.8,false,1.2,1.4", "dungeons_gear:bee_stinger,1.2,1.2,false,1.35,1.6", "dungeons_gear:bone_cudgel,6.5,0.9,false,1.1,1.2", "dungeons_gear:bonebow,1.2,1.6,false,1.0,1.0", "dungeons_gear:boneclub,6.5,0.9,false,1.1,1.2", "dungeons_gear:bow_of_lost_souls,1.2,1.6,false,1.0,1.0", "dungeons_gear:broadsword,4.5,0.8,false,1.1,1.2", "dungeons_gear:broken_sawblade,1.5,1.2,false,1.1,1.2", "dungeons_gear:burst_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:butterfly_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:chill_gale_knife,1.6,1.9,false,1.5,2.5", "dungeons_gear:claymore,4.5,0.8,false,1.1,1.2", "dungeons_gear:cog_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:coral_blade,0.5,2.1,false,1.5,2.5", "dungeons_gear:corrupted_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:cursed_axe,4.2,0.8,false,1.1,1.2", "dungeons_gear:cutlass,1.2,1.0,false,1.5,2.0", "dungeons_gear:dagger,0.5,2.1,false,1.5,2.5", "dungeons_gear:dancers_sword,1.2,1.0,false,1.5,2.0", "dungeons_gear:dark_katana,2.2,1.1,false,1.25,1.5", "dungeons_gear:diamond_pickaxe,1.6,1,false,1.4,2", "dungeons_gear:diamond_sword,1.5,1,false,1.25,1.5", "dungeons_gear:doom_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:double_axe,4.2,0.8,false,1.1,1.2", "dungeons_gear:elite_power_bow,1.2,1.6,false,1.0,1.0", "dungeons_gear:encrusted_anchor,5,0.9,false,1.1,1.2", "dungeons_gear:eternal_knife,1.6,1.9,false,1.5,2.5", "dungeons_gear:exploding_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:fang_of_frost,0.5,2.1,false,1.5,2.5", "dungeons_gear:feral_soul_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:fighters_binding,1.0,1.6,false,1.2,1.4", "dungeons_gear:firebolt_thrower,2.0,1.5,true,20,0.1", "dungeons_gear:firebrand,3.4,0.8,false,1.1,1.2", "dungeons_gear:flail,4.2,1.1,false,1.1,1.2", "dungeons_gear:fortune_spear,1.1,1.6,false,1.2,1.4", "dungeons_gear:freezing_foil,1.2,1.2,false,1.35,1.6", "dungeons_gear:frost_scythe,1.3,1.3,false,1.4,2", "dungeons_gear:frost_slayer,4.5,0.8,false,1.1,1.2", "dungeons_gear:gauntlet,1.0,1.5,false,1.2,1.4", "dungeons_gear:glaive,1.7,1.3,false,1.2,1.4", "dungeons_gear:grave_bane,1.7,1.3,false,1.2,1.4", "dungeons_gear:great_axeblade,4.5,0.8,false,1.1,1.2", "dungeons_gear:great_hammer,5.7,1.1,false,1.1,1.2", "dungeons_gear:growing_staff,1.7,0.8,false,1.2,1.4", "dungeons_gear:guardian_bow,1.2,1.6,false,1.0,1.0", "dungeons_gear:hammer_of_gravity,5.7,1.1,false,1.1,1.2", "dungeons_gear:harp_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:harpoon_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:haunted_bow,1.2,1.6,false,1.0,1.0", "dungeons_gear:hawkbrand,1.5,1,false,1.25,1.5", "dungeons_gear:heartstealer,4.5,0.8,false,1.1,1.2", "dungeons_gear:heavy_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:highland_axe,3.4,0.8,false,1.1,1.2", "dungeons_gear:hunters_promise,1.2,1.6,false,1.0,1.0", "dungeons_gear:hunting_bow,1.2,1.6,false,1.0,1.0", "dungeons_gear:imploding_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:jailors_scythe,1.3,1.3,false,1.4,2", "dungeons_gear:katana,2.2,1.1,false,1.25,1.5", "dungeons_gear:lightning_harp_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:longbow,1.2,1.6,false,1.0,1.0", "dungeons_gear:love_spell_bow,1.2,1.6,false,1.0,1.0", "dungeons_gear:mace,4.2,1.1,false,1.1,1.2", "dungeons_gear:masters_bow,1.2,1.6,false,1.0,1.0", "dungeons_gear:masters_katana,2.2,1.1,false,1.25,1.5", "dungeons_gear:mauler,1.0,1.5,false,1.2,1.4", "dungeons_gear:mechanical_shortbow,1.2,1.6,false,1.0,1.0", "dungeons_gear:mechanized_sawblade,1.5,1.2,false,1.1,1.2", "dungeons_gear:moon_dagger,0.5,2.1,false,1.5,2.5", "dungeons_gear:nameless_blade,1.2,1.0,false,1.5,2.0", "dungeons_gear:nautical_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:nightmares_bite,1.3,1.3,false,1.4,2", "dungeons_gear:nocturnal_bow,1.2,1.6,false,1.0,1.0", "dungeons_gear:pickaxe,1.6,1,false,1.4,2", "dungeons_gear:power_bow,1.2,1.6,false,1.0,1.0", "dungeons_gear:pride_of_the_piglins,2.0,1.5,true,20,0.1", "dungeons_gear:purple_storm,1.2,1.6,false,1.0,1.0", "dungeons_gear:rapid_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:rapier,1.2,1.2,false,1.35,1.6", "dungeons_gear:red_snake,1.2,1.6,false,1.0,1.0", "dungeons_gear:resolute_tempest_knife,1.6,1.9,false,1.5,2.5", "dungeons_gear:sabrewing,1.2,1.6,false,1.0,1.0", "dungeons_gear:scatter_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:shear_dagger,0.5,2.1,false,1.5,2.5", "dungeons_gear:shortbow,1.2,1.6,false,1.0,1.0", "dungeons_gear:sickle,1.3,1.3,false, 1.4,2", "dungeons_gear:sinister_sword,1.5,1,false,1.25,1.5", "dungeons_gear:slayer_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:snow_bow,1.2,1.6,false,1.0,1.0", "dungeons_gear:soul_bow,1.2,1.6,false,1.0,1.0", "dungeons_gear:soul_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:soul_fist,1.0,1.5,false,1.2,1.4", "dungeons_gear:soul_hunter_crossbow,2.0,1.5,true,20,0.1", "dungeons_gear:soul_knife,1.6,1.9,false,1.5,2.5", "dungeons_gear:soul_scythe,1.3,1.3,false,1.4,2", "dungeons_gear:spear,1.1,1.6,false,1.2,1.4", "dungeons_gear:sponge_striker,0.5,2.1,false,1.5,2.5", "dungeons_gear:stormlander,5.7,1.1,false,1.1,1.2", "dungeons_gear:suns_grace,4.2,1.1,false,1.1,1.2", "dungeons_gear:sword,2.7,1,false,1.25,1.5", "dungeons_gear:tempest_knife,1.6,1.9,false,1.5,2.5", "dungeons_gear:the_green_menace,1.2,1.6,false,1.0,1.0", "dungeons_gear:the_last_laugh,1.3,1.3,false,1.4,2", "dungeons_gear:the_pink_scoundrel,1.2,1.6,false,1.0,1.0", "dungeons_gear:the_slicer,2.0,1.5,true,20,0.1", "dungeons_gear:trickbow,1.2,1.6,false,1.0,1.0", "dungeons_gear:truthseeker,1.6,1.9,false,1.5,2.5", "dungeons_gear:twin_bow,1.2,1.6,false,1.0,1.0", "dungeons_gear:venom_glaive,1.7,1.3,false,1.2,1.4", "dungeons_gear:vine_whip,-1.4,-1.6,false,1.1,1.2", "dungeons_gear:voidcaller,1.2,1.6,false,1.0,1.0", "dungeons_gear:whip,-1.4,-1.6,false,1.1,1.2", "dungeons_gear:whirlwind,4.2,0.8,false,1.1,1.2", "dungeons_gear:whispering_spear,1.1,1.6,false,1.2,1.4", "dungeons_gear:winters_touch,1.2,1.6,false,1.0,1.0", "dungeons_mobs:royal_guard_shield,3.5,0.6,true,50,0.4", "dungeons_mobs:skeleton_vanguard_shield,3.5,0.7,true,50,0.3", "eidolon:cleaving_axe,4.0,0.8,false,1.1,1.2", "eidolon:reaper_scythe,1.5,1.4,false,1.4,2", "eidolon:reversal_pick,1.5,1,false,1.4,2", "eidolon:sapping_sword,1.8,1,false,1.25,1.5", "endrem:end_crystal_axe,3.6,0.8,false,1.1,1.2", "endrem:end_crystal_hoe,0.35,1.4,false,1.4,2", "endrem:end_crystal_pickaxe,1.6,1,false,1.4,2", "endrem:end_crystal_shovel,2.6,0.9,false,1.1,1.2", "endrem:end_crystal_sword,1.5,1,false,1.25,1.5", "enigmaticlegacy:astral_breaker,4.5,0.8,false,1.1,1.2", "enigmaticlegacy:etherium_axe,4.3,0.8,false,1.1,1.2", "enigmaticlegacy:etherium_pickaxe,1.7,1,false,1.4,2", "enigmaticlegacy:etherium_scythe,0.4,1.4,false,1.4,2", "enigmaticlegacy:etherium_shovel,3.0,0.9,false,1.1,1.2", "enigmaticlegacy:etherium_sword,1.9,1,false,1.25,1.5", "enigmaticlegacy:forbidden_axe,2.7,1,false,1.1,1.2", "enigmaticlegacy:the_acknowledgment,1,2,true,20,0.15", "enigmaticlegacy:the_twist,2,2.0,true,20,0.3", "epicfight:diamond_spear,1.2,1.5,false,1.1,1.2", "epicfight:gold_spear,1,1.7,false,1.1,1.2", "epicfight:greatsword,4,1,false,1.1,1.2", "epicfight:iron_spear,1.1,1.6,false,1.1,1.2", "epicfight:katana,1.7,1.1,false,1.25,1.5", "epicfight:stone_spear,1,1.7,false,1.1,1.2", "evilcraft:mace_of_destruction,5.0,0.9,false,1.1,1.2", "evilcraft:mace_of_distortion,5.0,0.9,false,1.1,1.2", "evilcraft:vein_sword,1.8,1,false,1.25,1.5", "evilcraft:vengeance_pickaxe,1.9,1.3,false,1.4,2", "farmersdelight:diamond_knife,0.7,2.0,false,1.5,2.5", "farmersdelight:flint_knife,0.5,2.0,false,1.5,2.5", "farmersdelight:golden_knife,0.5,2.0,false,1.5,2.5", "farmersdelight:iron_knife,0.6,2.0,false,1.5,2.5", "farmersdelight:netherite_knife,0.8,2.0,false,1.5,2.5", "fins:red_claw_gauntlet,1.2,1.5,false,1.2,1.4", "fins:white_claw_gauntlet,1.0,1.4,false,1.2,1.4", "greekfantasy:bident,1.5,1.6,false,1.2,1.4", "greekfantasy:flint_knife,0.5,2.1,false,1.5,2.5", "greekfantasy:iron_club,13,0.5,true,60,0.3", "greekfantasy:iron_spear,1.1,1.6,false,1.2,1.4", "greekfantasy:ivory_sword,1.5,1,false,1.25,1.5", "greekfantasy:stone_club,11,0.5,true,60,0.25", "greekfantasy:stone_spear,1,1.6,false,1.2,1.4", "greekfantasy:wooden_club,10,0.6,true,60,0.2", "greekfantasy:wooden_spear,0.9,1.6,false,1.2,1.4", "gunswithoutroses:diamond_gatling,2.2,1.5,false,1.0,1.0", "gunswithoutroses:diamond_shotgun,2.2,1.5,false,1.0,1.0", "gunswithoutroses:diamond_sniper,2.2,1.5,false,1.0,1.0", "gunswithoutroses:gold_gun,1.8,1.5,false,1.0,1.0", "gunswithoutroses:iron_gun,1.8,1.5,false,1.0,1.0", "iceandfire:amphithere_macuahuitl,4.0,1.1,false,1.1,1.2", "iceandfire:copper_axe,3.2,0.9,false,1.1,1.2", "iceandfire:copper_hoe,0.3,1.5,false,1.4,2", "iceandfire:copper_pickaxe,1.4,1,false,1.4,2", "iceandfire:copper_shovel,2.2,0.9,false,1.1,1.2", "iceandfire:copper_sword,1.2,1,false,1.25,1.5", "iceandfire:deathworm_gauntlet_red,2.5,0.8,false,1.1,1.2", "iceandfire:deathworm_gauntlet_white,2.5,0.8,false,1.1,1.2", "iceandfire:deathworm_gauntlet_yellow,2.5,0.8,false,1.1,1.2", "iceandfire:dragonbone_axe,4.3,0.8,false,1.1,1.2", "iceandfire:dragonbone_bow,1.5,1.5,false,1.0,1.0", "iceandfire:dragonbone_hoe,0.45,1.4,false,1.4,2", "iceandfire:dragonbone_pickaxe,1.7,1,false,1.4,2", "iceandfire:dragonbone_shovel,2.8,0.9,false,1.1,1.2", "iceandfire:dragonbone_sword,1.7,1,false,1.25,1.5", "iceandfire:dragonbone_sword_fire,1.9,0.9,false,1.25,1.5", "iceandfire:dragonbone_sword_ice,1.8,1,false,1.25,1.5", "iceandfire:dragonbone_sword_lightning,1.8,0.9,false,1.25,1.5", "iceandfire:dragonsteel_fire_axe,4.9,0.8,false,1.1,1.2", "iceandfire:dragonsteel_fire_hoe,0.5,1.3,false,1.4,2", "iceandfire:dragonsteel_fire_pickaxe,2.0,0.9,false,1.4,2", "iceandfire:dragonsteel_fire_shovel,3.4,0.8,false,1.1,1.2", "iceandfire:dragonsteel_fire_sword,2.2,0.9,false,1.25,1.5", "iceandfire:dragonsteel_ice_axe,4.5,0.8,false,1.1,1.2", "iceandfire:dragonsteel_ice_hoe,0.45,1.2,false,1.4,2", "iceandfire:dragonsteel_ice_pickaxe,1.9,0.9,false,1.4,2", "iceandfire:dragonsteel_ice_shovel,3.2,0.8,false,1.1,1.2", "iceandfire:dragonsteel_ice_sword,2.0,0.9,false,1.25,1.5", "iceandfire:dragonsteel_lightning_axe,4.5,0.8,false,1.1,1.2", "iceandfire:dragonsteel_lightning_hoe,0.45,1.3,false,1.4,2", "iceandfire:dragonsteel_lightning_pickaxe,1.9,0.9,false,1.4,2", "iceandfire:dragonsteel_lightning_shovel,3.2,0.8,false,1.1,1.2", "iceandfire:dragonsteel_lightning_sword,2.1,0.9,false,1.25,1.5", "iceandfire:dread_knight_sword,1.7,0.9,false,1.25,1.5", "iceandfire:dread_queen_sword,1.8,0.9,false,1.25,1.5", "iceandfire:dread_sword,1.7,1,false,1.25,1.5", "iceandfire:ghost_sword,1.8,0.9,false,1.25,1.5", "iceandfire:hippocampus_slapper,3,1.4,false,1.1,1.2", "iceandfire:hippogryph_sword,1.8,1,false,1.25,1.5", "iceandfire:myrmex_desert_axe,4.9,0.8,false,1.1,1.2", "iceandfire:myrmex_desert_hoe,0.35,1.4,false,1.4,2", "iceandfire:myrmex_desert_pickaxe,1.5,1,false,1.4,2", "iceandfire:myrmex_desert_shovel,2.3,0.9,false,1.1,1.2", "iceandfire:myrmex_desert_sword,1.5,1,false,1.25,1.5", "iceandfire:myrmex_desert_sword_venom,2.8,1,false,1.25,1.5", "iceandfire:myrmex_jungle_axe,4.9,0.8,false,1.1,1.2", "iceandfire:myrmex_jungle_hoe,0.35,1.4,false,1.4,2", "iceandfire:myrmex_jungle_pickaxe,1.5,1,false,1.4,2", "iceandfire:myrmex_jungle_shovel,2.3,0.9,false,1.1,1.2", "iceandfire:myrmex_jungle_sword,1.5,1,false,1.25,1.5", "iceandfire:myrmex_jungle_sword_venom,2.8,1,false,1.25,1.5", "iceandfire:silver_axe,3.5,0.8,false,1.1,1.2", "iceandfire:silver_hoe,0.3,1.4,false,1.4,2", "iceandfire:silver_pickaxe,1.5,1,false,1.4,2", "iceandfire:silver_shovel,2.2,0.9,false,1.1,1.2", "iceandfire:silver_sword,1.2,1,false,1.25,1.5", "iceandfire:stymphalian_bird_dagger,0.8,2.0,false,1.5,3.0", "iceandfire:troll_weapon_axe,11,0.5,true,60,0.3", "iceandfire:troll_weapon_column,11,0.5,true,60,0.4", "iceandfire:troll_weapon_column_forest,11,0.5,true,60,0.4", "iceandfire:troll_weapon_column_frost,11,0.5,true,60,0.4", "iceandfire:troll_weapon_hammer,11,0.5,true,60,0.3", "iceandfire:troll_weapon_trunk,11,0.5,true,60,0.3", "iceandfire:troll_weapon_trunk_frost,11,0.5,true,60,0.3", "infernalexp:blindsight_tongue_whip, -1.6, -1, false, 1.2, 1.4", "infernalexp:glowsilk_bow, 1.4, 1.6, false, 1.0, 1.0", "immersiveengineering:axe_steel,3.4,1,false,1.1,1.2", "immersiveengineering:hoe_steel,0.3,1.4,false,1.4,2", "immersiveengineering:pickaxe_steel,1.6,1,false,1.4,2", "immersiveengineering:revolver,1.8,1.5,false,1.0,1.0", "immersiveengineering:shield,3,0.5,true,70,0.3", "immersiveengineering:shovel_steel,2.4,1,false,1.1,1.2", "immersiveengineering:sword_steel,2.7,1,false,1.25,1.5", "kobolds:kobold_axe,3.4,0.8,false,1.1,1.2", "kobolds:kobold_netherite_sword,1.6,1,false,1.25,1.5", "kobolds:kobold_pickaxe,1.5,1,false,1.4,2", "kobolds:kobold_shovel,2.4,0.9,false,1.1,1.2", "kobolds:kobold_sword,1.4,1,false,1.25,1.5", "magistuarmory:barbedclub, 4.5, 1.2, false, 1.3, 1.6", "magistuarmory:blacksmith_hammer, 3.5, 1.0, false, 1.1, 1.2", "magistuarmory:bronze_ahlspiess, 1.7, 1.4, false, 1.2, 1.4", "magistuarmory:bronze_bastardsword, 2.3, 0.9, false, 1.2, 1.4", "magistuarmory:bronze_buckler, 1.0, 1.0, true, 20, 0.2", "magistuarmory:bronze_chainmorgenstern, 4.9, 1.2, false, 1.2, 1.4", "magistuarmory:bronze_chivalrylance, 3.7, 1.0, false, 1.1, 1.2", "magistuarmory:bronze_claymore, 2.3, 0.9, false, 1.2, 1.4", "magistuarmory:bronze_concavehalberd, 4.5, 1.2, false, 1.1, 1.2", "magistuarmory:bronze_ellipticalshield, 2.5, 0.8, true, 70, 0.4", "magistuarmory:bronze_estoc, 1.5, 1.2, false, 1.4, 1.75", "magistuarmory:bronze_guisarme, 1.2, 1.5, false, 1.2, 1.4", "magistuarmory:bronze_heatershield, 2.0, 0.9, true, 50, 0.3", "magistuarmory:bronze_heavymace, 4.4, 1.0, false, 1.1, 1.2", "magistuarmory:bronze_heavywarhammer, 5.4, 1.0, false, 1.1, 1.2", "magistuarmory:bronze_katzbalger, 1.3, 0.95, false, 1.25, 1.5", "magistuarmory:bronze_lochaberaxe, 4.7, 1.2, false, 1.1, 1.2", "magistuarmory:bronze_lucernhammer, 6.6, 1.0, false, 1.2, 1.4", "magistuarmory:bronze_morgenstern, 4.4, 1.2, false, 1.2, 1.4", "magistuarmory:bronze_pavese, 3.5, 0.7, true, 100, 0.6", "magistuarmory:bronze_pike, 1.1, 1.6, false, 1.2, 1.4", "magistuarmory:bronze_ranseur, 1.2, 1.5, false, 1.2, 1.4", "magistuarmory:bronze_rondache, 2.5, 0.7, true, 60, 0.45", "magistuarmory:bronze_roundshield, 1.5, 0.9, true, 50, 0.25", "magistuarmory:bronze_shortsword, 1.4, 1.0, false, 1.25, 1.5", "magistuarmory:bronze_stylet, 0.9, 1.4, false, 1.5, 2.0", "magistuarmory:bronze_tartsche, 2.5, 0.8, true, 50, 0.35", "magistuarmory:bronze_zweihander, 3.0, 0.8, false, 1.1, 1.2", "magistuarmory:copper_ahlspiess, 1.6, 1.4, false, 1.2, 1.4", "magistuarmory:copper_bastardsword, 2.15, 0.9, false, 1.2, 1.4", "magistuarmory:copper_buckler, 1.0, 1.1, true, 20, 0.2", "magistuarmory:copper_chainmorgenstern, 4.7, 1.2, false, 1.2, 1.4", "magistuarmory:copper_chivalrylance, 3.5, 1.0, false, 1.1, 1.2", "magistuarmory:copper_claymore, 2.15, 0.9, false, 1.2, 1.4", "magistuarmory:copper_concavehalberd 4.3, 1.2, false, 1.1, 1.2", "magistuarmory:copper_ellipticalshield, 2.5, 0.8, true, 70, 0.35", "magistuarmory:copper_estoc, 1.4, 1.2, false, 1.4, 1.75", "magistuarmory:copper_guisarme, 1.1, 1.5, false, 1.2, 1.4", "magistuarmory:copper_heatershield, 2.0, 0.9, true, 50, 0.25", "magistuarmory:copper_heavymace, 4.2, 1.0, false, 1.1, 1.2", "magistuarmory:copper_heavywarhammer, 5.6, 1.0, false, 1.1, 1.2", "magistuarmory:copper_katzbalger, 1.2, 0.95, false, 1.25, 1.5", "magistuarmory:copper_lochaberaxe, 4.6, 1.2, false, 1.1, 1.2", "magistuarmory:copper_lucernhammer, 6.2, 1.0, false, 1.2, 1.4", "magistuarmory:copper_morgenstern, 4.2, 0.9, false, 1.2, 1.4", "magistuarmory:copper_pavese, 3.5, 0.75, true, 100, 0.55", "magistuarmory:copper_pike, 1.1, 1.6, false, 1.2, 1.4", "magistuarmory:copper_ranseur, 1.1, 1.5, false, 1.2, 1.4", "magistuarmory:copper_rondache, 2.0, 0.75, true, 60, 0.4", "magistuarmory:copper_roundshield, 1.5, 0.9, true, 40, 0.2", "magistuarmory:copper_shortsword, 1.3, 1.0, false, 1.25, 1.5", "magistuarmory:copper_stylet, 0.85, 1.4, false, 1.5, 2.0", "magistuarmory:copper_target, 1.0, 1.1, true, 20, 0.2", "magistuarmory:copper_tartsche, 2.5, 0.9, true, 50, 0.3", "magistuarmory:copper_zweihander, 2.9, 0.8, false, 1.1, 1.2", "magistuarmory:diamond_ahlspiess, 1.8, 1.4, false, 1.2, 1.4", "magistuarmory:diamond_bastardsword, 2.6, 0.9, false, 1.2, 1.4", "magistuarmory:diamond_buckler, 1.0, 0.8, true, 20, 0.3", "magistuarmory:diamond_chainmorgenstern, 5.3, 1.2, false, 1.2, 1.4", "magistuarmory:diamond_chivalrylance, 4.1, 1.0, false, 1.1, 1.2", "magistuarmory:diamond_claymore, 2.6, 0.9, false, 1.2, 1.4", "magistuarmory:diamond_concavehalberd, 4.9, 1.2, false, 1.1, 1.2", "magistuarmory:diamond_ellipticalshield, 2.5, 0.7, true, 70, 0.5", "magistuarmory:diamond_estoc, 1.7, 1.2, false, 1.4, 1.75", "magistuarmory:diamond_guisarme, 1.4, 1.5, false, 1.2, 1.4", "magistuarmory:diamond_heatershield, 2.0, 0.8, true, 50, 0.4", "magistuarmory:diamond_heavymace, 4.6, 1.0, false, 1.1, 1.2", "magistuarmory:diamond_heavywarhammer, 6.2, 1.0, false, 1.1, 1.2", "magistuarmory:diamond_katzbalger, 1.4, 0.95, false, 1.25, 1.5", "magistuarmory:diamond_lochaberaxe, 4.9, 1.2, false, 1.1, 1.2", "magistuarmory:diamond_lucernhammer, 7.0, 1.0, false, 1.2, 1.4", "magistuarmory:diamond_morgenstern, 4.8, 0.9, false, 1.2, 1.4", "magistuarmory:diamond_pavese, 3.5, 0.6, true, 100, 0.7", "magistuarmory:diamond_pike, 1.2, 1.6, false, 1.2, 1.4", "magistuarmory:diamond_ranseur, 1.4, 1.5, false, 1.2, 1.4", "magistuarmory:diamond_rondache, 2.0, 0.6, true, 60, 0.55", "magistuarmory:diamond_roundshield, 1.5, 0.8, true, 40, 0.35", "magistuarmory:diamond_shortsword, 1.5, 1.0, false, 1.25, 1.5", "magistuarmory:diamond_stylet, 1.0, 1.4, false, 1.5, 2.0", "magistuarmory:diamond_target, 1.0, 0.8, true, 20, 0.3", "magistuarmory:diamond_tartsche, 2.5, 0.7, true, 50, 0.45", "magistuarmory:diamond_zweihander, 3.2, 0.8, false, 1.1, 1.2", "magistuarmory:gold_ahlspiess, 1.6, 1.4, false, 1.2, 1.4", "magistuarmory:gold_bastardsword, 2.15, 0.9, false, 1.2, 1.4", "magistuarmory:gold_buckler, 1.0, 1.0, true, 20, 0.2", "magistuarmory:gold_chainmorgenstern, 4.7, 1.2, false, 1.2, 1.4", "magistuarmory:gold_chivalrylance, 3.5, 1.0, false, 1.1, 1.2", "magistuarmory:gold_claymore, 2.15, 0.9, false, 1.2, 1.4", "magistuarmory:gold_concavehalberd, 4.3, 1.2, false, 1.1, 1.2", "magistuarmory:gold_ellipticalshield, 2.5, 0.8, true, 70, 0.35", "magistuarmory:gold_estoc, 1.4, 1.2, false, 1.4, 1.75", "magistuarmory:gold_guisarme, 1.1, 1.5, false, 1.2, 1.4", "magistuarmory:gold_heatershield, 2.0, 0.9, true, 50, 0.25", "magistuarmory:gold_heavymace, 4.2, 1.0, false, 1.1, 1.2", "magistuarmory:gold_heavywarhammer, 5.6, 1.0, false, 1.1, 1.2", "magistuarmory:gold_katzbalger, 1.2, 0.95, false, 1.25, 1.5", "magistuarmory:gold_lochaberaxe, 4.5, 1.2, false, 1.1, 1.2", "magistuarmory:gold_lucernhammer, 6.4, 1.0, false, 1.2, 1.4", "magistuarmory:gold_morgenstern, 4.2, 0.9, false, 1.2, 1.4", "magistuarmory:gold_pavese, 3.5, 0.7, true, 100, 0.6", "magistuarmory:gold_pike, 1.0, 1.6, false, 1.2, 1.4", "magistuarmory:gold_ranseur, 1.1, 1.5, false, 1.2, 1.4", "magistuarmory:gold_rondache, 2.0, 0.7, true, 60, 0.45", "magistuarmory:gold_roundshield, 1.5, 0.9, true, 40, 0.20", "magistuarmory:gold_shortsword, 1.3, 1.0, false, 1.25, 1.5", "magistuarmory:gold_stylet, 0.7, 1.4, false, 1.5, 2.0", "magistuarmory:gold_target, 1.0, 1.0, true, 20, 0.2", "magistuarmory:gold_tartsche, 2.5, 0.8, true, 50, 0.35", "magistuarmory:gold_zweihander, 2.9, 0.8, false, 1.1, 1.2", "magistuarmory:hilt, 0.4, 1.8, false, 1.25, 1.5", "magistuarmory:iron_ahlspiess, 1.7, 1.4, false, 1.2, 1.4", "magistuarmory:iron_bastardsword, 2.3, 0.9, false, 1.2, 1.4", "magistuarmory:iron_buckler, 1.0, 1.0, true, 20, 0.2", "magistuarmory:iron_chainmorgenstern, 4.9, 1.2, false, 1.2, 1.4", "magistuarmory:iron_chivalrylance, 3.7, 1.0, false, 1.1, 1.2", "magistuarmory:iron_claymore, 2.3, 0.9, false, 1.2, 1.4", "magistuarmory:iron_concavehalberd, 4.5, 1.2, false, 1.1, 1.2", "magistuarmory:iron_ellipticalshield, 2.5, 0.8, true, 70, 0.4", "magistuarmory:iron_estoc, 1.5, 1.2, false, 1.4, 1.75", "magistuarmory:iron_guisarme, 1.2, 1.5, false, 1.2, 1.4", "magistuarmory:iron_heatershield, 2.0, 0.9, true, 50, 0.3", "magistuarmory:iron_heavymace, 4.4, 1.0, false, 1.1, 1.2", "magistuarmory:iron_heavywarhammer, 5.8, 1.0, false, 1.1, 1.2", "magistuarmory:iron_katzbalger, 1.3, 0.95, false, 1.25, 1.5", "magistuarmory:iron_lochaberaxe, 4.7, 1.2, false, 1.1, 1.2", "magistuarmory:iron_lucernhammer, 6.6, 1.0, false, 1.2, 1.4", "magistuarmory:iron_morgensterne, 4.4, 0.9, false, 1.2, 1.4", "magistuarmory:iron_pavese, 3.5, 0.7, true, 100, 0.6", "magistuarmory:iron_pike, 1.1, 1.6, false, 1.2, 1.4", "magistuarmory:iron_ranseur, 1.2, 1.5, false, 1.2, 1.4", "magistuarmory:iron_rondache, 2.0, 0.7, true, 60, 0.45", "magistuarmory:iron_roundshield, 1.5, 0.9, true, 40, 0.25", "magistuarmory:iron_shortsword, 1.4, 1.0, false, 1.25, 1.5", "magistuarmory:iron_stylet, 0.9, 1.4, false, 1.5, 2.0", "magistuarmory:iron_target, 1.0, 1.0, true, 20, 0.2", "magistuarmory:iron_tartsche, 2.5, 0.8, true, 50, 0.35", "magistuarmory:iron_zweihander, 3.0, 0.8, false, 1.1, 1.2", "magistuarmory:longbow, 1.5, 1.6, false, 1.0, 1.0", "magistuarmory:netherite_ahlspiess, 1.9, 1.4, false, 1.2, 1.4", "magistuarmory:netherite_bastardsword, 2.75, 0.9, false, 1.2, 1.4", "magistuarmory:netherite_buckler, 1.0, 0.8, true, 20, 0.35", "magistuarmory:netherite_chainmorgenstern, 5.5, 1.2, false, 1.2, 1.4", "magistuarmory:netherite_chivalrylance, 4.3, 1.0, false, 1.1, 1.2", "magistuarmory:netherite_claymore, 2.75, 0.9, false, 1.2, 1.4", "magistuarmory:netherite_concavehalberd, 5.1, 1.2, false, 1.1, 1.2", "magistuarmory:netherite_ellipticalshield, 2.5, 0.65, true, 70, 0.6", "magistuarmory:netherite_estoc, 1.8, 1.2, false, 1.4, 1.75", "magistuarmory:netherite_guisarme, 1.5, 1.5, false, 1.2, 1.4", "magistuarmory:netherite_heatershield, 2.0, 0.75, true, 50, 0.5", "magistuarmory:netherite_heavymace, 4.8, 1.0, false, 1.1, 1.2", "magistuarmory:netherite_heavywarhammer, 6.4, 1.0, false, 1.1, 1.2", "magistuarmory:netherite_katzbalger, 1.5, 0.95, false, 1.25, 1.5", "magistuarmory:netherite_lochaberaxe, 5.0, 1.2, false, 1.1, 1.2", "magistuarmory:netherite_lucernhammer, 7.2, 1.0, false, 1.2, 1.4", "magistuarmory:netherite_morgenstern, 5.0, 0.9, false, 1.2, 1.4", "magistuarmory:netherite_pavese, 3.5, 0.65, true, 100, 0.75", "magistuarmory:netherite_pike, 1.3, 1.6, false, 1.2, 1.4", "magistuarmory:netherite_ranseur, 1.5, 1.5, false, 1.2, 1.4", "magistuarmory:netherite_rondache, 2.0, 0.55, true, 60, 0.6", "magistuarmory:netherite_roundshield, 1.5, 0.75, true, 40, 0.45", "magistuarmory:netherite_shortsword, 1.6, 1.0, false, 1.25, 1.5", "magistuarmory:netherite_stylet, 1.1, 1.4, false, 1.5, 2.0", "magistuarmory:netherite_target, 1.0, 0.8, true, 20, 0.35", "magistuarmory:netherite_tartsche, 2.5, 0.65, true, 50, 0.5", "magistuarmory:netherite_zweihander, 3.3, 0.8, false, 1.1, 1.2", "magistuarmory:noble_sword, 2.0, 1.0, false, 1.25, 1.5", "magistuarmory:pitchfork, 1.25, 1.6, false, 1.2, 1.4", "magistuarmory:pole, 0.6, 1.7, false, 1.25, 1.5", "magistuarmory:silver_ahlspiess, 1.6, 1.4, false, 1.2, 1.4", "magistuarmory:silver_bastardsword, 2.30, 0.9, false, 1.2, 1.4", "magistuarmory:silver_buckler, 1.0, 1.0, true, 20, 0.2", "magistuarmory:silver_chainmorgenstern, 4.9, 1.2, false, 1.2, 1.4", "magistuarmory:silver_chivalrylance, 3.5, 1.0, false, 1.1, 1.2", "magistuarmory:silver_claymore, 2.30, 0.9, false, 1.2, 1.4", "magistuarmory:silver_concavehalberd, 4.5, 1.2, false, 1.1, 1.2", "magistuarmory:silver_ellipticalshield, 2.5, 0.7, true, 70, 0.4", "magistuarmory:silver_estoc, 1.5, 1.2, false, 1.4, 1.75", "magistuarmory:silver_guisarme, 1.2, 1.5, false, 1.2, 1.4", "magistuarmory:silver_heatershield, 2.0, 0.8, true, 50, 0.3", "magistuarmory:silver_heavymace, 4.4, 1.0, false, 1.1, 1.2", "magistuarmory:silver_heavywarhammer, 5.8, 1.0, false, 1.1, 1.2", "magistuarmory:silver_katzbalger, 1.2, 0.95, false, 1.25, 1.5", "magistuarmory:silver_lochaberaxe, 4.7, 1.2, false, 1.1, 1.2", "magistuarmory:silver_lucernhammer, 6.6, 1.0, false, 1.2, 1.4", "magistuarmory:silver_morgenstern, 4.4, 0.9, false, 1.2, 1.4", "magistuarmory:silver_pavese, 3.5, 0.7, true, 100, 0.6", "magistuarmory:silver_pike, 1.1, 1.6, false, 1.2, 1.4", "magistuarmory:silver_ranseur, 1.2, 1.5, false, 1.2, 1.4", "magistuarmory:silver_rondache, 2.0, 0.7, true, 60, 0.45", "magistuarmory:silver_roundshield, 1.5, 0.8, true, 40, 0.25", "magistuarmory:silver_shortsword, 1.3, 1.0, false, 1.25, 1.5", "magistuarmory:silver_stylet, 0.7, 1.4, false, 1.5, 2.0", "magistuarmory:silver_target, 1.0, 1.0, true, 20, 0.2", "magistuarmory:silver_tartsche, 2.5, 0.8, true, 50, 0.35", "magistuarmory:silver_zweihander, 3.0, 0.8, false, 1.1, 1.2", "magistuarmory:steel_ahlspiess, 1.7, 1.4, false, 1.2, 1.4", "magistuarmory:steel_bastardsword, 2.45, 0.9, false, 1.2, 1.4", "magistuarmory:steel_buckler, 1.0, 0.9, true, 20, 0.25", "magistuarmory:steel_chain, 1, 1.3, false, 1.15, 1.3", "magistuarmory:steel_chainmorgenstern, 5.1, 1.2, false, 1.2, 1.4", "magistuarmory:steel_chivalrylance, 3.9, 1.0, false, 1.1, 1.2", "magistuarmory:steel_claymore, 2.45, 0.9, false, 1.2, 1.4", "magistuarmory:steel_concavehalberd, 4.7, 1.2, false, 1.1, 1.2", "magistuarmory:steel_ellipticalshield, 2.5, 0.75, true, 70, 0.45", "magistuarmory:steel_estoc, 1.6, 1.2, false, 1.4, 1.75", "magistuarmory:steel_guisarme, 1.3, 1.5, false, 1.2, 1.4", "magistuarmory:steel_heatershield, 2.0, 0.85, true, 50, 0.35", "magistuarmory:steel_heavymace, 4.6, 1.0, false, 1.1, 1.2", "magistuarmory:steel_heavywarhammer, 6.0, 1.0, false, 1.1, 1.2", "magistuarmory:steel_katzbalger, 1.3, 0.95, false, 1.25, 1.5", "magistuarmory:steel_lochaberaxe, 4.8, 1.2, false, 1.1, 1.2", "magistuarmory:steel_lucernhammer, 6.8, 1.0, false, 1.2, 1.4", "magistuarmory:steel_morgenstern, 4.6, 0.9, false, 1.2, 1.4", "magistuarmory:steel_pavese, 3.5, 0.65, true, 100, 0.65", "magistuarmory:steel_pike, 1.2, 1.6, false, 1.2, 1.4", "magistuarmory:steel_ranseur, 1.3, 1.5, false, 1.2, 1.4", "magistuarmory:steel_rondache, 2.0, 0.65, true, 60, 0.5", "magistuarmory:steel_roundshield, 1.5, 0.85, true, 40, 0.3", "magistuarmory:steel_shortsword, 1.4, 1.0, false, 1.25, 1.5", "magistuarmory:steel_stylet, 0.95, 1.4, false, 1.5, 2.0", "magistuarmory:steel_target, 1.0, 0.9, true, 20, 0.25", "magistuarmory:steel_tartsche, 2.5, 0.75, true, 50, 0.4", "magistuarmory:steel_zweihander, 3.1, 0.8, false, 1.1, 1.2", "magistuarmory:stone_ahlspiess, 1.6, 1.4, false, 1.2, 1.4", "magistuarmory:stone_bastardsword, 2.15, 0.9, false, 1.2, 1.4", "magistuarmory:stone_buckler, 1.0, 1.1, true, 20, 0.15", "magistuarmory:stone_chainmorgenstern, 4.7, 1.2, false, 1.2, 1.4", "magistuarmory:stone_chivalrylance, 3.5, 1.0, false, 1.1, 1.2", "magistuarmory:stone_claymored, 2.15, 0.9, false, 1.2, 1.4", "magistuarmory:stone_concavehalberd, 4.3, 1.2, false, 1.1, 1.2", "magistuarmory:stone_ellipticalshield, 2.5, 0.85, true, 70, 0.35", "magistuarmory:stone_estoc, 1.4, 1.2, false, 1.4, 1.75", "magistuarmory:stone_guisarme, 1.1, 1.5, false, 1.2, 1.4", "magistuarmory:stone_heatershield, 2.0, 0.95, true, 50, 0.25", "magistuarmory:stone_heavymace, 4.2, 1.0, false, 1.1, 1.2", "magistuarmory:stone_heavywarhammer, 5.6, 1.0, false, 1.1, 1.2", "magistuarmory:stone_katzbalger, 1.2, 0.95, false, 1.25, 1.5", "magistuarmory:stone_lochaberaxe, 4.6, 1.2, false, 1.1, 1.2", "magistuarmory:stone_lucernhammer, 6.4, 1.0, false, 1.2, 1.4", "magistuarmory:stone_morgenstern, 4.2, 0.9, false, 1.2, 1.4", "magistuarmory:stone_pavese, 3.5, 0.75, true, 100, 0.55", "magistuarmory:stone_pike, 1.0, 1.6, false, 1.2, 1.4", "magistuarmory:stone_ranseur, 1.1, 1.5, false, 1.2, 1.4", "magistuarmory:stone_rondache, 2.0, 0.75, true, 60, 0.4", "magistuarmory:stone_roundshield, 1.5, 0.95, true, 40, 0.20", "magistuarmory:stone_shortsword, 1.3, 1.0, false, 1.25, 1.5", "magistuarmory:stone_stylet, 0.8, 1.4, false, 1.5, 2.0", "magistuarmory:stone_target, 1.0, 1.1, true, 20, 0.15", "magistuarmory:stone_tartsche, 2.5, 0.85, true, 50, 0.3", "magistuarmory:stone_zweihander, 2.9, 0.8, false, 1.1, 1.2", "magistuarmory:tin_ahlspiess, 1.6, 1.4, false, 1.2, 1.4", "magistuarmory:tin_bastardsword, 2.15, 0.9, false, 1.2, 1.4", "magistuarmory:tin_buckler, 1.0, 1.1, true, 20, 0.2", "magistuarmory:tin_chainmorgenstern, 4.7, 1.2, false, 1.2, 1.4", "magistuarmory:tin_chivalrylance, 3.5, 1.0, false, 1.1, 1.2", "magistuarmory:tin_claymore, 2.15, 0.9, false, 1.2, 1.4", "magistuarmory:tin_concavehalberd, 4.3, 1.2, false, 1.1, 1.2", "magistuarmory:tin_ellipticalshield, 2.5, 0.8, true, 70, 0.45", "magistuarmory:tin_estoc, 1.4, 1.2, false, 1.4, 1.75", "magistuarmory:tin_guisarme, 1.1, 1.5, false, 1.2, 1.4", "magistuarmory:tin_heatershield, 2.0, 0.9, true, 50, 0.35", "magistuarmory:tin_heavymace, 4.2, 1.0, false, 1.1, 1.2", "magistuarmory:tin_heavywarhammer, 5.6, 1.0, false, 1.1, 1.2", "magistuarmory:tin_katzbalger, 1.2, 0.95, false, 1.25, 1.5", "magistuarmory:tin_lochaberaxe, 4.5, 1.2, false, 1.1, 1.2", "magistuarmory:tin_lucernhammer, 6.4, 1.0, false, 1.2, 1.4", "magistuarmory:tin_morgenstern, 4.2, 0.9, false, 1.2, 1.4", "magistuarmory:tin_pavese, 3.5, 0.75, true, 100, 0.6", "magistuarmory:tin_pike, 1.1, 1.6, false, 1.2, 1.4", "magistuarmory:tin_ranseur, 1.1, 1.5, false, 1.2, 1.4", "magistuarmory:tin_rondache, 2.5, 0.75, true, 60, 0.50", "magistuarmory:tin_roundshield, 1.5, 0.9, true, 50, 0.3", "magistuarmory:tin_shortsword, 1.4, 1.0, false, 1.25, 1.5", "magistuarmory:tin_stylet, 0.85, 1.4, false, 1.5, 2.0", "magistuarmory:tin_tartsche, 2.5, 0.8, true, 50, 0.35", "magistuarmory:tin_zweihander, 2.9, 0.8, false, 1.1, 1.2", "magistuarmory:wood_ahlspiess, 1.5, 1.4, false, 1.2, 1.4", "magistuarmory:wood_bastardsword, 2.0, 0.9, false, 1.2, 1.4", "magistuarmory:wood_buckler, 1.0, 1.2, true, 20, 0.1", "magistuarmory:wood_chainmorgenstern, 4.5, 1.2, false, 1.2, 1.4", "magistuarmory:wood_chivalrylance, 3.3, 1.0, false, 1.1, 1.2", "magistuarmory:wood_claymore, 2.0, 0.9, false, 1.2, 1.4", "magistuarmory:wood_concavehalberd, 4.1, 1.2, false, 1.1, 1.2", "magistuarmory:wood_ellipticalshield, 2.5, 0.90, true, 70, 0.3", "magistuarmory:wood_estoc, 1.3, 1.2, false, 1.4, 1.75", "magistuarmory:wood_guisarme, 1.0, 1.5, false, 1.2, 1.4", "magistuarmory:wood_heatershield, 2.0, 1.0, true, 50, 0.2", "magistuarmory:wood_heavymace, 4.0, 1.0, false, 1.1, 1.2", "magistuarmory:wood_heavywarhammer, 5.4, 1.0, false, 1.1, 1.2", "magistuarmory:wood_katzbalger, 1.1, 0.95, false, 1.25, 1.5", "magistuarmory:wood_lochaberaxe, 4.5, 1.2, false, 1.1, 1.2", "magistuarmory:wood_lucernhammer, 6.2, 1.0, false, 1.2, 1.4", "magistuarmory:wood_morgenstern, 4.0, 0.9, false, 1.2, 1.4", "magistuarmory:wood_pavese, 3.5, 0.8, true, 100, 0.5", "magistuarmory:wood_pike, 0.9, 1.6, false, 1.2, 1.4", "magistuarmory:wood_ranseur, 1.0, 1.5, false, 1.2, 1.4", "magistuarmory:wood_rondache, 2.0, 0.8, true, 60, 0.35", "magistuarmory:wood_roundshield, 1.5, 1.0, true, 40, 0.15", "magistuarmory:wood_shortsword, 1.2, 1.0, false, 1.25, 1.5", "magistuarmory:wood_stylet, 0.70, 1.4, false, 1.5, 2.0", "magistuarmory:wood_target, 1.0, 1.2, true, 20, 0.1", "magistuarmory:wood_tartsche, 2.5, 0.9, true, 50, 0.25", "magistuarmory:wood_zweihander, 2.8, 0.8, false, 1.1, 1.2", "mahoutsukai:caliburn,2.0,1,false,1.25,1.5", "mahoutsukai:clarent,2.0,1,false,1.25,1.5", "mahoutsukai:dagger,0.5,1.3,false,1.5,2.5", "mahoutsukai:morgan,2.0,1,false,1.25,1.5", "mahoutsukai:proximity_projection_keys,2,1.3,false,1.5,2.0", "mahoutsukai:theripper,1.5,1.3,false,1.5,2.5", "mahoutsukai:weapon_projectile_bow,1.5,1.7,false,1.0,1.0", "majruszs_difficulty:end_axe,3.8,0.8,false,1.1,1.2", "majruszs_difficulty:end_hoe,0.5,1.4,false,1.4,2.0", "majruszs_difficulty:end_pickaxe,1.7,1.0,false,1.4,2.0", "majruszs_difficulty:end_shovel,2.8,0.9,false,1.1,1.2", "majruszs_difficulty:end_sword,1.6,1.0,false,1.25,1.5", "majruszs_difficulty:ocean_shield,3.5,0.6,true,50,0.4", "meetyourfight:cocktail_cutlass,1.7,1.1,false,1.25,1.5", "meetyourfight:cocktail_shotgun,2.2,1.5,false,1.0,1.0", "meetyourfight:depth_star,4.5,1.1,false,1.1,1.2", "meetyourfight:phantasmal_rifle,2.2,1.5,false,1.0,1.0", "mod_lavacow:beast_claw, 1.0, 1.5, false, 1.4, 2.0", "mod_lavacow:bonesword, 1.4, 1, false, 1.2, 1.4", "mod_lavacow:famine, 0.8, 1.4, false, 1.5, 2.5", "mod_lavacow:frozen_dagger, 1.4, 1.2, false, 1.4, 2.0", "mod_lavacow:frozenthigh, 2.0, 1.4, false, 1.2, 1.4", "mod_lavacow:moltenaxe, 3.6, 0.9, false, 1.1, 1.2", "mod_lavacow:moltenhammer, 2.5, 0.9, false, 1.1, 1.2", "mod_lavacow:moltenpan, 2.5, 0.8, false, 1.1, 1.2", "mod_lavacow:piranhalauncher, 2.0, 1.4, false, 1.1, 1.2", "mod_lavacow:reapers_scythe, 1.6, 1.4, false, 1.4, 2.0", "mod_lavacow:skeletonking_mace, 5.0, 0.7, false, 1.2, 1.4", "mod_lavacow:sludge_wand, 2.0, 1.0, false, 1.2, 1.4", "mod_lavacow:spectral_dagger, 1.4, 1.2, false, 1.4, 2.0", "mod_lavacow:tooth_dagger, 0.75, 1.6, false, 1.5, 2.5", "mod_lavacow:undertaker_shovel, 2.4, 0.9, false, 1.2, 1.4", "mod_lavacow:vespa_dagger, 0.75, 1.6, false, 1.5, 2.5", "mod_lavacow:vespa_shield, 2.0, 0.8, true, 50, 0.3", "mod_lavacow:war, 2.0, 1.4, false, 1.1, 1.2", "mowziesmobs:naga_fang_dagger,1.0,1.5,false,2.0,4.0", "mowziesmobs:spear,1.0,1.6,false,1.25,1.5", "mowziesmobs:wrought_axe,4.4,0.7,false,1.2,1.4", "mutantbeasts:creeper_shard,1.0,1.6,false,1.75,3.0", "mutantbeasts:endersoul_hand,1.2,1.4,false,1.5,2.5", "mutantbeasts:hulk_hammer,4.0,0.8,false,1.2,1.4", "mutantmore:withered_claymore,3.8,0.8,false,1.25,1.5", "mysticalworld:sapphire_axe,3.6,0.8,false,1.1,1.2", "mysticalworld:sapphire_hoe,0.45,1.4,false,1.4,2.0", "mysticalworld:sapphire_knife,0.7,2.0,false,1.5,2.5", "mysticalworld:sapphire_pickaxe,1.6,1,false,1.4,2.0", "mysticalworld:sapphire_shovel,2.6,0.9,false,1.1,1.2", "mysticalworld:sapphire_spear,1.1,1.6,false,1.2,1.4", "mysticalworld:sapphire_sword,1.5,1,false,1.25,1.5", "mysticalworld:cactus_axe,3.0,0.8,false,1.1,1.2", "mysticalworld:cactus_hoe,0.25,1.4,false,1.4,2.0", "mysticalworld:cactus_knife,0.5,2.0,false,1.5,2.5", "mysticalworld:cactus_pickaxe,1.2,1,false,1.4,2.0", "mysticalworld:cactus_shovel,2.0,0.9,false,1.1,1.2", "mysticalworld:cactus_spear,0.9,1.6,false,1.2,1.4", "mysticalworld:cactus_sword,1.2,1,false,1.25,1.5", "mysticalworld:copper_axe,3.2,0.8,false,1.1,1.2", "mysticalworld:copper_hoe,0.35,1.4,false,1.4,2.0", "mysticalworld:copper_knife,0.5,2.0,false,1.5,2.5", "mysticalworld:copper_pickaxe,1.5,1,false,1.4,2.0", "mysticalworld:copper_shovel,2.2,0.9,false,1.1,1.2", "mysticalworld:copper_spear,0.9,1.6,false,1.2,1.4", "mysticalworld:copper_sword,1.4,1,false,1.25,1.5", "mysticalworld:diamond_knife,0.7,2.0,false,1.5,2.5", "mysticalworld:diamond_spear,1.1,1.6,false,1.2,1.4", "mysticalworld:gold_knife,0.5,2.0,false,1.5,2.5", "mysticalworld:gold_spear,0.9,1.6,false,1.2,1.4", "mysticalworld:iron_knife,0.6,2.0,false,1.5,2.5", "mysticalworld:iron_spear,1.0,1.6,false,1.2,1.4", "mysticalworld:lead_axe,4.2,0.8,false,1.1,1.2", "mysticalworld:lead_hoe,0.6,1.4,false,1.4,2.0", "mysticalworld:lead_knife,1.0,2.0,false,1.5,2.5", "mysticalworld:lead_pickaxe,2.0,1,false,1.4,2.0", "mysticalworld:lead_shovel,2.8,0.9,false,1.1,1.2", "mysticalworld:lead_spear,1.3,1.6,false,1.2,1.4", "mysticalworld:lead_sword,1.8,1,false,1.25,1.5", "mysticalworld:quicksilver_axe,3.2,0.8,false,1.1,1.2", "mysticalworld:quicksilver_hoe,0.35,1.4,false,1.4,2.0", "mysticalworld:quicksilver_knife,0.5,2.0,false,1.5,2.5", "mysticalworld:quicksilver_pickaxe,1.5,1,false,1.4,2.0", "mysticalworld:quicksilver_shovel,2.4,0.9,false,1.1,1.2", "mysticalworld:quicksilver_spear,0.9,1.6,false,1.2,1.4", "mysticalworld:quicksilver_sword,1.4,1,false,1.25,1.5", "mysticalworld:silver_axe,3.2,0.8,false,1.1,1.2", "mysticalworld:silver_axe,3.2,0.8,false,1.1,1.2", "mysticalworld:silver_hoe,0.35,1.4,false,1.4,2.0", "mysticalworld:silver_knife,0.5,2.0,false,1.5,2.5", "mysticalworld:silver_pickaxe,1.5,1,false,1.4,2.0", "mysticalworld:silver_pickaxe,1.5,1,false,1.4,2.0", "mysticalworld:silver_shovel,2.4,0.9,false,1.1,1.2", "mysticalworld:silver_shovel,2.4,0.9,false,1.1,1.2", "mysticalworld:silver_spear,0.9,1.6,false,1.2,1.4", "mysticalworld:silver_sword,1.4,1,false,1.25,1.5", "mysticalworld:silver_sword,1.4,1,false,1.25,1.5", "mysticalworld:stone_knife,0.5,2.0,false,1.5,2.5", "mysticalworld:stone_spear,0.9,1.6,false,1.2,1.4", "mysticalworld:tin_axe,3.2,0.8,false,1.1,1.2", "mysticalworld:tin_hoe,0.35,1.4,false,1.4,2.0", "mysticalworld:tin_knife,0.5,2.0,false,1.5,2.5", "mysticalworld:tin_pickaxe,1.5,1,false,1.4,2.0", "mysticalworld:tin_shovel,2.4,0.9,false,1.1,1.2", "mysticalworld:tin_spear,0.9,1.6,false,1.2,1.4", "mysticalworld:tin_sword,1.4,1,false,1.25,1.5", "mysticalworld:wood_knife,0.4,2.0,false,1.5,2.5", "mysticalworld:wood_spear,0.8,1.6,false,1.2,1.4", "pamhc2foodcore:rolleritem,1.5,1.3,false,1.0,1.0", "pamhc2foodcore:saucepanitem,1.5,1.6,false,1.0,1.0", "pamhc2foodcore:skilletitem,2.0,1.5,false,1.0,1.0", "pandoras_creatures:arachnon_hammer,3.0,0.8,false,1.2,1.4", "pandoras_creatures:arachnon_hammer,4.5,0.8,false,1.1,1.2", "pyromancer:blazing_journal,2.0,1,true,20,0.1", "pyromancer:diamond_mace,5.1,1.0,false,1.1,1.2", "pyromancer:firelink,1.5,1,false,1.25,1.5", "pyromancer:golden_mace,4.7,1.0,false,1.1,1.2", "pyromancer:iron_mace,4.9,1.0,false,1.1,1.2", "pyromancer:netherite_mace,5.1,1.0,false,1.1,1.2", "pyromancyer:hogwhip,1.4,1.6,false,1.1,1.2", "rats:feral_bagh_nakhs,0.25,1.4,false,1.25,1.5", "rats:ghost_pirat_cutlass,1.2,1.0,false,1.5,2.0", "rats:pirat_cutlass,1.2,1.0,false,1.25,1.5", "rats:plague_scythe,2.0,1.4,false,1.5,2.5", "rats:ratlantis_axe,3.8,1.0,false,1.1,1.2", "rats:ratlantis_bow,1.5,1.6,false,1.0,1.0", "rats:ratlantis_hoe,0.5,1.0,false,1.4,2.0", "rats:ratlantis_pickaxe,1.4,1.0,false,1.4,2.0", "rats:ratlantis_shovel,2.8,1.0,false,1.1,1.2", "rats:ratlantis_sword,1.2,1.0,false,1.25,1.5", "rising_uppercut:gauntlet,1.0,1.5,false,1.2,1.4", "rootsclassic:bark_knife,0.5,1.8,false,1.5,2.5", "rootsclassic:crystal_staff,2.5,0.8,false,1.2,1.4", "rootsclassic:engraved_blade,3.4,0.8,false,1.1,1.2", "rootsclassic:living_axe,3.4,0.8,false,1.1,1.2", "rootsclassic:living_hoe,0.3,1.4,false,1.4,2", "rootsclassic:living_pickaxe,1.5,1,false,1.4,2", "rootsclassic:living_shovel,2.4,0.9,false,1.1,1.2", "rootsclassic:living_sword,1.4,1,false,1.25,1.5", "rootsclassic:staff,2.5,0.8,false,1.2,1.4", "savageandravage:cleaver_of_beheading,3.5,0.8,false,1.25,1.5", "silentgear:axe,3.3,0.8,false,1.1,1.2", "silentgear:bow,1.5,1.6,false,1.0,1.0", "silentgear:crossbow,2.0,1.5,true,20,0.1", "silentgear:dagger,0.5,1.8,false,1.5,2.5", "silentgear:excavator,3.5,1.3,false,1.1,1.2", "silentgear:hammer,4.5,1.5,false,1.1,1.2", "silentgear:katana,2.0,1.1,false,1.25,1.5", "silentgear:knife,0.5,1.8,false,1.5,2.5", "silentgear:machete,1.6,1,false,1.25,1.5", "silentgear:mattock,2,1.2,false,1.1,1.2", "silentgear:paxel,2.5,1.1,false,1.2,1.4", "silentgear:pickaxe,1.5,1,false,1.4,2", "silentgear:prospector_hammer,2.5,1.2,false,1.1,1.2", "silentgear:saw,1,1.7,false,1.1,1.1", "silentgear:shield,2.5,0.7,true,50,0.3", "silentgear:shovel,2.5,1.1,false,1.1,1.2", "silentgear:sickle,1.3,1.6,false,1.1,1.2", "silentgear:spear,1.2,1.5,false,1.25,1.5", "silentgear:sword,1.5,1,false,1.25,1.5", "spartanshields:shield_basic_bronze,2.0,0.8,true,40,0.3", "spartanshields:shield_basic_constantan,2.0,0.8,true,40,0.3", "spartanshields:shield_basic_copper,2.0,0.9,true,40,0.3", "spartanshields:shield_basic_diamond,2.0,0.7,true,40,0.3", "spartanshields:shield_basic_electrum,2.0,0.8,true,40,0.3", "spartanshields:shield_basic_gold,2.0,0.9,true,40,0.3", "spartanshields:shield_basic_invar,2.0,0.7,true,40,0.3", "spartanshields:shield_basic_iron,2.0,0.8,true,40,0.3", "spartanshields:shield_basic_lead,2.0,0.6,true,60,0.3", "spartanshields:shield_basic_netherite,2.0,0.6,true,40,0.3", "spartanshields:shield_basic_nickel,2.0,0.7,true,40,0.3", "spartanshields:shield_basic_obsidian,2.0,0.6,true,60,0.4", "spartanshields:shield_basic_platinum,2.0,0.5,true,40,0.2", "spartanshields:shield_basic_silver,2.0,0.9,true,40,0.3", "spartanshields:shield_basic_steel,2.0,0.7,true,40,0.3", "spartanshields:shield_basic_stone,2.0,0.9,true,40,0.3", "spartanshields:shield_basic_tin,2.0,0.9,true,40,0.3", "spartanshields:shield_basic_wood,2.0,1,true,40,0.3", "spartanshields:shield_botania_elementium,2.5,0.6,true,60,0.3", "spartanshields:shield_botania_manasteel,2.5,0.7,true,60,0.3", "spartanshields:shield_botania_terrasteel,2.5,0.5,true,60,0.4", "spartanshields:shield_mekanism_lapis_lazuli,2.5,0.8,true,60,0.3", "spartanshields:shield_mekanism_osmium,2.5,0.7,true,60,0.4", "spartanshields:shield_mekanism_refined_glowstone,2.5,0.7,true,60,0.3", "spartanshields:shield_mekanism_refined_obsidian,2.5,0.4,true,60,0.4", "spartanshields:shield_tower_bronze,2.5,0.7,true,60,0.4", "spartanshields:shield_tower_constantan,2.5,0.7,true,60,0.4", "spartanshields:shield_tower_copper,2.5,0.9,true,60,0.4", "spartanshields:shield_tower_diamond,2.5,0.6,true,60,0.4", "spartanshields:shield_tower_electrum,2.5,0.7,true,60,0.4", "spartanshields:shield_tower_gold,2.5,0.8,true,60,0.4", "spartanshields:shield_tower_invar,2.5,0.7,true,60,0.4", "spartanshields:shield_tower_iron,2.5,0.7,true,60,0.4", "spartanshields:shield_tower_lead,2.5,0.5,true,70,0.4", "spartanshields:shield_tower_netherite,2.5,0.6,true,60,0.4", "spartanshields:shield_tower_nickel,3,0.8,true,60,0.4", "spartanshields:shield_tower_obsidian,2.5,0.6,true,60,0.5", "spartanshields:shield_tower_platinum,2.5,0.4,true,60,0.3", "spartanshields:shield_tower_silver,2.5,0.8,true,60,0.4", "spartanshields:shield_tower_steel,3,0.6,true,60,0.4", "spartanshields:shield_tower_stone,3,0.8,true,60,0.4", "spartanshields:shield_tower_tin,2.5,0.9,true,60,0.4", "spartanshields:shield_tower_wood,2.5,0.9,true,60,0.4", "spartanweaponry:battleaxe_bronze,5.9,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_copper,5.7,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_diamond,6.1,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_electrum,5.9,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_gold,5.7,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_invar,5.9,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_iron,5.9,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_lead,6.5,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_netherite,6.1,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_nickel,5.9,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_platinum,6.1,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_silver,5.7,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_steel,5.9,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_stone,5.7,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_tin,5.7,0.9,false,1.1,1.2", "spartanweaponry:battleaxe_wood,5.5,0.9,false,1.1,1.2", "spartanweaponry:boomerang_bronze,1.7,1.2,false,1.3,1.6", "spartanweaponry:boomerang_copper,1.6,1.2,false,1.3,1.6", "spartanweaponry:boomerang_diamond,1. 8,1.2,false,1.3,1.6", "spartanweaponry:boomerang_electrum,1.7,1.2,false,1.3,1.6", "spartanweaponry:boomerang_gold,1.6,1.2,false,1.3,1.6", "spartanweaponry:boomerang_invar,1.7,1.2,false,1.3,1.6", "spartanweaponry:boomerang_iron,1.7,1.2,false,1.3,1.6", "spartanweaponry:boomerang_lead,1.8,1.2,false,1.3,1.6", "spartanweaponry:boomerang_netherite,1.8,1.2,false,1.3,1.6", "spartanweaponry:boomerang_nickel,1.7,1.2,false,1.3,1.6", "spartanweaponry:boomerang_platinum,1.8,1.2,false,1.3,1.6", "spartanweaponry:boomerang_silver,1.6,1.2,false,1.3,1.6", "spartanweaponry:boomerang_steel,1.7,1.2,false,1.3,1.6", "spartanweaponry:boomerang_stone,1.6,1.2,false,1.3,1.6", "spartanweaponry:boomerang_tin,1.6,1.2,false,1.3,1.6", "spartanweaponry:boomerang_wood,1.5,1.2,false,1.3,1.6", "spartanweaponry:cestus,0.8,1.5,false,1.2,1.4", "spartanweaponry:cestus_studded,1.0,1.4,false,1.2,1.4", "spartanweaponry:club_studded,4.5,1.2,false,1.2,1.4", "spartanweaponry:club_wood,3.5,1.2,false,1.2,1.4", "spartanweaponry:dagger_bronze,0.6,2,false,1.5,2.5", "spartanweaponry:dagger_copper,0.5,2.0,false,1.5,2.5", "spartanweaponry:dagger_diamond,0.7,2.0,false,1.5,2.5", "spartanweaponry:dagger_electrum,0.5,2,false,1.5,2.5", "spartanweaponry:dagger_gold,0.5,2.0,false,1.5,2.5", "spartanweaponry:dagger_invar,0.6,2,false,1.5,2.5", "spartanweaponry:dagger_iron,0.6,2.0,false,1.5,2.5", "spartanweaponry:dagger_lead,1.0,2.0,false,1.5,2.5", "spartanweaponry:dagger_netherite,0.8,2.0,false,1.5,2.5", "spartanweaponry:dagger_nickel,0.6,2,false,1.5,2.5", "spartanweaponry:dagger_platinum,0.7,2.0,false,1.5,2.5", "spartanweaponry:dagger_silver,0.5,2.0,false,1.5,2.5", "spartanweaponry:dagger_steel,0.6,2,false,1.5,2.5", "spartanweaponry:dagger_stone,0.5,2.0,false,1.5,2.5", "spartanweaponry:dagger_tin,0.5,2.0,false,1.5,2.5", "spartanweaponry:dagger_wood,0.4,2.0,false,1.5,2.5", "spartanweaponry:flanged_mace_bronze,4.9,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_copper,4.7,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_diamond,5.1,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_electrum,4.9,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_gold,4.7,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_invar,4.9,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_iron,4.9,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_lead,5.5,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_netherite,5.1,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_nickel,4.9,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_platinum,5.1,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_silver,4.7,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_steel,4.9,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_stone,4.7,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_tin,4.7,1.0,false,1.1,1.2", "spartanweaponry:flanged_mace_wood,4.5,1.0,false,1.1,1.2", "spartanweaponry:glaive_bronze,1.9,1.3,false,1.2,1.4", "spartanweaponry:glaive_copper,1.8,1.3,false,1.2,1.4", "spartanweaponry:glaive_diamond,2.0,1.3,false,1.2,1.4", "spartanweaponry:glaive_electrum,1.9,1.3,false,1.2,1.4", "spartanweaponry:glaive_gold,1.8,1.3,false,1.2,1.4", "spartanweaponry:glaive_invar,1.9,1.3,false,1.2,1.4", "spartanweaponry:glaive_iron,1.9,1.3,false,1.2,1.4", "spartanweaponry:glaive_lead,2.0,1.3,false,1.2,1.4", "spartanweaponry:glaive_netherite,2.0,1.3,false,1.2,1.4", "spartanweaponry:glaive_nickel,1.8,1.3,false,1.2,1.4", "spartanweaponry:glaive_platinum,2.0,1.3,false,1.2,1.4", "spartanweaponry:glaive_silver,1.8,1.3,false,1.2,1.4", "spartanweaponry:glaive_steel,1.9,1.3,false,1.2,1.4", "spartanweaponry:glaive_stone,1.8,1.3,false,1.2,1.4", "spartanweaponry:glaive_tin,1.8,1.3,false,1.2,1.4", "spartanweaponry:glaive_wood,1.7,1.3,false,1.2,1.4", "spartanweaponry:greatsword_bronze,3,0.8,false,1.1,1.2", "spartanweaponry:greatsword_copper,2.9,0.8,false,1.1,1.2", "spartanweaponry:greatsword_diamond,3.1,0.8,false,1.1,1.2", "spartanweaponry:greatsword_electrum,3,0.8,false,1.1,1.2", "spartanweaponry:greatsword_gold,2.9,0.8,false,1.1,1.2", "spartanweaponry:greatsword_invar,3,0.8,false,1.1,1.2", "spartanweaponry:greatsword_iron,3,0.8,false,1.1,1.2", "spartanweaponry:greatsword_lead,3.1,0.8,false,1.1,1.2", "spartanweaponry:greatsword_netherite,3.1,0.8,false,1.1,1.2", "spartanweaponry:greatsword_nickel,3,0.8,false,1.1,1.2", "spartanweaponry:greatsword_platinum,3.1,0.8,false,1.1,1.2", "spartanweaponry:greatsword_silver,2.9,0.8,false,1.1,1.2", "spartanweaponry:greatsword_steel,3,0.8,false,1.1,1.2", "spartanweaponry:greatsword_stone,2.9,0.8,false,1.1,1.2", "spartanweaponry:greatsword_tin,2.9,0.8,false,1.1,1.2", "spartanweaponry:greatsword_wood,2.8,0.8,false,1.1,1.2", "spartanweaponry:halberd_bronze,4.5,1.2,false,1.1,1.2", "spartanweaponry:halberd_copper,4.3,1.2,false,1.1,1.2", "spartanweaponry:halberd_diamond,4.7,1.2,false,1.1,1.2", "spartanweaponry:halberd_electrum,4.5,1.2,false,1.1,1.2", "spartanweaponry:halberd_gold,4.3,1.2,false,1.1,1.2", "spartanweaponry:halberd_invar,4.5,1.2,false,1.1,1.2", "spartanweaponry:halberd_iron,4.5,1.2,false,1.1,1.2", "spartanweaponry:halberd_lead,4.7,1.2,false,1.1,1.2", "spartanweaponry:halberd_netherite,4.7,1.2,false,1.1,1.2", "spartanweaponry:halberd_nickel,4.5,1.2,false,1.1,1.2", "spartanweaponry:halberd_platinum,4.7,1.2,false,1.1,1.2", "spartanweaponry:halberd_silver,4.3,1.2,false,1.1,1.2", "spartanweaponry:halberd_steel,4.5,1.2,false,1.1,1.2", "spartanweaponry:halberd_stone,4.3,1.2,false,1.1,1.2", "spartanweaponry:halberd_tin,4.3,1.2,false,1.1,1.2", "spartanweaponry:halberd_wood,4.1,1.2,false,1.1,1.2", "spartanweaponry:hammer_bronze,4.4,1.0,false,1.1,1.2", "spartanweaponry:hammer_copper,4.2,1.0,false,1.1,1.2", "spartanweaponry:hammer_diamond,4.6,1.0,false,1.1,1.2", "spartanweaponry:hammer_electrum,4.4,1.0,false,1.1,1.2", "spartanweaponry:hammer_gold,4.2,1.0,false,1.1,1.2", "spartanweaponry:hammer_invar,4.4,1.0,false,1.1,1.2", "spartanweaponry:hammer_iron,4.4,1.0,false,1.1,1.2", "spartanweaponry:hammer_lead,5.0,1.0,false,1.1,1.2", "spartanweaponry:hammer_netherite,4.8,1.0,false,1.1,1.2", "spartanweaponry:hammer_nickel,4.4,1.0,false,1.1,1.2", "spartanweaponry:hammer_platinum,4.6,1.0,false,1.1,1.2", "spartanweaponry:hammer_silver,4.2,1.0,false,1.1,1.2", "spartanweaponry:hammer_steel,4.4,1.0,false,1.1,1.2", "spartanweaponry:hammer_stone,4.2,1.0,false,1.1,1.2", "spartanweaponry:hammer_tin,4.2,1.0,false,1.1,1.2", "spartanweaponry:hammer_wood,4.0,1.0,false,1.1,1.2", "spartanweaponry:heavy_crossbow_bronze,2.2,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_copper,2.1,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_diamond,2.2,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_electrum,2.1,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_gold,2.1,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_invar,2.2,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_iron,2.2,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_lead,2.8,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_leather,2.1,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_netherite,2.3,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_nickel,2.2,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_platinum,2.3,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_silver,2.1,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_steel,2.2,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_tin,2.1,1.5,true,20,0.1", "spartanweaponry:heavy_crossbow_wood,2.0,1.5,true,20,0.1", "spartanweaponry:javelin_bronze,1.5,1.6,false,1.2,1.4", "spartanweaponry:javelin_copper,2,1.6,false,1.2,1.4", "spartanweaponry:javelin_diamond,1.6,1.6,false,1.2,1.4", "spartanweaponry:javelin_electrum,1.7,1.6,false,1.2,1.4", "spartanweaponry:javelin_gold,1.5,1.6,false,1.2,1.4", "spartanweaponry:javelin_invar,1.4,1.6,false,1.2,1.4", "spartanweaponry:javelin_iron,1.5,1.6,false,1.2,1.4", "spartanweaponry:javelin_lead,1.5,1.6,false,1.2,1.4", "spartanweaponry:javelin_netherite,1.6,1.6,false,1.2,1.4", "spartanweaponry:javelin_nickel,1.5,1.6,false,1.2,1.4", "spartanweaponry:javelin_platinum,1.6,1.6,false,1.2,1.4", "spartanweaponry:javelin_silver,1.4,1.6,false,1.2,1.4", "spartanweaponry:javelin_steel,1.6,1.6,false,1.2,1.4", "spartanweaponry:javelin_stone,1.4,1.6,false,1.2,1.4", "spartanweaponry:javelin_tin,2,1.6,false,1.2,1.4", "spartanweaponry:javelin_wood,1.3,1.6,false,1.2,1.4", "spartanweaponry:katana_bronze,2.2,1.0,false,1.25,1.5", "spartanweaponry:katana_copper,2.1,1.0,false,1.25,1.5", "spartanweaponry:katana_diamond,2.3,1.0,false,1.25,1.5", "spartanweaponry:katana_electrum,2.1,1.0,false,1.25,1.5", "spartanweaponry:katana_gold,2.1,1.0,false,1.25,1.5", "spartanweaponry:katana_invar,2.2,1.0,false,1.25,1.5", "spartanweaponry:katana_iron,2.2,1.0,false,1.25,1.5", "spartanweaponry:katana_lead,2.2,1.0,false,1.25,1.5", "spartanweaponry:katana_netherite,2.3,1.0,false,1.25,1.5", "spartanweaponry:katana_nickel,2.2,1.0,false,1.25,1.5", "spartanweaponry:katana_platinum,2.3,1.0,false,1.25,1.5", "spartanweaponry:katana_silver,2.1,1.0,false,1.25,1.5", "spartanweaponry:katana_steel,2.2,1.0,false,1.25,1.5", "spartanweaponry:katana_stone,2.1,1.0,false,1.25,1.5", "spartanweaponry:katana_tin,2.1,1.0,false,1.25,1.5", "spartanweaponry:katana_wood,2.0,1.0,false,1.25,1.5", "spartanweaponry:lance_bronze,3.4,1,false,1.1,1.2", "spartanweaponry:lance_copper,3.3,1,false,1.1,1.2", "spartanweaponry:lance_diamond,3.5,1,false,1.1,1.2", "spartanweaponry:lance_electrum,3.4,1,false,1.1,1.2", "spartanweaponry:lance_gold,3.3,1,false,1.1,1.2", "spartanweaponry:lance_invar,3.4,1,false,1.1,1.2", "spartanweaponry:lance_iron,3.4,1,false,1.1,1.2", "spartanweaponry:lance_lead,3.5,1,false,1.1,1.2", "spartanweaponry:lance_netherite,3.5,1,false,1.1,1.2", "spartanweaponry:lance_nickel,3.4,1,false,1.1,1.2", "spartanweaponry:lance_platinum,3.5,0.7,false,1.1,1.2", "spartanweaponry:lance_silver,3.3,1,false,1.1,1.2", "spartanweaponry:lance_steel,3.4,1,false,1.1,1.2", "spartanweaponry:lance_stone,3.3,1,false,1.1,1.2", "spartanweaponry:lance_tin,3.3,1,false,1.1,1.2", "spartanweaponry:lance_wood,3.2,1,false,1.1,1.2", "spartanweaponry:longbow_bronze,1.4,1.8,false,1.0,1.0", "spartanweaponry:longbow_copper,1.3,1.8,false,1.0,1.0", "spartanweaponry:longbow_diamond,1.5,1.8,false,1.0,1.0", "spartanweaponry:longbow_electrum,1.3,1.8,false,1.0,1.0", "spartanweaponry:longbow_gold,1.4,1.8,false,1.0,1.0", "spartanweaponry:longbow_invar,1.4,1.8,false,1.0,1.0", "spartanweaponry:longbow_iron,1.4,1.8,false,1.0,1.0", "spartanweaponry:longbow_lead,1.8,1.8,false,1.0,1.0", "spartanweaponry:longbow_leather,1.3,1.8,false,1.0,1.0", "spartanweaponry:longbow_netherite,1.6,1.8,false,1.0,1.0", "spartanweaponry:longbow_nickel,1.4,1.8,false,1.0,1.0", "spartanweaponry:longbow_platinum,1.5,1.8,false,1.0,1.0", "spartanweaponry:longbow_silver,1.3,1.8,false,1.0,1.0", "spartanweaponry:longbow_steel,1.4,1.8,false,1.0,1.0", "spartanweaponry:longbow_tin,1.3,1.8,false,1.0,1.0", "spartanweaponry:longbow_wood,1.3,1.8,false,1.0,1.0", "spartanweaponry:longsword_bronze,2.4,0.9,false,1.25,1.5", "spartanweaponry:longsword_copper,2.3,0.9,false,1.25,1.5", "spartanweaponry:longsword_diamond,2.5,0.9,false,1.25,1.5", "spartanweaponry:longsword_electrum,2.4,0.9,false,1.25,1.5", "spartanweaponry:longsword_gold,2.3,0.9,false,1.25,1.5", "spartanweaponry:longsword_invar,2.4,0.9,false,1.25,1.5", "spartanweaponry:longsword_iron,2.4,0.9,false,1.25,1.5", "spartanweaponry:longsword_lead,2.5,0.9,false,1.25,1.5", "spartanweaponry:longsword_netherite,2.5,0.9,false,1.25,1.5", "spartanweaponry:longsword_nickel,2.4,0.9,false,1.25,1.5", "spartanweaponry:longsword_platinum,2.5,0.9,false,1.25,1.5", "spartanweaponry:longsword_silver,2.3,0.9,false,1.25,1.5", "spartanweaponry:longsword_steel,2.4,0.9,false,1.25,1.5", "spartanweaponry:longsword_stone,2.3,0.9,false,1.25,1.5", "spartanweaponry:longsword_tin,2.3,0.9,false,1.25,1.5", "spartanweaponry:longsword_wood,2.2,0.9,false,1.25,1.5", "spartanweaponry:parrying_dagger_bronze, 0.9, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_copper, 0.8, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_diamond, 1.0, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_electrum, 0.8, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_gold, 0.8, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_invar, 0.9, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_iron, 0.9, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_lead, 1.3, 1.4, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_netherite, 1.1, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_nickel, 0.9, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_platinum, 1.0, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_silver, 0.8, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_steel, 0.9, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_stone, 0.8, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_tin, 0.8, 1.5, false, 1.5, 2.5", "spartanweaponry:parrying_dagger_wood, 0.7, 1.5, false, 1.5, 2.5", "spartanweaponry:pike_bronze,1.1,1.6,false,1.2,1.4", "spartanweaponry:pike_copper,1,1.6,false,1.2,1.4", "spartanweaponry:pike_diamond,1.2,1.6,false,1.2,1.4", "spartanweaponry:pike_electrum,1.1,1.6,false,1.2,1.4", "spartanweaponry:pike_gold,1,1.6,false,1.2,1.4", "spartanweaponry:pike_invar,1.1,1.6,false,1.2,1.4", "spartanweaponry:pike_iron,1.1,1.6,false,1.2,1.4", "spartanweaponry:pike_lead,1.2,1.6,false,1.2,1.4", "spartanweaponry:pike_netherite,1.2,1.6,false,1.2,1.4", "spartanweaponry:pike_nickel,1.1,1.6,false,1.2,1.4", "spartanweaponry:pike_platinum,1.2,1.5,false,1.2,1.4", "spartanweaponry:pike_silver,1,1.6,false,1.2,1.4", "spartanweaponry:pike_steel,1.1,1.6,false,1.2,1.4", "spartanweaponry:pike_stone,1,1.6,false,1.2,1.4", "spartanweaponry:pike_tin,1,1.6,false,1.2,1.4", "spartanweaponry:pike_wood,0.9,1.6,false,1.2,1.4", "spartanweaponry:quarterstaff_bronze,2.7,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_copper,2.6,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_diamond,2.8,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_electrum,2.6,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_gold,2.6,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_invar,2.6,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_iron,2.7,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_lead,2.7,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_netherite,2.8,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_nickel,2.6,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_platinum,2.8,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_silver,2.6,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_steel,2.7,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_stone,2.6,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_tin,2.6,0.8,false,1.2,1.4", "spartanweaponry:quarterstaff_wood,2.5,0.8,false,1.2,1.4", "spartanweaponry:rapier_bronze,1.4,1.1,false,1.35,1.6", "spartanweaponry:rapier_copper,1.3,1.1,false,1.35,1.6", "spartanweaponry:rapier_diamond,1.5,1.1,false,1.35,1.6", "spartanweaponry:rapier_electrum,1.3,1.1,false,1.35,1.6", "spartanweaponry:rapier_gold,1.3,1.1,false,1.35,1.6", "spartanweaponry:rapier_invar,1.4,1.1,false,1.35,1.6", "spartanweaponry:rapier_iron,1.4,1.1,false,1.35,1.6", "spartanweaponry:rapier_lead,1.7,1.1,false,1.35,1.6", "spartanweaponry:rapier_netherite,1.5,1.1,false,1.35,1.6", "spartanweaponry:rapier_nickel,1.4,1.1,false,1.35,1.6", "spartanweaponry:rapier_platinum,1.5,1.1,false,1.35,1.6", "spartanweaponry:rapier_silver,1.3,1.1,false,1.35,1.6", "spartanweaponry:rapier_steel,1.4,1.1,false,1.35,1.6", "spartanweaponry:rapier_stone,1.3,1.1,false,1.35,1.6", "spartanweaponry:rapier_tin,1.3,1.1,false,1.35,1.6", "spartanweaponry:rapier_wood,1.2,1.1,false,1.35,1.6", "spartanweaponry:saber_bronze,1.7,0.9,false,1.25,1.5", "spartanweaponry:saber_copper,1.5,0.9,false,1.25,1.5", "spartanweaponry:saber_diamond,1.8,0.9,false,1.25,1.5", "spartanweaponry:saber_electrum,1.6,0.9,false,1.25,1.5", "spartanweaponry:saber_gold,1.5,0.9,false,1.25,1.5", "spartanweaponry:saber_invar,1.7,0.9,false,1.25,1.5", "spartanweaponry:saber_iron,1.7,0.9,false,1.25,1.5", "spartanweaponry:saber_lead,2.0,0.9,false,1.25,1.5", "spartanweaponry:saber_netherite,1.9,0.9,false,1.25,1.5", "spartanweaponry:saber_nickel,1.7,0.9,false,1.25,1.5", "spartanweaponry:saber_platinum,1.9,0.9,false,1.25,1.5", "spartanweaponry:saber_silver,1.6,0.9,false,1.25,1.5", "spartanweaponry:saber_steel,1.7,0.9,false,1.25,1.5", "spartanweaponry:saber_stone,1.6,0.9,false,1.25,1.5", "spartanweaponry:saber_tin,1.5,0.9,false,1.25,1.5", "spartanweaponry:saber_wood,1.5,0.9,false,1.25,1.5", "spartanweaponry:scythe_bronze, 1.7, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_copper, 1.55, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_diamond, 1.7, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_electrum, 1.55, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_gold, 1.55, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_invar, 1.7, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_iron, 1.7, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_lead, 2.15, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_netherite, 1.85, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_nickel, 1.7, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_platinum, 1.7, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_silver, 1.55, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_steel, 1.7, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_stone, 1.55, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_tin, 1.55, 1.2, false, 1.4, 1.8", "spartanweaponry:scythe_wood, 1.4, 1.2, false, 1.4, 1.8", "spartanweaponry:spear_bronze,1.1,1.6,false,1.2,1.4", "spartanweaponry:spear_copper,1,1.6,false,1.2,1.4", "spartanweaponry:spear_diamond,1.2,1.6,false,1.2,1.4", "spartanweaponry:spear_electrum,1.1,1.6,false,1.2,1.4", "spartanweaponry:spear_gold,1,1.6,false,1.2,1.4", "spartanweaponry:spear_invar,1.1,1.6,false,1.2,1.4", "spartanweaponry:spear_iron,1.1,1.6,false,1.2,1.4", "spartanweaponry:spear_lead,1.2,1.6,false,1.2,1.4", "spartanweaponry:spear_netherite,1.2,1.6,false,1.2,1.4", "spartanweaponry:spear_nickel,1.1,1.6,false,1.2,1.4", "spartanweaponry:spear_platinum,1.2,1.6,false,1.2,1.4", "spartanweaponry:spear_silver,1,1.6,false,1.2,1.4", "spartanweaponry:spear_steel,1.1,1.6,false,1.2,1.4", "spartanweaponry:spear_stone,1,1.6,false,1.2,1.4", "spartanweaponry:spear_tin,1,1.6,false,1.2,1.4", "spartanweaponry:spear_wood,0.9,1.6,false,1.2,1.4", "spartanweaponry:throwing_knife_bronze,0.7,2,false,1.5,2.5", "spartanweaponry:throwing_knife_copper,0.6,2,false,1.5,2.5", "spartanweaponry:throwing_knife_diamond,0.8,2,false,1.5,2.5", "spartanweaponry:throwing_knife_electrum,0.7,2,false,1.5,2.5", "spartanweaponry:throwing_knife_gold,0.6,2,false,1.5,2.5", "spartanweaponry:throwing_knife_invar,0.7,2,false,1.5,2.5", "spartanweaponry:throwing_knife_iron,0.7,2,false,1.5,2.5", "spartanweaponry:throwing_knife_lead,0.8,2,false,1.5,2.5", "spartanweaponry:throwing_knife_netherite,0.8,2,false,1.5,2.5", "spartanweaponry:throwing_knife_nickel,0.7,2,false,1.5,2.5", "spartanweaponry:throwing_knife_platinum,0.8,2,false,1.5,2.5", "spartanweaponry:throwing_knife_silver,0.6,2,false,1.5,2.5", "spartanweaponry:throwing_knife_steel,0.7,2,false,1.5,2.5", "spartanweaponry:throwing_knife_stone,0.6,2,false,1.5,2.5", "spartanweaponry:throwing_knife_tin,0.6,2,false,1.5,2.5", "spartanweaponry:throwing_knife_wood,0.6,2,false,1.5,2.5", "spartanweaponry:tomahawk_bronze,2.7,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_copper,2.6,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_diamond,2.8,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_electrum,2.6,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_gold,2.6,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_invar,2.7,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_iron,2.7,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_lead,2.7,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_netherite,2.8,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_nickel,2.7,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_platinum,2.8,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_silver,2.6,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_steel,2.7,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_stone,2.6,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_tin,2.6,1.2,false,1.25,1.5", "spartanweaponry:tomahawk_wood,2.5,1.2,false,1.25,1.5", "spartanweaponry:warhammer_bronze,6.9,1.2,false,1.1,1.2", "spartanweaponry:warhammer_copper,6.7,1.2,false,1.1,1.2", "spartanweaponry:warhammer_diamond,7.1,1.2,false,1.1,1.2", "spartanweaponry:warhammer_electrum,6.9,1.2,false,1.1,1.2", "spartanweaponry:warhammer_gold,6.7,1.2,false,1.1,1.2", "spartanweaponry:warhammer_invar,6.9,1.2,false,1.1,1.2", "spartanweaponry:warhammer_iron,6.9,1.2,false,1.1,1.2", "spartanweaponry:warhammer_lead,7.4,1.2,false,1.1,1.2", "spartanweaponry:warhammer_netherite,7.1,1.2,false,1.1,1.2", "spartanweaponry:warhammer_nickel,6.7,1.2,false,1.1,1.2", "spartanweaponry:warhammer_platinum,7.1,1.2,false,1.1,1.2", "spartanweaponry:warhammer_silver,6.7,1.2,false,1.1,1.2", "spartanweaponry:warhammer_steel,6.9,1.2,false,1.1,1.2", "spartanweaponry:warhammer_stone,6.7,1.2,false,1.1,1.2", "spartanweaponry:warhammer_tin,6.7,1.2,false,1.1,1.2", "spartanweaponry:warhammer_wood,6.5,1.2,false,1.1,1.2", "switchbow:switchcrossbow,1.0,1.0,false,1.1,1.2", "switchbow:switchbow,1.0,1.0,false,1.1,1.2", "twilightforest:block_and_chain,4.0,1.4,false,1.1,1.2", "twilightforest:ender_bow,1.5,1.7,false,1.0,1.0", "twilightforest:fiery_pickaxe,1.6,1.0,false,1.4,2.0", "twilightforest:fiery_sword,1.6,1.0,false,1.25,1.5", "twilightforest:giant_pickaxe,4.0,0.8,false,1.4,2.0", "twilightforest:giant_sword,6.0,0.6,false,1.25,1.5", "twilightforest:glass_sword,20,2.0,false,2.0,5.0", "twilightforest:ice_bow,1.5,1.7,false,1.0,1.0", "twilightforest:ice_sword,1.5,1.0,false,1.25,1.5", "twilightforest:ironwood_axe,3.4,0.8,false,1.1,1.2", "twilightforest:ironwood_hoe,0.35,1.4,false,1.4,2.0", "twilightforest:ironwood_pickaxe,1.4,1.0,false,1.4,2.0", "twilightforest:ironwood_shovel,2.4,0.9,false,1.1,1.2", "twilightforest:ironwood_sword,1.4,1.0,false,1.25,1.5", "twilightforest:knightmetal_axe,1.0,1.0,false,1.1,1.2", "twilightforest:knightmetal_pickaxe,1.0,1.0,false,1.4,2.0", "twilightforest:knightmetal_shield,2.0,0.6,true,40,0.4", "twilightforest:knightmetal_sword,1.0,1.0,false,1.25,1.5", "twilightforest:mazebreaker_pickaxe,1.8,1.0,false,1.4,2.0", "twilightforest:minotaur_axe,4.0,0.9,false,1.1,1.2", "twilightforest:minotaur_axe_gold,3.5,0.9,false,1.1,1.2", "twilightforest:seeker_bow,1.5,1.7,false,1.0,1.0", "twilightforest:steeleaf_axe,3.6,0.9,false,1.1,1.2", "twilightforest:steeleaf_hoe,0.4,1.4,false,1.4,2.0", "twilightforest:steeleaf_pickaxe,1.5,1.0,false,1.4,2.0", "twilightforest:steeleaf_shovel,2.6,0.9,false,1.1,1.2", "twilightforest:steeleaf_sword,1.5,1.0,false,1.25,1.5", "twilightforest:triple_bow,1.5,1.7,false,1.0,1.0", "vampirism:heart_seeker_enhanced,2.8,1,false,1.25,1.5", "vampirism:heart_seeker_normal,2.7,1.1,false,1.2,1.4", "vampirism:heart_seeker_ultimate,2.9,1,false,1.3,1.6", "vampirism:heart_striker_enhanced,2.4,0.9,false,1.5,2.5", "vampirism:heart_striker_normal,2.3,0.9,false,1.4,2.4", "vampirism:heart_striker_ultimate,2.5,0.8,false,1.6,2.6", "vampirism:hunter_axe_enhanced,5.7,0.8,false,1.1,1.2", "vampirism:hunter_axe_normal,5.5,0.9,false,1.1,1.2", "vampirism:hunter_axe_ultimate,6,0.7,false,1.1,1.2", "vampirism:pitchfork,2.5,1.6,false,1.1,1.2", "vampirism:stake,2.5,1.6,false,1.5,2", "vanillafoodpantry:flint_butcher_axe,5.0,1.0,false,1.2,1.4", "vanillafoodpantry:rolling_pin,1.5,1.3,false,1.0,1.0", "wyrmroost:blue_geode_axe,3.8,0.8,false,1.1,1.2", "wyrmroost:blue_geode_hoe,0.35,1.4,false,1.4,2", "wyrmroost:blue_geode_pickaxe,1.5,1,false,1.4,2", "wyrmroost:blue_geode_shovel,3.0,0.9,false,1.1,1.2", "wyrmroost:blue_geode_sword,1.7,1,false,1.25,1.5", "wyrmroost:platinum_axe,3.5,0.8,false,1.1,1.2", "wyrmroost:platinum_hoe,0.35,1.4,false,1.4,2", "wyrmroost:platinum_pickaxe,1.5,1,false,1.4,2", "wyrmroost:platinum_shovel,2.8,0.9,false,1.1,1.2", "wyrmroost:platinum_sword,1.7,1,false,1.25,1.5", "wyrmroost:purple_geode_axe,4.3,0.8,false,1.1,1.2", "wyrmroost:purple_geode_hoe,0.4,1.4,false,1.4,2", "wyrmroost:purple_geode_pickaxe,1.7,1,false,1.4,2", "wyrmroost:purple_geode_shovel,3.4,0.9,false,1.1,1.2", "wyrmroost:purple_geode_sword,1.9,1,false,1.25,1.5", "wyrmroost:red_geode_axe,4.1,0.8,false,1.1,1.2", "wyrmroost:red_geode_hoe,0.35,1.4,false,1.4,2", "wyrmroost:red_geode_pickaxe,1.6,1,false,1.4,2", "wyrmroost:red_geode_shovel,3.2,0.9,false,1.1,1.2", "wyrmroost:red_geode_sword,1.8,1,false,1.25,1.5", "xreliquary:handgun,1.8,1.5,false,1.0,1.0", "xreliquary:magicbane,1.0,1.6,false,1.6,2.8", "xreliquary:mercy_cross,8.0,0.6,false,1.5,2.0", "xreliquary:sojourner_staff,1.0,1.2,false,1.1,1.2", "minecraft:oak_trapdoor,0.7,0.9,false,1.0,1.0", "minecraft:spruce_trapdoor,0.7,0.9,true,40,0.2", "minecraft:birch_trapdoor,0.7,0.9,true,40,0.2", "minecraft:jungle_trapdoor,0.7,0.9,true,40,0.2", "minecraft:acacia_trapdoor,0.7,0.9,true,40,0.2", "minecraft:dark_oak_trapdoor,0.7,0.9,true,40,0.2", "minecraft:crimson_trapdoor,0.7,0.9,true,40,0.2", "minecraft:warped_trapdoor,0.7,0.9,true,40,0.2", "minecraft:iron_trapdoor,0.9,0.7,true,50,0.2", "ars_nouveau:archwood_trapdoor,0.7,0.9,true,40,0.2", "atmospheric:rosewood_trapdoor,0.7,0.9,true,40,0.2", "atmospheric:morado_trapdoor,0.7,0.9,true,40,0.2", "atmospheric:yucca_trapdoor,0.7,0.9,true,40,0.2", "atmospheric:kousa_trapdoor,0.7,0.9,true,40,0.2", "atmospheric:aspen_trapdoor,0.7,0.9,true,40,0.2", "atmospheric:grimwood_trapdoor,0.7,0.9,true,40,0.2", "byg:aspen_trapdoor,0.7,0.9,true,40,0.2", "byg:baobab_trapdoor,0.7,0.9,true,40,0.2", "byg:blue_enchanted_trapdoor,0.7,0.9,true,40,0.2", "byg:bulbis_trapdoor,0.7,0.9,true,40,0.2", "byg:cherry_trapdoor,0.7,0.9,true,40,0.2", "byg:cika_trapdoor,0.7,0.9,true,40,0.2", "byg:cypress_trapdoor,0.7,0.9,true,40,0.2", "byg:ebony_trapdoor,0.7,0.9,true,40,0.2", "byg:ether_trapdoor,0.7,0.9,true,40,0.2", "byg:fir_trapdoor,0.7,0.9,true,40,0.2", "byg:green_enchanted_trapdoor,0.7,0.9,true,40,0.2", "byg:holly_trapdoor,0.7,0.9,true,40,0.2", "byg:imparius_trapdoor,0.7,0.9,true,40,0.2", "byg:jacaranda_trapdoor,0.7,0.9,true,40,0.2", "byg:lament_trapdoor,0.7,0.9,true,40,0.2", "byg:mahogany_trapdoor,0.7,0.9,true,40,0.2", "byg:mangrove_trapdoor,0.7,0.9,true,40,0.2", "byg:maple_trapdoor,0.7,0.9,true,40,0.2", "byg:nightshade_trapdoor,0.7,0.9,true,40,0.2", "byg:palm_trapdoor,0.7,0.9,true,40,0.2", "byg:pine_trapdoor,0.7,0.9,true,40,0.2", "byg:rainbow_eucalyptus_trapdoor,0.7,0.9,true,40,0.2", "byg:redwood_trapdoor,0.7,0.9,true,40,0.2", "byg:skyris_trapdoor,0.7,0.9,true,40,0.2", "byg:willow_trapdoor,0.7,0.9,true,40,0.2", "byg:witch_hazel_trapdoor,0.7,0.9,true,40,0.2", "byg:zelkova_trapdoor,0.7,0.9,true,40,0.2", "byg:sythian_trapdoor,0.7,0.9,true,40,0.2", "byg:embur_trapdoor,0.7,0.9,true,40,0.2", "endergetic:poise_trapdoor,0.7,0.9,true,40,0.2", "outer_end:azure_trapdoor,0.7,0.9,true,40,0.2", "betterendforge:mossy_glowshroom_trapdoor,0.7,0.9,true,40,0.2", "betterendforge:lacugrove_trapdoor,0.7,0.9,true,40,0.2", "betterendforge:end_lotus_trapdoor,0.7,0.9,true,40,0.2", "betterendforge:pythadendron_trapdoor,0.7,0.9,true,40,0.2", "betterendforge:dragon_tree_trapdoor,0.7,0.9,true,40,0.2", "betterendforge:tenanea_trapdoor,0.7,0.9,true,40,0.2", "betterendforge:helix_tree_trapdoor,0.7,0.9,true,40,0.2", "betterendforge:umbrella_tree_trapdoor,0.7,0.9,true,40,0.2", "betterendforge:jellyshroom_trapdoor,0.7,0.9,true,40,0.2", "betterendforge:lucernia_trapdoor,0.7,0.9,true,40,0.2", "betterendforge:thallasium_trapdoor,1.0,0.8,true,40,0.2", "betterendforge:terminite_trapdoor,1.0,0.7,true,40,0.2", "environmental:willow_trapdoor,0.7,0.9,true,40,0.2", "environmental:cherry_trapdoor,0.7,0.9,true,40,0.2", "environmental:wisteria_trapdoor,0.7,0.9,true,40,0.2", "traverse:fir_trapdoor,0.7,0.9,true,40,0.2", "darkerdepths:petrified_trapdoor,0.7,0.9,true,40,0.2", "securitycraft:reinforced_iron_trapdoor,2.0,0.5,true,60,0.2", "betternether:stalagnate_planks_trapdoor,0.7,0.9,true,40,0.2", "betternether:reeds_trapdoor,0.7,0.9,true,40,0.2", "betternether:willow_trapdoor,0.7,0.9,true,40,0.2", "betternether:wart_trapdoor,0.7,0.9,true,40,0.2", "betternether:rubeus_trapdoor,0.7,0.9,true,40,0.2", "betternether:mushroom_trapdoor,0.7,0.9,true,40,0.2", "betternether:mushroom_fir_trapdoor,0.7,0.9,true,40,0.2", "betternether:anchor_tree_trapdoor,0.7,0.9,true,40,0.2", "betternether:nether_sakura_trapdoor,0.7,0.9,true,40,0.2", "minecraft:iron_door,1.5,0.7,true,70,0.4", "minecraft:oak_door,1.25,0.8,true,60,0.4", "minecraft:spruce_door,1.25,0.8,true,60,0.4", "minecraft:birch_door,1.25,0.8,true,60,0.4", "minecraft:jungle_door,1.25,0.8,true,60,0.4", "minecraft:acacia_door,1.25,0.8,true,60,0.4", "minecraft:dark_oak_door,1.25,0.8,true,60,0.4", "minecraft:crimson_door,1.25,0.8,true,60,0.4", "minecraft:warped_door,1.25,0.8,true,60,0.4", "ars_nouveau:archwood_door,1.25,0.8,true,60,0.4", "atmospheric:rosewood_door,1.25,0.8,true,60,0.4", "atmospheric:morado_door,1.25,0.8,true,60,0.4", "atmospheric:yucca_door,1.25,0.8,true,60,0.4", "atmospheric:kousa_door,1.25,0.8,true,60,0.4", "atmospheric:aspen_door,1.25,0.8,true,60,0.4", "atmospheric:grimwood_door,1.25,0.8,true,60,0.4", "byg:aspen_door,1.25,0.8,true,60,0.4", "byg:baobab_door,1.25,0.8,true,60,0.4", "byg:blue_enchanted_door,1.25,0.8,true,60,0.4", "byg:bulbis_door,1.25,0.8,true,60,0.4", "byg:cherry_door,1.25,0.8,true,60,0.4", "byg:cika_door,1.25,0.8,true,60,0.4", "byg:cypress_door,1.25,0.8,true,60,0.4", "byg:ebony_door,1.25,0.8,true,60,0.4", "byg:ether_door,1.25,0.8,true,60,0.4", "byg:fir_door,1.25,0.8,true,60,0.4", "byg:green_enchanted_door,1.25,0.8,true,60,0.4", "byg:holly_door,1.25,0.8,true,60,0.4", "byg:imparius_door,1.25,0.8,true,60,0.4", "byg:jacaranda_door,1.25,0.8,true,60,0.4", "byg:lament_door,1.25,0.8,true,60,0.4", "byg:mahogany_door,1.25,0.8,true,60,0.4", "byg:mangrove_door,1.25,0.8,true,60,0.4", "byg:maple_door,1.25,0.8,true,60,0.4", "byg:nightshade_door,1.25,0.8,true,60,0.4", "byg:palm_door,1.25,0.8,true,60,0.4", "byg:pine_door,1.25,0.8,true,60,0.4", "byg:rainbow_eucalyptus_door,1.25,0.8,true,60,0.4", "byg:redwood_door,1.25,0.8,true,60,0.4", "byg:skyris_door,1.25,0.8,true,60,0.4", "byg:willow_door,1.25,0.8,true,60,0.4", "byg:witch_hazel_door,1.25,0.8,true,60,0.4", "byg:zelkova_door,1.25,0.8,true,60,0.4", "byg:sythian_door,1.25,0.8,true,60,0.4", "byg:embur_door,1.25,0.8,true,60,0.4", "endergetic:poise_door,1.25,0.8,true,60,0.4", "outer_end:azure_door,1.25,0.8,true,60,0.4", "betterendforge:mossy_glowshroom_door,1.25,0.8,true,60,0.4", "betterendforge:lacugrove_door,1.25,0.8,true,60,0.4", "betterendforge:end_lotus_door,1.25,0.8,true,60,0.4", "betterendforge:pythadendron_door,1.25,0.8,true,60,0.4", "betterendforge:dragon_tree_door,1.25,0.8,true,60,0.4", "betterendforge:tenanea_door,1.25,0.8,true,60,0.4", "betterendforge:helix_tree_door,1.25,0.8,true,60,0.4", "betterendforge:umbrella_tree_door,1.25,0.8,true,60,0.4", "betterendforge:jellyshroom_door,1.25,0.8,true,60,0.4", "betterendforge:lucernia_door,1.25,0.8,true,60,0.4", "betterendforge:thallasium_door,1.5,0.7,true,70,0.4", "betterendforge:terminite_door,1.5,0.6,true,70,0.4", "atum:limestone_door,1.0,0.7,true,60,0.4", "atum:limestone_cracked_door,1.0,0.7,true,80,0.4", "atum:limestone_brick_small_door,1.0,0.7,true,80,0.4", "atum:limestone_brick_large_door,1.0,0.7,true,80,0.4", "atum:limestone_brick_cracked_brick_door,1.0,0.7,true,80,0.4", "atum:limestone_brick_chiseled_door,1.0,0.7,true,80,0.4", "atum:limestone_brick_carved_door,1.0,0.7,true,80,0.4", "atum:palm_door,1.0,0.8,true,60,0.4", "atum:deadwood_door,1.0,0.8,true,60,0.4", "environmental:willow_door,1.25,0.8,true,60,0.4", "environmental:cherry_door,1.25,0.8,true,60,0.4", "environmental:wisteria_door,1.25,0.8,true,60,0.4", "traverse:fir_door,1.25,0.8,true,60,0.4", "darkerdepths:petrified_door,1.25,0.8,true,60,0.4", "securitycraft:keypad_door_item,1.25,0.7,true,80,0.4", "securitycraft:door_indestructible_iron_item,1.25,0.7,true,80,0.4", "securitycraft:scanner_door_item,1.25,0.7,true,80,0.4", "betternether:stalagnate_planks_door,1.25,0.8,true,60,0.4", "betternether:reeds_door,1.25,0.8,true,60,0.4", "betternether:bone_reed_door,1.25,0.8,true,60,0.4", "betternether:bone_cincinnasite_door,1.25,0.8,true,60,0.4", "betternether:willow_door,1.25,0.8,true,60,0.4", "betternether:wart_door,1.25,0.8,true,60,0.4", "betternether:rubeus_door,1.25,0.8,true,60,0.4", "betternether:mushroom_door,1.25,0.8,true,60,0.4", "betternether:mushroom_fir_door,1.25,0.8,true,60,0.4", "betternether:anchor_tree_door,1.25,0.8,true,60,0.4", "betternether:nether_sakura_door,1.25,0.8,true,60,0.4", "minecraft:oak_sign,1.0,0.9,false,1.25,1.5", "minecraft:spruce_sign,1.0,0.9,false,1.25,1.5", "minecraft:birch_sign,1.0,0.9,false,1.25,1.5", "minecraft:jungle_sign,1.0,0.9,false,1.25,1.5", "minecraft:acacia_sign,1.0,0.9,false,1.25,1.5", "minecraft:dark_oak_sign,1.0,0.9,false,1.25,1.5", "minecraft:crimson_sign,1.0,0.9,false,1.25,1.5", "minecraft:warped_sign,1.0,0.9,false,1.25,1.5", "atmospheric:rosewood_sign,1.0,0.9,false,1.25,1.5", "atmospheric:morado_sign,1.0,0.9,false,1.25,1.5", "atmospheric:yucca_sign,1.0,0.9,false,1.25,1.5", "atmospheric:kousa_sign,1.0,0.9,false,1.25,1.5", "atmospheric:aspen_sign,1.0,0.9,false,1.25,1.5", "atmospheric:grimwood_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:white_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:orange_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:magenta_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:light_blue_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:yellow_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:lime_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:pink_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:gray_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:light_gray_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:cyan_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:purple_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:blue_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:brown_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:green_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:red_canvas_sign,1.0,0.9,false,1.25,1.5", "farmersdelight:black_canvas_sign,1.0,0.9,false,1.25,1.5", "endergetic:poise_sign,1.0,0.9,false,1.25,1.5", "outer_end:azure_sign,1.0,0.9,false,1.25,1.5", "betterendforge:mossy_glowshroom_sign,1.0,0.9,false,1.25,1.5", "betterendforge:lacugrove_sign,1.0,0.9,false,1.25,1.5", "betterendforge:end_lotus_sign,1.0,0.9,false,1.25,1.5", "betterendforge:pythadendron_sign,1.0,0.9,false,1.25,1.5", "betterendforge:dragon_tree_sign,1.0,0.9,false,1.25,1.5", "betterendforge:tenanea_sign,1.0,0.9,false,1.25,1.5", "betterendforge:helix_tree_sign,1.0,0.9,false,1.25,1.5", "betterendforge:umbrella_tree_sign,1.0,0.9,false,1.25,1.5", "betterendforge:jellyshroom_sign,1.0,0.9,false,1.25,1.5", "betterendforge:lucernia_sign,1.0,0.9,false,1.25,1.5", "atum:palm_sign,1.0,0.9,false,1.25,1.5", "atum:deadwood_sign,1.0,0.9,false,1.25,1.5", "environmental:willow_sign,1.0,0.9,false,1.25,1.5", "environmental:cherry_sign,1.0,0.9,false,1.25,1.5", "environmental:wisteria_sign,1.0,0.9,false,1.25,1.5", "traverse:fir_sign,1.0,0.9,false,1.25,1.5", "darkerdepths:petrified_sign,1.0,0.9,false,1.25,1.5", "securitycraft:secret_sign_item,1.0,0.9,false,1.25,1.5", "securitycraft:secret_spruce_sign_item,1.0,0.9,false,1.25,1.5", "securitycraft:secret_birch_sign_item,1.0,0.9,false,1.25,1.5", "securitycraft:secret_jungle_sign_item,1.0,0.9,false,1.25,1.5", "securitycraft:secret_acacia_sign_item,1.0,0.9,false,1.25,1.5", "securitycraft:secret_dark_oak_sign_item,1.0,0.9,false,1.25,1.5", "securitycraft:secret_crimson_sign_item,1.0,0.9,false,1.25,1.5", "securitycraft:secret_warped_sign_item,1.0,0.9,false,1.25,1.5", "betternether:sign_anchor_tree,1.0,0.9,false,1.25,1.5", "betternether:sign_nether_sakura,1.0,0.9,false,1.25,1.5", "betternether:sign_stalagnate,1.0,0.9,false,1.25,1.5", "betternether:sign_reed,1.0,0.9,false,1.25,1.5", "betternether:sign_willow,1.0,0.9,false,1.25,1.5", "betternether:sign_wart,1.0,0.9,false,1.25,1.5", "betternether:sign_rubeus,1.0,0.9,false,1.25,1.5", "betternether:sign_mushroom,1.0,0.9,false,1.25,1.5", "betternether:sign_mushroom_fir,1.0,0.9,false,1.25,1.5"};
        UNARMED = new String[]{"coldsclaws:diamond_claw", "coldsclaws:golden_claw", "coldsclaws:iron_claw", "coldsclaws:netherite_claw", "coldsclaws:stone_claw", "coldsclaws:wooden_claw", "dungeons_gear:fighters_binding", "dungeons_gear:gauntlet", "dungeons_gear:mauler", "dungeons_gear:soul_fist", "rats:feral_bagh_nakhs", "spartanweaponry:cestus", "spartanweaponry:cestus_studded", "fins:red_claw_gauntlet", "fins:white_claw_gauntlet", "iceandfire:deathworm_gauntlet_red", "iceandfire:deathworm_gauntlet_white", "iceandfire:deathworm_gauntlet_yellow", "alexsmobs:falconry_glove", "mutantbeasts:endersoul_hand", "biomancy:leech_claw", "biomancy:long_range_claw", "rising_uppercut:gauntlet"};
        ARMOR = new String[]{"minecraft:chainmail_boots, 0.1, 4, 2, -1", "minecraft:chainmail_chestplate, 0.3, 9, 5, -5", "minecraft:chainmail_helmet, 0.1, 4, 3, -2", "minecraft:chainmail_leggings, 0.2, 7, 4, -4", "minecraft:diamond_boots, 0, 5, 6, -3", "minecraft:diamond_chestplate, 0, 10, 16, -8", "minecraft:diamond_helmet, 0, 5, 6, -3", "minecraft:diamond_leggings, 0, 8, 12, -6", "minecraft:golden_boots, 0.2, 2, 1, -1", "minecraft:golden_chestplate, 1.0, 6, 2, -5", "minecraft:golden_helmet, 0.4, 2, 1, -2", "minecraft:golden_leggings, 0.6, 5, 1, -3", "minecraft:iron_boots, 0.1, 6, 1, -2", "minecraft:iron_chestplate, 0.1, 16, 3, -6", "minecraft:iron_helmet, 0.1, 6, 1, -2", "minecraft:iron_leggings, 0.1, 12, 2, -5", "minecraft:leather_boots, 0.3, 0, 0, -1", "minecraft:leather_chestplate, 0.6, 0, 0, -3", "minecraft:leather_helmet, 0.3, 0, 0, -1", "minecraft:leather_leggings, 0.4, 0, 0, -2", "minecraft:netherite_boots, 0.2, 6, 0, -3", "minecraft:netherite_chestplate, 1.0, 16, 0, -8", "minecraft:netherite_helmet, 0.4, 6, 0, -3", "minecraft:netherite_leggings, 0.6, 12, 0, -6", "minecraft:turtle_helmet, 0.1, 7, 3, -2", "advancedrocketry:spaceboots, 1.5, 0, 0, -3", "advancedrocketry:spacechest, 3, 0, 0, -8", "advancedrocketry:spacehelmet, 1.5, 0, 0, -3", "advancedrocketry:spaceleggings, 2, 0, 0, -6", "alexsmobs:centipede_leggings, 0.3, 10, 6, -5", "alexsmobs:crocodile_chestplate, 0.4, 12, 6, -5", "alexsmobs:emu_leggings, 0.6, 0, 0, -3", "alexsmobs:fedora, 0.6, 0, 0, 0", "alexsmobs:frontier_cap, 1.0, 0, 0, 0", "alexsmobs:moose_headgear, 0.5, 10, 0, -3", "alexsmobs:roadrunner_boots, 0.4, 0, 0, -2", "alexsmobs:sombrero, 0.5, 0, 0, 0", "alexsmobs:spiked_turtle_shell, 0.2, 12, 6, -2", "aquaculture:neptunium_boots, 0.2, 6, 5, -3", "aquaculture:neptunium_chestplate, 0.6, 14, 12, -8", "aquaculture:neptunium_helmet, 0.2, 6, 5, -3", "aquaculture:neptunium_leggings, 0.4, 10, 8, -6", "ars_nouveau:apprentice_boots, 0.4, 0, 1, -1", "ars_nouveau:apprentice_hood, 0.4, 0, 1, -2", "ars_nouveau:apprentice_leggings, 0.6, 0, 2, -4", "ars_nouveau:apprentice_robes, 0.8, 0, 3, -5", "ars_nouveau:archmage_boots, 0.6, 0, 2, -1", "ars_nouveau:archmage_hood, 0.6, 0, 2, -2", "ars_nouveau:archmage_leggings, 1.0, 0, 3, -4", "ars_nouveau:archmage_robes, 1.2, 0, 4, -5", "ars_nouveau:novice_boots, 0.3, 0, 0, -1", "ars_nouveau:novice_hood, 0.3, 0, 0, -2", "ars_nouveau:novice_leggings, 0.4, 0, 0, -4", "ars_nouveau:novice_robes, 0.6, 0, 0, -5", "atum:body_of_atem, 0.6, 14, 12, -8", "atum:body_of_ra, 0.6, 14, 12, -8", "atum:desert_boots_diamond, 0, 5, 6, -3", "atum:desert_boots_gold, 0.2, 2, 1, -1", "atum:desert_boots_iron, 0.1, 6, 1, -2", "atum:desert_chest_diamond, 0, 10, 16, -8", "atum:desert_chest_gold, 1.0, 6, 2, -5", "atum:desert_chest_iron, 0.1, 16, 3, -6", "atum:desert_helmet_diamond, 0, 5, 6, -3", "atum:desert_helmet_gold, 0.4, 2, 1, -2", "atum:desert_helmet_iron, 0.1, 6, 1, -2", "atum:desert_legs_diamond, 0, 8, 12, -6", "atum:desert_legs_gold, 0.6, 5, 1, -3", "atum:desert_legs_iron, 0.1, 12, 2, -5", "atum:eyes_of_atem, 0.2, 6, 5, -3", "atum:feet_of_atem, 0.2, 6, 5, -3", "atum:feet_of_ra, 0.2, 6, 5, -3", "atum:halo_of_ra, 0.2, 6, 5, -3", "atum:legs_of_atem, 0.4, 10, 8, -6", "atum:legs_of_ra, 0.4, 10, 8, -6", "atum:wanderer_boots, 0.3, 0, 0, -1", "atum:wanderer_chestplate, 0.6, 0, 0, -3", "atum:wanderer_helmet, 0.3, 0, 0, -1", "atum:wanderer_legs, 0.4, 0, 0, -2", "better_diving:diving_mask, 0.5, 0, 5, -1", "better_diving:fins, 0.3, 0, 0, -4", "better_diving:high_capacity_o2_tank, 0.2, 10, 0, -6", "better_diving:improved_wetsuit_leggings, 0.5, 0, 0, -2", "better_diving:rebreather, 0.5, 0, 5, -1", "better_diving:reinforced_diving_mask, 1.0, 0, 10, -1", "better_diving:reinforced_fins, 1.0, 0, 0, -4", "better_diving:reinforced_o2_tank, 0.4, 16, 0, -6", "better_diving:reinforced_wetsuit_leggings, 1.0, 0, 0, -2", "better_diving:standard_o2_tank, 0.2, 10, 0, -6", "better_diving:ultra_glide_fins, 0.3, 0, 0, -4", "better_diving:wetsuit_leggings, 0.5, 0, 0, -2", "betterendforge:aeternium_boots, 0.2, 6, 3, -4", "betterendforge:aeternium_chestplate, 0.8, 16, 8, -9", "betterendforge:aeternium_helmet, 0.3, 6, 3, -4", "betterendforge:aeternium_leggings, 0.5, 12, 6, -7", "betterendforge:crystalite_boots, 0, 7, 6, -3.5", "betterendforge:crystalite_chestplate, 0, 12, 16, -8.5", "betterendforge:crystalite_helmet, 0, 7, 6, -3.5", "betterendforge:crystalite_leggings, 0, 10, 12, -6.5", "betterendforge:terminite_boots, 0.1, 6, 1, -3", "betterendforge:terminite_chestplate, 0.1, 16, 5, -8", "betterendforge:terminite_helmet, 0.1, 6, 2, -3", "betterendforge:terminite_leggings, 0.1, 12, 4, -6", "betterendforge:thallasium_boots, 0.1, 4, 2, -1", "betterendforge:thallasium_chestplate, 0.3, 9, 5, -5", "betterendforge:thallasium_helmet, 0.1, 4, 3, -2", "betterendforge:thallasium_leggings, 0.2, 7, 4, -4", "betternether:cincinnasite_boots, 0.2, 2, 1, -3", "betternether:cincinnasite_chestplate, 1.0, 6, 2, -8", "betternether:cincinnasite_helmet, 0.4, 2, 1, -3", "betternether:cincinnasite_leggings, 0.6, 5, 1, -6", "betternether:nether_ruby_boots, 0, 5, 6, -3", "betternether:nether_ruby_chestplate, 0, 10, 16, -7", "betternether:nether_ruby_helmet, 0, 5, 6, -3", "betternether:nether_ruby_leggings, 0, 8, 12, -5", "bloodmagic:livingboots, 0.2, 4, 1, -2", "bloodmagic:livinghelmet, 0.2, 4, 1, -2", "bloodmagic:livingleggings, 0.2, 10, 2, -5", "bloodmagic:livingplate, 0.2, 15, 3, -6", "blue_skies:aquite_boots, 0.1, 8, 4, -2", "blue_skies:aquite_chestplate, 0.1, 18, 10, -6", "blue_skies:aquite_helmet, 0.1, 8, 5, -2", "blue_skies:aquite_leggings, 0.1, 16, 8, -5", "blue_skies:charoite_boots, 0, 5, 6, -3", "blue_skies:charoite_chestplate, 0, 10, 16, -8", "blue_skies:charoite_helmet, 0, 5, 6, -3", "blue_skies:charoite_leggings, 0, 8, 12, -6", "blue_skies:diopside_boots, 0.2, 2, 8, -3", "blue_skies:diopside_chestplate, 0.2, 8, 20, -8", "blue_skies:diopside_helmet, 0.2, 2, 8, -3", "blue_skies:diopside_leggings, 0.2, 6, 16, -6", "blue_skies:horizonite_boots, 0.1, 6, 1, -1", "blue_skies:horizonite_chestplate, 0.1, 16, 3, -5", "blue_skies:horizonite_helmet, 0.1, 6, 1, -2", "blue_skies:horizonite_leggings, 0.1, 12, 2, -4", "blue_skies:pyrope_boots, 0.1, 4, 6, -1", "blue_skies:pyrope_chestplate, 0.1, 9, 12, -5", "blue_skies:pyrope_helmet, 0.1, 4, 6, -2", "blue_skies:pyrope_leggings, 0.1, 7, 10, -4", "blue_skies:shadow_boots, 0.25, 8, 8, -2", "blue_skies:shadow_chestplate, 0.25, 18, 20, -6", "blue_skies:shadow_helmet, 0.25, 8, 8, -2", "blue_skies:shadow_leggings, 0.25, 16, 16, -5", "byg:ametrine_boots, 0.2, 6, 8, -4", "byg:ametrine_chestplate, 1.0, 16, 18, -9", "byg:ametrine_helmet, 0.4, 6, 8, -4", "byg:ametrine_leggings, 0.6, 12, 14, -7", "comfortable_nether:golden_snout_helmet, 0.4, 2, 1, -2", "comfortable_nether:padded_leather_boots_boots, 0.3, 0, 0, -1", "conjurer_illager:conjurer_hat, 1, 0, 0, -1", "cyclic:crystal_boots, 0.2, 6, 8, -3", "cyclic:crystal_chestplate, 1.0, 16, 18, -8", "cyclic:crystal_helmet, 0.4, 6, 8, -3", "cyclic:crystal_leggings, 0.6, 12, 14, -6", "cyclic:emerald_boots, 0, 5, 6, -3", "cyclic:emerald_chestplate, 0, 10, 16, -6", "cyclic:emerald_helmet, 0, 5, 6, -3", "cyclic:emerald_leggings, 0, 8, 12, -5", "cyclic:glowing_helmet, 0, 8, 10, -3", "dannys_expansion:antique_boots, 0, 6, 3, -2", "dannys_expansion:antique_chestplate, 0, 16, 8, -6", "dannys_expansion:antique_helmet, 0, 6, 3, -2", "dannys_expansion:antique_leggings, 0, 12, 6, -6", "dannys_expansion:mummy_chestplate, 0, 16, 8, -5", "druidcraft:bone_boots, 0, 4, 5, -1", "druidcraft:bone_chestplate, 0, 8, 11, -4", "druidcraft:bone_helmet, 0, 3, 5, -1", "druidcraft:bone_leggings, 0, 6, 9, -3", "druidcraft:chitin_boots, 0.2, 6, 0, -2.5", "druidcraft:chitin_chestplate, 1.0, 16, 0, -6.5", "druidcraft:chitin_helmet, 0.4, 6, 0, -2.5", "druidcraft:chitin_leggings, 0.6, 12, 0, -4.5", "druidcraft:moonstone_boots, 0, 5, 6, -3", "druidcraft:moonstone_chestplate, 0, 10, 16, -8", "druidcraft:moonstone_helmet, 0, 5, 6, -3", "druidcraft:moonstone_leggings, 0, 8, 12, -6", "dungeons_gear:archers_hood, 0.4, 0, 0, -1", "dungeons_gear:archers_vest, 0.7, 0, 0, -4", "dungeons_gear:battle_robe, 0.7, 0, 0, -4", "dungeons_gear:cave_crawler_chestplate, 0.3, 9, 5, -5", "dungeons_gear:cave_crawler_helmet, 0.1, 4, 3, -2", "dungeons_gear:champions_chestplate, 0.1, 24, 3, -6", "dungeons_gear:champions_helmet, 0.1, 9, 1, -3", "dungeons_gear:curious_chestplate, 0.3, 9, 5, -5", "dungeons_gear:curious_helmet, 0.1, 4, 3, -2", "dungeons_gear:dark_chestplate, 0.7, 10, 9, -8", "dungeons_gear:dark_helmet, 0.4, 5, 5, -3", "dungeons_gear:ember_hat, 1.0, 6, 2, -1", "dungeons_gear:ember_robe, 0.4, 2, 1, -4", "dungeons_gear:evocation_hat, 1.0, 6, 2, -1", "dungeons_gear:evocation_robe, 0.4, 2, 1, -4", "dungeons_gear:fox_hood, 0.4, 0, 0, -1", "dungeons_gear:fox_vest, 0.7, 0, 0, -4", "dungeons_gear:frost_bite_chestplate, 0, 10, 16, -5", "dungeons_gear:frost_bite_helmet, 0, 5, 6, -2", "dungeons_gear:frost_chestplate, 0.3, 9, 5, -6", "dungeons_gear:frost_helmet, 0.1, 4, 3, -3", "dungeons_gear:full_metal_chestplate, 0.7, 10, 9, -8", "dungeons_gear:full_metal_helmet, 0.4, 5, 5, -3", "dungeons_gear:grim_chestplate, 0, 10, 16, -5", "dungeons_gear:grim_helmet, 0, 5, 6, -2", "dungeons_gear:guard_chestplate, 0.3, 9, 5, -5", "dungeons_gear:guards_helmet, 0.1, 4, 3, -2", "dungeons_gear:heros_chestplate, 0.1, 24, 3, -6", "dungeons_gear:heros_helmet, 0.1, 9, 1, -3", "dungeons_gear:highland_chestplate, 0.3, 9, 5, -6", "dungeons_gear:highland_helmet, 0.1, 4, 3, -2", "dungeons_gear:hunters_vest, 0.7, 0, 0, -4", "dungeons_gear:mercenary_chestplate, 0.3, 9, 5, -8", "dungeons_gear:mercenary_helmet, 0.1, 4, 3, -3", "dungeons_gear:ocelot_hood, 0.4, 0, 0, -1", "dungeons_gear:ocelot_vest, 0.7, 0, 0, -4", "dungeons_gear:phantom_chestplate, 0, 10, 16, -5", "dungeons_gear:phantom_helmet, 0, 5, 6, -2", "dungeons_gear:plate_chestplate, 0.7, 10, 9, -8", "dungeons_gear:plate_helmet, 0.4, 5, 5, -3", "dungeons_gear:reinforced_mail_chestplate, 0.7, 10, 9, -6", "dungeons_gear:reinforced_mail_helmet, 0.4, 5, 5, -3", "dungeons_gear:renegade_chestplate, 0.3, 9, 5, -8", "dungeons_gear:renegade_helmet, 0.1, 4, 3, -3", "dungeons_gear:royal_guard_chestplate, 0.7, 10, 9, -8", "dungeons_gear:royal_guard_helmet, 0.4, 5, 5, -3", "dungeons_gear:scale_mail_chestplate, 0.3, 9, 5, -6", "dungeons_gear:scale_mail_helmet, 0.1, 4, 3, -6", "dungeons_gear:shadow_walker_hood, 0.4, 0, 0, -1", "dungeons_gear:shadow_walker_vest, 0.7, 0, 0, -4", "dungeons_gear:snow_chestplate, 0.3, 9, 5, -6", "dungeons_gear:snow_helmet, 0.1, 4, 3, -3", "dungeons_gear:soul_hood, 1.0, 6, 2, -1", "dungeons_gear:soul_robe, 0.4, 2, 1, -4", "dungeons_gear:souldancer_hood, 1.0, 6, 2, -1", "dungeons_gear:souldancer_robe, 0.4, 2, 1, -4", "dungeons_gear:spelunker_chestplate, 0.3, 9, 5, -5", "dungeons_gear:spelunker_helmet, 0.1, 4, 3, -2", "dungeons_gear:spider_hood, 0.4, 0, 0, -1", "dungeons_gear:spider_vest, 0.7, 0, 0, -4", "dungeons_gear:splendid_robe, 0.7, 0, 0, -4", "dungeons_gear:stalwart_chestplate, 0.7, 10, 9, -6", "dungeons_gear:stalwart_helmet, 0.4, 5, 5, -3", "dungeons_gear:thief_hood, 0.4, 0, 0, -1", "dungeons_gear:thief_vest, 0.7, 0, 0, -4", "dungeons_gear:titans_shroud_chestplate, 0.7, 10, 9, -8", "dungeons_gear:titans_shroud_helmet, 0.4, 5, 5, -3", "dungeons_gear:wither_chestplate, 0, 10, 16, -5", "dungeons_gear:wither_helmet, 0, 5, 6, -2", "dungeons_gear:wolf_hood, 0.4, 0, 0, -1", "dungeons_gear:wolf_vest, 0.7, 0, 0, -4", "eidolon:top_hat, 0.3, 0, 0, 2", "eidolon:warlock_boots, 0.4, 0, 0, 1", "eidolon:warlock_cloak, 0.8, 0, 0, 2", "eidolon:warlock_hat, 0.4, 0, 0, 1", "endergetic:booflo_vest, 2, 0, 0, -3", "endrem:end_crystal_boots, 0, 5, 6, -3", "endrem:end_crystal_chestplate, 0, 10, 16, -8", "endrem:end_crystal_helmet, 0, 5, 6, -3", "endrem:end_crystal_leggings, 0, 8, 12, -6", "enigmaticlegacy:etherium_boots, 0.4, 6, 0, 0", "enigmaticlegacy:etherium_chestplate, 1.2, 16, 0, 0", "enigmaticlegacy:etherium_helmet, 0.6, 6, 0, 0", "enigmaticlegacy:etherium_leggings, 0.8, 12, 0, 0", "environmental:architect_belt, 0.4, 0, 0, 0", "environmental:healer_pouch, 0.6, 0, 0, 0", "environmental:thief_hood, 0.3, 0, 0, 1", "environmental:wanderer_boots, 0.3, 0, 0, 0", "epicfight:stray_hat, 0.3, 0, 0, 1", "epicfight:stray_pants, 0.4, 0, 0, 2", "epicfight:stray_robes, 0.6, 0, 0, 3", "fins:fwinged_boots, 0.3, 0, 0, -2", "greekfantasy:achilles_boots, 0.2, 6, 0, -3", "greekfantasy:achilles_chestplate, 1.0, 16, 0, -6", "greekfantasy:achilles_helmet, 0.4, 6, 0, -3", "greekfantasy:achilles_leggings, 0.6, 12, 0, -5", "greekfantasy:helm_of_darkness, 0.3, 6, 0, 0", "greekfantasy:nemean_lion_hide, 0.3, 6, 0, -2", "greekfantasy:snakeskin_boots, 0.3, 0, 0, -2", "greekfantasy:snakeskin_chestplate, 0.6, 0, 0, -6", "greekfantasy:snakeskin_helmet, 0.3, 0, 0, -2", "greekfantasy:snakeskin_leggings, 0.4, 0, 0, -5", "greekfantasy:winged_sandals, 0.3, 0, 0, -1, -2", "iceandfire:armor_amythest_boots, 0.2, 6, 0, -4", "iceandfire:armor_amythest_chestplate, 0.5, 16, 0, -8", "iceandfire:armor_amythest_helmet, 0.2, 6, 0, -4", "iceandfire:armor_amythest_leggings, 0.4, 12, 0, -6", "iceandfire:armor_black_boots, 0.2, 6, 0, -4", "iceandfire:armor_black_chestplate, 0.5, 16, 0, -8", "iceandfire:armor_black_helmet, 0.2, 6, 0, -4", "iceandfire:armor_black_leggings, 0.4, 12, 0, -6", "iceandfire:armor_blue_boots, 0.2, 6, 0, -4", "iceandfire:armor_blue_chestplate, 0.5, 16, 0, -8", "iceandfire:armor_blue_helmet, 0.2, 6, 0, -4", "iceandfire:armor_blue_leggings, 0.4, 12, 0, -6", "iceandfire:armor_bronze_boots, 0.2, 6, 0, -4", "iceandfire:armor_bronze_chestplate, 0.5, 16, 0, -8", "iceandfire:armor_bronze_helmet, 0.2, 6, 0, -4", "iceandfire:armor_bronze_leggings, 0.4, 12, 0, -6", "iceandfire:armor_copper_boots, 0.2, 6, 0, -4", "iceandfire:armor_copper_chestplate, 0.5, 16, 0, -8", "iceandfire:armor_copper_helmet, 0.2, 6, 0, -4", "iceandfire:armor_copper_leggings, 0.4, 12, 0, -6", "iceandfire:armor_copper_metal_boots, 0.3, 4, 0, -4", "iceandfire:armor_copper_metal_chestplate, 0.4, 12, 0, -8", "iceandfire:armor_copper_metal_helmet, 0.3, 6, 0, -4", "iceandfire:armor_copper_metal_leggings, 0.4, 8, 0, -6", "iceandfire:armor_electric_boots, 0.2, 6, 0, -4", "iceandfire:armor_electric_chestplate, 0.5, 16, 0, -8", "iceandfire:armor_electric_helmet, 0.2, 6, 0, -4", "iceandfire:armor_electric_leggings, 0.4, 12, 0, -6", "iceandfire:armor_gray_boots, 0.2, 6, 0, -4", "iceandfire:armor_gray_chestplate, 0.5, 16, 0, -8", "iceandfire:armor_gray_helmet, 0.2, 6, 0, -4", "iceandfire:armor_gray_leggings, 0.4, 12, 0, -6", "iceandfire:armor_green_boots, 0.2, 6, 0, -4", "iceandfire:armor_green_chestplate, 0.5, 16, 0, -8", "iceandfire:armor_green_helmet, 0.2, 6, 0, -4", "iceandfire:armor_green_leggings, 0.4, 12, 0, -6", "iceandfire:armor_red_boots, 0.2, 6, 0, -4", "iceandfire:armor_red_chestplate, 0.5, 16, 0, -8", "iceandfire:armor_red_helmet, 0.2, 6, 0, -4", "iceandfire:armor_red_leggings, 0.4, 12, 0, -6", "iceandfire:armor_sapphire_boots, 0.2, 6, 0, -4", "iceandfire:armor_sapphire_chestplate, 0.5, 16, 0, -8", "iceandfire:armor_sapphire_helmet, 0.2, 6, 0, -4", "iceandfire:armor_sapphire_leggings, 0.4, 12, 0, -6", "iceandfire:armor_silver_boots, 0.2, 6, 0, -4", "iceandfire:armor_silver_chestplate, 0.5, 16, 0, -8", "iceandfire:armor_silver_helmet, 0.2, 6, 0, -4", "iceandfire:armor_silver_leggings, 0.4, 12, 0, -6", "iceandfire:armor_silver_metal_boots, 0.2, 6, 1, -1", "iceandfire:armor_silver_metal_chestplate, 0.4, 16, 3, -5", "iceandfire:armor_silver_metal_helmet, 0.2, 6, 1, -2", "iceandfire:armor_silver_metal_leggings, 0.3, 12, 2, -4", "iceandfire:armor_white_boots, 0.2, 6, 0, -4", "iceandfire:armor_white_chestplate, 0.5, 16, 0, -8", "iceandfire:armor_white_helmet, 0.2, 6, 0, -4", "iceandfire:armor_white_leggings, 0.4, 12, 0, -6", "iceandfire:deathworm_red_boots, 0.2, 5, 0, -1", "iceandfire:deathworm_red_chestplate, 1.0, 9, 0, -3", "iceandfire:deathworm_red_helmet, 0.4, 5, 0, -1.5", "iceandfire:deathworm_red_leggings, 0.6, 8, 0, -2.5", "iceandfire:deathworm_white_boots, 0.2, 5, 0, -1", "iceandfire:deathworm_white_chestplate, 1.0, 9, 0, -3", "iceandfire:deathworm_white_helmet, 0.4, 5, 0, -1.5", "iceandfire:deathworm_white_leggings, 0.6, 8, 0, -2.5", "iceandfire:deathworm_yellow_boots, 0.2, 5, 0, -1", "iceandfire:deathworm_yellow_chestplate, 1.0, 9, 0, -3", "iceandfire:deathworm_yellow_helmet, 0.4, 5, 0, -1.5", "iceandfire:deathworm_yellow_leggings, 0.6, 8, 0, -2.5", "iceandfire:dragonsteel_fire_boots, 0, 9, 3, -6", "iceandfire:dragonsteel_fire_chestplate, 0, 24, 8, -12", "iceandfire:dragonsteel_fire_helmet, 0, 9, 3, -7", "iceandfire:dragonsteel_fire_leggings, 0, 18, 6, -9", "iceandfire:dragonsteel_ice_boots, 0, 9, 3, -6", "iceandfire:dragonsteel_ice_chestplate, 0, 24, 8, -12", "iceandfire:dragonsteel_ice_helmet, 0, 9, 3, -7", "iceandfire:dragonsteel_ice_leggings, 0, 18, 6, -9", "iceandfire:dragonsteel_lightning_boots, 0, 9, 3, -6", "iceandfire:dragonsteel_lightning_chestplate, 0, 24, 8, -12", "iceandfire:dragonsteel_lightning_helmet, 0, 9, 3, -7", "iceandfire:dragonsteel_lightning_leggings, 0, 18, 6, -9", "iceandfire:forest_troll_leather_boots, 0.4, 6, 0, -1", "iceandfire:forest_troll_leather_chestplate, 0.8, 16, 0, -3", "iceandfire:forest_troll_leather_helmet, 0.4, 0, 0, -1", "iceandfire:forest_troll_leather_leggings, 0.6, 12, 0, -2", "iceandfire:frost_troll_leather_boots, 0.4, 6, 0, -1", "iceandfire:frost_troll_leather_chestplate, 0.8, 16, 0, -3", "iceandfire:frost_troll_leather_helmet, 0.4, 0, 0, -2", "iceandfire:frost_troll_leather_leggings, 0.6, 12, 0, -1", "iceandfire:mountain_troll_leather_boots, 0.4, 6, 0, -1", "iceandfire:mountain_troll_leather_chestplate, 0.8, 16, 0, -3", "iceandfire:mountain_troll_leather_helmet, 0.4, 0, 0, -2", "iceandfire:mountain_troll_leather_leggings, 0.6, 12, 0, -1", "iceandfire:myrmex_desert_boots, 0.3, 6, 1, -1", "iceandfire:myrmex_desert_chestplate, 0.6, 16, 3, -4", "iceandfire:myrmex_desert_helmet, 0.3, 6, 1, -2", "iceandfire:myrmex_desert_leggings, 0.5, 12, 2, -3", "iceandfire:myrmex_jungle_boots, 0.2, 8, 1, -1", "iceandfire:myrmex_jungle_chestplate, 0.5, 18, 3, -4", "iceandfire:myrmex_jungle_helmet, 0.2, 8, 1, -2", "iceandfire:myrmex_jungle_leggings, 0.4, 14, 2, -3", "iceandfire:sheep_boots, 0.4, 0, 0, 1", "iceandfire:sheep_chestplate, 0.7, 0, 0, 1", "iceandfire:sheep_helmet, 0.4, 0, 0, 1", "iceandfire:sheep_leggings, 0.5, 0, 0, 1", "iceandfire:tide_blue_boots, 0.2, 5, 0, -3", "iceandfire:tide_blue_chestplate, 1.0, 13, 0, -6", "iceandfire:tide_blue_helmet, 0.4, 5, 0, -3", "iceandfire:tide_blue_leggings, 0.6, 9, 0, -7", "iceandfire:tide_bronze_boots, 0.2, 5, 0, -3", "iceandfire:tide_bronze_chestplate, 1.0, 13, 0, -6", "iceandfire:tide_bronze_helmet, 0.4, 5, 0, -3", "iceandfire:tide_bronze_leggings, 0.6, 9, 0, -7", "iceandfire:tide_deepblue_boots, 0.2, 5, 0, -3", "iceandfire:tide_deepblue_chestplate, 1.0, 13, 0, -6", "iceandfire:tide_deepblue_helmet, 0.4, 5, 0, -3", "iceandfire:tide_deepblue_leggings, 0.6, 9, 0, -7", "iceandfire:tide_green_boots, 0.2, 5, 0, -3", "iceandfire:tide_green_chestplate, 1.0, 13, 0, -6", "iceandfire:tide_green_helmet, 0.4, 5, 0, -4", "iceandfire:tide_green_leggings, 0.6, 9, 0, -8", "iceandfire:tide_purple_boots, 0.2, 5, 0, -4", "iceandfire:tide_purple_chestplate, 1.0, 13, 0, -7", "iceandfire:tide_purple_helmet, 0.4, 5, 0, -3", "iceandfire:tide_purple_leggings, 0.6, 9, 0, -7", "iceandfire:tide_red_boots, 0.2, 5, 0, -3", "iceandfire:tide_red_chestplate, 1.0, 13, 0, -6", "iceandfire:tide_red_helmet, 0.4, 5, 0, -3", "iceandfire:tide_red_leggings, 0.6, 9, 0, -7", "iceandfire:tide_teal_boots, 0.2, 5, 0, -3", "iceandfire:tide_teal_chestplate, 1.0, 13, 0, -6", "iceandfire:tide_teal_helmet, 0.4, 5, 0, -3", "iceandfire:tide_teal_leggings, 0.6, 9, 0, -7", "immersiveengineering:armor_faraday_chest, 0.3, 8, 3, -5", "immersiveengineering:armor_faraday_feet, 0.1, 4, 1, -4", "immersiveengineering:armor_faraday_head, 0.1, 4, 1, -2", "immersiveengineering:armor_faraday_legs, 0.2, 6, 2, -1", "immersiveengineering:armor_steel_chest, 0.3, 16, 6, -8", "immersiveengineering:armor_steel_feet, 0.1, 7, 2, -3", "immersiveengineering:armor_steel_head, 0.1, 7, 2, -3", "immersiveengineering:armor_steel_legs, 0.2, 14, 4, -6", "magistuarmory:armet, 0.1, 10, 2, -8", "magistuarmory:knight_chestplate, 0.3, 24, 4, -12", "magistuarmory:knight_leggings, 0.2, 20, 3, -10", "magistuarmory:knight_boots, 0.1, 8, 1, -6", "magistuarmory:stechhelm, 0.1, 10, 2, -10", "magistuarmory:jousting_chestplate, 0.3, 24, 4, -16", "magistuarmory:jousting_leggings, 0.2, 20, 3, -8", "magistuarmory:jousting_boots, 0.1, 8, 1, -8", "magistuarmory:sallet, 0.1, 10, 2, -8", "magistuarmory:gothic_chestplate, 0.3, 24, 4, -16", "magistuarmory:gothic_leggings, 0.2, 20, 3, -8", "magistuarmory:gothic_boots, 0.1, 8, 1, -8", "magistuarmory:maximilian_helmet, 0.2, 14, 3, -10", "magistuarmory:maximilian_chestplate, 0.4, 24, 6, -14", "magistuarmory:maximilian_leggings, 0.3, 20, 4, -12", "magistuarmory:maximilian_boots, 0.2, 12, 2, -6", "magistuarmory:chainmail_helmet, 0.1, 4, 3, -2", "magistuarmory:chainmail_chestplate, 0.3, 9, 5, -5", "magistuarmory:chainmail_leggings, 0.2, 7, 4, -4", "magistuarmory:chainmail_boots, 0.1, 4, 2, -1", "magistuarmory:kettlehat, 0.1, 6, 3, -4", "magistuarmory:platemail_chestplate, 0.4, 12, 5, -8", "magistuarmory:platemail_leggings, 0.3, 8, 4, -6", "magistuarmory:platemail_boots, 0.1, 4, 2, -2", "magistuarmory:barbute, 0.1, 6, 1, -2", "magistuarmory:halfarmor_chestplate, 0.1, 16, 3, -7", "magistuarmory:greathelm, 0.2, 8, 3, -9", "magistuarmory:crusader_chestplate, 0.8, 10, 4, -7", "magistuarmory:crusader_leggings, 0.6, 6, 3, -5", "magistuarmory:crusader_boots, 0.3, 3, 1, -1", "magistuarmory:ceremonialarmet, 0.1, 10, 2, -8", "magistuarmory:ceremonial_chestplate, 0.3, 24, 4, -12", "magistuarmory:ceremonial_boots, 0.1, 8, 1, -6", "magistuarmory:coif, 0.3, 0, 0, -1", "magistuarmory:gambeson_chestplate, 0.8, 0, 0, -3", "magistuarmory:pantyhose, 0.4, 0, 0, -2", "magistuarmory:gambeson_boots, 0.2, 0, 0, -1", "magistuarmory:brigandine_chestplate, 0.8, 5, 0, -4", "magistuarmory:norman_helmet, 0.1, 6, 3, -4", "magistuarmory:shishak, 0.1, 6, 3, -4", "magistuarmory:bascinet, 0.1, 10, 2, -8", "magistuarmory:xivcenturyknight_chestplate, 0.3, 24, 4, -12", "magistuarmory:xivcenturyknight_leggings, 0.2, 20, 3, -10", "magistuarmory:xivcenturyknight_boots, 0.1, 8, 1, -6", "magistuarmory:wingedhussar_chestplate, 0.3, 24, 4, -12", "magistuarmory:cuirassier_helmet, 0.1, 6, 1, -2", "magistuarmory:cuirassier_chestplate, 0.1, 12, 1, -5", "magistuarmory:cuirassier_leggings, 0.4, 0, 0, -2", "magistuarmory:cuirassier_boots, 0.3, 3, 1, -1", "majruszs_difficulty:end_boots, 0.2, 9, 2, -4", "majruszs_difficulty:end_chestplate, 1.0, 20, 6, -8", "majruszs_difficulty:end_helmet, 4, 9, 2, -4", "majruszs_difficulty:end_leggings, 0.6, 16, 3, -6", "majruszs_difficulty:hermes_boots, 1, 0, 0, -2", "mod_lavacow:faminearmor_boots, 0.4, 0, 0, -2", "mod_lavacow:faminearmor_chestplate, 1.2, 12, 0, -6", "mod_lavacow:faminearmor_helmet, 0.6, 16, 0, -4", "mod_lavacow:faminearmor_leggings, 0.9, 4, 0, -4", "mod_lavacow:felarmor_boots, 0.4, 0, 4, -2", "mod_lavacow:felarmor_chestplate, 1.0, 0, 12, -10", "mod_lavacow:felarmor_helmet, 0.5, 0, 4, -5", "mod_lavacow:felarmor_leggings, 0.5, 0, 8, -3", "mod_lavacow:skeletonking_crown, 0, 12, 10, -3", "mod_lavacow:swinearmor_boots, 0.3, 0, 0, -2", "mod_lavacow:swinearmor_chestplate, 0.6, 0, 0, -5", "mod_lavacow:swinearmor_helmet, 0.3, 0, 0, -2", "mod_lavacow:swinearmor_leggings, 0.5, 0, 0, -4", "mowziesmobs:barako_mask, 1, 8, 10, 0", "mowziesmobs:barakoa_mask_bliss, 0.2, 4, 2, 1", "mowziesmobs:barakoa_mask_fear, 0.2, 4, 2, 1", "mowziesmobs:barakoa_mask_fury, 0.2, 4, 2, 1", "mowziesmobs:barakoa_mask_misery, 0.2, 4, 2, 1", "mowziesmobs:barakoa_mask_rage, 0.2, 4, 2, 1", "mowziesmobs:wrought_helmet, 0, 12, 8, -2", "mutantbeasts:mutant_skeleton_boots, 0, 4, 5, -1", "mutantbeasts:mutant_skeleton_chestplate, 0, 8, 11, -4", "mutantbeasts:mutant_skeleton_leggings, 0, 6, 9, -3", "mutantbeasts:mutant_skeleton_skull, 0, 3, 5, -1", "mysticalworld:sapphire_boots, 0, 7, 3, -2", "mysticalworld:sapphire_chestplate, 0, 14, 12, -7", "mysticalworld:sapphire_helmet, 0, 7, 3, -2", "mysticalworld:sapphire_leggings, 0, 10, 8, -5", "mysticalworld:copper_boots, 0.1, 4, 1, -2", "mysticalworld:copper_chestplate, 0.1, 8, 3, -6", "mysticalworld:copper_helmet, 0.1, 4, 1, -2", "mysticalworld:copper_leggings, 0.1, 6, 2, -5", "mysticalworld:lead_boots, 0.25, 8, 4, -4", "mysticalworld:lead_chestplate, 0.5, 20, 10, -9", "mysticalworld:lead_helmet, 0.25, 8, 4, -4", "mysticalworld:lead_leggings, 0.3, 16, 6, -7", "mysticalworld:quicksilver_boots, 0.3, 4, 1, -1", "mysticalworld:quicksilver_chestplate, 0.8, 8, 2, -5", "mysticalworld:quicksilver_helmet, 0.3, 4, 1, -3", "mysticalworld:quicksilver_leggings, 0.5, 6, 2, -2", "mysticalworld:silver_boots, 0.2, 2, 1, -1", "mysticalworld:silver_chestplate, 1.0, 6, 1, -5", "mysticalworld:silver_helmet, 0.4, 2, 1, -2", "mysticalworld:silver_leggings, 0.6, 5, 1, -3", "mysticalworld:tin_boots, 0.1, 5, 0, -1", "mysticalworld:tin_chestplate, 0.1, 10, 2, -5", "mysticalworld:tin_helmet, 0.1, 5, 0, -2", "mysticalworld:tin_leggings, 0.1, 8, 1, -4", "pandoras_creatures:plant_hat, 0.3, 0, 0, 2", "psi:psimetal_exosuit_boots, 0.2, 5, 4, -2", "psi:psimetal_exosuit_chestplate, 0.4, 10, 8, -6", "psi:psimetal_exosuit_helmet, 0.2, 5, 4, -2", "psi:psimetal_exosuit_leggings, 0.3, 8, 6, -5", "pyromancer:marauders_armor_boots, 0.3, 0, 0, -1", "pyromancer:marauders_armor_chestplate, 0.6, 0, 0, -3", "pyromancer:marauders_armor_helmet, 0.3, 0, 0, -1", "pyromancer:marauders_armor_leggings, 0.4, 0, 0, -2", "pyromancer:netherite_mask_helmet, 0.4, 6, 0, -3", "quark:forgotten_hat, 0.5, 0, 0, 1", "rats:archeologist_hat, 0.5, 0, 0, 0", "rats:aviator_hat, 0.5, 0, 0, 0", "rats:black_death_mask, 1.0, 0, 4, 1", "rats:exterminator_hat, 0.5, 0, 0, 0", "rats:farmer_hat, 0.5, 0, 0, 0", "rats:fisherman_hat, 0.5, 0, 0, 0", "rats:halo_hat, 0.5, 4, 2, 0", "rats:party_hat_1, 0.5, 0, 0, 0", "rats:party_hat_2, 0.5, 0, 0, 0", "rats:party_hat_3, 0.5, 0, 0, 0", "rats:party_hat_4, 0.5, 0, 0, 0", "rats:pirat_hat, 0, 0.5, 0, 0", "rats:plague_doctor_mask, 0.5, 0, 0, 0", "rats:rat_fez, 0.5, 0, 0, 0", "rats:rat_king_crown, 0, 6, 2, 0", "rats:ratlantis_boots, 0.3, 8, 8, -5", "rats:ratlantis_chestplate, 0.3, 16, 16, -10", "rats:ratlantis_helmet, 0.3, 8, 8, -5", "rats:ratlantis_leggings, 0.3, 12, 12, -8", "rats:santa_hat, 0.5, 0, 0, 0", "rats:top_hat, 0.5, 0, 0, 0", "rootsclassic:sylvan_boots, 0.3, 0, 0, -1", "rootsclassic:sylvan_robes, 0.6, 0, 0, -3", "rootsclassic:sylvan_hood, 0.3, 0, 0, -1", "rootsclassic:sylvan_tunic, 0.4, 0, 0, -2", "rootsclassic:wildwood_boots, 0.2, 5, 4, -2", "rootsclassic:wildwood_plate, 0.4, 10, 8, -6", "rootsclassic:wildwood_mask, 0.2, 5, 4, -2", "rootsclassic:wildwood_leggings, 0.3, 8, 6, -5", "savageandravage:griefer_boots, 0.2, 8, 6, -2", "savageandravage:griefer_chestplate, 0.6, 18, 14, -6", "savageandravage:griefer_helmet, 0.2, 8, 6, -2", "savageandravage:griefer_leggings, 0.4, 15, 10, -5", "silentgear:boots, 0.1, 4, 2, -2", "silentgear:chestplate, 0.3, 9, 5, -6", "silentgear:helmet, 0.1, 4, 3, -2", "silentgear:leggings, 0.2, 7, 4, -5", "thermal:beekeeper_boots, 0.5, 0, 0, -1", "thermal:beekeeper_chestplate, 1.0, 0, 0, -5", "thermal:beekeeper_helmet, 0.5, 0, 0, -2", "thermal:beekeeper_leggings, 0.6, 0, 0, -4", "thermal:diving_boots, 0.1, 5, 2, -1", "thermal:diving_chestplate, 0.3, 10, 5, -5", "thermal:diving_helmet, 0.1, 5, 2, -2", "thermal:diving_leggings, 0.2, 8, 4, -4", "thermal:hazmat_boots, 0.75, 0, 0, -1", "thermal:hazmat_chestplate, 1.5, 0, 0, -5", "thermal:hazmat_helmet, 0.75, 0, 0, -2", "thermal:hazmat_leggings, 1.2, 0, 0, -4", "twilightforest:arctic_boots, 0.75, 0, 0, -1", "twilightforest:arctic_chestplate, 2, 0, 0, -5", "twilightforest:arctic_helmet, 0.75, 0, 0, -3", "twilightforest:arctic_leggings, 1.5, 0, 0, -4", "twilightforest:fiery_boots, 0.2, 7, 4, -3", "twilightforest:fiery_chestplate, 0.2, 16, 8, -8", "twilightforest:fiery_helmet, 0.2, 7, 4, -3", "twilightforest:fiery_leggings, 0.2, 14, 6, -6", "twilightforest:ironwood_boots, 0.2, 5, 2, -2", "twilightforest:ironwood_chestplate, 0.2, 10, 5, -6", "twilightforest:ironwood_helmet, 0.2, 5, 3, -2", "twilightforest:ironwood_leggings, 0.2, 8, 4, -5", "twilightforest:knightmetal_boots, 0.1, 10, 4, -3", "twilightforest:knightmetal_chestplate, 0.1, 20, 8, -7", "twilightforest:knightmetal_helmet, 0.1, 10, 4, -3", "twilightforest:knightmetal_leggings, 0.1, 18, 6, -5", "twilightforest:naga_chestplate, 0.4, 14, 12, -5", "twilightforest:naga_leggings, 0.3, 10, 8, -4", "twilightforest:phantom_chestplate, 0.2, 12, 10, -3", "twilightforest:phantom_helmet, 0.2, 16, 12, -7", "twilightforest:steeleaf_boots, 0.3, 6, 2, -2", "twilightforest:steeleaf_chestplate, 0.6, 16, 4, -6", "twilightforest:steeleaf_helmet, 0.3, 6, 2, -2", "twilightforest:steeleaf_leggings, 0.4, 12, 3, -5", "twilightforest:yeti_boots, 1, 0, 0, -2", "twilightforest:yeti_chestplate, 2, 0, 0, -6", "twilightforest:yeti_helmet, 1, 0, 0, -2", "twilightforest:yeti_leggings, 1.5, 0, 0, -5", "vampirism:armor_of_swiftness_chest_enhanced, 0.6, 0, 0, -6", "vampirism:armor_of_swiftness_chest_normal, 0.6, 0, 0, -6", "vampirism:armor_of_swiftness_chest_ultimate, 0.6, 0, 0, -6", "vampirism:armor_of_swiftness_feet_enhanced, 0.3, 0, 0, -2", "vampirism:armor_of_swiftness_feet_normal, 0.3, 0, 0, -2", "vampirism:armor_of_swiftness_feet_ultimate, 0.3, 0, 0, -2", "vampirism:armor_of_swiftness_head_enhanced, 0.3, 0, 0, -2", "vampirism:armor_of_swiftness_head_normal, 0.3, 0, 0, -2", "vampirism:armor_of_swiftness_head_ultimate, 0.3, 0, 0, -2", "vampirism:armor_of_swiftness_legs_enhanced, 0.4, 0, 0, -5", "vampirism:armor_of_swiftness_legs_normal, 0.4, 0, 0, -5", "vampirism:armor_of_swiftness_legs_ultimate, 0.4, 0, 0, -5", "vampirism:hunter_coat_chest_enhanced, 0.3, 9, 5, -5", "vampirism:hunter_coat_chest_normal, 0.3, 9, 5, -5", "vampirism:hunter_coat_chest_ultimate, 0.3, 9, 5, -5", "vampirism:hunter_coat_feet_enhanced, 0.1, 4, 2, -1", "vampirism:hunter_coat_feet_normal, 0.1, 4, 2, -1", "vampirism:hunter_coat_feet_ultimate, 0.1, 4, 2, -1", "vampirism:hunter_coat_head_enhanced, 0.1, 4, 3, -2", "vampirism:hunter_coat_head_normal, 0.1, 4, 3, -2", "vampirism:hunter_coat_head_ultimate, 0.1, 4, 3, -2", "vampirism:hunter_coat_legs_enhanced, 0.2, 7, 4, -4", "vampirism:hunter_coat_legs_normal, 0.2, 7, 4, -4", "vampirism:hunter_coat_legs_ultimate, 0.2, 7, 4, -4", "vampirism:hunter_hat_head_0, 0.3, 0, 0, -2", "vampirism:hunter_hat_head_1, 0.3, 0, 0, -2", "vampirism:obsidian_armor_chest_enhanced, 0, 10, 16, -8", "vampirism:obsidian_armor_chest_normal, 0, 10, 16, -8", "vampirism:obsidian_armor_chest_ultimate, 0, 10, 16, -8", "vampirism:obsidian_armor_feet_enhanced, 0, 5, 6, -3", "vampirism:obsidian_armor_feet_normal, 0, 5, 6, -3", "vampirism:obsidian_armor_feet_ultimate, 0, 5, 6, -3", "vampirism:obsidian_armor_head_enhanced, 0, 5, 6, -3", "vampirism:obsidian_armor_head_normal, 0, 5, 6, -3", "vampirism:obsidian_armor_head_ultimate, 0, 5, 6, -3", "vampirism:obsidian_armor_legs_enhanced, 0, 8, 12, -3", "vampirism:obsidian_armor_legs_normal, 0, 8, 12, -3", "vampirism:obsidian_armor_legs_ultimate, 0, 8, 12, -3", "wizard-staff:druid_boots, 0.4, 0, 0, -1", "wizard-staff:druid_chestplate, 0.8, 0, 0, -5", "wizard-staff:druid_helmet, 0.4, 0, 0, -2", "wizard-staff:druid_leggings, 0.6, 0, 0, -3", "wizard-staff:warlock_boots, 0.4, 0, 0, -2", "wizard-staff:warlock_chestplate, 0.8, 0, 0, -6", "wizard-staff:warlock_helmet, 0.4, 0, 0, -2", "wizard-staff:warlock_leggings, 0.6, 0, 0, -5", "wizard-staff:wizard_boots, 0.4, 0, 0, -1", "wizard-staff:wizard_chestplate, 0.8, 0, 0, -3", "wizard-staff:wizard_hat, 0.4, 0, 0, -1", "wizard-staff:wizard_leggings, 0.6, 0, 0, -2", "wyrmroost:blue_geode_boots, 0, 5, 4, -3", "wyrmroost:blue_geode_chestplate, 0, 10, 13, -7", "wyrmroost:blue_geode_helmet, 0, 5, 4, -3", "wyrmroost:blue_geode_leggings, 0, 8, 11, -5", "wyrmroost:drake_boots, 0.2, 6, 0, -2", "wyrmroost:drake_chestplate, 1.0, 16, 0, -6", "wyrmroost:drake_helmet, 0.4, 6, 0, -2", "wyrmroost:drake_leggings, 0.6, 12, 0, -5", "wyrmroost:platinum_boots, 0.1, 7, 1, -2", "wyrmroost:platinum_chestplate, 0.2, 16, 3, -6", "wyrmroost:platinum_helmet, 0.1, 7, 1, -2", "wyrmroost:platinum_leggings, 0.2, 12, 2, -5", "wyrmroost:purple_geode_boots, 0, 5, 8, -4", "wyrmroost:purple_geode_chestplate, 0, 10, 19, -10", "wyrmroost:purple_geode_helmet, 0, 5, 8, -4", "wyrmroost:purple_geode_leggings, 0, 8, 15, -7", "wyrmroost:red_geode_boots, 0, 5, 6, -3", "wyrmroost:red_geode_chestplate, 0, 10, 16, -8", "wyrmroost:red_geode_helmet, 0, 5, 6, -3", "wyrmroost:red_geode_leggings, 0, 8, 12, -6"};
        Pair specPair = new ForgeConfigSpec.Builder().configure(ItemConfig::new);
        CONFIG = (ItemConfig)specPair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
    }
}

