/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.entity;

import jackiecrazy.footwork.utils.TargetingUtils;
import jackiecrazy.wardance.utils.SkillUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class FakeExplosion
extends Explosion {
    private float radius;
    private float damage;
    private World world;

    public FakeExplosion(World worldIn, @Nullable Entity entityIn, double x, double y, double z, float radius, DamageSource ds, float damage) {
        super(worldIn, entityIn, ds, null, x, y, z, radius, false, Explosion.Mode.NONE);
        this.radius = radius * 2.0f;
        this.world = worldIn;
        this.damage = damage;
    }

    public static FakeExplosion explode(World world, Entity entityIn, double x, double y, double z, float radius, DamageSource damageSource, float damage) {
        FakeExplosion explosion = new FakeExplosion(world, entityIn, x, y, z, radius, damageSource, damage);
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        SkillUtils.createCloud(world, entityIn, x, y, z, radius * 2.0f, (IParticleData)ParticleTypes.field_197627_t);
        return explosion;
    }

    public void func_77278_a() {
        if (this.getExploder() == null) {
            return;
        }
        List list = this.world.func_72839_b(this.getExploder(), AxisAlignedBB.func_241549_a_((Vector3d)this.getPosition()).func_186662_g((double)this.radius));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)(this.radius * 2.0f));
        Vector3d vector3d = this.getPosition();
        for (Entity entity : list) {
            double zDiff;
            double yDiff;
            double xDiff;
            double dist;
            double percentage;
            if (entity.func_180427_aV() || TargetingUtils.isAlly((Entity)entity, (Entity)this.getExploder()) || !((percentage = (double)(MathHelper.func_76133_a((double)entity.func_195048_a(vector3d)) / this.radius)) <= 1.0) || (dist = (double)MathHelper.func_76133_a((double)((xDiff = entity.func_226277_ct_() - vector3d.field_72450_a) * xDiff + (yDiff = entity.func_226280_cw_() - vector3d.field_72448_b) * yDiff + (zDiff = entity.func_226281_cx_() - vector3d.field_72449_c) * zDiff))) == 0.0) continue;
            xDiff /= dist;
            yDiff /= dist;
            zDiff /= dist;
            double density = FakeExplosion.func_222259_a((Vector3d)vector3d, (Entity)entity);
            double densityReducedPerc = (1.0 - percentage) * density;
            entity.func_70097_a(this.func_199591_b(), (float)((double)this.damage * densityReducedPerc));
            double d11 = densityReducedPerc;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)densityReducedPerc);
            }
            if (entity == this.func_199591_b().func_76346_g() || entity == this.func_199591_b().func_76364_f()) continue;
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(xDiff * d11, yDiff * d11, zDiff * d11));
        }
    }
}

