/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.handlers;

import jackiecrazy.footwork.api.WarAttributes;
import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.capability.resources.ICombatCapability;
import jackiecrazy.footwork.capability.weaponry.CombatManipulator;
import jackiecrazy.footwork.capability.weaponry.ICombatItemCapability;
import jackiecrazy.footwork.event.DamageKnockbackEvent;
import jackiecrazy.footwork.event.MeleeKnockbackEvent;
import jackiecrazy.footwork.potion.FootworkEffects;
import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.footwork.utils.StealthUtils;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.api.CombatDamageSource;
import jackiecrazy.wardance.config.CombatConfig;
import jackiecrazy.wardance.config.GeneralConfig;
import jackiecrazy.wardance.config.ResourceConfig;
import jackiecrazy.wardance.config.StealthConfig;
import jackiecrazy.wardance.entity.FearEntity;
import jackiecrazy.wardance.entity.WarEntities;
import jackiecrazy.wardance.event.ParryEvent;
import jackiecrazy.wardance.event.ProjectileParryEvent;
import jackiecrazy.wardance.handlers.SubtleBonusHandler;
import jackiecrazy.wardance.mixin.ProjectileImpactMixin;
import jackiecrazy.wardance.utils.CombatUtils;
import jackiecrazy.wardance.utils.MovementUtils;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wardance")
public class CombatHandler {
    private static final UUID uuid = UUID.fromString("98c361c7-de32-4f40-b129-d7752bac3712");
    private static final UUID uuid2 = UUID.fromString("98c361c8-de32-4f40-b129-d7752bac3722");
    public static boolean downingHit = false;

    @SubscribeEvent
    public static void mohistWhy(AttackEntityEvent e) {
        CombatData.getCap((LivingEntity)e.getPlayer()).setCachedCooldown(e.getPlayer().func_184825_o(0.5f));
    }

    @SubscribeEvent
    public static void mudamudamuda(LivingEntityUseItemEvent e) {
        Hand h;
        Object object = e.getEntityLiving().func_184614_ca() == e.getItem() ? Hand.MAIN_HAND : (h = e.getEntityLiving().func_184592_cb() == e.getItem() ? Hand.OFF_HAND : null);
        if (h != null && CombatData.getCap((LivingEntity)e.getEntityLiving()).getHandBind(h) > 0) {
            if (e.isCancelable()) {
                e.setCanceled(true);
            }
            e.setDuration(-1);
        }
    }

    @SubscribeEvent
    public static void projectileParry(ProjectileImpactEvent e) {
        Entity projectile = e.getEntity();
        if (projectile instanceof ProjectileEntity && ((ProjectileEntity)projectile).func_234616_v_() instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)((ProjectileEntity)projectile).func_234616_v_();
            CombatData.getCap((LivingEntity)shooter).addRangedMight(e.getRayTraceResult().func_216346_c() == RayTraceResult.Type.ENTITY);
        }
        if (e.getRayTraceResult().func_216346_c() == RayTraceResult.Type.ENTITY && e.getRayTraceResult() instanceof EntityRayTraceResult && ((EntityRayTraceResult)e.getRayTraceResult()).func_216348_a() instanceof LivingEntity) {
            LivingEntity uke = (LivingEntity)((EntityRayTraceResult)e.getRayTraceResult()).func_216348_a();
            if (StealthUtils.INSTANCE.getAwareness(null, uke) != StealthUtils.Awareness.ALERT) {
                return;
            }
            if (MovementUtils.hasInvFrames(uke)) {
                e.setCanceled(true);
            }
            if (uke.func_184585_cz()) {
                return;
            }
            if (e.getEntity() instanceof AbstractArrowEntity && ((AbstractArrowEntity)e.getEntity()).func_213874_s() > 0) {
                return;
            }
            float consume = CombatConfig.posturePerProjectile;
            ICombatCapability ukeCap = CombatData.getCap((LivingEntity)uke);
            boolean failManualParry = CombatConfig.sneakParry > 0 && (ukeCap.getParryingTick() > uke.field_70173_aa || ukeCap.getParryingTick() < uke.field_70173_aa - CombatConfig.sneakParry);
            failManualParry |= CombatConfig.sneakParry < 0 && ukeCap.getParryingTick() == -1;
            failManualParry &= uke instanceof PlayerEntity;
            boolean free = ukeCap.getBarrierCooldown() > 0;
            ItemStack defend = null;
            Hand h = null;
            float defMult = 0.0f;
            if (CombatUtils.isShield(uke, uke.func_184592_cb()) && CombatUtils.canParry(uke, e.getEntity(), uke.func_184592_cb(), 0.0f)) {
                defend = uke.func_184592_cb();
                defMult = CombatUtils.getPostureDef(null, uke, defend, 0.0f);
                h = Hand.OFF_HAND;
            } else if (CombatUtils.isShield(uke, uke.func_184614_ca()) && CombatUtils.canParry(uke, e.getEntity(), uke.func_184614_ca(), 0.0f)) {
                defend = uke.func_184614_ca();
                defMult = CombatUtils.getPostureDef(null, uke, defend, 0.0f);
                h = Hand.MAIN_HAND;
            }
            StealthUtils.Awareness a = StealthUtils.Awareness.ALERT;
            if (projectile instanceof ProjectileEntity && ((ProjectileEntity)projectile).func_234616_v_() instanceof LivingEntity) {
                if (((ProjectileEntity)projectile).func_234616_v_() == uke) {
                    return;
                }
                a = StealthUtils.INSTANCE.getAwareness((LivingEntity)((ProjectileEntity)projectile).func_234616_v_(), uke);
            }
            boolean canParry = GeneralUtils.isFacingEntity((Entity)uke, (Entity)projectile, (int)120);
            boolean force = false;
            if (a != StealthUtils.Awareness.UNAWARE && CombatUtils.parryMap.containsKey(GeneralUtils.getResourceLocationFromEntity((Entity)uke))) {
                CombatUtils.MobInfo stats = CombatUtils.parryMap.get(GeneralUtils.getResourceLocationFromEntity((Entity)uke));
                if (stats.shield && (double)WarDance.rand.nextFloat() < stats.chance) {
                    if (stats.mult < 0.0) {
                        defend = null;
                        canParry = false;
                        defMult = (float)(-stats.mult);
                    } else if (stats.omnidirectional || canParry) {
                        if (!canParry) {
                            h = CombatUtils.getCooledAttackStrength(uke, Hand.MAIN_HAND, 0.5f) > CombatUtils.getCooledAttackStrength(uke, Hand.OFF_HAND, 0.5f) ? Hand.MAIN_HAND : Hand.OFF_HAND;
                        }
                        defend = ItemStack.field_190927_a;
                        defMult = (float)Math.min(stats.mult, (double)defMult);
                        canParry = true;
                        force = true;
                    }
                }
            }
            ProjectileParryEvent pe = new ProjectileParryEvent(uke, projectile, h, defend, defMult);
            if (failManualParry) {
                pe.setResult(Event.Result.DENY);
            }
            if (force) {
                pe.setResult(Event.Result.ALLOW);
            }
            MinecraftForge.EVENT_BUS.post((Event)pe);
            if (pe.getResult() == Event.Result.ALLOW || defend != null && canParry && pe.getResult() == Event.Result.DEFAULT && ukeCap.consumeBarrier(pe.getPostureConsumption()) != 0.0f) {
                e.setCanceled(true);
                uke.field_70170_p.func_184148_a(null, uke.func_226277_ct_(), uke.func_226278_cu_(), uke.func_226281_cx_(), free ? SoundEvents.field_187879_gP : SoundEvents.field_187877_gO, SoundCategory.PLAYERS, 0.75f + WarDance.rand.nextFloat() * 0.5f, 1.0f - ukeCap.getPosture() / ukeCap.getMaxPosture() + WarDance.rand.nextFloat() * 0.5f);
                if (pe.doesTrigger()) {
                    if (uke.func_70613_aW()) {
                        FearEntity dummy = new FearEntity(WarEntities.fear, uke.field_70170_p);
                        dummy.func_70634_a(projectile.func_226277_ct_(), projectile.func_226278_cu_(), projectile.func_226281_cx_());
                        uke.field_70170_p.func_217376_c((Entity)dummy);
                        if (projectile instanceof ProjectileEntity) {
                            EntityRayTraceResult rtr = new EntityRayTraceResult((Entity)dummy);
                            ((ProjectileImpactMixin)projectile).callOnHit((RayTraceResult)rtr);
                        }
                    }
                } else if (pe.getReturnVec() != null) {
                    projectile.func_213293_j(pe.getReturnVec().field_72450_a, pe.getReturnVec().field_72448_b, pe.getReturnVec().field_72449_c);
                    if (projectile instanceof ProjectileEntity) {
                        double power = pe.getReturnVec().field_72450_a / pe.getReturnVec().func_72432_b().field_72450_a;
                        ((ProjectileEntity)projectile).func_70186_c(pe.getReturnVec().field_72450_a, pe.getReturnVec().field_72448_b, pe.getReturnVec().field_72449_c, (float)power, 0.0f);
                    }
                } else {
                    projectile.func_70106_y();
                }
                CombatUtils.knockBack((Entity)uke, projectile, 0.01f, true, false);
                return;
            }
            if ((uke instanceof PlayerEntity || WarDance.rand.nextFloat() > CombatConfig.mobDeflectChance) && GeneralUtils.isFacingEntity((Entity)uke, (Entity)projectile, (int)(120 + 2 * (int)GeneralUtils.getAttributeValueSafe((LivingEntity)uke, (Attribute)((Attribute)WarAttributes.DEFLECTION.get())))) && !canParry && ukeCap.doConsumePosture(consume)) {
                e.setCanceled(true);
                uke.field_70170_p.func_184148_a(null, uke.func_226277_ct_(), uke.func_226278_cu_(), uke.func_226281_cx_(), SoundEvents.field_187617_cK, SoundCategory.PLAYERS, 0.75f + WarDance.rand.nextFloat() * 0.5f, 1.0f - ukeCap.getPosture() / ukeCap.getMaxPosture() + WarDance.rand.nextFloat() * 0.5f);
                if (pe.getReturnVec() != null) {
                    projectile.func_213293_j(pe.getReturnVec().field_72450_a, pe.getReturnVec().field_72448_b, pe.getReturnVec().field_72449_c);
                    if (projectile instanceof ProjectileEntity) {
                        double power = pe.getReturnVec().field_72450_a / pe.getReturnVec().func_72432_b().field_72450_a;
                        ((ProjectileEntity)projectile).func_70186_c(pe.getReturnVec().field_72450_a, pe.getReturnVec().field_72448_b, pe.getReturnVec().field_72449_c, (float)power, 0.0f);
                    }
                } else {
                    projectile.func_70106_y();
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void cancel(LivingAttackEvent e) {
        if (!e.getEntityLiving().field_70170_p.field_72995_K && e.getSource() != null && CombatUtils.isPhysicalAttack(e.getSource())) {
            LivingEntity uke = e.getEntityLiving();
            if (MovementUtils.hasInvFrames(uke)) {
                e.setCanceled(true);
            }
            ICombatCapability ukeCap = CombatData.getCap((LivingEntity)uke);
            ItemStack attack = CombatUtils.getAttackingItemStack(e.getSource());
            if (CombatUtils.isMeleeAttack(e.getSource()) && e.getSource().func_76346_g() instanceof LivingEntity && attack != null && e.getAmount() > 0.0f) {
                Hand h;
                LivingEntity seme = (LivingEntity)e.getSource().func_76346_g();
                ICombatCapability semeCap = CombatData.getCap((LivingEntity)seme);
                ukeCap.serverTick();
                semeCap.serverTick();
                Hand hand = h = semeCap.isOffhandAttack() ? Hand.OFF_HAND : Hand.MAIN_HAND;
                if (semeCap.getStaggerTime() > 0 || semeCap.getHandBind(h) > 0) {
                    e.setCanceled(true);
                    return;
                }
                if (seme.func_184614_ca().getCapability(CombatManipulator.CAP).resolve().isPresent()) {
                    e.setCanceled(((ICombatItemCapability)seme.func_184614_ca().getCapability(CombatManipulator.CAP).resolve().get()).canAttack(e.getSource(), seme, uke, seme.func_184614_ca(), e.getAmount()));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void parry(LivingAttackEvent e) {
        if (!e.getEntityLiving().field_70170_p.field_72995_K && e.getSource() != null && CombatUtils.isPhysicalAttack(e.getSource())) {
            LivingEntity uke = e.getEntityLiving();
            if (MovementUtils.hasInvFrames(uke)) {
                e.setCanceled(true);
            }
            ICombatCapability ukeCap = CombatData.getCap((LivingEntity)uke);
            ItemStack attack = CombatUtils.getAttackingItemStack(e.getSource());
            if (CombatUtils.isMeleeAttack(e.getSource()) && e.getSource().func_76346_g() instanceof LivingEntity && attack != null && e.getAmount() > 0.0f) {
                float atkMult;
                boolean useDeflect;
                Hand attackingHand;
                LivingEntity seme = (LivingEntity)e.getSource().func_76346_g();
                ICombatCapability semeCap = CombatData.getCap((LivingEntity)seme);
                Hand hand = attackingHand = semeCap.isOffhandAttack() ? Hand.OFF_HAND : Hand.MAIN_HAND;
                if (semeCap.getStaggerTime() > 0 || semeCap.getHandBind(attackingHand) > 0) {
                    e.setCanceled(true);
                    return;
                }
                boolean sweeping = false;
                seme.func_184614_ca().getCapability(CombatManipulator.CAP).ifPresent(i -> i.attackStart(e.getSource(), seme, uke, seme.func_184614_ca(), e.getAmount()));
                if (semeCap.getSweepTick() != seme.field_70173_aa) {
                    semeCap.addRank(0.1f);
                    float might = CombatUtils.getAttackMight(seme, uke);
                    semeCap.addMight(might);
                    semeCap.setSweepTick(seme.field_70173_aa);
                } else {
                    sweeping = true;
                }
                if (uke.func_184585_cz()) {
                    ukeCap.consumePosture(0.0f);
                    return;
                }
                boolean failManualParry = CombatConfig.sneakParry > 0 && (ukeCap.getParryingTick() > uke.field_70173_aa || ukeCap.getParryingTick() < uke.field_70173_aa - CombatConfig.sneakParry);
                failManualParry |= CombatConfig.sneakParry < 0 && ukeCap.getParryingTick() == -1;
                failManualParry &= uke instanceof PlayerEntity;
                boolean canParry = GeneralUtils.isFacingEntity((Entity)uke, (Entity)seme, (int)120);
                boolean bl = useDeflect = (uke instanceof PlayerEntity || WarDance.rand.nextFloat() < CombatConfig.mobDeflectChance) && GeneralUtils.isFacingEntity((Entity)uke, (Entity)seme, (int)(120 + 2 * (int)GeneralUtils.getAttributeValueSafe((LivingEntity)uke, (Attribute)((Attribute)WarAttributes.DEFLECTION.get())))) && !GeneralUtils.isFacingEntity((Entity)uke, (Entity)seme, (int)120) && !canParry;
                if (ukeCap.getStaggerTime() > 0) {
                    downingHit = false;
                    return;
                }
                float original = atkMult = CombatUtils.getPostureAtk(seme, seme, attackingHand, e.getAmount(), attack);
                downingHit = true;
                StealthUtils.Awareness awareness = StealthUtils.INSTANCE.getAwareness(seme, uke);
                if (e.getSource() instanceof CombatDamageSource && ((CombatDamageSource)e.getSource()).isCrit()) {
                    atkMult *= ((CombatDamageSource)e.getSource()).getCritDamage();
                }
                ItemStack defend = null;
                Hand parryHand = null;
                if (canParry) {
                    float posMod = 1337.0f;
                    boolean isShield = false;
                    if (CombatUtils.canParry(uke, (Entity)seme, uke.func_184592_cb(), atkMult)) {
                        defend = uke.func_184592_cb();
                        posMod = CombatUtils.getPostureDef(seme, uke, uke.func_184592_cb(), e.getAmount());
                        isShield = CombatUtils.isShield(uke, uke.func_184592_cb());
                        parryHand = Hand.OFF_HAND;
                    }
                    if (!isShield && CombatUtils.canParry(uke, (Entity)seme, uke.func_184614_ca(), atkMult) && CombatUtils.getPostureDef(seme, uke, uke.func_184614_ca(), e.getAmount()) < posMod) {
                        defend = uke.func_184614_ca();
                        parryHand = Hand.MAIN_HAND;
                    }
                }
                float defMult = CombatUtils.getPostureDef(seme, uke, defend, e.getAmount());
                if (atkMult >= 0.0f && awareness != StealthUtils.Awareness.UNAWARE && CombatUtils.parryMap.containsKey(GeneralUtils.getResourceLocationFromEntity((Entity)uke))) {
                    CombatUtils.MobInfo stats = CombatUtils.parryMap.get(GeneralUtils.getResourceLocationFromEntity((Entity)uke));
                    if ((double)WarDance.rand.nextFloat() < stats.chance) {
                        if (stats.mult < 0.0) {
                            defend = null;
                            canParry = false;
                            defMult = (float)(-stats.mult);
                        } else if ((stats.omnidirectional || canParry) && (double)defMult > stats.mult) {
                            if (!canParry) {
                                parryHand = CombatUtils.getCooledAttackStrength(uke, Hand.MAIN_HAND, 0.5f) > CombatUtils.getCooledAttackStrength(uke, Hand.OFF_HAND, 0.5f) ? Hand.MAIN_HAND : Hand.OFF_HAND;
                            }
                            defend = ItemStack.field_190927_a;
                            defMult = (float)Math.min(stats.mult, (double)defMult);
                            canParry = true;
                        }
                    }
                }
                float finalPostureConsumption = Math.abs(atkMult * defMult);
                float originalPostureConsumption = Math.abs(original * defMult);
                ParryEvent pe = new ParryEvent(uke, seme, canParry && defend != null || useDeflect, attackingHand, attack, parryHand, defend, finalPostureConsumption, originalPostureConsumption, e.getAmount());
                if (failManualParry) {
                    pe.setResult(Event.Result.DENY);
                }
                MinecraftForge.EVENT_BUS.post((Event)pe);
                if (pe.isCanceled()) {
                    e.setCanceled(true);
                    return;
                }
                if (ukeCap.getStaggerTime() == 0) {
                    float consumption = pe.getPostureConsumption();
                    if (pe.canParry() && !useDeflect && CombatUtils.isShield(uke, defend)) {
                        consumption -= ukeCap.consumeBarrier(consumption);
                    }
                    float knockback = ukeCap.consumePosture(seme, consumption);
                    if (StealthConfig.ignore && awareness == StealthUtils.Awareness.UNAWARE) {
                        return;
                    }
                    if (pe.canParry()) {
                        e.setCanceled(true);
                        downingHit = false;
                        ukeCap.addRank(0.0f);
                        if (useDeflect) {
                            uke.field_70170_p.func_184148_a(null, uke.func_226277_ct_(), uke.func_226278_cu_(), uke.func_226281_cx_(), SoundEvents.field_187617_cK, SoundCategory.PLAYERS, 0.75f + WarDance.rand.nextFloat() * 0.5f, 1.0f - ukeCap.getPosture() / ukeCap.getMaxPosture() + WarDance.rand.nextFloat() * 0.5f);
                            return;
                        }
                        boolean disshield = false;
                        Hand hand2 = parryHand = uke.func_184592_cb() == defend ? Hand.OFF_HAND : Hand.MAIN_HAND;
                        if (CombatUtils.isShield(uke, defend)) {
                            Tuple<Integer, Float> stat = CombatUtils.getShieldStats(defend);
                            if (attack.canDisableShield(defend, uke, seme)) {
                                if (uke instanceof PlayerEntity) {
                                    ((PlayerEntity)uke).func_184811_cZ().func_185145_a(defend.func_77973_b(), ((Integer)stat.func_76341_a()).intValue());
                                } else {
                                    ukeCap.setHandBind(parryHand, ((Integer)stat.func_76341_a()).intValue());
                                }
                                disshield = true;
                            }
                        }
                        double kb = Math.sqrt(atkMult) - 0.18 - 1.0 / Math.max((double)defMult, 0.1);
                        kb = 1.0 / (1.0 + Math.exp(-kb));
                        CombatUtils.knockBack((Entity)uke, (Entity)seme, Math.min(uke instanceof PlayerEntity ? 1.6f : 1.3f, 0.2f + (pe.getPostureConsumption() + knockback) * (float)kb * (float)(uke instanceof PlayerEntity ? 6 : 4) / ukeCap.getMaxPosture()), true, false);
                        kb = 1.0 - kb;
                        CombatUtils.knockBack((Entity)seme, (Entity)uke, Math.min(uke instanceof PlayerEntity ? 1.6f : 1.3f, 0.1f + pe.getPostureConsumption() * (float)kb * (float)(seme instanceof PlayerEntity ? 3 : 2) / semeCap.getMaxPosture()), true, false);
                        uke.field_70170_p.func_184148_a(null, uke.func_226277_ct_(), uke.func_226278_cu_(), uke.func_226281_cx_(), disshield ? SoundEvents.field_187767_eL : SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.25f + WarDance.rand.nextFloat() * 0.5f, 1.0f - ukeCap.getPosture() / ukeCap.getMaxPosture() + WarDance.rand.nextFloat() * 0.5f);
                        if (defMult != 0.0f) {
                            int ticks = (int)((consumption + 1.0f) * 5.0f);
                            float cd = CombatUtils.getCooldownPeriod(uke, parryHand);
                            if (cd > (float)ticks) {
                                CombatUtils.setHandCooldownDirect(uke, parryHand, ticks, true);
                            } else {
                                ukeCap.setHandBind(parryHand, ticks - (int)cd);
                            }
                        }
                        if (sweeping) {
                            CombatUtils.setHandCooldown(seme, attackingHand, 0.0f, true);
                        } else {
                            CombatUtils.setHandCooldown(seme, attackingHand, (float)(1.0 - kb), true);
                        }
                        if (defend != null) {
                            ItemStack finalDefend = defend;
                            defend.getCapability(CombatManipulator.CAP).ifPresent(i -> i.onParry(seme, uke, finalDefend, e.getAmount()));
                            Hand other = uke.func_184614_ca() == defend ? Hand.OFF_HAND : Hand.MAIN_HAND;
                            ItemStack finalDefend1 = uke.func_184586_b(other);
                            finalDefend1.getCapability(CombatManipulator.CAP).ifPresent(i -> i.onOtherHandParry(seme, uke, finalDefend1, e.getAmount()));
                        }
                    }
                }
                if (!(seme instanceof PlayerEntity)) {
                    semeCap.setHandBind(attackingHand, CombatUtils.getCooldownPeriod(seme, attackingHand) + 7);
                }
            }
            if (!uke.func_184585_cz() && !e.isCanceled() && CombatUtils.isPhysicalAttack(e.getSource()) && StealthUtils.INSTANCE.getAwareness(e.getSource().func_76364_f() instanceof LivingEntity ? (LivingEntity)e.getSource().func_76364_f() : null, uke) != StealthUtils.Awareness.UNAWARE && CombatData.getCap((LivingEntity)uke).consumeShatter(e.getAmount())) {
                e.setCanceled(true);
                uke.field_70170_p.func_184148_a(null, uke.func_226277_ct_(), uke.func_226278_cu_(), uke.func_226281_cx_(), SoundEvents.field_187561_bM, SoundCategory.PLAYERS, 0.25f + WarDance.rand.nextFloat() * 0.5f, 0.75f + WarDance.rand.nextFloat() * 0.5f);
            }
        }
    }

    @SubscribeEvent
    public static void critHooks(CriticalHitEvent e) {
        if (!e.getEntityLiving().field_70170_p.field_72995_K) {
            LivingEntity uke = e.getEntityLiving();
            PlayerEntity seme = e.getPlayer();
            if (seme.func_184614_ca().getCapability(CombatManipulator.CAP).isPresent()) {
                e.setResult(((ICombatItemCapability)seme.func_184614_ca().getCapability(CombatManipulator.CAP).resolve().get()).critCheck((LivingEntity)seme, uke, seme.func_184614_ca(), e.getOldDamageModifier(), e.isVanillaCritical()));
                e.setDamageModifier(((ICombatItemCapability)seme.func_184614_ca().getCapability(CombatManipulator.CAP).resolve().get()).critDamage((LivingEntity)seme, uke, seme.func_184614_ca()));
            }
        }
    }

    @SubscribeEvent
    public static void knockbackHooks(MeleeKnockbackEvent e) {
        if (!e.getEntityLiving().field_70170_p.field_72995_K) {
            LivingEntity uke = e.getEntityLiving();
            LivingEntity seme = e.getAttacker();
            seme.func_184614_ca().getCapability(CombatManipulator.CAP).ifPresent(i -> i.onKnockingBack(seme, uke, seme.func_184614_ca(), e.getOriginalStrength()));
            uke.func_184614_ca().getCapability(CombatManipulator.CAP).ifPresent(i -> i.onBeingKnockedBack(seme, uke, seme.func_184614_ca(), e.getOriginalStrength()));
            uke.func_184592_cb().getCapability(CombatManipulator.CAP).ifPresent(i -> i.onBeingKnockedBack(seme, uke, seme.func_184592_cb(), e.getOriginalStrength()));
        }
    }

    @SubscribeEvent
    public static void otherKnockbackHooks(DamageKnockbackEvent e) {
        if (e.getDamageSource() instanceof CombatDamageSource) {
            CombatDamageSource cds = (CombatDamageSource)e.getDamageSource();
            e.setStrength(e.getStrength() * cds.getKnockbackPercentage());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void knockKnockWhosThere(LivingKnockBackEvent e) {
        if (!CombatData.getCap((LivingEntity)e.getEntityLiving()).isFirstStaggerStrike() && CombatData.getCap((LivingEntity)e.getEntityLiving()).getStaggerTime() > 0) {
            e.setCanceled(true);
            return;
        }
        if (e.getEntityLiving().func_184187_bx() != null) {
            LivingEntity ride;
            int divisor = 1;
            for (ride = e.getEntityLiving(); ride != null && ride.func_184187_bx() != null; ride = ride.func_184187_bx()) {
                ++divisor;
            }
            for (ride = e.getEntityLiving(); ride != null && ride.func_184187_bx() != null; ride = ride.func_184187_bx()) {
                if (!(ride instanceof LivingEntity)) continue;
                CombatData.getCap((LivingEntity)ride).consumePosture(e.getStrength() / (float)divisor);
            }
        }
        e.setStrength(e.getStrength() * CombatConfig.kbNerf);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void pain(LivingHurtEvent e) {
        LivingEntity seme;
        ICombatItemCapability icic;
        float mult;
        if (GeneralConfig.debug) {
            WarDance.LOGGER.debug("damage from " + e.getSource() + " received with amount " + e.getAmount());
        }
        LivingEntity uke = e.getEntityLiving();
        uke.func_195063_d((Effect)FootworkEffects.DISTRACTION.get());
        uke.func_195063_d((Effect)FootworkEffects.FEAR.get());
        uke.func_195063_d((Effect)FootworkEffects.SLEEP.get());
        LivingEntity kek = null;
        DamageSource ds = e.getSource();
        if (uke.func_70644_a((Effect)FootworkEffects.VULNERABLE.get()) && !CombatUtils.isPhysicalAttack(ds)) {
            e.setAmount(e.getAmount() + (float)uke.func_70660_b((Effect)FootworkEffects.VULNERABLE.get()).func_76458_c() + 1.0f);
        }
        if (ds.func_76364_f() instanceof LivingEntity) {
            kek = (LivingEntity)ds.func_76364_f();
        }
        uke.func_110148_a(Attributes.field_233826_i_).func_188479_b(uuid);
        uke.func_110148_a(Attributes.field_233826_i_).func_188479_b(uuid2);
        if (ds instanceof CombatDamageSource && (mult = -((CombatDamageSource)ds).getArmorReductionPercentage()) != 0.0f) {
            AttributeModifier armor = new AttributeModifier(uuid2, "temporary armor multiplier", (double)mult, AttributeModifier.Operation.MULTIPLY_TOTAL);
            uke.func_110148_a(Attributes.field_233826_i_).func_233767_b_(armor);
        }
        ItemStack ukemain = uke.func_184614_ca();
        ItemStack ukeoff = uke.func_184592_cb();
        if (ukemain.getCapability(CombatManipulator.CAP).isPresent()) {
            icic = (ICombatItemCapability)ukemain.getCapability(CombatManipulator.CAP).resolve().get();
            e.setAmount(icic.onBeingHurt(e.getSource(), uke, ukemain, e.getAmount()));
        }
        if (ukeoff.getCapability(CombatManipulator.CAP).isPresent()) {
            icic = (ICombatItemCapability)ukeoff.getCapability(CombatManipulator.CAP).resolve().get();
            e.setAmount(icic.onBeingHurt(e.getSource(), uke, ukeoff, e.getAmount()));
        }
        ICombatCapability cap = CombatData.getCap((LivingEntity)uke);
        cap.setSpiritGrace(ResourceConfig.spiritCD);
        cap.setAdrenalineCooldown(CombatConfig.adrenaline);
        SubtleBonusHandler.update = true;
        StealthUtils.Awareness awareness = StealthUtils.INSTANCE.getAwareness(kek, uke);
        if (ds.func_76346_g() instanceof LivingEntity) {
            seme = (LivingEntity)ds.func_76346_g();
            if (seme.func_184614_ca().getCapability(CombatManipulator.CAP).isPresent()) {
                ICombatItemCapability icic2 = (ICombatItemCapability)seme.func_184614_ca().getCapability(CombatManipulator.CAP).resolve().get();
                e.setAmount(icic2.hurtStart(e.getSource(), seme, uke, seme.func_184614_ca(), e.getAmount()) * icic2.damageMultiplier(seme, uke, seme.func_184614_ca()));
                AttributeModifier armor = new AttributeModifier(uuid, "temporary armor removal", (double)(-icic2.armorIgnoreAmount(e.getSource(), seme, uke, seme.func_184614_ca(), e.getAmount())), AttributeModifier.Operation.ADDITION);
                uke.func_110148_a(Attributes.field_233826_i_).func_233767_b_(armor);
            }
            if (CombatUtils.isPhysicalAttack(e.getSource())) {
                cap.setMightGrace(0);
            }
            double luckDiff = (double)WarDance.rand.nextFloat() * GeneralUtils.getAttributeValueSafe((LivingEntity)seme, (Attribute)Attributes.field_233828_k_) - (double)WarDance.rand.nextFloat() * GeneralUtils.getAttributeValueSafe((LivingEntity)uke, (Attribute)Attributes.field_233828_k_);
            e.setAmount(e.getAmount() + (float)luckDiff * GeneralConfig.luck);
        }
        if (cap.getStaggerTime() > 0 && !cap.isFirstStaggerStrike() && e.getAmount() > 1.0f && CombatUtils.isPhysicalAttack(ds)) {
            e.setAmount(e.getAmount() * (1.0f + cap.getFatigue() * 2.0f / Math.max(cap.getTrueMaxPosture(), 1.0f)));
            e.setAmount(e.getAmount() * CombatConfig.staggerDamage);
            if (ds.func_76346_g() instanceof LivingEntity) {
                seme = (LivingEntity)ds.func_76346_g();
                if (seme.field_70170_p instanceof ServerWorld) {
                    ((ServerWorld)seme.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197609_b, uke.func_226277_ct_(), uke.func_226278_cu_(), uke.func_226281_cx_(), 5, (double)uke.func_213311_cf(), (double)uke.func_213302_cg(), (double)uke.func_213311_cf(), 0.5);
                }
                seme.field_70170_p.func_184148_a(null, uke.func_226277_ct_(), uke.func_226278_cu_(), uke.func_226281_cx_(), SoundEvents.field_187655_bw, SoundCategory.PLAYERS, 0.25f + WarDance.rand.nextFloat() * 0.5f, 0.75f + WarDance.rand.nextFloat() * 0.5f);
            }
        } else {
            e.setAmount(e.getAmount() * CombatConfig.unStaggerDamage);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void tanky(LivingDamageEvent e) {
        LivingEntity uke = e.getEntityLiving();
        uke.func_110148_a(Attributes.field_233826_i_).func_188479_b(uuid);
        uke.func_110148_a(Attributes.field_233826_i_).func_188479_b(uuid2);
        ItemStack active = uke.func_184586_b(uke.func_184600_cs());
        if (CombatUtils.isPhysicalAttack(e.getSource()) && CombatConfig.foodCool >= 0 && (active.func_77973_b().func_77661_b(active) == UseAction.EAT || active.func_77973_b().func_77661_b(active) == UseAction.DRINK) && uke.func_184587_cr()) {
            uke.func_184597_cx();
            if (uke instanceof PlayerEntity && CombatConfig.foodCool > 0) {
                ((PlayerEntity)uke).func_184811_cZ().func_185145_a(active.func_77973_b(), CombatConfig.foodCool);
            }
        }
        if (e.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity seme = (LivingEntity)e.getSource().func_76346_g();
            if (CombatUtils.isMeleeAttack(e.getSource())) {
                ICombatItemCapability icic;
                ItemStack sememain = seme.func_184614_ca();
                if (sememain.getCapability(CombatManipulator.CAP).isPresent()) {
                    ICombatItemCapability icic2 = (ICombatItemCapability)sememain.getCapability(CombatManipulator.CAP).resolve().get();
                    e.setAmount(icic2.damageStart(e.getSource(), seme, uke, sememain, e.getAmount()));
                }
                ItemStack ukemain = uke.func_184614_ca();
                ItemStack ukeoff = uke.func_184592_cb();
                if (ukemain.getCapability(CombatManipulator.CAP).isPresent()) {
                    icic = (ICombatItemCapability)ukemain.getCapability(CombatManipulator.CAP).resolve().get();
                    e.setAmount(icic.onBeingDamaged(e.getSource(), uke, ukemain, e.getAmount()));
                }
                if (ukeoff.getCapability(CombatManipulator.CAP).isPresent()) {
                    icic = (ICombatItemCapability)ukeoff.getCapability(CombatManipulator.CAP).resolve().get();
                    e.setAmount(icic.onBeingDamaged(e.getSource(), uke, ukeoff, e.getAmount()));
                }
            }
        }
        if (CombatData.getCap((LivingEntity)uke).getStaggerTime() == 0 && CombatUtils.isPhysicalAttack(e.getSource())) {
            if (e.getSource().func_76346_g() instanceof LivingEntity && StealthUtils.INSTANCE.getAwareness((LivingEntity)e.getSource().func_76346_g(), uke) == StealthUtils.Awareness.UNAWARE) {
                return;
            }
            float amount = e.getAmount();
            amount = (float)((double)amount - GeneralUtils.getAttributeValueSafe((LivingEntity)uke, (Attribute)((Attribute)WarAttributes.ABSORPTION.get())));
            e.setAmount(Math.max(0.0f, amount));
        }
        if (e.getAmount() <= 0.0f) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void udedlol(LivingDamageEvent e) {
        if (GeneralConfig.debug) {
            WarDance.LOGGER.debug("damage from " + e.getSource() + " finalized with amount " + e.getAmount());
        }
        if (!Float.isFinite(e.getAmount())) {
            e.setAmount(0.0f);
        }
        ICombatCapability cap = CombatData.getCap((LivingEntity)e.getEntityLiving());
        if (!e.isCanceled() && cap.getStaggerTime() > 0 && CombatUtils.isMeleeAttack(e.getSource()) && !cap.isFirstStaggerStrike()) {
            cap.decrementStaggerCount(1);
        }
        if (e.getAmount() > e.getEntityLiving().func_110143_aJ() + e.getEntityLiving().func_110139_bj()) {
            cap.setFatigue(0.0f);
            cap.setWounding(0.0f);
            cap.setBurnout(0.0f);
        } else if (e.getAmount() > 0.0f && ResourceConfig.woundWL == ResourceConfig.woundList.contains(e.getSource().func_76355_l())) {
            cap.addWounding(e.getAmount() * ResourceConfig.wound);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void adMortemInimicus(LivingDeathEvent e) {
        ICombatCapability icc = CombatData.getCap((LivingEntity)e.getEntityLiving());
        icc.setFatigue(0.0f);
        icc.setWounding(0.0f);
        icc.setBurnout(0.0f);
    }
}

