/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.handlers;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.capability.resources.ICombatCapability;
import jackiecrazy.wardance.capability.resources.CombatDataOverride;
import jackiecrazy.wardance.capability.skill.CasterData;
import jackiecrazy.wardance.capability.skill.ISkillCapability;
import jackiecrazy.wardance.capability.status.Marks;
import jackiecrazy.wardance.networking.CombatChannel;
import jackiecrazy.wardance.networking.SyncSkillPacket;
import jackiecrazy.wardance.skill.Skill;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="wardance")
public class EntityHandler {
    public static final HashMap<PlayerEntity, Entity> mustUpdate = new HashMap();
    public static final ConcurrentHashMap<Tuple<World, BlockPos>, Float> alertTracker = new ConcurrentHashMap();

    @SubscribeEvent
    public static void start(FMLServerStartingEvent e) {
        mustUpdate.clear();
        alertTracker.clear();
    }

    @SubscribeEvent
    public static void stop(FMLServerStoppingEvent e) {
        mustUpdate.clear();
        alertTracker.clear();
    }

    @SubscribeEvent
    public static void caps(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof LivingEntity) {
            e.addCapability(new ResourceLocation("wardance:combatinfo"), (ICapabilityProvider)new CombatDataOverride((LivingEntity)e.getObject()));
            e.addCapability(new ResourceLocation("wardance:statuseffects"), (ICapabilityProvider)new Marks((LivingEntity)e.getObject()));
            if (e.getObject() instanceof PlayerEntity) {
                e.addCapability(new ResourceLocation("wardance:casterinfo"), (ICapabilityProvider)new CasterData((LivingEntity)e.getObject()));
            }
        }
    }

    @SubscribeEvent
    public static void takeThis(EntityJoinWorldEvent e) {
        if (e.getEntity() instanceof ServerPlayerEntity) {
            CombatChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)e.getEntity()), (Object)new SyncSkillPacket(CasterData.getCap((LivingEntity)e.getEntity()).write()));
        }
    }

    @SubscribeEvent
    public static void respawn(PlayerEvent.Clone e) {
        CasterData.getCap((LivingEntity)e.getPlayer()).read(CasterData.getCap((LivingEntity)e.getOriginal()).write());
        if (!e.isWasDeath()) {
            ICombatCapability icc = CombatData.getCap((LivingEntity)e.getPlayer());
            icc.read(CombatData.getCap((LivingEntity)e.getOriginal()).write());
            icc.setFatigue(0.0f);
            icc.setBurnout(0.0f);
            icc.setWounding(0.0f);
        }
        ISkillCapability cap = CasterData.getCap((LivingEntity)e.getPlayer());
        cap.setEquippedSkills(CasterData.getCap((LivingEntity)e.getOriginal()).getEquippedSkills());
        for (Skill s : cap.getEquippedSkills()) {
            if (s == null) continue;
            s.onEquip((LivingEntity)e.getPlayer());
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.PlayerTickEvent e) {
        if (e.player.func_70089_S() && e.phase == TickEvent.Phase.START) {
            if (e.side != LogicalSide.SERVER) {
                CombatData.getCap((LivingEntity)e.player).clientTick();
                return;
            }
            CombatData.getCap((LivingEntity)e.player).serverTick();
            CasterData.getCap((LivingEntity)e.player).update();
            Marks.getCap((LivingEntity)e.player).update();
        }
    }

    @SubscribeEvent
    public static void tickMobs(LivingEvent.LivingUpdateEvent e) {
        LivingEntity elb = e.getEntityLiving();
        if (!elb.field_70170_p.field_72995_K && !(elb instanceof PlayerEntity)) {
            Marks.getCap(elb).update();
            ICombatCapability cap = CombatData.getCap((LivingEntity)elb);
            if (cap.getStaggerTime() > 0 || mustUpdate.containsValue(e.getEntity())) {
                cap.serverTick();
            }
        }
    }
}

