/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.networking;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.capability.resources.ICombatCapability;
import jackiecrazy.wardance.config.CombatConfig;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ManualParryPacket {

    public static class ParryHandler
    implements BiConsumer<ManualParryPacket, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(ManualParryPacket updateClientPacket, Supplier<NetworkEvent.Context> contextSupplier) {
            contextSupplier.get().enqueueWork(() -> {
                ServerPlayerEntity le = Objects.requireNonNull(((NetworkEvent.Context)contextSupplier.get()).getSender());
                ICombatCapability cap = CombatData.getCap((LivingEntity)le);
                if (CombatConfig.sneakParry < 0) {
                    cap.setParryingTick(cap.getParryingTick() == -1 ? 0 : -1);
                } else if (cap.getParryingTick() < le.field_70173_aa + CombatConfig.sneakParry * 2) {
                    cap.setParryingTick(le.field_70173_aa);
                }
            });
            contextSupplier.get().setPacketHandled(true);
        }
    }

    public static class ParryDecoder
    implements Function<PacketBuffer, ManualParryPacket> {
        @Override
        public ManualParryPacket apply(PacketBuffer packetBuffer) {
            return new ManualParryPacket();
        }
    }

    public static class ParryEncoder
    implements BiConsumer<ManualParryPacket, PacketBuffer> {
        @Override
        public void accept(ManualParryPacket updateClientPacket, PacketBuffer packetBuffer) {
        }
    }
}

