/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.networking;

import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.wardance.config.GeneralConfig;
import jackiecrazy.wardance.utils.CombatUtils;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.network.NetworkEvent;

public class RequestSweepPacket {
    boolean main;
    int id;

    public RequestSweepPacket(boolean isMainHand, int ignoreID) {
        this.main = isMainHand;
        this.id = ignoreID;
    }

    public RequestSweepPacket(boolean isMainHand, Entity ignore) {
        this.main = isMainHand;
        this.id = ignore == null ? -1 : ignore.func_145782_y();
    }

    public static class RequestSweepHandler
    implements BiConsumer<RequestSweepPacket, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(RequestSweepPacket updateClientPacket, Supplier<NetworkEvent.Context> contextSupplier) {
            contextSupplier.get().enqueueWork(() -> {
                Hand h;
                ServerPlayerEntity sender = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                Hand hand = h = updateClientPacket.main ? Hand.MAIN_HAND : Hand.OFF_HAND;
                if (sender != null && (GeneralConfig.dual || updateClientPacket.main) && CombatUtils.getCooledAttackStrength((LivingEntity)sender, h, 1.0f) >= 0.9f) {
                    double d0 = sender.field_70140_Q - sender.field_70141_P;
                    if ((!(sender.field_70143_R > 0.0f) || sender.func_70617_f_() || sender.func_70090_H() || sender.func_70644_a(Effects.field_76440_q) || sender.func_184218_aH()) && !sender.func_70051_ag() && sender.func_233570_aj_() && d0 < (double)sender.func_70689_ay()) {
                        CombatUtils.sweep((LivingEntity)sender, sender.field_70170_p.func_73045_a(updateClientPacket.id), h, GeneralUtils.getAttributeValueSafe((LivingEntity)sender, (Attribute)((Attribute)ForgeMod.REACH_DISTANCE.get())));
                    }
                }
                if (h == Hand.OFF_HAND) {
                    CombatUtils.setHandCooldown((LivingEntity)sender, h, 0.0f, false);
                }
            });
            contextSupplier.get().setPacketHandled(true);
        }
    }

    public static class RequestSweepDecoder
    implements Function<PacketBuffer, RequestSweepPacket> {
        @Override
        public RequestSweepPacket apply(PacketBuffer packetBuffer) {
            return new RequestSweepPacket(packetBuffer.readBoolean(), packetBuffer.readInt());
        }
    }

    public static class RequestSweepEncoder
    implements BiConsumer<RequestSweepPacket, PacketBuffer> {
        @Override
        public void accept(RequestSweepPacket updateClientPacket, PacketBuffer packetBuffer) {
            packetBuffer.writeBoolean(updateClientPacket.main);
            packetBuffer.writeInt(updateClientPacket.id);
        }
    }
}

