/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.networking;

import jackiecrazy.wardance.capability.skill.CasterData;
import jackiecrazy.wardance.capability.skill.ISkillCapability;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateSkillSelectionPacket {
    private static final ResourceLocation DUMMY = new ResourceLocation("wardance:thisisadummy");
    private static final Comparator<Skill> comparator = (o1, o2) -> {
        if (o1 == o2 && o2 == null) {
            return 0;
        }
        if (o1 == null || o1.getRegistryName() == null) {
            return -1;
        }
        if (o2 == null || o2.getRegistryName() == null) {
            return 1;
        }
        return o1 == o2 ? 0 : o1.getRegistryName().compareTo(o2.getRegistryName());
    };
    private List<Skill> l;

    public UpdateSkillSelectionPacket(List<Skill> list) {
        this.l = list;
    }

    public static class UpdateSkillHandler
    implements BiConsumer<UpdateSkillSelectionPacket, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(UpdateSkillSelectionPacket updateSkillPacket, Supplier<NetworkEvent.Context> contextSupplier) {
            contextSupplier.get().enqueueWork(() -> {
                ServerPlayerEntity sender = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                if (sender != null) {
                    ISkillCapability cap = CasterData.getCap((LivingEntity)sender);
                    List<Skill> prev = cap.getEquippedSkills();
                    ArrayList now = new ArrayList(updateSkillPacket.l);
                    prev.sort(comparator);
                    now.sort(comparator);
                    if (!prev.equals(now)) {
                        for (Skill s : cap.getEquippedSkills()) {
                            if (s == null) continue;
                            s.onUnequip((LivingEntity)sender, new SkillData(s, 0.0f).setCaster((LivingEntity)sender));
                        }
                        cap.getAllSkillData().clear();
                        cap.setEquippedSkills(updateSkillPacket.l);
                        for (Skill s : cap.getEquippedSkills()) {
                            if (s == null) continue;
                            s.onEquip((LivingEntity)sender);
                        }
                    } else {
                        cap.setEquippedSkills(updateSkillPacket.l);
                    }
                }
            });
            contextSupplier.get().setPacketHandled(true);
        }
    }

    public static class UpdateSkillDecoder
    implements Function<PacketBuffer, UpdateSkillSelectionPacket> {
        @Override
        public UpdateSkillSelectionPacket apply(PacketBuffer packetBuffer) {
            int size = packetBuffer.readInt();
            ArrayList<Skill> read = new ArrayList<Skill>(size);
            for (int a = 0; a < size; ++a) {
                read.add(a, Skill.getSkill(packetBuffer.func_192575_l()));
            }
            return new UpdateSkillSelectionPacket(read);
        }
    }

    public static class UpdateSkillEncoder
    implements BiConsumer<UpdateSkillSelectionPacket, PacketBuffer> {
        @Override
        public void accept(UpdateSkillSelectionPacket updateSkillPacket, PacketBuffer packetBuffer) {
            packetBuffer.writeInt(updateSkillPacket.l.size());
            for (Skill s : updateSkillPacket.l) {
                if (s != null) {
                    packetBuffer.func_192572_a(s.getRegistryName());
                    continue;
                }
                packetBuffer.func_192572_a(DUMMY);
            }
        }
    }
}

