/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.networking;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateTargetPacket {
    int m;
    int t;

    public UpdateTargetPacket(int mob, int target) {
        this.m = mob;
        this.t = target;
    }

    public static class UpdateTargetHandler
    implements BiConsumer<UpdateTargetPacket, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(UpdateTargetPacket updateClientPacket, Supplier<NetworkEvent.Context> contextSupplier) {
            contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                if (world != null) {
                    Entity mob = world.func_73045_a(updateClientPacket.m);
                    Entity target = world.func_73045_a(updateClientPacket.t);
                    if (mob instanceof MobEntity) {
                        if (target instanceof LivingEntity) {
                            ((MobEntity)mob).func_70624_b((LivingEntity)target);
                        } else if (updateClientPacket.t == -1) {
                            ((MobEntity)mob).func_70624_b(null);
                        }
                    }
                }
            }));
            contextSupplier.get().setPacketHandled(true);
        }
    }

    public static class UpdateTargetDecoder
    implements Function<PacketBuffer, UpdateTargetPacket> {
        @Override
        public UpdateTargetPacket apply(PacketBuffer packetBuffer) {
            return new UpdateTargetPacket(packetBuffer.readInt(), packetBuffer.readInt());
        }
    }

    public static class UpdateTargetEncoder
    implements BiConsumer<UpdateTargetPacket, PacketBuffer> {
        @Override
        public void accept(UpdateTargetPacket updateClientPacket, PacketBuffer packetBuffer) {
            packetBuffer.writeInt(updateClientPacket.m);
            packetBuffer.writeInt(updateClientPacket.t);
        }
    }
}

