/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.capability.skill.CasterData;
import jackiecrazy.wardance.capability.skill.ISkillCapability;
import jackiecrazy.wardance.capability.status.Marks;
import jackiecrazy.wardance.config.GeneralConfig;
import jackiecrazy.wardance.event.SkillCastEvent;
import jackiecrazy.wardance.event.SkillCooldownEvent;
import jackiecrazy.wardance.event.SkillResourceEvent;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Skill
extends ForgeRegistryEntry<Skill> {
    public static final HashMap<SkillCategory, List<Skill>> variationMap = new HashMap();
    protected static final Tag<String> none = Tag.func_241284_a_();
    protected static final Tag<String> offensivePhysical = Skill.makeTag("offensive", "physical");
    protected static final Tag<String> defensivePhysical = Skill.makeTag("defensive", "physical");
    protected static final Tag<String> offensive = Skill.makeTag("offensive");
    protected static final Tag<String> defensive = Skill.makeTag("defensive");
    protected static final Tag<String> passive = Skill.makeTag("passive");
    protected static final Tag<String> special = Skill.makeTag("special");
    protected static final Tag<String> state = Skill.makeTag("state");

    public Skill() {
        List<Skill> insert = variationMap.get(this.getParentCategory());
        if (insert == null) {
            insert = new ArrayList<Skill>();
        }
        insert.add(this);
        variationMap.put(this.getParentCategory(), insert);
    }

    protected static Tag<String> makeTag(String ... stuff) {
        return Tag.func_241286_a_(new HashSet<String>(Arrays.asList(stuff)));
    }

    @Nullable
    public static Skill getSkill(String name) {
        return Skill.getSkill(new ResourceLocation(name));
    }

    @Nullable
    public static Skill getSkill(ResourceLocation name) {
        return (Skill)GameRegistry.findRegistry(Skill.class).getValue(name);
    }

    public boolean isFamily(Skill s) {
        if (s == null) {
            return false;
        }
        return this.getParentCategory().equals(s.getParentCategory());
    }

    public boolean isPassive(LivingEntity caster) {
        return this.getTags(caster).func_230235_a_((Object)"passive");
    }

    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.none;
    }

    public boolean isSelectable(LivingEntity caster) {
        return true;
    }

    public CastStatus castingCheck(LivingEntity caster) {
        ISkillCapability cap = CasterData.getCap(caster);
        switch (cap.getSkillState(this)) {
            case ACTIVE: {
                return CastStatus.ACTIVE;
            }
            case COOLING: {
                return CastStatus.COOLDOWN;
            }
            case HOLSTERED: {
                return CastStatus.HOLSTERED;
            }
        }
        for (String s : this.getSoftIncompatibility(caster).func_230236_b_()) {
            if (!cap.isTagActive(s)) continue;
            return CastStatus.CONFLICT;
        }
        if (caster.func_174814_R() && this.getTags(caster).func_230235_a_((Object)"chant")) {
            return CastStatus.SILENCE;
        }
        if (CombatData.getCap((LivingEntity)caster).getSpirit() < this.spiritConsumption(caster)) {
            return CastStatus.SPIRIT;
        }
        if (CombatData.getCap((LivingEntity)caster).getMight() < this.mightConsumption(caster)) {
            return CastStatus.MIGHT;
        }
        return CastStatus.ALLOWED;
    }

    public float spiritConsumption(LivingEntity caster) {
        return 0.0f;
    }

    public float mightConsumption(LivingEntity caster) {
        return 0.0f;
    }

    public boolean isCompatibleWith(Skill s, LivingEntity caster) {
        if (s == null) {
            return true;
        }
        for (String tag : this.getTags(caster).func_230236_b_()) {
            if (!s.getSoftIncompatibility(caster).func_230235_a_((Object)tag)) continue;
            return false;
        }
        for (String tag : s.getTags(caster).func_230236_b_()) {
            if (!this.getSoftIncompatibility(caster).func_230235_a_((Object)tag)) continue;
            return false;
        }
        return true;
    }

    public void onCooledDown(LivingEntity caster, float overflow) {
        caster.field_70170_p.func_217384_a(null, (Entity)caster, SoundEvents.field_187604_bf, SoundCategory.AMBIENT, 0.3f + WarDance.rand.nextFloat(), 0.5f + WarDance.rand.nextFloat());
    }

    public ITextComponent description() {
        return new TranslationTextComponent(this.getRegistryName().toString() + ".desc");
    }

    public ITextComponent getDisplayName(LivingEntity caster) {
        return new TranslationTextComponent(this.getRegistryName().toString() + ".name");
    }

    public ResourceLocation icon() {
        return this.getParentCategory().icon();
    }

    public Color getColor() {
        return Color.WHITE;
    }

    public abstract Tag<String> getTags(LivingEntity var1);

    @Nonnull
    public abstract Tag<String> getSoftIncompatibility(LivingEntity var1);

    public Tag<String> getHardIncompatibility(LivingEntity caster) {
        return none;
    }

    public boolean equippedTick(LivingEntity caster, SkillData stats) {
        return false;
    }

    public boolean markTick(LivingEntity caster, LivingEntity target, SkillData sd) {
        if (sd.getDuration() <= 0.0f) {
            this.removeMark(target);
            return true;
        }
        return false;
    }

    public boolean showsMark(SkillData mark, LivingEntity target) {
        return true;
    }

    protected void removeMark(LivingEntity target) {
        Marks.getCap(target).removeMark(this);
    }

    public void onEquip(LivingEntity caster) {
        SkillData put = new SkillData(this, 0.0f).setState(STATE.INACTIVE).setCaster(caster);
        this.onStateChange(caster, put, STATE.INACTIVE, STATE.COOLING);
        put.markDirty();
        CasterData.getCap(caster).getAllSkillData().put(this, put);
    }

    public void onUnequip(LivingEntity caster, SkillData stats) {
    }

    public void onProc(LivingEntity caster, Event procPoint, STATE state, SkillData stats, @Nullable LivingEntity target) {
    }

    public abstract boolean onStateChange(LivingEntity var1, SkillData var2, STATE var3, STATE var4);

    @Nullable
    public SkillData onMarked(LivingEntity caster, LivingEntity target, SkillData sd, @Nullable SkillData existing) {
        if (existing != null) {
            sd.setDuration(sd.getDuration() + existing.getDuration());
            sd.setMaxDuration(sd.getDuration());
        }
        return sd;
    }

    public void onMarkEnd(LivingEntity caster, LivingEntity target, SkillData sd) {
    }

    protected boolean instantCast(SkillData mod, STATE from, STATE to) {
        if (from == to) {
            return true;
        }
        if (to == STATE.HOLSTERED) {
            mod.setState(STATE.ACTIVE);
            return true;
        }
        if (to == STATE.INACTIVE && from == STATE.COOLING && mod.getDuration() <= 0.0f) {
            mod.setState(STATE.INACTIVE);
            return true;
        }
        return false;
    }

    protected boolean passive(SkillData mod, STATE from, STATE to) {
        if (from == to) {
            return true;
        }
        if (to == STATE.INACTIVE && from == STATE.COOLING && mod.getDuration() <= 0.0f) {
            mod.setState(STATE.INACTIVE);
            return true;
        }
        return false;
    }

    protected boolean boundCast(SkillData mod, STATE from, STATE to) {
        if (from == to) {
            return true;
        }
        if (from == STATE.INACTIVE && to == STATE.HOLSTERED || from == STATE.HOLSTERED && to == STATE.INACTIVE) {
            mod.setState(to);
            return true;
        }
        if (to == STATE.INACTIVE && from == STATE.COOLING && mod.getDuration() <= 0.0f) {
            mod.setState(STATE.INACTIVE);
            return true;
        }
        return false;
    }

    protected void attackCooldown(Event e, LivingEntity caster, SkillData stats) {
        if (e instanceof LivingAttackEvent && ((LivingAttackEvent)e).getEntityLiving() != caster && stats.getState() == STATE.COOLING && e.getPhase() == EventPriority.HIGHEST) {
            stats.decrementDuration();
        }
    }

    protected boolean cooldownTick(SkillData stats) {
        if (stats.getState() == STATE.COOLING && stats.getDuration() > 0.0f) {
            stats.decrementDuration(0.05f);
            int round = (int)(stats.getDuration() * 20.0f);
            return stats.getDuration() < 3.0f || round % 20 == 0;
        }
        return false;
    }

    protected boolean activeTick(SkillData stats) {
        if (stats.getState() == STATE.ACTIVE) {
            stats.decrementDuration(0.05f);
            int round = (int)(stats.getDuration() * 20.0f);
            return stats.getDuration() < 3.0f || round % 20 == 0;
        }
        return false;
    }

    protected boolean cast(LivingEntity caster, float duration) {
        return this.cast(caster, null, duration);
    }

    protected boolean cast(LivingEntity caster, LivingEntity target, float duration) {
        return this.cast(caster, target, duration, false, 0.0f);
    }

    protected boolean cast(LivingEntity caster, @Nullable LivingEntity target, float duration, boolean flag, float arbitrary) {
        SkillResourceEvent sre = new SkillResourceEvent(caster, target, this);
        MinecraftForge.EVENT_BUS.post((Event)sre);
        if (!sre.isCanceled() && CombatData.getCap((LivingEntity)caster).getMight() >= sre.getMight() && CombatData.getCap((LivingEntity)caster).getSpirit() >= sre.getSpirit()) {
            SkillCastEvent sce = new SkillCastEvent(caster, target, this, sre.getMight(), sre.getSpirit(), duration, flag, arbitrary);
            MinecraftForge.EVENT_BUS.post((Event)sce);
            CombatData.getCap((LivingEntity)caster).consumeMight(sce.getMight());
            CombatData.getCap((LivingEntity)caster).consumeSpirit(sce.getSpirit());
            this.activate(caster, sce.getDuration(), sce.isFlag(), sce.getArbitrary());
            return true;
        }
        return false;
    }

    protected void setCooldown(LivingEntity caster, SkillData a, float duration) {
        SkillCooldownEvent sce = new SkillCooldownEvent(caster, this, duration);
        MinecraftForge.EVENT_BUS.post((Event)sce);
        a.flagCondition(false);
        a.setArbitraryFloat(0.0f);
        a.setState(STATE.COOLING);
        float dur = CasterData.getCap(caster).getSkillData(this).isPresent() ? sce.getCooldown() : duration;
        a.setMaxDuration(dur);
        a.setDuration(dur);
    }

    protected boolean activate(LivingEntity caster, float duration) {
        return this.activate(caster, duration, false, 0.0f);
    }

    protected boolean activate(LivingEntity caster, float duration, boolean flag) {
        return this.activate(caster, duration, flag, 0.0f);
    }

    protected boolean activate(LivingEntity caster, float duration, float something) {
        return this.activate(caster, duration, false, something);
    }

    protected boolean activate(LivingEntity caster, float duration, boolean flag, float something) {
        caster.field_70170_p.func_217384_a(null, (Entity)caster, SoundEvents.field_187616_bj, SoundCategory.AMBIENT, 0.3f + WarDance.rand.nextFloat(), 0.5f + WarDance.rand.nextFloat());
        CasterData.getCap(caster).getSkillData(this).ifPresent(a -> {
            a.setDuration(duration);
            a.setMaxDuration(duration);
            a.flagCondition(flag);
            a.setArbitraryFloat(something);
            a.setState(STATE.ACTIVE);
        });
        return true;
    }

    protected void markUsed(LivingEntity caster) {
        if (GeneralConfig.debug) {
            WarDance.LOGGER.debug(this.getRegistryName() + " has ended");
        }
        caster.field_70170_p.func_217384_a(null, (Entity)caster, SoundEvents.field_187646_bt, SoundCategory.AMBIENT, 0.3f + WarDance.rand.nextFloat() * 0.5f, 0.5f + WarDance.rand.nextFloat());
        CasterData.getCap(caster).getSkillData(this).ifPresent(a -> {
            a.setDuration(-1.7014117E38f);
            a.setState(STATE.ACTIVE);
        });
    }

    protected void mark(LivingEntity caster, LivingEntity target, float duration) {
        this.mark(caster, target, duration, 0.0f);
    }

    protected void mark(LivingEntity caster, LivingEntity target, float duration, float arbitrary) {
        Marks.getCap(target).mark(new SkillData(this, duration).setCaster(caster).setArbitraryFloat(arbitrary));
    }

    protected SkillData getExistingMark(LivingEntity target) {
        return Marks.getCap(target).getActiveMark(this).orElse(SkillData.DUMMY);
    }

    protected boolean hasMark(LivingEntity target) {
        return Marks.getCap(target).getActiveMark(this).isPresent();
    }

    public static enum STATE {
        INACTIVE,
        HOLSTERED,
        ACTIVE,
        COOLING;

    }

    public static enum CastStatus {
        ALLOWED,
        COOLDOWN,
        CONFLICT,
        HOLSTERED,
        SPIRIT,
        MIGHT,
        SILENCE,
        ACTIVE,
        OTHER;

    }
}

