/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill;

import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.WarSkills;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;

public class SkillData {
    public static final SkillData DUMMY = new SkillData((Skill)WarSkills.VITAL_STRIKE.get(), 0.0f);
    private final Skill s;
    private float duration;
    private float max;
    private float var;
    private boolean condition;
    private boolean dirty;
    private Skill.STATE state = Skill.STATE.INACTIVE;
    private LivingEntity caster;
    private UUID casterID;

    public SkillData(Skill skill, float arbitraryDuration, float max) {
        this.s = skill;
        this.duration = arbitraryDuration;
        this.max = max;
        this.var = 0.0f;
        this.condition = false;
    }

    public SkillData(Skill skill, float arbitraryDuration) {
        this(skill, arbitraryDuration, arbitraryDuration);
        this.state = Skill.STATE.ACTIVE;
    }

    @Nullable
    public static SkillData read(CompoundNBT from) {
        if (!from.func_74764_b("skill") || !from.func_74764_b("duration")) {
            return null;
        }
        if (Skill.getSkill(from.func_74779_i("skill")) == null) {
            return null;
        }
        SkillData ret = new SkillData(Skill.getSkill(from.func_74779_i("skill")), from.func_74760_g("duration")).flagCondition(from.func_74767_n("condition")).setArbitraryFloat(from.func_74760_g("something"));
        ret.max = from.func_74760_g("max");
        ret.state = Skill.STATE.values()[from.func_74762_e("state")];
        if (from.func_74764_b("caster")) {
            ret.casterID = from.func_186857_a("caster");
        }
        return ret;
    }

    @Nullable
    public LivingEntity getCaster(World world) {
        if (this.casterID == null) {
            return null;
        }
        if (this.caster != null) {
            return this.caster;
        }
        if (world.func_217371_b(this.casterID) != null) {
            this.caster = world.func_217371_b(this.casterID);
        }
        return this.caster;
    }

    public SkillData setCaster(LivingEntity caster) {
        this.casterID = caster.func_110124_au();
        this.caster = caster;
        return this;
    }

    public float getDuration() {
        return this.duration;
    }

    public SkillData setDuration(float duration) {
        this.duration = duration;
        if (duration > this.max) {
            this.max = duration;
        }
        return this;
    }

    public float getArbitraryFloat() {
        return this.var;
    }

    public SkillData setArbitraryFloat(float variable) {
        this.var = variable;
        return this;
    }

    public boolean isCondition() {
        return this.condition;
    }

    public SkillData flagCondition(boolean success) {
        this.condition = success;
        return this;
    }

    public boolean _isDirty() {
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public float getMaxDuration() {
        return this.max;
    }

    public SkillData setMaxDuration(float max) {
        this.max = max;
        return this;
    }

    public void decrementDuration() {
        this.duration -= 1.0f;
        this.markDirty();
    }

    public void decrementDuration(float amount) {
        this.duration -= amount;
    }

    public Skill getSkill() {
        return this.s;
    }

    public CompoundNBT write(CompoundNBT to) {
        if (this.s == null) {
            return to;
        }
        to.func_74778_a("skill", this.s.getRegistryName().toString());
        to.func_74768_a("state", this.state.ordinal());
        to.func_74776_a("duration", this.duration);
        to.func_74776_a("max", this.max);
        to.func_74776_a("something", this.var);
        to.func_74757_a("condition", this.condition);
        if (this.casterID != null) {
            to.func_186854_a("caster", this.casterID);
        }
        return to;
    }

    public Skill.STATE getState() {
        return this.state;
    }

    public SkillData setState(Skill.STATE state) {
        this.state = state;
        return this;
    }
}

