/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.coupdegrace;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.capability.resources.ICombatCapability;
import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.footwork.utils.TargetingUtils;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.api.CombatDamageSource;
import jackiecrazy.wardance.capability.skill.CasterData;
import jackiecrazy.wardance.capability.skill.ISkillCapability;
import jackiecrazy.wardance.entity.FakeExplosion;
import jackiecrazy.wardance.event.SkillCastEvent;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.WarSkills;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class CoupDeGrace
extends Skill {
    private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("physical", "melee", "normalAttack", "beforeArmor", "rechargeWithCast", "manipulateParry", "execution")));

    protected float getDamage(LivingEntity caster, LivingEntity target) {
        return (GeneralUtils.getMaxHealthBeforeWounding((LivingEntity)target) - target.func_110143_aJ()) * 0.2f;
    }

    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return special;
    }

    @Override
    @Nonnull
    public Tag<String> getSoftIncompatibility(LivingEntity caster) {
        return special;
    }

    @Override
    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.coup_de_grace;
    }

    @Override
    public Skill.CastStatus castingCheck(LivingEntity caster) {
        Skill.CastStatus supes = super.castingCheck(caster);
        return supes == Skill.CastStatus.ACTIVE | supes == Skill.CastStatus.HOLSTERED ? Skill.CastStatus.ALLOWED : supes;
    }

    @Override
    public float mightConsumption(LivingEntity caster) {
        return 3.0f;
    }

    protected void deathCheck(LivingEntity caster, LivingEntity target, float amount) {
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof LivingHurtEvent && procPoint.getPhase() == EventPriority.HIGHEST && state == Skill.STATE.ACTIVE) {
            LivingHurtEvent e = (LivingHurtEvent)procPoint;
            if (e.getEntityLiving() != caster) {
                if (CombatData.getCap((LivingEntity)e.getEntityLiving()).getStaggerTime() > 0 && !CombatData.getCap((LivingEntity)e.getEntityLiving()).isFirstStaggerStrike()) {
                    if (this.willKillOnCast(caster, target)) {
                        target.func_70606_j(1.0f);
                    }
                    e.setAmount(e.getAmount() + this.getDamage(caster, target));
                    e.getSource().func_76348_h().func_151518_m();
                    CombatData.getCap((LivingEntity)target).decrementStaggerTime(CombatData.getCap((LivingEntity)target).getStaggerTime());
                    this.deathCheck(caster, target, e.getAmount());
                    this.markUsed(caster);
                } else if (target.func_110143_aJ() < this.getDamage(caster, target)) {
                    e.setCanceled(true);
                    CombatData.getCap((LivingEntity)target).consumePosture(caster, e.getAmount());
                }
            }
        } else if (procPoint instanceof SkillCastEvent && procPoint.getPhase() == EventPriority.HIGHEST && state == Skill.STATE.COOLING) {
            stats.decrementDuration();
        }
        if (state == Skill.STATE.ACTIVE && stats.getDuration() < 0.0f && this == WarSkills.DECAPITATE.get() && procPoint.getPhase() == EventPriority.LOWEST) {
            if (procPoint instanceof LivingDropsEvent && ((LivingDropsEvent)procPoint).getEntityLiving() == target) {
                ItemStack drop = GeneralUtils.dropSkull((LivingEntity)target);
                if (drop == null) {
                    return;
                }
                for (ItemEntity i : ((LivingDropsEvent)procPoint).getDrops()) {
                    if (i.func_92059_d().func_77973_b() != drop.func_77973_b() || target instanceof PlayerEntity && !i.func_92059_d().func_196082_o().func_74779_i("SkullOwner").equalsIgnoreCase(drop.func_77978_p().func_74779_i("SkullOwner"))) continue;
                    return;
                }
                ItemEntity forceSkull = new ItemEntity(target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), drop);
                forceSkull.func_174869_p();
                ((LivingDropsEvent)procPoint).getDrops().add(forceSkull);
            }
            if (procPoint instanceof LootingLevelEvent && ((LootingLevelEvent)procPoint).getEntityLiving() == target && GeneralUtils.dropSkull((LivingEntity)target) == null) {
                ((LootingLevelEvent)procPoint).setLootingLevel(((LootingLevelEvent)procPoint).getLootingLevel() + 3);
            }
        }
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        if (from == Skill.STATE.ACTIVE && to == Skill.STATE.HOLSTERED) {
            CasterData.getCap(caster).removeActiveTag("special");
        }
        if (from == Skill.STATE.INACTIVE && to == Skill.STATE.HOLSTERED && this.cast(caster, 1.0f)) {
            CasterData.getCap(caster).removeActiveTag("special");
            prev.setMaxDuration(0.0f);
        }
        if (to == Skill.STATE.COOLING) {
            this.setCooldown(caster, prev, 2.0f);
        }
        return this.instantCast(prev, from, to);
    }

    public boolean willKillOnCast(LivingEntity caster, LivingEntity target) {
        return target.func_110143_aJ() < this.getDamage(caster, target);
    }

    public static class Frenzy
    extends CoupDeGrace {
        @Override
        public Color getColor() {
            return Color.ORANGE;
        }

        @Override
        protected void deathCheck(LivingEntity caster, LivingEntity target, float amount) {
            ISkillCapability isc = CasterData.getCap(caster);
            for (SkillData d : isc.getAllSkillData().values()) {
                if (d.getState() != Skill.STATE.COOLING || !d.getSkill().getTags(caster).func_230235_a_((Object)"physical")) continue;
                isc.changeSkillState(d.getSkill(), Skill.STATE.INACTIVE);
            }
        }
    }

    public static class Reinvigorate
    extends CoupDeGrace {
        @Override
        public Color getColor() {
            return Color.GREEN;
        }

        @Override
        protected void deathCheck(LivingEntity caster, LivingEntity target, float amount) {
            ICombatCapability cap = CombatData.getCap((LivingEntity)caster);
            cap.addFatigue(-1.0f);
            cap.addWounding(-1.0f);
            cap.addBurnout(-1.0f);
        }
    }

    public static class ReapersLaugh
    extends CoupDeGrace {
        private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("physical", "melee", "manipulateAwareness", "beforeArmor", "rechargeWithCast", "manipulateParry", "execution")));
        private final Tag<String> tague = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("special", "offensive")));

        @Override
        public Tag<String> getTags(LivingEntity caster) {
            return special;
        }

        @Override
        public Color getColor() {
            return Color.RED;
        }

        @Override
        public float mightConsumption(LivingEntity caster) {
            return 0.0f;
        }

        @Override
        public boolean willKillOnCast(LivingEntity caster, LivingEntity target) {
            return (double)target.func_110143_aJ() < (double)(GeneralUtils.getMaxHealthBeforeWounding((LivingEntity)target) * 0.1f) + caster.func_233637_b_(Attributes.field_233823_f_);
        }

        @Override
        public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
            if (from == Skill.STATE.INACTIVE && to == Skill.STATE.HOLSTERED) {
                caster.field_70170_p.func_184148_a(null, caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_(), SoundEvents.field_219645_fe, SoundCategory.PLAYERS, 0.8f + WarDance.rand.nextFloat() * 0.5f, 0.75f + WarDance.rand.nextFloat() * 0.5f);
                prev.setState(Skill.STATE.HOLSTERED);
            }
            if (to == Skill.STATE.ACTIVE && this.cast(caster, -999.0f)) {
                for (Entity e : caster.field_70170_p.func_175674_a((Entity)caster, caster.func_174813_aQ().func_186662_g(caster.func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get())), a -> !TargetingUtils.isAlly((Entity)a, (Entity)caster))) {
                    if (!(e instanceof LivingEntity) || !caster.func_70685_l(e)) continue;
                    CombatDamageSource die = new CombatDamageSource("player", (Entity)caster).setDamageTyping(CombatDamageSource.TYPE.PHYSICAL).setProcSkillEffects(true).setSkillUsed(this).setKnockbackPercentage(0.0f);
                    if (this.willKillOnCast(caster, (LivingEntity)e)) {
                        prev.flagCondition(true);
                        die.setCrit(true).setDamageTyping(CombatDamageSource.TYPE.TRUE).func_76348_h().func_151518_m();
                    }
                    e.func_70097_a((DamageSource)die, GeneralUtils.getMaxHealthBeforeWounding((LivingEntity)((LivingEntity)e)) * 0.1f + (float)caster.func_233637_b_(Attributes.field_233823_f_));
                }
            }
            if (to == Skill.STATE.COOLING) {
                if (prev.isCondition()) {
                    prev.setState(Skill.STATE.INACTIVE);
                } else {
                    this.setCooldown(caster, prev, 5.0f);
                }
            }
            this.boundCast(prev, from, to);
            return from != prev.getState();
        }

        @Override
        public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
            if (procPoint instanceof SkillCastEvent && procPoint.getPhase() == EventPriority.HIGHEST && state == Skill.STATE.COOLING) {
                stats.decrementDuration();
            }
        }
    }

    public static class DanseMacabre
    extends CoupDeGrace {
        @Override
        public Color getColor() {
            return Color.LIGHT_GRAY;
        }

        @Override
        protected float getDamage(LivingEntity caster, LivingEntity target) {
            return GeneralUtils.getMaxHealthBeforeWounding((LivingEntity)target) * (1.0f - target.func_110143_aJ() / GeneralUtils.getMaxHealthBeforeWounding((LivingEntity)target)) * (0.2f + 0.2f * (CombatData.getCap((LivingEntity)caster).getRank() / 10.0f));
        }
    }

    public static class Rupture
    extends CoupDeGrace {
        @Override
        public Color getColor() {
            return Color.CYAN;
        }

        @Override
        protected void deathCheck(LivingEntity caster, LivingEntity target, float amount) {
            CombatData.getCap((LivingEntity)target).consumeSpirit(CombatData.getCap((LivingEntity)target).getSpirit() / 2.0f);
            FakeExplosion.explode(caster.field_70170_p, (Entity)caster, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), (float)Math.sqrt(CombatData.getCap((LivingEntity)target).getTrueMaxPosture()), new CombatDamageSource("explosion.player", (Entity)caster).setProxy((Entity)target).setDamageTyping(CombatDamageSource.TYPE.PHYSICAL).setProcSkillEffects(true).func_94540_d().func_82726_p(), 4.0f * CombatData.getCap((LivingEntity)target).getSpirit());
        }
    }
}

