/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.crownchampion;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.event.AttackMightEvent;
import jackiecrazy.footwork.event.GainMightEvent;
import jackiecrazy.footwork.potion.FootworkEffects;
import jackiecrazy.footwork.utils.StealthUtils;
import jackiecrazy.footwork.utils.TargetingUtils;
import jackiecrazy.wardance.capability.skill.CasterData;
import jackiecrazy.wardance.capability.status.Marks;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.WarSkills;
import jackiecrazy.wardance.utils.CombatUtils;
import jackiecrazy.wardance.utils.SkillUtils;
import jackiecrazy.wardance.utils.WarColors;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.Tag;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wardance")
public class CrownChampion
extends Skill {
    private static final UUID MULT = UUID.fromString("abb2e130-36af-4fbb-bf66-0f4be905dc24");
    private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("passive", "manipulateMightGain")));

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void hurt(LivingDamageEvent e) {
        Entity seme = e.getSource().func_76346_g();
        LivingEntity uke = e.getEntityLiving();
        if (seme instanceof LivingEntity) {
            Skill venge = (Skill)WarSkills.VENGEFUL_MIGHT.get();
            for (PlayerEntity p : uke.field_70170_p.func_217369_A()) {
                if (!TargetingUtils.isAlly((Entity)p, (Entity)uke) || TargetingUtils.isAlly((Entity)p, (Entity)seme) || !(p.func_70068_e((Entity)uke) < 100.0) || !CasterData.getCap((LivingEntity)p).getEquippedSkills().contains((Object)venge)) continue;
                ((LivingEntity)seme).func_195064_c(new EffectInstance(Effects.field_188423_x, 100));
                SkillData apply = Marks.getCap((LivingEntity)seme).getActiveMark(venge).orElse(new SkillData(venge, 0.0f));
                apply.setArbitraryFloat(apply.getArbitraryFloat() + e.getAmount());
                Marks.getCap((LivingEntity)seme).mark(apply);
            }
            if (Marks.getCap(uke).isMarked(venge) && CasterData.getCap((LivingEntity)seme).getEquippedSkills().contains((Object)venge)) {
                Marks.getCap(uke).getActiveMark(venge).ifPresent(a -> {
                    float amnt = Math.min(e.getAmount(), a.getArbitraryFloat());
                    CombatData.getCap((LivingEntity)((LivingEntity)seme)).addMight(amnt);
                    e.setAmount(e.getAmount() + amnt);
                    a.setArbitraryFloat(a.getArbitraryFloat() - e.getAmount());
                    if (a.getArbitraryFloat() < 0.0f) {
                        a.setDuration(-10.0f);
                    }
                });
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void oops(LivingDamageEvent e) {
        LivingEntity uke = e.getEntityLiving();
        if (CasterData.getCap(uke).getEquippedSkills().contains(WarSkills.PRIDEFUL_MIGHT.get())) {
            CombatData.getCap((LivingEntity)uke).setMight(0.0f);
        }
    }

    @SubscribeEvent
    public static void sneaky(LivingEvent.LivingVisibilityEvent e) {
        if (CasterData.getCap(e.getEntityLiving()).getEquippedSkills().contains(WarSkills.HIDDEN_MIGHT.get())) {
            e.modifyVisibility(0.7 + (double)CombatData.getCap((LivingEntity)e.getEntityLiving()).getMight() * 0.03);
        }
    }

    @SubscribeEvent
    public static void deady(LivingDeathEvent e) {
        if (!CombatUtils.isPhysicalAttack(e.getSource())) {
            for (PlayerEntity pe : e.getEntityLiving().field_70170_p.func_225317_b(PlayerEntity.class, e.getEntity().func_174813_aQ().func_186662_g(5.0))) {
                if (!CasterData.getCap((LivingEntity)pe).getEquippedSkills().contains(WarSkills.ELEMENTAL_MIGHT.get())) continue;
                CombatData.getCap((LivingEntity)pe).addMight(1.0f);
            }
        }
    }

    @Override
    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.prowess;
    }

    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return passive;
    }

    @Override
    @Nonnull
    public Tag<String> getSoftIncompatibility(LivingEntity caster) {
        return none;
    }

    @Override
    public void onEquip(LivingEntity caster) {
        super.onEquip(caster);
    }

    @Override
    public void onUnequip(LivingEntity caster, SkillData stats) {
        caster.func_110148_a(Attributes.field_233823_f_).func_188479_b(MULT);
        caster.func_110148_a(Attributes.field_233821_d_).func_188479_b(MULT);
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        int might = (int)CombatData.getCap((LivingEntity)caster).getMight() - 1;
        if (procPoint instanceof LivingAttackEvent && procPoint.getPhase() == EventPriority.LOWEST) {
            SkillUtils.modifyAttribute(caster, Attributes.field_233823_f_, MULT, 0.05f * (float)might, AttributeModifier.Operation.MULTIPLY_BASE);
        }
        if (procPoint instanceof GainMightEvent && procPoint.getPhase() == EventPriority.HIGHEST) {
            ((GainMightEvent)procPoint).setQuantity(((GainMightEvent)procPoint).getQuantity() * (15.0f - (float)might / 2.0f) / 10.0f);
        }
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        prev.setState(Skill.STATE.INACTIVE);
        return false;
    }

    public static class ElementalMight
    extends CrownChampion {
        @Override
        public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
            if (procPoint instanceof LivingAttackEvent) {
                ((LivingAttackEvent)procPoint).getEntityLiving().func_195064_c(new EffectInstance((Effect)FootworkEffects.VULNERABLE.get(), 100, (int)(CombatData.getCap((LivingEntity)caster).getMight() / 3.0f)));
            }
        }

        @Override
        public Color getColor() {
            return WarColors.VIOLET;
        }
    }

    public static class PridefulMight
    extends CrownChampion {
        @Override
        public Color getColor() {
            return Color.ORANGE;
        }

        @Override
        public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData pd, LivingEntity target) {
            if (procPoint instanceof GainMightEvent && procPoint.getPhase() == EventPriority.HIGHEST) {
                ((GainMightEvent)procPoint).setQuantity(((GainMightEvent)procPoint).getQuantity() * 3.0f);
                pd.setArbitraryFloat(pd.getArbitraryFloat() + ((GainMightEvent)procPoint).getQuantity());
                if (pd.getArbitraryFloat() > 3.0f) {
                    pd.setArbitraryFloat(pd.getArbitraryFloat() % 3.0f);
                    CombatData.getCap((LivingEntity)caster).setShatterCooldown(0);
                }
            }
        }
    }

    public static class VengefulMight
    extends CrownChampion {
        @Override
        public Color getColor() {
            return Color.RED;
        }

        @Override
        public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        }

        @Override
        public boolean markTick(LivingEntity caster, LivingEntity target, SkillData sd) {
            target.func_195064_c(new EffectInstance(Effects.field_188423_x, 10));
            if (sd.getDuration() < 0.0f) {
                this.removeMark(target);
                return true;
            }
            return false;
        }
    }

    public static class HiddenMight
    extends CrownChampion {
        private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("passive", "manipulateMight")));

        @Override
        public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
            if (procPoint instanceof AttackMightEvent && procPoint.getPhase() == EventPriority.HIGHEST && StealthUtils.INSTANCE.getAwareness(caster, target).equals((Object)StealthUtils.Awareness.UNAWARE)) {
                ((AttackMightEvent)procPoint).setQuantity(((AttackMightEvent)procPoint).getQuantity() + 0.5f);
            }
        }

        @Override
        public boolean equippedTick(LivingEntity caster, SkillData stats) {
            int might = (int)CombatData.getCap((LivingEntity)caster).getMight() - 1;
            SkillUtils.modifyAttribute(caster, Attributes.field_233821_d_, MULT, 0.03f * (float)might, AttributeModifier.Operation.MULTIPLY_BASE);
            return super.equippedTick(caster, stats);
        }

        @Override
        public Color getColor() {
            return Color.LIGHT_GRAY;
        }
    }
}

