/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.feint;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.event.EntityAwarenessEvent;
import jackiecrazy.footwork.potion.FootworkEffects;
import jackiecrazy.footwork.utils.EffectUtils;
import jackiecrazy.footwork.utils.StealthUtils;
import jackiecrazy.wardance.api.CombatDamageSource;
import jackiecrazy.wardance.capability.skill.CasterData;
import jackiecrazy.wardance.capability.skill.ISkillCapability;
import jackiecrazy.wardance.capability.status.Marks;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.WarSkills;
import jackiecrazy.wardance.utils.CombatUtils;
import jackiecrazy.wardance.utils.SkillUtils;
import jackiecrazy.wardance.utils.WarColors;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.Tag;
import net.minecraft.util.Hand;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wardance")
public class Feint
extends Skill {
    private final Tag<String> proc = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("physical", "disableShield", "noDamage", "melee", "afflictionTick", "boundCast", "countdown", "rechargeWithAttack", "manipulateParry")));
    private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("physical", "offensive", "noDamage")));

    @SubscribeEvent
    public static void hurt(LivingAttackEvent e) {
        LivingEntity caster;
        ISkillCapability cap;
        Skill feint;
        Entity seme = e.getSource().func_76346_g();
        LivingEntity uke = e.getEntityLiving();
        if (seme instanceof LivingEntity && (feint = (cap = CasterData.getCap(caster = (LivingEntity)seme)).getEquippedVariation(SkillCategories.feint)) != null && Marks.getCap(uke).isMarked(SkillCategories.feint)) {
            Marks.getCap(uke).getActiveMark(feint).ifPresent(a -> a.setArbitraryFloat(a.getArbitraryFloat() - 1.0f));
            if (cap.getEquippedSkills().contains(WarSkills.CAPRICIOUS_STRIKE.get())) {
                for (Skill s : cap.getEquippedSkills()) {
                    if (s == null || !s.getTags(caster).func_230235_a_((Object)"physical") || cap.getSkillState(s) != Skill.STATE.COOLING) continue;
                    cap.getSkillData(s).ifPresent(SkillData::decrementDuration);
                }
            }
        }
        Marks.getCap(uke).getActiveMark((Skill)WarSkills.SPIRIT_RESONANCE.get()).ifPresent(a -> {
            if ((double)a.getDuration() <= 0.1 && e.getSource() instanceof CombatDamageSource && ((CombatDamageSource)e.getSource()).canProcSkillEffects()) {
                a.flagCondition(true);
                a.setArbitraryFloat(a.getArbitraryFloat() - 1.0f);
                a.setDuration(1.1f);
                CombatData.getCap((LivingEntity)uke).consumePosture(2.0f);
            }
        });
    }

    @SubscribeEvent
    public static void spiritBomb(LivingHurtEvent e) {
        LivingEntity uke = e.getEntityLiving();
        Marks.getCap(uke).getActiveMark((Skill)WarSkills.SPIRIT_RESONANCE.get()).ifPresent(a -> {
            if (a.isCondition() && e.getSource() instanceof CombatDamageSource && ((CombatDamageSource)e.getSource()).canProcSkillEffects()) {
                e.setAmount(e.getAmount() + 2.0f);
            }
            a.flagCondition(false);
        });
    }

    @SubscribeEvent
    public static void aware(EntityAwarenessEvent e) {
        LivingEntity seme = e.getAttacker();
        LivingEntity uke = e.getEntityLiving();
        if (seme != null && Marks.getCap(uke).isMarked((Skill)WarSkills.SMIRKING_SHADOW.get()) && (double)Marks.getCap(uke).getActiveMark((Skill)WarSkills.SMIRKING_SHADOW.get()).get().getDuration() > 0.1 && CasterData.getCap(seme).getEquippedSkills().contains(WarSkills.SMIRKING_SHADOW.get())) {
            e.setAwareness(StealthUtils.Awareness.UNAWARE);
        }
    }

    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return this.tag;
    }

    @Override
    @Nonnull
    public Tag<String> getSoftIncompatibility(LivingEntity caster) {
        return offensive;
    }

    @Override
    public float spiritConsumption(LivingEntity caster) {
        return 3.0f;
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof LivingAttackEvent && procPoint.getPhase() == EventPriority.HIGHEST && state == Skill.STATE.HOLSTERED && ((LivingAttackEvent)procPoint).getEntityLiving() == target && this.cast(caster, target, -999.0f)) {
            int dur = 20;
            if (Marks.getCap(target).isMarked(this)) {
                SkillData a = Marks.getCap(target).getActiveMark(this).get();
                dur = (int)((float)dur - a.getArbitraryFloat());
            }
            CombatData.getCap((LivingEntity)target).setHandBind(Hand.MAIN_HAND, dur);
            CombatData.getCap((LivingEntity)target).setHandBind(Hand.OFF_HAND, dur);
            CombatUtils.setHandCooldown(caster, Hand.MAIN_HAND, this == WarSkills.FOLLOWUP.get() ? 1.0f : 0.5f, true);
            this.mark(caster, target, (float)dur / 20.0f + 0.1f, 6.0f);
            procPoint.setCanceled(true);
            this.markUsed(caster);
        }
        if (procPoint instanceof LivingAttackEvent && this == WarSkills.FOLLOWUP.get() && procPoint.getPhase() == EventPriority.LOWEST && ((LivingAttackEvent)procPoint).getEntityLiving() == target && CombatData.getCap((LivingEntity)target).getHandBind(Hand.MAIN_HAND) > 0 && CombatData.getCap((LivingEntity)target).getHandBind(Hand.OFF_HAND) > 0) {
            CombatUtils.setHandCooldown(caster, Hand.MAIN_HAND, 0.5f, true);
        }
    }

    @Override
    public SkillData onMarked(LivingEntity caster, LivingEntity target, SkillData sd, @Nullable SkillData existing) {
        if (existing != null) {
            sd.setArbitraryFloat(sd.getArbitraryFloat() + existing.getArbitraryFloat());
        }
        return sd;
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        if (to == Skill.STATE.COOLING) {
            prev.setState(Skill.STATE.INACTIVE);
        }
        return this.boundCast(prev, from, to);
    }

    @Override
    public boolean markTick(LivingEntity caster, LivingEntity target, SkillData sd) {
        if ((double)sd.getDuration() > 0.1 || sd.getArbitraryFloat() <= 0.0f) {
            sd.decrementDuration(0.05f);
        }
        return super.markTick(caster, target, sd);
    }

    @Override
    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.feint;
    }

    public static class UpperHand
    extends Feint {
        static final UUID UPPER = UUID.fromString("67fe7ef6-a398-4c62-9fb1-42edaa80e7c1");

        @Override
        public Color getColor() {
            return Color.GREEN;
        }

        @Override
        public boolean markTick(LivingEntity caster, LivingEntity target, SkillData sd) {
            if (caster == target) {
                sd.decrementDuration();
                return true;
            }
            return super.markTick(caster, target, sd);
        }

        @Override
        public SkillData onMarked(LivingEntity caster, LivingEntity target, SkillData sd, @Nullable SkillData existing) {
            if (existing != null) {
                sd.setDuration(200.0f);
                sd.setArbitraryFloat(sd.getArbitraryFloat() + existing.getArbitraryFloat());
                if (caster == target) {
                    SkillUtils.modifyAttribute(caster, Attributes.field_233826_i_, UPPER, sd.getArbitraryFloat() * 2.0f, AttributeModifier.Operation.ADDITION);
                } else {
                    target.func_195064_c(new EffectInstance((Effect)FootworkEffects.CORROSION.get(), 200));
                }
            }
            return super.onMarked(caster, target, sd, existing);
        }

        @Override
        public void onMarkEnd(LivingEntity caster, LivingEntity target, SkillData sd) {
            caster.func_110148_a(Attributes.field_233826_i_).func_188479_b(UPPER);
            super.onMarkEnd(caster, target, sd);
        }
    }

    public static class ScorpionSting
    extends Feint {
        private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("physical", "disableShield", "noDamage", "melee", "boundCast", "beforeArmor", "countdown", "rechargeWithAttack", "manipulateParry")));
        private final Tag<String> no = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("normalAttack")));

        @Override
        public Color getColor() {
            return WarColors.VIOLET;
        }

        @Override
        public SkillData onMarked(LivingEntity caster, LivingEntity target, SkillData sd, @Nullable SkillData existing) {
            target.func_195064_c(new EffectInstance(Effects.field_76436_u, 200));
            for (EffectInstance ei : new ArrayList(target.func_70651_bq())) {
                EffectInstance override = new EffectInstance(ei.func_188419_a(), ei.func_76459_b(), ei.func_76458_c() + 1, ei.func_82720_e(), ei.func_188418_e(), ei.func_205348_f());
                EffectUtils.stackPot((LivingEntity)target, (EffectInstance)override, (EffectUtils.StackingMethod)EffectUtils.StackingMethod.NONE);
            }
            return super.onMarked(caster, target, sd, existing);
        }
    }

    public static class CapriciousStrike
    extends Feint {
        @Override
        public Color getColor() {
            return Color.orange;
        }
    }

    public static class SmirkingShadow
    extends Feint {
        @Override
        public Color getColor() {
            return Color.LIGHT_GRAY;
        }
    }

    public static class SpiritBomb
    extends Feint {
        @Override
        public Color getColor() {
            return Color.CYAN;
        }
    }
}

