/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.grapple;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.capability.resources.ICombatCapability;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.WarSkills;
import jackiecrazy.wardance.utils.CombatUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tags.Tag;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class Grapple
extends Skill {
    private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("physical", "boundCast", "melee", "normalAttack", "countdown", "unarmed", "rechargeWithAttack")));
    private final Tag<String> unarm = Grapple.makeTag("offensive", "physical", "unarmed");

    @Override
    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.grapple;
    }

    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return this.unarm;
    }

    @Override
    @Nonnull
    public Tag<String> getSoftIncompatibility(LivingEntity caster) {
        return offensive;
    }

    @Override
    public float spiritConsumption(LivingEntity caster) {
        return 2.0f;
    }

    protected void performEffect(LivingEntity caster, LivingEntity target) {
        caster.field_70170_p.func_184148_a(null, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), SoundEvents.field_219602_O, SoundCategory.PLAYERS, 0.3f + WarDance.rand.nextFloat() * 0.5f, 0.75f + WarDance.rand.nextFloat() * 0.5f);
        if (this == WarSkills.THROW.get()) {
            CombatData.getCap((LivingEntity)target).consumePosture(caster, 11.0f, 0.0f, true);
        } else {
            CombatData.getCap((LivingEntity)target).consumePosture(caster, 7.0f, 0.0f, true);
        }
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof LivingAttackEvent && ((LivingAttackEvent)procPoint).getEntityLiving() == target && procPoint.getPhase() == EventPriority.HIGHEST && state == Skill.STATE.HOLSTERED && this.isUnarmed(caster)) {
            if (stats.isCondition() && caster.func_110144_aD() == target && caster.field_70173_aa - caster.func_142013_aG() < 40 && this.cast(caster, target, -999.0f)) {
                this.performEffect(caster, target);
            } else {
                stats.flagCondition(true);
                caster.func_130011_c((Entity)target);
            }
        }
        this.attackCooldown(procPoint, caster, stats);
    }

    protected boolean isUnarmed(LivingEntity caster) {
        return CombatUtils.isUnarmed(caster.func_184614_ca(), caster);
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        if (to == Skill.STATE.COOLING) {
            this.setCooldown(caster, prev, 7.0f);
        }
        prev.flagCondition(false);
        return this.boundCast(prev, from, to);
    }

    public static class Suplex
    extends Grapple {
        @Override
        public Color getColor() {
            return Color.RED;
        }

        @Override
        protected void performEffect(LivingEntity caster, LivingEntity target) {
            caster.field_70170_p.func_184148_a(null, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), SoundEvents.field_187928_hb, SoundCategory.PLAYERS, 0.3f + WarDance.rand.nextFloat() * 0.5f, 0.75f + WarDance.rand.nextFloat() * 0.5f);
            ICombatCapability casterCap = CombatData.getCap((LivingEntity)caster);
            float posture = casterCap.getPosture();
            target.func_213317_d(caster.func_213322_ci().func_178787_e(caster.func_213303_ch().func_72444_a(target.func_213303_ch()).func_186678_a(-0.3)));
            target.field_70133_I = true;
            CombatData.getCap((LivingEntity)target).consumePosture(caster, posture * 2.0f, 0.0f, true);
            casterCap.setPosture(0.1f);
        }
    }

    public static class ReverseGrip
    extends Grapple {
        @Override
        public Color getColor() {
            return Color.LIGHT_GRAY;
        }

        @Override
        protected boolean isUnarmed(LivingEntity caster) {
            return true;
        }

        @Override
        public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
            if (to == Skill.STATE.COOLING) {
                this.setCooldown(caster, prev, 9.0f);
            }
            prev.flagCondition(false);
            return this.boundCast(prev, from, to);
        }
    }
}

