/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.heavyblow;

import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tags.Tag;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class HeavyBlow
extends Skill {
    private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("physical", "disableShield", "melee", "beforeArmor", "boundCast", "normalAttack", "modifyCrit", "rechargeWithAttack", "onBeingParried")));
    private final Tag<String> tags = HeavyBlow.makeTag("physical", "forcedCrit", "passive", "offensive", "disableShield");

    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return passive;
    }

    @Override
    @Nonnull
    public Tag<String> getSoftIncompatibility(LivingEntity caster) {
        return Tag.func_241284_a_();
    }

    @Override
    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.heavy_blow;
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof CriticalHitEvent && procPoint.getPhase() == EventPriority.HIGHEST) {
            if (this.isCrit((CriticalHitEvent)procPoint) && state == Skill.STATE.INACTIVE && this.cast(caster, target, -999.0f)) {
                this.onCrit((CriticalHitEvent)procPoint, stats, caster, target);
            } else if (state == Skill.STATE.COOLING) {
                stats.decrementDuration();
            }
        }
    }

    protected boolean isCrit(CriticalHitEvent c) {
        return c.getResult() == Event.Result.DEFAULT && c.isVanillaCritical() || c.getResult() == Event.Result.ALLOW;
    }

    protected void onCrit(CriticalHitEvent proc, SkillData stats, LivingEntity caster, LivingEntity target) {
        proc.setDamageModifier(proc.getDamageModifier() * 1.3f);
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        if (to == Skill.STATE.COOLING) {
            this.setCooldown(caster, prev, 3.0f);
        }
        return this.passive(prev, from, to);
    }

    public static class Leverage
    extends HeavyBlow {
        @Override
        public Color getColor() {
            return Color.CYAN;
        }

        @Override
        protected void onCrit(CriticalHitEvent proc, SkillData stats, LivingEntity caster, LivingEntity target) {
            proc.setDamageModifier(1.0f + (float)Math.max(2.0, Math.sqrt(GeneralUtils.getDistSqCompensated((Entity)caster, (Entity)target)) / 4.0));
        }
    }
}

