/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.heavyblow;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.wardance.capability.skill.CasterData;
import jackiecrazy.wardance.event.ParryEvent;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.heavyblow.HeavyBlow;
import java.awt.Color;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wardance")
public class Momentum
extends HeavyBlow {
    @Override
    public Color getColor() {
        return Color.ORANGE;
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof ParryEvent && ((ParryEvent)procPoint).getDefendingHand() != null && procPoint.getPhase() == EventPriority.HIGHEST && ((ParryEvent)procPoint).getAttacker() == caster) {
            if (CasterData.getCap(target).getCategoryState(SkillCategories.iron_guard) == Skill.STATE.ACTIVE) {
                return;
            }
            ((ParryEvent)procPoint).setPostureConsumption(((ParryEvent)procPoint).getPostureConsumption() + 0.01f * this.power(2.0f, CombatData.getCap((LivingEntity)caster).getComboRank()));
        } else if (procPoint instanceof CriticalHitEvent && procPoint.getPhase() == EventPriority.HIGHEST) {
            float combo = stats.getArbitraryFloat() + 1.0f;
            if ((combo %= (float)(8 - CombatData.getCap((LivingEntity)caster).getComboRank())) == 0.0f) {
                procPoint.setResult(Event.Result.ALLOW);
            } else {
                procPoint.setResult(Event.Result.DENY);
            }
            stats.setArbitraryFloat(combo);
            ((CriticalHitEvent)procPoint).setDamageModifier(((CriticalHitEvent)procPoint).getDamageModifier() + 0.005f * this.power(2.0f, CombatData.getCap((LivingEntity)caster).getComboRank()));
        }
    }

    private float power(float base, int to) {
        float fin = 1.0f;
        while (to != 0) {
            fin *= base;
            --to;
        }
        return fin;
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        prev.setState(Skill.STATE.INACTIVE);
        return false;
    }
}

