/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.heavyblow;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.utils.StealthUtils;
import jackiecrazy.wardance.capability.skill.CasterData;
import jackiecrazy.wardance.capability.status.Marks;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.WarSkills;
import jackiecrazy.wardance.skill.heavyblow.HeavyBlow;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tags.Tag;
import net.minecraft.util.Hand;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wardance")
public class Silencer
extends HeavyBlow {
    private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("physical", "disableShield", "melee", "normalAttack", "modifyCrit", "rechargeWithAttack", "afflictionTick")));

    @SubscribeEvent
    public static void silenced(LivingDeathEvent e) {
        if (e.getSource().func_76346_g() instanceof LivingEntity && Marks.getCap(e.getEntityLiving()).isMarked((Skill)WarSkills.SILENCER.get())) {
            LivingEntity elb = (LivingEntity)e.getSource().func_76346_g();
            CasterData.getCap(elb).changeSkillState((Skill)WarSkills.SILENCER.get(), Skill.STATE.INACTIVE);
        }
    }

    @Override
    public Color getColor() {
        return Color.LIGHT_GRAY;
    }

    @Override
    public boolean isPassive(LivingEntity caster) {
        return true;
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof CriticalHitEvent && ((CriticalHitEvent)procPoint).getTarget() == target && state == Skill.STATE.INACTIVE) {
            if (caster.field_70170_p.func_201670_d() || caster == target) {
                return;
            }
            if (StealthUtils.INSTANCE.getAwareness(caster, target) != StealthUtils.Awareness.UNAWARE || !this.cast(caster, target, -999.0f)) {
                return;
            }
            CombatData.getCap((LivingEntity)target).setHandBind(Hand.MAIN_HAND, 60);
            CombatData.getCap((LivingEntity)target).setHandBind(Hand.OFF_HAND, 60);
            procPoint.setResult(Event.Result.ALLOW);
            this.mark(caster, target, 60.0f);
        } else if (state == Skill.STATE.COOLING) {
            stats.decrementDuration();
        }
    }

    @Override
    public SkillData onMarked(LivingEntity caster, LivingEntity target, SkillData sd, @Nullable SkillData existing) {
        sd.flagCondition(existing == null ? target.func_174814_R() : existing.isCondition());
        target.func_174810_b(true);
        return super.onMarked(caster, target, sd, existing);
    }

    @Override
    public boolean markTick(LivingEntity caster, LivingEntity target, SkillData sd) {
        sd.decrementDuration();
        return super.markTick(caster, target, sd);
    }

    @Override
    public void onMarkEnd(LivingEntity caster, LivingEntity target, SkillData sd) {
        target.func_174810_b(sd.isCondition());
        super.onMarkEnd(caster, target, sd);
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        if (to == Skill.STATE.COOLING) {
            this.setCooldown(caster, prev, 5.0f);
        }
        return super.onStateChange(caster, prev, from, to);
    }
}

