/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.heavyblow;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.wardance.event.ParryEvent;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.heavyblow.HeavyBlow;
import java.awt.Color;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Hand;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class Stagger
extends HeavyBlow {
    @Override
    public Color getColor() {
        return Color.RED;
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof ParryEvent && state != Skill.STATE.COOLING && stats.isCondition() && procPoint.getPhase() == EventPriority.LOWEST && ((ParryEvent)procPoint).getAttacker() == caster && this.cast(caster, target, -999.0f)) {
            CombatData.getCap((LivingEntity)target).setHandBind(Hand.MAIN_HAND, 60);
            CombatData.getCap((LivingEntity)target).setHandBind(Hand.OFF_HAND, 60);
            ((ParryEvent)procPoint).setPostureConsumption(((ParryEvent)procPoint).getPostureConsumption() * stats.getArbitraryFloat());
            this.markUsed(caster);
        } else if (procPoint instanceof CriticalHitEvent) {
            if (this.isCrit((CriticalHitEvent)procPoint) && state != Skill.STATE.COOLING && procPoint.getPhase() == EventPriority.LOWEST) {
                this.onCrit((CriticalHitEvent)procPoint, stats, caster, target);
            } else if (state == Skill.STATE.COOLING && procPoint.getPhase() == EventPriority.HIGHEST) {
                stats.decrementDuration();
            }
        }
    }

    @Override
    protected void onCrit(CriticalHitEvent proc, SkillData stats, LivingEntity caster, LivingEntity target) {
        stats.setArbitraryFloat(proc.getDamageModifier());
        proc.setDamageModifier(1.0f);
        stats.flagCondition(true);
    }
}

