/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.hex;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.capability.resources.ICombatCapability;
import jackiecrazy.footwork.event.LuckEvent;
import jackiecrazy.footwork.utils.EffectUtils;
import jackiecrazy.wardance.api.CombatDamageSource;
import jackiecrazy.wardance.capability.status.Marks;
import jackiecrazy.wardance.entity.FakeExplosion;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.WarSkills;
import jackiecrazy.wardance.utils.CombatUtils;
import jackiecrazy.wardance.utils.SkillUtils;
import jackiecrazy.wardance.utils.WarColors;
import java.awt.Color;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wardance")
public class Hex
extends Skill {
    static final UUID HEX = UUID.fromString("67fe7ef6-a398-4c62-9bb1-42edaa80e7b1");
    private final Tag<String> tag = Hex.makeTag("melee", "noDamage", "boundCast", "afflictionTick", "manipulateParry", "rechargeWithTime", "normalAttack", "chant", "countdown");
    private final Tag<String> thing = Hex.makeTag("offensive", "magical");

    @SubscribeEvent
    public static void snakebite(LivingHealEvent e) {
        if (!e.getEntityLiving().func_70613_aW()) {
            return;
        }
        LivingEntity entity = e.getEntityLiving();
        Marks.getCap(entity).getActiveMark((Skill)WarSkills.GANGRENE.get()).ifPresent(a -> e.setCanceled(a.getArbitraryFloat() > 0.0f));
    }

    @SubscribeEvent
    public static void echoes(LivingHurtEvent e) {
        LivingEntity target = e.getEntityLiving();
        Marks.getCap(target).getActiveMark((Skill)WarSkills.CURSE_OF_ECHOES.get()).ifPresent(a -> {
            if (a.getArbitraryFloat() < 0.0f && CombatUtils.isMeleeAttack(e.getSource())) {
                target.field_70172_ad = 0;
                target.func_70097_a(new CombatDamageSource("echo", (Entity)a.getCaster(target.field_70170_p)).setDamageTyping(CombatDamageSource.TYPE.TRUE).setSkillUsed((Skill)WarSkills.CURSE_OF_ECHOES.get()).func_76348_h().func_151518_m(), e.getAmount() * 0.4f);
                a.setArbitraryFloat(20.0f);
            }
        });
    }

    @SubscribeEvent
    public static void blackmark(LivingDamageEvent e) {
        Entity source;
        if (!e.getEntityLiving().func_70613_aW()) {
            return;
        }
        LivingEntity target = e.getEntityLiving();
        if (e.getAmount() > 0.0f && CombatUtils.isMeleeAttack(e.getSource()) && Marks.getCap(target).isMarked((Skill)WarSkills.BLACK_MARK.get()) && (source = e.getSource().func_76346_g()) instanceof LivingEntity) {
            float spirit;
            LivingEntity le = (LivingEntity)source;
            ICombatCapability cap = CombatData.getCap((LivingEntity)le);
            float posture = cap.getPosture();
            if (posture < (spirit = cap.getSpirit())) {
                CombatData.getCap((LivingEntity)target).consumePosture(2.0f);
                cap.addPosture(1.0f);
            } else {
                CombatData.getCap((LivingEntity)target).consumeSpirit(3.0f);
                cap.addSpirit(1.5f);
            }
            le.func_70691_i(e.getAmount() / 3.0f);
        }
        if (!CombatUtils.isPhysicalAttack(e.getSource())) {
            Marks.getCap(e.getEntityLiving()).getActiveMark((Skill)WarSkills.GANGRENE.get()).ifPresent(g -> g.setArbitraryFloat(40.0f));
        }
    }

    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return this.thing;
    }

    @Override
    @Nonnull
    public Tag<String> getSoftIncompatibility(LivingEntity caster) {
        return offensive;
    }

    @Override
    public float spiritConsumption(LivingEntity caster) {
        return 4.0f;
    }

    @Override
    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.hex;
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        LivingEntity e = SkillUtils.aimLiving(caster);
        if (to == Skill.STATE.ACTIVE && e != null && this.cast(caster, e, -999.0f)) {
            this.mark(caster, e, this.duration(), prev.getArbitraryFloat());
            prev.setArbitraryFloat(0.0f);
            this.markUsed(caster);
        }
        if (to == Skill.STATE.COOLING) {
            this.setCooldown(caster, prev, 15.0f);
        }
        return this.boundCast(prev, from, to);
    }

    protected int duration() {
        return 200;
    }

    @Override
    public boolean markTick(LivingEntity caster, LivingEntity target, SkillData sd) {
        sd.decrementDuration();
        return super.markTick(caster, target, sd);
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (this == WarSkills.CURSE_OF_MISFORTUNE.get() && procPoint instanceof LuckEvent.Post && state != Skill.STATE.COOLING) {
            stats.setArbitraryFloat(Math.min(11.0f, stats.getArbitraryFloat() + 1.0f));
        }
    }

    @Override
    public boolean equippedTick(LivingEntity caster, SkillData stats) {
        if (this.cooldownTick(stats)) {
            return true;
        }
        return super.equippedTick(caster, stats);
    }

    @Override
    public SkillData onMarked(LivingEntity caster, LivingEntity target, SkillData sd, @Nullable SkillData existing) {
        ModifiableAttributeInstance luck = target.func_110148_a(Attributes.field_233828_k_);
        if (luck != null && this == WarSkills.CURSE_OF_MISFORTUNE.get()) {
            luck.func_188479_b(HEX);
            AttributeModifier am = new AttributeModifier(HEX, "hex", (double)(-2.0f - sd.getArbitraryFloat()), AttributeModifier.Operation.ADDITION);
            sd.setArbitraryFloat(0.0f);
            luck.func_233767_b_(am);
        }
        return super.onMarked(caster, target, sd, existing);
    }

    @Override
    public void onMarkEnd(LivingEntity caster, LivingEntity target, SkillData sd) {
        ModifiableAttributeInstance luck = target.func_110148_a(Attributes.field_233828_k_);
        if (luck != null) {
            luck.func_188479_b(HEX);
        }
        super.onMarkEnd(caster, target, sd);
    }

    public static class Unravel
    extends Hex {
        @Override
        public Color getColor() {
            return Color.ORANGE;
        }

        @Override
        protected void mark(LivingEntity caster, LivingEntity target, float duration, float arbitrary) {
            ItemStack milk = new ItemStack((IItemProvider)Items.field_151117_aB);
            ArrayList potions = new ArrayList(target.func_70651_bq());
            target.curePotionEffects(milk);
            float size = 8.0f;
            float damage = 6.0f;
            boolean proc = false;
            for (EffectInstance ei : potions) {
                proc = true;
                EffectInstance drop = new EffectInstance(ei.func_188419_a(), 0, -2);
                if ((drop = EffectUtils.stackPot((LivingEntity)caster, (EffectInstance)drop, (EffectUtils.StackingMethod)EffectUtils.StackingMethod.MAXDURATION)).func_76458_c() < 0) continue;
                target.func_195064_c(drop);
            }
            if (proc) {
                FakeExplosion.explode(caster.field_70170_p, (Entity)caster, target.func_226277_ct_(), target.func_226278_cu_() + (double)(target.func_213302_cg() * 1.1f), target.func_226281_cx_(), size, DamageSource.func_188405_b((LivingEntity)caster).func_82726_p(), damage);
            }
        }
    }

    public static class CurseOfEchoes
    extends Hex {
        @Override
        public Color getColor() {
            return Color.RED;
        }

        @Override
        public boolean markTick(LivingEntity caster, LivingEntity target, SkillData sd) {
            sd.setArbitraryFloat(sd.getArbitraryFloat() - 1.0f);
            return super.markTick(caster, target, sd);
        }
    }

    public static class BlackMark
    extends Hex {
        @Override
        public Color getColor() {
            return Color.LIGHT_GRAY;
        }
    }

    public static class Gangrene
    extends Hex {
        @Override
        public Color getColor() {
            return WarColors.VIOLET;
        }

        @Override
        public boolean markTick(LivingEntity caster, LivingEntity target, SkillData sd) {
            sd.setArbitraryFloat(sd.getArbitraryFloat() - 1.0f);
            return super.markTick(caster, target, sd);
        }

        @Override
        protected int duration() {
            return 160;
        }
    }
}

