/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.judgment;

import jackiecrazy.wardance.api.CombatDamageSource;
import jackiecrazy.wardance.event.SkillCastEvent;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.judgment.Judgment;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class ComboBreaker
extends Judgment {
    @Override
    public Color getColor() {
        return Color.ORANGE;
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof SkillCastEvent && this.hasMark(target) && target == ((SkillCastEvent)procPoint).getTarget() && procPoint.getPhase() == EventPriority.HIGHEST) {
            this.mark(caster, target, 5.0f, 1.0f);
        } else {
            super.onProc(caster, procPoint, state, stats, target);
        }
    }

    @Override
    protected void performEffect(LivingEntity caster, LivingEntity target, int stack, SkillData sd) {
    }

    private void detonate(LivingEntity caster, LivingEntity target, SkillData sd) {
        float amount = (float)((double)sd.getArbitraryFloat() * 0.04 * (double)target.func_110143_aJ());
        target.func_70097_a(new CombatDamageSource("player", (Entity)caster).setDamageTyping(CombatDamageSource.TYPE.PHYSICAL).setProcSkillEffects(true).setProcAttackEffects(true).setDamageTyping(CombatDamageSource.TYPE.TRUE).func_76348_h().func_151518_m(), amount);
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        if (to == Skill.STATE.COOLING) {
            this.setCooldown(caster, prev, 10.0f);
            return true;
        }
        return super.onStateChange(caster, prev, from, to);
    }

    @Override
    public SkillData onMarked(LivingEntity caster, LivingEntity target, SkillData sd, @Nullable SkillData existing) {
        if (existing != null) {
            if (existing.getDuration() < 0.0f) {
                return null;
            }
            sd.setArbitraryFloat(sd.getArbitraryFloat() + existing.getArbitraryFloat());
            if (sd.getArbitraryFloat() > 10.0f) {
                this.removeMark(target);
            }
        }
        sd.setDuration(5.0f);
        return sd;
    }

    @Override
    public void onMarkEnd(LivingEntity caster, LivingEntity target, SkillData sd) {
        this.detonate(caster, target, sd);
    }
}

