/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.judgment;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.api.CombatDamageSource;
import jackiecrazy.wardance.capability.status.Marks;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.WarSkills;
import jackiecrazy.wardance.utils.CombatUtils;
import jackiecrazy.wardance.utils.SkillUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tags.Tag;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class Judgment
extends Skill {
    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return special;
    }

    @Override
    @Nonnull
    public Tag<String> getSoftIncompatibility(LivingEntity caster) {
        return special;
    }

    @Override
    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.judgment;
    }

    protected void performEffect(LivingEntity caster, LivingEntity target, int stack, SkillData sd) {
        float amount;
        float f = amount = stack == 3 ? target.func_110143_aJ() * 0.15f : target.func_110143_aJ() * 0.03f;
        if (this == WarSkills.AMPUTATION.get()) {
            if (stack == 3) {
                float healthDiff = target.func_110138_aP() - target.func_110143_aJ();
                amount += healthDiff;
            }
            CombatData.getCap((LivingEntity)target).addWounding(amount);
        } else {
            target.func_70097_a(new CombatDamageSource("player", (Entity)caster).setDamageTyping(CombatDamageSource.TYPE.PHYSICAL).setProcSkillEffects(true).setProcAttackEffects(true).setDamageTyping(CombatDamageSource.TYPE.TRUE).func_76348_h().func_151518_m(), amount);
        }
    }

    @Override
    public Skill.CastStatus castingCheck(LivingEntity caster) {
        if (CombatData.getCap((LivingEntity)caster).getComboRank() < 5) {
            return Skill.CastStatus.OTHER;
        }
        return super.castingCheck(caster);
    }

    @Override
    public float mightConsumption(LivingEntity caster) {
        return 3.0f;
    }

    @Override
    public boolean equippedTick(LivingEntity caster, SkillData stats) {
        if (stats.getState() == Skill.STATE.ACTIVE && stats.getDuration() > 0.0f) {
            boolean stat = stats.getDuration() > 0.0f;
            this.activeTick(stats);
            if (stats.getDuration() < 0.0f && stat) {
                this.onStateChange(caster, stats, Skill.STATE.INACTIVE, Skill.STATE.HOLSTERED);
                stats.setDuration(0.0f);
            }
            return true;
        }
        return this.cooldownTick(stats);
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        LivingEntity target = SkillUtils.aimLiving(caster);
        if (from == Skill.STATE.HOLSTERED && to == Skill.STATE.ACTIVE && target != null && this.cast(caster, target, -999.0f)) {
            int stack = 1;
            float arb = Marks.getCap(target).getActiveMark(this).orElse(SkillData.DUMMY).getArbitraryFloat();
            if (arb >= 2.0f) {
                caster.field_70170_p.func_184148_a(null, caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_(), SoundEvents.field_187523_aM, SoundCategory.PLAYERS, 0.25f + WarDance.rand.nextFloat() * 0.5f, 0.5f + WarDance.rand.nextFloat() * 0.5f);
                this.removeMark(target);
            } else {
                prev.flagCondition(true);
                this.mark(caster, target, 6.0f, 1.0f);
            }
            stack = (int)((float)stack + arb);
            this.performEffect(caster, target, stack, prev);
            target.field_70172_ad = 0;
            boolean offhand = stack == 2;
            CombatUtils.attack(caster, (Entity)target, offhand);
            caster.func_226292_a_(offhand ? Hand.OFF_HAND : Hand.MAIN_HAND, true);
            caster.field_70170_p.func_184148_a(null, caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_(), SoundEvents.field_219648_fh, SoundCategory.PLAYERS, 0.25f + WarDance.rand.nextFloat() * 0.5f, 0.5f + WarDance.rand.nextFloat() * 0.5f);
        }
        if (to == Skill.STATE.COOLING) {
            if (prev.isCondition()) {
                prev.setDuration(2.0f);
            } else {
                this.setCooldown(caster, prev, 20.0f);
            }
            return true;
        }
        if (from != Skill.STATE.COOLING && to == Skill.STATE.HOLSTERED) {
            caster.field_70170_p.func_184148_a(null, caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_(), SoundEvents.field_219642_eu, SoundCategory.PLAYERS, 0.25f + WarDance.rand.nextFloat() * 0.5f, 0.5f + WarDance.rand.nextFloat() * 0.5f);
        }
        return this.boundCast(prev, from, to);
    }

    @Override
    public SkillData onMarked(LivingEntity caster, LivingEntity target, SkillData sd, @Nullable SkillData existing) {
        if (existing != null) {
            if (existing.getDuration() < 0.0f) {
                return null;
            }
            sd.setArbitraryFloat(sd.getArbitraryFloat() + existing.getArbitraryFloat());
            sd.setDuration(12.0f);
        }
        return sd;
    }

    @Override
    public boolean markTick(LivingEntity caster, LivingEntity target, SkillData sd) {
        sd.decrementDuration(0.05f);
        return super.markTick(caster, target, sd);
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, @Nullable LivingEntity target) {
        if (procPoint instanceof LivingDeathEvent && procPoint.getPhase() == EventPriority.HIGHEST && ((LivingDeathEvent)procPoint).getEntityLiving() == target) {
            Marks.getCap(target).getActiveMark(this).ifPresent(a -> CombatData.getCap((LivingEntity)caster).addMight(a.getArbitraryFloat() * this.mightConsumption(caster) * 1.4f));
        }
        if (procPoint instanceof LivingAttackEvent && ((LivingAttackEvent)procPoint).getEntityLiving() == target) {
            if (state == Skill.STATE.ACTIVE) {
                ((LivingAttackEvent)procPoint).getSource().func_76348_h().func_151518_m();
            }
            Marks.getCap(target).getActiveMark(this).ifPresent(a -> a.setDuration(a.getArbitraryFloat() == 1.0f ? 6.0f : 12.0f));
        }
    }
}

