/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.kick;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.capability.resources.ICombatCapability;
import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.api.CombatDamageSource;
import jackiecrazy.wardance.config.CombatConfig;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.eventbus.api.Event;

public class Kick
extends Skill {
    private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("physical", "melee", "noDamage", "boundCast", "normalAttack", "countdown", "rechargeWithAttack")));
    private final Tag<String> no = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("normalAttack")));

    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return offensivePhysical;
    }

    @Override
    @Nonnull
    public Tag<String> getSoftIncompatibility(LivingEntity caster) {
        return offensive;
    }

    @Override
    public float spiritConsumption(LivingEntity caster) {
        return 3.0f;
    }

    @Override
    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.kick;
    }

    protected void additionally(LivingEntity caster, LivingEntity target) {
        ICombatCapability cap = CombatData.getCap((LivingEntity)target);
        if (cap.getStaggerTime() > 0) {
            cap.setStaggerTime(cap.getStaggerTime() + CombatConfig.staggerDuration);
            cap.setStaggerCount(cap.getStaggerCount() + CombatConfig.staggerHits);
        }
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, @Nullable LivingEntity target) {
        this.attackCooldown(procPoint, caster, stats);
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        LivingEntity target = GeneralUtils.raytraceLiving((LivingEntity)caster, (double)this.distance());
        if (from == Skill.STATE.HOLSTERED && to == Skill.STATE.ACTIVE && target != null && this.cast(caster, target, -999.0f)) {
            CombatData.getCap((LivingEntity)target).consumePosture(caster, 4.0f);
            if (caster instanceof PlayerEntity) {
                ((PlayerEntity)caster).func_184810_cG();
            }
            this.additionally(caster, target);
            target.func_70097_a((DamageSource)new CombatDamageSource("fallingBlock", (Entity)caster).setDamageTyping(CombatDamageSource.TYPE.PHYSICAL).setProcSkillEffects(true).setProcAttackEffects(true), 2.0f);
            if (target.func_70643_av() == null) {
                target.func_70604_c(caster);
            }
            caster.field_70170_p.func_184148_a(null, caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_(), SoundEvents.field_187927_ha, SoundCategory.PLAYERS, 0.25f + WarDance.rand.nextFloat() * 0.5f, 0.5f + WarDance.rand.nextFloat() * 0.5f);
        }
        if (to == Skill.STATE.COOLING) {
            this.setCooldown(caster, prev, 4.0f);
            return true;
        }
        return this.boundCast(prev, from, to);
    }

    protected int distance() {
        return 3;
    }

    public static class Backflip
    extends Kick {
        @Override
        public Color getColor() {
            return Color.LIGHT_GRAY;
        }

        @Override
        protected void additionally(LivingEntity caster, LivingEntity target) {
            Vector3d vec = caster.func_213303_ch().func_72444_a(target.func_213303_ch());
            Vector3d noy = new Vector3d(vec.field_72450_a, 0.0, vec.field_72449_c).func_72432_b().func_186678_a(-1.0);
            caster.func_213317_d(caster.func_213322_ci().func_72441_c(noy.field_72450_a, 0.4, noy.field_72449_c));
            caster.field_70133_I = true;
            ICombatCapability cap = CombatData.getCap((LivingEntity)caster);
            cap.addRank(0.4f);
            cap.addPosture(0.3f * (cap.getPosture() / cap.getMaxPosture()));
        }
    }
}

