/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.kick;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.api.CombatDamageSource;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.kick.Kick;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;

public class ShadowlessKick
extends Kick {
    @Override
    public Color getColor() {
        return Color.ORANGE;
    }

    @Override
    public float spiritConsumption(LivingEntity caster) {
        return 4.0f;
    }

    @Override
    public boolean equippedTick(LivingEntity caster, SkillData stats) {
        if (stats.getState() == Skill.STATE.ACTIVE) {
            stats.decrementDuration();
            if (stats.getDuration() == 0.0f && this.kick(caster, stats)) {
                stats.setDuration(5.0f);
            }
        }
        return super.equippedTick(caster, stats);
    }

    @Override
    protected void additionally(LivingEntity caster, LivingEntity target) {
    }

    private boolean kick(LivingEntity caster, SkillData stats) {
        LivingEntity target = GeneralUtils.raytraceLiving((LivingEntity)caster, (double)this.distance());
        if (target != null) {
            CombatData.getCap((LivingEntity)target).consumePosture(caster, 2.0f);
            if (caster instanceof PlayerEntity && caster.field_70170_p instanceof ServerWorld) {
                double d0 = -MathHelper.func_76126_a((float)(caster.field_70177_z * ((float)Math.PI / 180)));
                double d1 = MathHelper.func_76134_b((float)(caster.field_70177_z * ((float)Math.PI / 180)));
                ((ServerWorld)caster.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197627_t, caster.func_226277_ct_() + d0, caster.func_226283_e_(0.5), caster.func_226281_cx_() + d1, 0, d0, 0.0, d1, 0.0);
            }
            target.func_70097_a((DamageSource)new CombatDamageSource("fallingBlock", (Entity)caster).setDamageTyping(CombatDamageSource.TYPE.PHYSICAL).setProcSkillEffects(true).setProcNormalEffects(false).setProcAttackEffects(true).setKnockbackPercentage(0.7f), 1.0f);
            if (target.func_70643_av() == null) {
                target.func_70604_c(caster);
            }
            stats.setArbitraryFloat(stats.getArbitraryFloat() + 1.0f);
            if (stats.getArbitraryFloat() >= 6.0f) {
                this.markUsed(caster);
                caster.field_70170_p.func_184148_a(null, caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_(), SoundEvents.field_187523_aM, SoundCategory.PLAYERS, 0.5f + WarDance.rand.nextFloat() * 0.5f, 0.5f + WarDance.rand.nextFloat() * 0.5f);
                return false;
            }
            caster.field_70170_p.func_184148_a(null, caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_(), SoundEvents.field_187927_ha, SoundCategory.PLAYERS, 0.25f + WarDance.rand.nextFloat() * 0.5f, 0.5f + WarDance.rand.nextFloat() * 0.5f);
            return true;
        }
        return false;
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        LivingEntity target;
        if (from == Skill.STATE.HOLSTERED && to == Skill.STATE.ACTIVE && this.kick(caster, prev) && (target = GeneralUtils.raytraceLiving((LivingEntity)caster, (double)this.distance())) != null && this.cast(caster, target, 5.0f)) {
            this.kick(caster, prev);
        }
        if (to == Skill.STATE.COOLING) {
            this.setCooldown(caster, prev, 6.0f);
            return true;
        }
        return this.boundCast(prev, from, to);
    }
}

