/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.mementomori;

import jackiecrazy.footwork.event.AttackMightEvent;
import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.footwork.utils.TargetingUtils;
import jackiecrazy.wardance.api.CombatDamageSource;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.WarSkills;
import jackiecrazy.wardance.utils.CombatUtils;
import jackiecrazy.wardance.utils.SkillUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.tags.Tag;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class MementoMori
extends Skill {
    private static final UUID MULT = UUID.fromString("c2b95d0d-b52a-45c7-b2d6-4ea669aa848e");
    private static final UUID LUCK = UUID.fromString("c2b95d0d-b52a-45c7-b2d6-4ea660aa848e");
    private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("passive", "rechargeWithSleep", "manipulateHealing", "onDamage", "manipulateMight")));
    private final Tag<String> no = Tag.func_241284_a_();

    @Override
    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.memento_mori;
    }

    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return passive;
    }

    @Override
    @Nonnull
    public Tag<String> getSoftIncompatibility(LivingEntity caster) {
        return none;
    }

    @Override
    public void onUnequip(LivingEntity caster, SkillData stats) {
        caster.func_110148_a(Attributes.field_233823_f_).func_188479_b(MULT);
        caster.func_110148_a(Attributes.field_233826_i_).func_188479_b(MULT);
        caster.func_110148_a(Attributes.field_233828_k_).func_188479_b(MULT);
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof AttackMightEvent && this == WarSkills.BLOODLUST.get()) {
            float healthPercentage = caster.func_110143_aJ() / GeneralUtils.getMaxHealthBeforeWounding((LivingEntity)caster);
            ((AttackMightEvent)procPoint).setQuantity(((AttackMightEvent)procPoint).getQuantity() * (3.0f - 2.0f * healthPercentage));
        }
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        return false;
    }

    @Override
    public boolean equippedTick(LivingEntity caster, SkillData d) {
        if (((Object)((Object)this)).getClass() != MementoMori.class) {
            return false;
        }
        float health = 1.0f - caster.func_110143_aJ() / GeneralUtils.getMaxHealthBeforeWounding((LivingEntity)caster);
        SkillUtils.modifyAttribute(caster, Attributes.field_233823_f_, MULT, health, AttributeModifier.Operation.MULTIPLY_TOTAL);
        return false;
    }

    public static class StaticDischarge
    extends MementoMori {
        @Override
        public Color getColor() {
            return Color.CYAN;
        }

        @Override
        public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
            float stat;
            if (procPoint instanceof LivingDamageEvent && procPoint.getPhase() == EventPriority.HIGHEST && ((LivingDamageEvent)procPoint).getEntityLiving() == caster) {
                stat = stats.getArbitraryFloat();
                stat += ((LivingDamageEvent)procPoint).getAmount();
                stat = Math.min(stat, GeneralUtils.getMaxHealthBeforeWounding((LivingEntity)caster) / 5.0f);
                stats.setArbitraryFloat(stat);
            }
            if (procPoint instanceof LivingAttackEvent && procPoint.getPhase() == EventPriority.HIGHEST && CombatUtils.isMeleeAttack(((LivingAttackEvent)procPoint).getSource()) && ((LivingAttackEvent)procPoint).getEntityLiving() == target && (stat = stats.getArbitraryFloat()) > 1.0f) {
                for (LivingEntity e : caster.field_70170_p.func_225317_b(LivingEntity.class, caster.func_174813_aQ().func_186662_g(5.0))) {
                    if (!TargetingUtils.isHostile((Entity)e, (Entity)caster)) continue;
                    e.func_70097_a(new CombatDamageSource("lightningBolt", (Entity)caster).setDamageTyping(CombatDamageSource.TYPE.MAGICAL).setProcSkillEffects(true).setKnockbackPercentage(0.0f).setAttackingHand(null).setSkillUsed(this).func_82726_p(), stat);
                    CombatUtils.knockBack((Entity)e, (Entity)caster, stat / 4.0f, true, false);
                }
                stats.setArbitraryFloat(0.0f);
            }
        }
    }

    public static class RapidClotting
    extends MementoMori {
        @Override
        public Color getColor() {
            return Color.GREEN;
        }

        @Override
        public boolean equippedTick(LivingEntity caster, SkillData d) {
            float lostHealth = GeneralUtils.getMaxHealthBeforeWounding((LivingEntity)caster) - caster.func_110143_aJ();
            SkillUtils.modifyAttribute(caster, Attributes.field_233826_i_, MULT, (lostHealth /= GeneralUtils.getMaxHealthBeforeWounding((LivingEntity)caster)) * 20.0f, AttributeModifier.Operation.ADDITION);
            return super.equippedTick(caster, d);
        }
    }
}

