/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.mementomori;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.wardance.api.CombatDamageSource;
import jackiecrazy.wardance.event.ParryEvent;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.mementomori.MementoMori;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tags.Tag;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class PoundOfFlesh
extends MementoMori {
    private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("melee", "beforeArmor", "state", "onBeingParried")));

    @Override
    public Color getColor() {
        return Color.RED;
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        if (to == Skill.STATE.COOLING) {
            prev.setState(Skill.STATE.INACTIVE);
            prev.setDuration(0.0f);
        }
        if (to == Skill.STATE.HOLSTERED && this.cast(caster, CombatData.getCap((LivingEntity)caster).getSpirit() * 40.0f)) {
            CombatData.getCap((LivingEntity)caster).setSpirit(0.0f);
        }
        return this.instantCast(prev, from, to);
    }

    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return special;
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (state == Skill.STATE.ACTIVE) {
            if (procPoint instanceof ParryEvent && procPoint.getPhase() == EventPriority.HIGHEST && ((ParryEvent)procPoint).canParry()) {
                caster.field_70172_ad = 0;
                caster.func_70097_a(CombatDamageSource.causeSelfDamage(caster).setDamageTyping(CombatDamageSource.TYPE.TRUE).setSkillUsed(this).func_76348_h().func_151518_m(), GeneralUtils.getMaxHealthBeforeWounding((LivingEntity)caster) * 0.05f);
                ((ParryEvent)procPoint).setPostureConsumption(((ParryEvent)procPoint).getPostureConsumption() + CombatData.getCap((LivingEntity)target).getTrueMaxPosture() * 0.1f);
            } else if (procPoint instanceof LivingHurtEvent && procPoint.getPhase() == EventPriority.HIGHEST && ((LivingHurtEvent)procPoint).getEntityLiving() == target && (!(((LivingHurtEvent)procPoint).getSource() instanceof CombatDamageSource) || ((CombatDamageSource)((LivingHurtEvent)procPoint).getSource()).getSkillUsed() != this)) {
                caster.field_70172_ad = 0;
                caster.func_70097_a(CombatDamageSource.causeSelfDamage(caster).setDamageTyping(CombatDamageSource.TYPE.TRUE).setSkillUsed(this).func_76348_h().func_151518_m(), GeneralUtils.getMaxHealthBeforeWounding((LivingEntity)caster) * 0.05f);
                ((LivingHurtEvent)procPoint).setAmount(((LivingHurtEvent)procPoint).getAmount() + GeneralUtils.getMaxHealthBeforeWounding((LivingEntity)target) * 0.05f);
            }
        }
    }

    @Override
    public boolean equippedTick(LivingEntity caster, SkillData d) {
        if (d.getState() == Skill.STATE.ACTIVE) {
            if (CombatData.getCap((LivingEntity)caster).getSpirit() == CombatData.getCap((LivingEntity)caster).getMaxSpirit()) {
                this.markUsed(caster);
            }
            d.decrementDuration();
        }
        return super.equippedTick(caster, d);
    }
}

