/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.mementomori;

import jackiecrazy.footwork.capability.goal.GoalCapabilityProvider;
import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.footwork.utils.TargetingUtils;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.mementomori.MementoMori;
import jackiecrazy.wardance.utils.SkillUtils;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class ShadowDive
extends MementoMori {
    @Override
    public Color getColor() {
        return Color.LIGHT_GRAY;
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof LivingDamageEvent && state == Skill.STATE.INACTIVE && ((LivingDamageEvent)procPoint).getEntityLiving() == caster && procPoint.getPhase() == EventPriority.HIGHEST && ((LivingDamageEvent)procPoint).getAmount() > caster.func_110143_aJ()) {
            this.activate(caster, 160.0f);
            caster.func_195064_c(new EffectInstance(Effects.field_76441_p, 160));
            caster.func_195064_c(new EffectInstance(Effects.field_76424_c, 160));
            SkillUtils.createCloud(caster.field_70170_p, (Entity)caster, caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_(), 7.0f, (IParticleData)ParticleTypes.field_197594_E);
        }
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        if (to == Skill.STATE.COOLING) {
            this.setCooldown(caster, prev, 10.0f);
            return true;
        }
        if (from != Skill.STATE.ACTIVE && to == Skill.STATE.ACTIVE) {
            prev.setDuration(100.0f);
            prev.setState(Skill.STATE.ACTIVE);
        }
        return this.passive(prev, from, to);
    }

    @Override
    public boolean equippedTick(LivingEntity caster, SkillData d) {
        if (d.getState() == Skill.STATE.ACTIVE) {
            d.decrementDuration();
            Entity tar = GeneralUtils.collidingEntity((Entity)caster);
            if (tar instanceof LivingEntity && !d.isCondition()) {
                d.flagCondition(true);
                SkillUtils.createCloud(caster.field_70170_p, (Entity)caster, caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_(), 7.0f, (IParticleData)ParticleTypes.field_197609_b);
                for (LivingEntity e : caster.field_70170_p.func_225316_b(LivingEntity.class, caster.func_174813_aQ().func_186662_g(40.0), a -> TargetingUtils.isHostile((Entity)a, (Entity)caster))) {
                    e.func_70604_c((LivingEntity)tar);
                    if (!(e instanceof MobEntity)) continue;
                    ((MobEntity)e).func_70624_b((LivingEntity)tar);
                    GoalCapabilityProvider.getCap((LivingEntity)e).ifPresent(a -> a.setForcedTarget((LivingEntity)tar));
                }
            }
            return true;
        }
        if (d.getState() == Skill.STATE.COOLING && caster.func_110143_aJ() == caster.func_110138_aP()) {
            d.setDuration(-10.0f);
        }
        return super.equippedTick(caster, d);
    }
}

