/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.regenspirit;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.event.EntityAwarenessEvent;
import jackiecrazy.footwork.utils.StealthUtils;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tags.Tag;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class ArchersParadox
extends Skill {
    @Override
    public Color getColor() {
        return Color.CYAN;
    }

    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return passive;
    }

    @Override
    @Nonnull
    public Tag<String> getSoftIncompatibility(LivingEntity caster) {
        return none;
    }

    @Override
    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.morale;
    }

    @Override
    public boolean equippedTick(LivingEntity caster, SkillData d) {
        if (d.isCondition()) {
            d.decrementDuration();
        }
        if (d.getDuration() <= 0.0f) {
            d.flagCondition(false);
            d.setDuration(30.0f);
        }
        return false;
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (stats.isCondition()) {
            return;
        }
        if (procPoint instanceof ProjectileImpactEvent && procPoint.getPhase() == EventPriority.HIGHEST) {
            CombatData.getCap((LivingEntity)caster).addSpirit(1.0f);
            stats.flagCondition(true);
        } else if (procPoint instanceof EntityAwarenessEvent && ((EntityAwarenessEvent)procPoint).getAttacker() == caster && procPoint.getPhase() == EventPriority.HIGHEST && ((EntityAwarenessEvent)procPoint).getAwareness() != StealthUtils.Awareness.ALERT) {
            CombatData.getCap((LivingEntity)caster).addSpirit(1.0f);
            stats.flagCondition(true);
        }
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        return false;
    }
}

