/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.regenspirit;

import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.footwork.utils.LuckUtils;
import jackiecrazy.wardance.event.SkillResourceEvent;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.tags.Tag;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class LadyLuck
extends Skill {
    @Override
    public Color getColor() {
        return Color.ORANGE;
    }

    @Override
    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.morale;
    }

    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return passive;
    }

    @Override
    @Nonnull
    public Tag<String> getSoftIncompatibility(LivingEntity caster) {
        return none;
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof SkillResourceEvent && ((SkillResourceEvent)procPoint).getSpirit() > 0.0f && procPoint.getPhase() == EventPriority.HIGHEST) {
            float luck = (float)Math.max(0.0, GeneralUtils.getAttributeValueSafe((LivingEntity)caster, (Attribute)Attributes.field_233828_k_));
            stats.setArbitraryFloat(stats.getArbitraryFloat() + (1.0f + luck) / (5.0f + luck));
            if (LuckUtils.luckRoll((LivingEntity)caster, (float)stats.getArbitraryFloat())) {
                ((SkillResourceEvent)procPoint).setSpirit(0.0f);
                stats.setArbitraryFloat(0.0f);
            }
        }
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        return false;
    }
}

