/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.shieldbash;

import jackiecrazy.footwork.api.WarAttributes;
import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.capability.resources.ICombatCapability;
import jackiecrazy.footwork.potion.FootworkEffects;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.api.CombatDamageSource;
import jackiecrazy.wardance.event.ParryEvent;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.utils.CombatUtils;
import jackiecrazy.wardance.utils.SkillUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class ShieldBash
extends Skill {
    private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("physical", "melee", "boundCast", "normalAttack", "countdown", "rechargeWithParry")));
    private final Tag<String> no = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("normalAttack")));

    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return offensivePhysical;
    }

    @Override
    @Nonnull
    public Tag<String> getSoftIncompatibility(LivingEntity caster) {
        return offensive;
    }

    @Override
    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.shield_bash;
    }

    @Override
    public float spiritConsumption(LivingEntity caster) {
        return 2.0f;
    }

    protected void performEffect(LivingEntity caster, LivingEntity target) {
        ICombatCapability cap = CombatData.getCap((LivingEntity)caster);
        SkillUtils.auxAttack(caster, target, (DamageSource)new CombatDamageSource("player", (Entity)caster).setProcNormalEffects(false).setProcAttackEffects(true).setProcSkillEffects(true).setAttackingHand(Hand.OFF_HAND).setDamageTyping(CombatDamageSource.TYPE.PHYSICAL).setDamageDealer(caster.func_184614_ca()), 0.0f, cap.consumeBarrier(cap.getBarrier() / 4.0f));
        cap.setBarrierCooldown(cap.getBarrierCooldown() / 2);
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof LivingAttackEvent && ((LivingAttackEvent)procPoint).getEntityLiving() == target && CombatUtils.isMeleeAttack(((LivingAttackEvent)procPoint).getSource()) && procPoint.getPhase() == EventPriority.HIGHEST) {
            boolean otherwise;
            boolean base = this.isPassive(caster) && state != Skill.STATE.COOLING;
            boolean bl = otherwise = state == Skill.STATE.HOLSTERED && CombatUtils.isShield(caster, CombatUtils.getAttackingItemStack(((LivingAttackEvent)procPoint).getSource()));
            if ((base || otherwise) && this.cast(caster, target, -999.0f)) {
                this.performEffect(caster, target);
                caster.field_70170_p.func_184148_a(null, caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_(), SoundEvents.field_187928_hb, SoundCategory.PLAYERS, 0.25f + WarDance.rand.nextFloat() * 0.5f, 0.5f + WarDance.rand.nextFloat() * 0.5f);
                this.markUsed(caster);
            }
        }
        if (procPoint instanceof ParryEvent && procPoint.getPhase() == EventPriority.HIGHEST && state == Skill.STATE.COOLING && ((ParryEvent)procPoint).getEntityLiving() == caster) {
            stats.decrementDuration();
        }
    }

    @Override
    public boolean equippedTick(LivingEntity caster, SkillData stats) {
        return super.equippedTick(caster, stats);
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        if (to == Skill.STATE.COOLING) {
            prev.setState(Skill.STATE.INACTIVE);
        }
        return this.boundCast(prev, from, to);
    }

    public static class FootSlam
    extends ShieldBash {
        @Override
        public Color getColor() {
            return Color.LIGHT_GRAY;
        }

        @Override
        protected void performEffect(LivingEntity caster, LivingEntity target) {
            super.performEffect(caster, target);
            int time = CombatData.getCap((LivingEntity)caster).getBarrierCooldown();
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, time * 2));
            target.func_195064_c(new EffectInstance((Effect)FootworkEffects.DISTRACTION.get(), time * 2));
        }
    }

    public static class RimPunch
    extends ShieldBash {
        @Override
        public Color getColor() {
            return Color.CYAN;
        }

        @Override
        protected void performEffect(LivingEntity caster, LivingEntity target) {
            target.func_195064_c(new EffectInstance(Effects.field_76431_k, 60));
            CombatUtils.knockBack((Entity)target, (Entity)caster, (float)caster.func_233637_b_((Attribute)WarAttributes.BARRIER.get()), true, false);
            CombatData.getCap((LivingEntity)caster).consumeBarrier(CombatData.getCap((LivingEntity)caster).getBarrier());
            CombatData.getCap((LivingEntity)caster).setBarrierCooldown(CombatData.getCap((LivingEntity)caster).getBarrierCooldown() / 2);
        }
    }
}

