/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.warcry;

import jackiecrazy.footwork.utils.StealthUtils;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.warcry.WarCry;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.Tag;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class FrostFang
extends WarCry {
    private static final AttributeModifier luck = new AttributeModifier(UUID.fromString("77723885-afb9-4937-9c02-612ee5b6135a"), "frost fang bonus", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier speed = new AttributeModifier(UUID.fromString("07430131-9baa-47b4-a51c-9a6f48d564f4"), "frost fang bonus", 0.4, AttributeModifier.Operation.MULTIPLY_BASE);
    private final Tag<String> tag = FrostFang.makeTag("chant", "melee", "onHurt", "countdown", "rechargeWithTime", "rechargeWithSleep");
    private final Tag<String> chant = FrostFang.makeTag("chant", "melee", "state");

    @Override
    protected void evoke(LivingEntity caster) {
        caster.func_110148_a(Attributes.field_233821_d_).func_111124_b(speed);
        caster.func_110148_a(Attributes.field_233821_d_).func_233767_b_(speed);
        super.evoke(caster);
    }

    @Override
    protected int getDuration(float might) {
        return (int)(might * 20.0f);
    }

    @Override
    public Color getColor() {
        return Color.CYAN;
    }

    @Override
    public void onEquip(LivingEntity caster) {
        caster.func_110148_a(Attributes.field_233828_k_).func_188479_b(luck.func_111167_a());
        caster.func_110148_a(Attributes.field_233828_k_).func_233769_c_(luck);
        super.onEquip(caster);
    }

    @Override
    public void onUnequip(LivingEntity caster, SkillData stats) {
        caster.func_110148_a(Attributes.field_233828_k_).func_111124_b(luck);
        caster.func_110148_a(Attributes.field_233821_d_).func_111124_b(speed);
        super.onUnequip(caster, stats);
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof LivingAttackEvent && state == Skill.STATE.ACTIVE && procPoint.getPhase() == EventPriority.HIGHEST && ((LivingAttackEvent)procPoint).getEntityLiving() == target) {
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 60));
            if (StealthUtils.INSTANCE.getAwareness(caster, target) == StealthUtils.Awareness.ALERT) {
                target.func_195064_c(new EffectInstance(Effects.field_76440_q, 20));
            }
        }
        super.onProc(caster, procPoint, state, stats, target);
    }

    @Override
    public boolean equippedTick(LivingEntity caster, SkillData stats) {
        if (stats.getState() == Skill.STATE.ACTIVE) {
            return this.activeTick(stats);
        }
        return super.equippedTick(caster, stats);
    }
}

