/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.warcry;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.WarSkills;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.Tag;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class WarCry
extends Skill {
    private static final AttributeModifier wrap = new AttributeModifier(UUID.fromString("4b342542-fcfb-47a8-8da8-4f57588f7003"), "bandaging wounds", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private final Tag<String> procs = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("chant", "onHurt", "countdown", "rechargeWithTime", "rechargeWithSleep")));
    private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("chant", "melee", "state")));

    @Override
    public Tag<String> getTags(LivingEntity caster) {
        return this.tag;
    }

    @Override
    @Nonnull
    public Tag<String> getSoftIncompatibility(LivingEntity caster) {
        return state;
    }

    @Override
    public float mightConsumption(LivingEntity caster) {
        return 5.0f;
    }

    @Override
    @Nonnull
    public SkillCategory getParentCategory() {
        return SkillCategories.war_cry;
    }

    protected int getDuration(float might) {
        return Math.max(0, (int)((double)might * 1.5));
    }

    protected void evoke(LivingEntity caster) {
        CombatData.getCap((LivingEntity)caster).addMight(this.mightConsumption(caster));
        caster.field_70170_p.func_217384_a(null, (Entity)caster, SoundEvents.field_187646_bt, SoundCategory.AMBIENT, 0.3f + WarDance.rand.nextFloat() * 0.5f, 0.5f + WarDance.rand.nextFloat());
        if (this == WarSkills.REJUVENATE.get()) {
            float might = CombatData.getCap((LivingEntity)caster).getMight();
            int duration = this.getDuration(might) * 20;
            caster.func_195064_c(new EffectInstance(Effects.field_76428_l, duration));
            if (might > 7.0f) {
                caster.func_195064_c(new EffectInstance(Effects.field_76429_m, duration));
                caster.func_195064_c(new EffectInstance(Effects.field_76444_x, duration, 1));
            } else {
                caster.func_195064_c(new EffectInstance(Effects.field_76444_x, duration));
            }
            this.markUsed(caster);
        }
        CombatData.getCap((LivingEntity)caster).setMight(0.0f);
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof LivingHealEvent && procPoint.getPhase() == EventPriority.HIGHEST) {
            ((LivingHealEvent)procPoint).setAmount(((LivingHealEvent)procPoint).getAmount() * 1.5f);
        }
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        if (to == Skill.STATE.HOLSTERED && this.cast(caster, this.getDuration(CombatData.getCap((LivingEntity)caster).getMight()))) {
            this.evoke(caster);
        }
        if (to == Skill.STATE.COOLING) {
            prev.setState(Skill.STATE.INACTIVE);
            prev.setDuration(0.0f);
        }
        return this.instantCast(prev, from, to);
    }
}

