/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.skill.warcry;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.warcry.WarCry;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.tags.Tag;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class WindScar
extends WarCry {
    private static final AttributeModifier reach = new AttributeModifier(UUID.fromString("abe24c38-73e3-4551-9df4-e06e117699c1"), "wind scar bonus", 1.0, AttributeModifier.Operation.ADDITION);
    private static final UUID bigReach = UUID.fromString("abe24c38-73e3-4551-9df4-e06e117699c3");
    private final Tag<String> tag = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("chant", "onHurt", "melee", "rechargeWithTime", "rechargeWithSleep")));
    private final Tag<String> no = Tag.func_241286_a_(new HashSet<String>(Arrays.asList("sweep")));

    @Override
    protected void evoke(LivingEntity caster) {
        caster.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_188479_b(bigReach);
        caster.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_233767_b_(new AttributeModifier(bigReach, "wind scar active bonus", (double)CombatData.getCap((LivingEntity)caster).getMight(), AttributeModifier.Operation.ADDITION));
        super.evoke(caster);
    }

    @Override
    public void onEquip(LivingEntity caster) {
        caster.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_233769_c_(reach);
        super.onEquip(caster);
    }

    @Override
    public void onUnequip(LivingEntity caster, SkillData stats) {
        caster.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111124_b(reach);
        caster.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_188479_b(bigReach);
        super.onUnequip(caster, stats);
    }

    @Override
    protected int getDuration(float might) {
        return (int)(3.0f * might);
    }

    @Override
    public void onProc(LivingEntity caster, Event procPoint, Skill.STATE state, SkillData stats, LivingEntity target) {
        if (procPoint instanceof LivingAttackEvent && procPoint.getPhase() == EventPriority.HIGHEST && state == Skill.STATE.ACTIVE && ((LivingAttackEvent)procPoint).getEntityLiving() == target) {
            double realReach = caster.func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get()) - (double)stats.getArbitraryFloat();
            double dist = Math.sqrt(GeneralUtils.getDistSqCompensated((Entity)caster, (Entity)target));
            if (dist > realReach) {
                stats.decrementDuration((float)(dist - realReach));
            }
        }
        super.onProc(caster, procPoint, state, stats, target);
    }

    @Override
    public Color getColor() {
        return Color.GREEN;
    }

    @Override
    protected boolean cast(LivingEntity caster, float duration) {
        return this.cast(caster, null, duration, false, CombatData.getCap((LivingEntity)caster).getMight());
    }

    @Override
    public boolean onStateChange(LivingEntity caster, SkillData prev, Skill.STATE from, Skill.STATE to) {
        if (to == Skill.STATE.COOLING) {
            caster.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_188479_b(bigReach);
        }
        return super.onStateChange(caster, prev, from, to);
    }
}

