/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.utils;

import jackiecrazy.footwork.api.WarAttributes;
import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.capability.resources.ICombatCapability;
import jackiecrazy.footwork.capability.weaponry.CombatManipulator;
import jackiecrazy.footwork.capability.weaponry.ICombatItemCapability;
import jackiecrazy.footwork.event.AttackMightEvent;
import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.api.CombatDamageSource;
import jackiecrazy.wardance.capability.skill.CasterData;
import jackiecrazy.wardance.config.CombatConfig;
import jackiecrazy.wardance.config.GeneralConfig;
import jackiecrazy.wardance.event.ProjectileParryEvent;
import jackiecrazy.wardance.networking.CombatChannel;
import jackiecrazy.wardance.networking.UpdateAttackPacket;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class CombatUtils {
    public static final UUID off = UUID.fromString("8c8028c8-da69-49a2-99cd-f92d7ad22534");
    private static final UUID main = UUID.fromString("8c8028c8-da67-49a2-99cd-f92d7ad22534");
    public static HashMap<ResourceLocation, Float> customPosture = new HashMap();
    public static HashMap<ResourceLocation, MobInfo> parryMap = new HashMap();
    public static HashMap<Item, AttributeModifier[]> armorStats = new HashMap();
    public static HashMap<Item, AttributeModifier[]> shieldStat = new HashMap();
    public static boolean isSweeping = false;
    public static boolean suppress = false;
    private static MeleeInfo DEFAULTMELEE = new MeleeInfo(1.0, 1.0, false, 0, 0.0f);
    private static ProjectileInfo DEFAULTRANGED = new ProjectileInfo(0.1, 1.0, false, false);
    private static HashMap<Item, MeleeInfo> combatList = new HashMap();
    private static HashMap<EntityType, ProjectileInfo> projectileMap = new HashMap();
    private static ArrayList<Item> unarmed = new ArrayList();

    public static void updateItems(List<? extends String> interpretC, List<? extends String> interpretA, List<? extends String> interpretU) {
        String name;
        String[] val;
        DEFAULTMELEE = new MeleeInfo(CombatConfig.defaultMultiplierPostureAttack, CombatConfig.defaultMultiplierPostureDefend, false, CombatConfig.shieldCooldown, CombatConfig.barrierSize);
        combatList = new HashMap();
        armorStats = new HashMap();
        shieldStat = new HashMap();
        unarmed = new ArrayList();
        for (String string : interpretC) {
            val = string.split(",");
            name = val[0];
            double attack = CombatConfig.defaultMultiplierPostureAttack;
            double defend = CombatConfig.defaultMultiplierPostureDefend;
            boolean shield = false;
            if (val.length > 1) {
                try {
                    attack = Float.parseFloat(val[1].trim());
                }
                catch (NumberFormatException ignored) {
                    WarDance.LOGGER.warn("attack data for config entry " + string + " is not properly formatted, replacing with default values.");
                }
            }
            if (val.length > 2) {
                try {
                    defend = Float.parseFloat(val[2].trim());
                }
                catch (NumberFormatException ignored) {
                    WarDance.LOGGER.warn("defense data for config entry " + string + " is not properly formatted, replacing with default values.");
                }
            }
            if (val.length > 3) {
                shield = Boolean.parseBoolean(val[3].trim());
            }
            int pTime = CombatConfig.shieldCooldown;
            float pCount = CombatConfig.barrierSize;
            if (shield) {
                try {
                    pTime = Integer.parseInt(val[4].trim());
                    pCount = Float.parseFloat(val[5].trim());
                }
                catch (Exception e) {
                    WarDance.LOGGER.warn("additional data for shield config entry " + string + " is not properly formatted, replacing with default values.");
                }
            }
            ResourceLocation key = null;
            try {
                key = new ResourceLocation(name);
            }
            catch (Exception e) {
                WarDance.LOGGER.warn(name + " is not a proper item name, it will not be registered.");
            }
            if (!ForgeRegistries.ITEMS.containsKey(key)) continue;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(key);
            combatList.put(item, new MeleeInfo(attack, defend, shield, pTime, pCount));
            if (!shield) continue;
            AttributeModifier downtimeM = new AttributeModifier(main, "extra downtime", (double)pTime, AttributeModifier.Operation.ADDITION);
            AttributeModifier barrierM = new AttributeModifier(main, "barrier bonus", (double)pCount, AttributeModifier.Operation.ADDITION);
            AttributeModifier downtimeO = new AttributeModifier(off, "extra downtime", (double)pTime, AttributeModifier.Operation.ADDITION);
            AttributeModifier barrierO = new AttributeModifier(off, "barrier bonus", (double)pCount, AttributeModifier.Operation.ADDITION);
            shieldStat.put(item, new AttributeModifier[]{downtimeM, barrierM, downtimeO, barrierO});
        }
        for (String string : interpretA) {
            val = string.split(",");
            name = val[0];
            double absorption = 0.0;
            double deflection = 0.0;
            double shatter = 0.0;
            double stealth = 0.0;
            try {
                absorption = Double.parseDouble(val[1]);
                deflection = Double.parseDouble(val[2]);
                shatter = Double.parseDouble(val[3]);
                stealth = Double.parseDouble(val[4]);
            }
            catch (Exception ignored) {
                WarDance.LOGGER.warn("armor data for config entry " + string + " is not properly formatted, filling in zeros.");
            }
            ResourceLocation key = null;
            try {
                key = new ResourceLocation(name);
            }
            catch (Exception e) {
                WarDance.LOGGER.warn(name + " is not a proper item name, it will not be registered.");
            }
            if (!ForgeRegistries.ITEMS.containsKey(key) || !(ForgeRegistries.ITEMS.getValue(key) instanceof ArmorItem)) continue;
            Item armor = (Item)ForgeRegistries.ITEMS.getValue(key);
            UUID touse = WarAttributes.MODIFIERS[((ArmorItem)armor).func_185083_B_().func_188454_b()];
            armorStats.put(armor, new AttributeModifier[]{new AttributeModifier(touse, "war dance modifier", absorption, AttributeModifier.Operation.ADDITION), new AttributeModifier(touse, "war dance modifier", deflection, AttributeModifier.Operation.ADDITION), new AttributeModifier(touse, "war dance modifier", shatter, AttributeModifier.Operation.ADDITION), new AttributeModifier(touse, "war dance modifier", stealth, AttributeModifier.Operation.ADDITION)});
        }
        for (String string : interpretU) {
            ResourceLocation key = null;
            try {
                key = new ResourceLocation(string);
            }
            catch (Exception e) {
                WarDance.LOGGER.warn(string + " is not a proper item name, it will not be registered.");
            }
            if (!ForgeRegistries.ITEMS.containsKey(key)) continue;
            unarmed.add((Item)ForgeRegistries.ITEMS.getValue(key));
        }
    }

    public static void updateProjectiles(List<? extends String> interpretP) {
        projectileMap.clear();
        DEFAULTRANGED = new ProjectileInfo(CombatConfig.posturePerProjectile, 1.0, false, false);
        for (String string : interpretP) {
            try {
                EntityType type;
                String[] val = string.split(",");
                ResourceLocation key = new ResourceLocation(val[0].trim());
                double posture = Double.parseDouble(val[1].trim());
                double count = Double.parseDouble(val[2].trim());
                boolean destroy = false;
                boolean trigger = false;
                if (val.length > 3) {
                    String tags = val[3];
                    destroy = tags.contains("d");
                    trigger = tags.contains("t");
                }
                if ((type = (EntityType)ForgeRegistries.ENTITIES.getValue(key)) == null) continue;
                projectileMap.put(type, new ProjectileInfo(posture, count, destroy, trigger));
            }
            catch (Exception e) {
                WarDance.LOGGER.warn("improperly formatted projectile parry definition " + string + "!");
            }
        }
    }

    public static void updateMobParrying(List<? extends String> interpretM) {
        parryMap.clear();
        for (String string : interpretM) {
            try {
                String[] val = string.split(",");
                if (val.length < 4) {
                    parryMap.put(new ResourceLocation(val[0]), new MobInfo(Float.parseFloat(val[1]), Float.parseFloat(val[2]), false, false));
                    continue;
                }
                parryMap.put(new ResourceLocation(val[0]), new MobInfo(Float.parseFloat(val[1]), Float.parseFloat(val[2]), val[3].contains("o"), val[3].contains("s")));
            }
            catch (Exception e) {
                WarDance.LOGGER.warn("improperly formatted mob parrying definition " + string + "!");
            }
        }
    }

    public static void updateMobPosture(List<? extends String> interpretP) {
        customPosture.clear();
        for (String string : interpretP) {
            try {
                String[] val = string.split(",");
                customPosture.put(new ResourceLocation(val[0]), Float.valueOf(Float.parseFloat(val[1])));
            }
            catch (Exception e) {
                WarDance.LOGGER.warn("improperly formatted custom posture definition " + string + "!");
            }
        }
    }

    public static void attack(LivingEntity from, Entity to, boolean offhand) {
        if (offhand) {
            CombatUtils.swapHeldItems(from);
            CombatData.getCap((LivingEntity)from).setOffhandAttack(true);
        }
        if (from.field_184617_aD > 0) {
            int temp = from.field_184617_aD;
            if (from instanceof PlayerEntity) {
                ((PlayerEntity)from).func_71059_n(to);
            } else {
                from.func_70652_k(to);
            }
            from.field_184617_aD = temp;
        }
        if (offhand) {
            CombatUtils.swapHeldItems(from);
            CombatData.getCap((LivingEntity)from).setOffhandAttack(false);
        }
    }

    public static float getCooledAttackStrength(LivingEntity e, Hand h, float adjustTicks) {
        if (!(e instanceof PlayerEntity) && h == Hand.MAIN_HAND) {
            return 1.0f;
        }
        return MathHelper.func_76131_a((float)(((float)(h == Hand.MAIN_HAND ? e.field_184617_aD : CombatData.getCap((LivingEntity)e).getOffhandCooldown()) + adjustTicks) / (float)CombatUtils.getCooldownPeriod(e, h)), (float)0.0f, (float)1.0f);
    }

    public static int getCooldownPeriod(LivingEntity e, Hand h) {
        return (int)(1.0 / GeneralUtils.getAttributeValueHandSensitive((LivingEntity)e, (Attribute)Attributes.field_233825_h_, (Hand)h) * 20.0);
    }

    public static boolean isShield(LivingEntity e, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return combatList.containsKey(stack.func_77973_b()) && combatList.getOrDefault(stack.func_77973_b(), DEFAULTMELEE).isShield;
    }

    public static boolean isWeapon(@Nullable LivingEntity e, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (e != null && CasterData.getCap(e).getCategoryState(SkillCategories.shield_bash) == Skill.STATE.HOLSTERED) {
            return combatList.containsKey(stack.func_77973_b());
        }
        return combatList.containsKey(stack.func_77973_b()) && !combatList.getOrDefault(stack.func_77973_b(), DEFAULTMELEE).isShield;
    }

    public static boolean isUnarmed(ItemStack is, LivingEntity e) {
        return is.func_190926_b() || unarmed.contains(is.func_77973_b());
    }

    public static boolean canParry(LivingEntity defender, Entity attacker, @Nonnull ItemStack i, float postureDamage) {
        Hand h;
        Hand hand = h = defender.func_184592_cb() == i ? Hand.OFF_HAND : Hand.MAIN_HAND;
        if (postureDamage < 0.0f) {
            return false;
        }
        if (attacker instanceof LivingEntity && CombatUtils.getPostureDef((LivingEntity)attacker, defender, i, postureDamage) < 0.0f) {
            return false;
        }
        if (defender instanceof PlayerEntity && ((PlayerEntity)defender).func_184811_cZ().func_185141_a(i.func_77973_b())) {
            return false;
        }
        if (CombatData.getCap((LivingEntity)defender).getHandBind(h) > 0) {
            return false;
        }
        float rand = WarDance.rand.nextFloat();
        boolean recharge = CombatUtils.getCooledAttackStrength(defender, h, 0.5f) > 0.9f && CombatData.getCap((LivingEntity)defender).getHandBind(h) == 0;
        recharge &= !(defender instanceof PlayerEntity) || ((PlayerEntity)defender).func_184811_cZ().func_185143_a(defender.func_184586_b(h).func_77973_b(), 0.0f) == 0.0f;
        if (i.getCapability(CombatManipulator.CAP).isPresent() && attacker instanceof LivingEntity) {
            return ((ICombatItemCapability)i.getCapability(CombatManipulator.CAP).resolve().get()).canBlock(defender, attacker, i, recharge, postureDamage);
        }
        if (CombatUtils.isShield(defender, i)) {
            boolean canShield = defender instanceof PlayerEntity || rand < CombatConfig.mobParryChanceShield + CombatData.getCap((LivingEntity)defender).getHandReel(h);
            boolean canParry = true;
            return recharge & canParry & canShield;
        }
        if (CombatUtils.isWeapon(defender, i)) {
            boolean canWeapon = defender instanceof PlayerEntity || rand < CombatConfig.mobParryChanceWeapon + CombatData.getCap((LivingEntity)defender).getHandReel(h);
            return recharge & canWeapon;
        }
        return false;
    }

    @Nullable
    public static ItemStack getAttackingItemStack(DamageSource ds) {
        if (ds instanceof CombatDamageSource) {
            return ((CombatDamageSource)ds).getDamageDealer();
        }
        if (ds.func_76346_g() instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)ds.func_76346_g();
            return e.func_184614_ca();
        }
        return null;
    }

    public static Tuple<Integer, Float> getShieldStats(ItemStack stack) {
        if (stack != null && combatList.containsKey(stack.func_77973_b())) {
            return new Tuple((Object)combatList.get(stack.func_77973_b()).parryTime, (Object)Float.valueOf(combatList.get(stack.func_77973_b()).parryCount));
        }
        return new Tuple((Object)CombatConfig.shieldCooldown, (Object)Float.valueOf(CombatConfig.barrierSize));
    }

    public static float getPostureAtk(@Nullable LivingEntity attacker, @Nullable LivingEntity defender, @Nullable Hand h, float amount, ItemStack stack) {
        float base = amount * (float)DEFAULTMELEE.attackPostureMultiplier;
        if (attacker != null && attacker.func_184585_cz()) {
            h = attacker.func_184600_cs();
            stack = attacker.func_184586_b(h);
        }
        float scaler = CombatConfig.mobScaler;
        if (stack != null && !stack.func_190926_b()) {
            scaler = 1.0f;
            if (stack.getCapability(CombatManipulator.CAP).isPresent()) {
                base = ((ICombatItemCapability)stack.getCapability(CombatManipulator.CAP).resolve().get()).postureDealtBase(attacker, defender, stack, amount);
            } else if (combatList.containsKey(stack.func_77973_b())) {
                base = (float)combatList.get(stack.func_77973_b()).attackPostureMultiplier;
            }
        } else if (!(attacker instanceof PlayerEntity)) {
            base = CombatData.getCap((LivingEntity)attacker).getMaxPosture() * CombatConfig.defaultMultiplierPostureMob;
        }
        if (attacker == null || h == null) {
            return base;
        }
        float fin = attacker instanceof PlayerEntity ? Math.max(CombatData.getCap((LivingEntity)attacker).getCachedCooldown(), ((PlayerEntity)attacker).func_184825_o(0.5f)) : scaler;
        return base * fin;
    }

    public static float getPostureDef(@Nullable LivingEntity attacker, @Nullable LivingEntity defender, ItemStack stack, float amount) {
        if (stack == null) {
            return (float)DEFAULTMELEE.defensePostureMultiplier;
        }
        if (stack.getCapability(CombatManipulator.CAP).isPresent()) {
            return ((ICombatItemCapability)stack.getCapability(CombatManipulator.CAP).resolve().get()).postureMultiplierDefend((Entity)attacker, defender, stack, amount);
        }
        if (combatList.containsKey(stack.func_77973_b())) {
            return (float)combatList.get(stack.func_77973_b()).defensePostureMultiplier;
        }
        return (float)DEFAULTMELEE.defensePostureMultiplier;
    }

    public static boolean isMeleeAttack(DamageSource s) {
        if (s instanceof CombatDamageSource) {
            return ((CombatDamageSource)s).canProcAutoEffects();
        }
        return s.func_76346_g() == s.func_76364_f() && !s.func_94541_c() && !s.func_76347_k() && !s.func_82725_o() && !s.func_76363_c() && !s.func_76352_a();
    }

    public static float getAttackMight(LivingEntity seme, LivingEntity uke) {
        ICombatCapability semeCap = CombatData.getCap((LivingEntity)seme);
        float magicScale = 1.722f;
        float magicNumber = 781.25f;
        float cooldownSq = semeCap.getCachedCooldown() * semeCap.getCachedCooldown();
        double period = 20.0 / (seme.func_110148_a(Attributes.field_233825_h_).func_111126_e() + 0.5);
        float might = cooldownSq * cooldownSq * 1.722f * (float)period * (float)period / 781.25f;
        might *= 1.0f + semeCap.getRank() / 20.0f;
        float weakness = 1.0f;
        if (seme.func_70644_a(Effects.field_76437_t)) {
            for (int foo = 0; foo < seme.func_70660_b(Effects.field_76437_t).func_76458_c() + 1; ++foo) {
                weakness *= GeneralConfig.weakness;
            }
        }
        AttackMightEvent ame = new AttackMightEvent(seme, uke, might *= weakness);
        MinecraftForge.EVENT_BUS.post((Event)ame);
        return ame.getQuantity();
    }

    public static boolean isPhysicalAttack(DamageSource s) {
        if (s instanceof CombatDamageSource) {
            CombatDamageSource cds = (CombatDamageSource)s;
            return cds.getDamageTyping() == CombatDamageSource.TYPE.PHYSICAL;
        }
        return !s.func_94541_c() && !s.func_76347_k() && !s.func_82725_o() && !s.func_76363_c();
    }

    public static boolean isTrueDamage(DamageSource s) {
        if (s instanceof CombatDamageSource) {
            CombatDamageSource cds = (CombatDamageSource)s;
            return cds.getDamageTyping() == CombatDamageSource.TYPE.TRUE;
        }
        return s.func_76357_e() || s.func_151517_h() && s.func_76363_c();
    }

    public static void knockBack(Entity to, Entity from, float strength, boolean considerRelativeAngle, boolean bypassAllChecks) {
        Vector3d distVec = to.func_213303_ch().func_72441_c(0.0, (double)(to.func_213302_cg() / 2.0f), 0.0).func_72444_a(from.func_213303_ch().func_72441_c(0.0, (double)(from.func_213302_cg() / 2.0f), 0.0)).func_216372_d(1.0, 0.5, 1.0).func_72432_b();
        if (to instanceof LivingEntity && !bypassAllChecks) {
            if (considerRelativeAngle) {
                CombatUtils.knockBack((LivingEntity)to, from, strength, distVec.field_72450_a, distVec.field_72448_b, distVec.field_72449_c, false);
            } else {
                CombatUtils.knockBack((LivingEntity)to, from, strength * 0.5f, MathHelper.func_76126_a((float)(from.field_70177_z * ((float)Math.PI / 180))), 0.0, -MathHelper.func_76134_b((float)(from.field_70177_z * ((float)Math.PI / 180))), false);
            }
        } else {
            if (considerRelativeAngle) {
                to.func_70016_h(distVec.field_72450_a * (double)(-strength), to.field_70124_G ? 0.1 : distVec.field_72448_b * (double)(-strength), distVec.field_72449_c * (double)(-strength));
            } else {
                to.func_70024_g((double)(-MathHelper.func_76126_a((float)(-from.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI))) * 0.5, 0.1, (double)(-MathHelper.func_76134_b((float)(-from.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI))) * 0.5);
            }
            to.field_70133_I = true;
        }
    }

    public static void knockBack(LivingEntity to, Entity from, float strength, double xRatio, double yRatio, double zRatio, boolean bypassEventCheck) {
        if (!bypassEventCheck) {
            LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)to, (float)strength, (double)xRatio, (double)zRatio);
            if (event.isCanceled()) {
                return;
            }
            strength = event.getStrength();
            xRatio = event.getRatioX();
            zRatio = event.getRatioZ();
        }
        if ((strength *= (float)Math.max(0.0, 1.0 - GeneralUtils.getAttributeValueSafe((LivingEntity)to, (Attribute)Attributes.field_233820_c_))) != 0.0f) {
            Vector3d vec = to.func_213322_ci();
            double motionX = vec.field_72450_a;
            double motionY = vec.field_72448_b;
            double motionZ = vec.field_72449_c;
            to.field_70160_al = true;
            float pythagora = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
            if (to.func_233570_aj_()) {
                motionY /= 2.0;
                if ((motionY += (double)strength) > (double)0.4f) {
                    motionY = 0.4f;
                }
            } else if (yRatio != 0.0) {
                pythagora = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio + yRatio * yRatio));
                motionY /= 2.0;
                motionY -= yRatio / (double)pythagora * (double)strength;
            }
            motionX /= 2.0;
            motionZ /= 2.0;
            to.func_213293_j(motionX -= xRatio / (double)pythagora * (double)strength, motionY, motionZ -= zRatio / (double)pythagora * (double)strength);
            to.field_70133_I = true;
        }
    }

    public static void setHandCooldown(LivingEntity e, Hand h, float percent, boolean sync) {
        int real = percent == 0.0f ? 0 : (int)(percent * (float)CombatUtils.getCooldownPeriod(e, h));
        switch (h) {
            case MAIN_HAND: {
                if (!(e instanceof PlayerEntity)) {
                    return;
                }
                e.field_184617_aD = real;
                if (e instanceof FakePlayer || !(e instanceof ServerPlayerEntity) || !sync) break;
                CombatChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)e), (Object)new UpdateAttackPacket(e.func_145782_y(), real));
                break;
            }
            case OFF_HAND: {
                CombatData.getCap((LivingEntity)e).setOffhandCooldown(real);
            }
        }
    }

    public static void setHandCooldownDirect(LivingEntity e, Hand h, int amount, boolean sync) {
        switch (h) {
            case MAIN_HAND: {
                if (!(e instanceof PlayerEntity)) {
                    return;
                }
                e.field_184617_aD = amount;
                if (e instanceof FakePlayer || !(e instanceof ServerPlayerEntity) || !sync) break;
                CombatChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)e), (Object)new UpdateAttackPacket(e.func_145782_y(), amount));
                break;
            }
            case OFF_HAND: {
                CombatData.getCap((LivingEntity)e).setOffhandCooldown(amount);
            }
        }
    }

    public static void swapHeldItems(LivingEntity e) {
        ItemStack main = e.func_184614_ca();
        ItemStack off = e.func_184592_cb();
        int tssl = e.field_184617_aD;
        suppress = true;
        ICombatCapability cap = CombatData.getCap((LivingEntity)e);
        e.func_184611_a(Hand.MAIN_HAND, e.func_184592_cb());
        e.func_184611_a(Hand.OFF_HAND, main);
        suppress = false;
        main.func_111283_C(EquipmentSlotType.MAINHAND).forEach((att, mod) -> Optional.ofNullable(e.func_110148_a(att)).ifPresent(mai -> mai.func_111124_b(mod)));
        off.func_111283_C(EquipmentSlotType.OFFHAND).forEach((att, mod) -> Optional.ofNullable(e.func_110148_a(att)).ifPresent(mai -> mai.func_111124_b(mod)));
        main.func_111283_C(EquipmentSlotType.OFFHAND).forEach((att, mod) -> Optional.ofNullable(e.func_110148_a(att)).ifPresent(mai -> mai.func_233767_b_(mod)));
        off.func_111283_C(EquipmentSlotType.MAINHAND).forEach((att, mod) -> Optional.ofNullable(e.func_110148_a(att)).ifPresent(mai -> mai.func_233767_b_(mod)));
        e.field_184617_aD = cap.getOffhandCooldown();
        cap.setOffhandCooldown(tssl);
    }

    public static void sweep(LivingEntity e, Entity ignore, Hand h, double reach) {
        int angle;
        if (!GeneralConfig.betterSweep) {
            return;
        }
        if (!CombatData.getCap((LivingEntity)e).isCombatMode()) {
            return;
        }
        if (CombatData.getCap((LivingEntity)e).getForcedSweep() == 0) {
            CombatData.getCap((LivingEntity)e).setForcedSweep(-1);
            return;
        }
        if (h == Hand.OFF_HAND) {
            CombatUtils.swapHeldItems(e);
            CombatData.getCap((LivingEntity)e).setOffhandAttack(true);
        }
        int n = angle = CombatData.getCap((LivingEntity)e).getForcedSweep() > 0 ? CombatData.getCap((LivingEntity)e).getForcedSweep() : EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_191530_r, (LivingEntity)e) * GeneralConfig.sweepAngle;
        if (e.func_184614_ca().getCapability(CombatManipulator.CAP).isPresent()) {
            angle = ((ICombatItemCapability)e.func_184614_ca().getCapability(CombatManipulator.CAP).resolve().get()).sweepArea(e, e.func_184614_ca());
        }
        float charge = Math.max(CombatUtils.getCooledAttackStrength(e, Hand.MAIN_HAND, 0.5f), CombatData.getCap((LivingEntity)e).getCachedCooldown());
        boolean hit = false;
        isSweeping = ignore != null;
        double modRange = Math.min((double)GeneralConfig.maxRange, (double)GeneralConfig.baseRange + (reach - 3.0) * GeneralConfig.rangeMult);
        for (Entity target : e.field_70170_p.func_72839_b((Entity)e, e.func_174813_aQ().func_186662_g(modRange + 3.0))) {
            if (target == ignore) {
                if (angle <= 0) continue;
                hit = true;
                continue;
            }
            if (!GeneralUtils.isFacingEntity((Entity)e, (Entity)target, (int)angle) || !e.func_70685_l(target) || GeneralUtils.getDistSqCompensated((Entity)e, (Entity)target) > modRange * modRange) continue;
            CombatUtils.setHandCooldown(e, Hand.MAIN_HAND, charge, false);
            hit = true;
            if (e instanceof PlayerEntity) {
                ((PlayerEntity)e).func_71059_n(target);
            } else {
                e.func_70652_k(target);
            }
            isSweeping = true;
        }
        if (e instanceof PlayerEntity && hit) {
            ((PlayerEntity)e).func_184810_cG();
            e.field_70170_p.func_184148_a(null, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), SoundEvents.field_187730_dW, e.func_184176_by(), 1.0f, 1.0f);
        }
        isSweeping = false;
        if (h == Hand.OFF_HAND) {
            CombatUtils.swapHeldItems(e);
            CombatData.getCap((LivingEntity)e).setOffhandAttack(false);
        }
        CombatData.getCap((LivingEntity)e).setForcedSweep(-1);
    }

    public static boolean isCrit(CriticalHitEvent e) {
        return e.getResult() == Event.Result.ALLOW || e.getResult() == Event.Result.DEFAULT && e.isVanillaCritical();
    }

    public static void initializePPE(ProjectileParryEvent ppe, float mult) {
        ProjectileInfo pi = projectileMap.getOrDefault(ppe.getProjectile().func_200600_R(), DEFAULTRANGED);
        ppe.setReturnVec(pi.destroy ? null : ppe.getProjectile().func_213322_ci().func_72432_b().func_186678_a(-0.1));
        ppe.setPostureConsumption((float)pi.posture * mult);
        ppe.setTrigger(pi.trigger);
    }

    public static class MobInfo {
        public final double mult;
        public final double chance;
        public final boolean omnidirectional;
        public final boolean shield;

        private MobInfo(double m, double c, boolean o, boolean s) {
            this.mult = m;
            this.chance = c;
            this.omnidirectional = o;
            this.shield = s;
        }
    }

    private static class ProjectileInfo {
        private final double posture;
        private final double count;
        private final boolean destroy;
        private final boolean trigger;

        private ProjectileInfo(double p, double c, boolean d, boolean t) {
            this.posture = p;
            this.count = c;
            this.destroy = d;
            this.trigger = t;
        }
    }

    private static class MeleeInfo {
        private final double attackPostureMultiplier;
        private final double defensePostureMultiplier;
        private final int parryTime;
        private final float parryCount;
        private final boolean isShield;

        private MeleeInfo(double attack, double defend, boolean shield, int pTime, float pCount) {
            this.attackPostureMultiplier = attack;
            this.defensePostureMultiplier = defend;
            this.isShield = shield;
            this.parryCount = pCount;
            this.parryTime = pTime;
        }
    }
}

