/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.utils;

import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.capability.resources.ICombatCapability;
import jackiecrazy.footwork.event.DodgeEvent;
import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.wardance.compat.WarCompat;
import jackiecrazy.wardance.config.CombatConfig;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class MovementUtils {
    public static boolean hasInvFrames(LivingEntity elb) {
        return CombatData.getCap((LivingEntity)elb).getRollTime() > CombatConfig.rollEndsAt || CombatData.getCap((LivingEntity)elb).getRollTime() < 0;
    }

    public static boolean attemptSlide(LivingEntity elb) {
        if (!elb.func_233570_aj_()) {
            return false;
        }
        ICombatCapability itsc = CombatData.getCap((LivingEntity)elb);
        if (!itsc.isCombatMode()) {
            return false;
        }
        DodgeEvent e = new DodgeEvent(elb, DodgeEvent.Direction.FORWARD, 1.5);
        MinecraftForge.EVENT_BUS.post((Event)e);
        if (e.isCanceled()) {
            return false;
        }
        Vector3d v = elb.func_70040_Z().func_178786_a(0.0, elb.func_70040_Z().field_72448_b, 0.0).func_72432_b().func_186678_a(e.getForce());
        itsc.consumePosture(0.0f);
        itsc.setRollTime(CombatConfig.rollCooldown);
        if (elb instanceof PlayerEntity) {
            ((PlayerEntity)elb).setForcedPose(Pose.SLEEPING);
        }
        elb.func_70031_b(false);
        elb.func_213293_j(v.field_72450_a, 0.0, v.field_72449_c);
        elb.field_70133_I = true;
        return true;
    }

    public static boolean attemptDodge(LivingEntity elb, int side) {
        ICombatCapability itsc = CombatData.getCap((LivingEntity)elb);
        if (!CombatConfig.dodge) {
            return false;
        }
        if (!(itsc.isCombatMode() || WarCompat.elenaiDodge && itsc.getStaggerTime() != 0)) {
            return false;
        }
        if (itsc.getRollTime() == 0) {
            if (side == 99) {
                return MovementUtils.attemptSlide(elb);
            }
            itsc.setRollTime(CombatConfig.rollCooldown);
            double x = 0.0;
            double y = 0.3;
            double z = 0.0;
            DodgeEvent.Direction d = DodgeEvent.Direction.FORWARD;
            switch (side) {
                case 0: {
                    x = MathHelper.func_76134_b((float)GeneralUtils.rad((float)elb.field_70177_z));
                    z = MathHelper.func_76126_a((float)GeneralUtils.rad((float)elb.field_70177_z));
                    d = DodgeEvent.Direction.LEFT;
                    break;
                }
                case 1: {
                    x = MathHelper.func_76134_b((float)GeneralUtils.rad((float)(elb.field_70177_z - 90.0f)));
                    z = MathHelper.func_76126_a((float)GeneralUtils.rad((float)(elb.field_70177_z - 90.0f)));
                    d = DodgeEvent.Direction.BACK;
                    break;
                }
                case 2: {
                    x = MathHelper.func_76134_b((float)GeneralUtils.rad((float)(elb.field_70177_z - 180.0f)));
                    z = MathHelper.func_76126_a((float)GeneralUtils.rad((float)(elb.field_70177_z - 180.0f)));
                    d = DodgeEvent.Direction.RIGHT;
                    break;
                }
                case 3: {
                    x = MathHelper.func_76134_b((float)GeneralUtils.rad((float)(elb.field_70177_z + 90.0f)));
                    z = MathHelper.func_76126_a((float)GeneralUtils.rad((float)(elb.field_70177_z + 90.0f)));
                    d = DodgeEvent.Direction.FORWARD;
                }
            }
            DodgeEvent e = new DodgeEvent(elb, d, 1.5);
            MinecraftForge.EVENT_BUS.post((Event)e);
            if (e.isCanceled()) {
                return false;
            }
            elb.func_70024_g(x *= e.getForce(), y, z *= e.getForce());
            elb.field_70133_I = true;
            itsc.consumePosture(0.0f);
            return true;
        }
        return false;
    }
}

