/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.client.gui.screens.extension;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import net.luis.xbackpack.client.gui.screens.BackpackScreen;
import net.luis.xbackpack.world.capability.BackpackProvider;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.extension.BackpackExtensions;
import net.luis.xbackpack.world.extension.ExtensionState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class AbstractExtensionScreen {
    protected final BackpackScreen screen;
    protected final BackpackExtension extension;
    protected final List<BackpackExtension> extensions;
    protected Minecraft minecraft;
    protected ItemRenderer itemRenderer;
    protected Font font;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;

    protected AbstractExtensionScreen(BackpackScreen screen, BackpackExtension extension, List<BackpackExtension> extensions) {
        this.screen = screen;
        this.extension = extension;
        this.extensions = extensions;
    }

    public final void init(Minecraft minecraft, ItemRenderer itemRenderer, Font font, int imageWidth, int imageHeight, int leftPos, int topPos) {
        this.minecraft = minecraft;
        this.itemRenderer = itemRenderer;
        this.font = font;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.leftPos = leftPos;
        this.topPos = topPos;
        if (this.minecraft != null) {
            this.init();
        }
    }

    protected void init() {
    }

    protected boolean canUseExtension(BackpackExtension extension) {
        return BackpackProvider.get((Player)this.minecraft.f_91074_).getConfig().getWithState(ExtensionState.UNLOCKED).contains((Object)extension);
    }

    protected int getExtensionOffset(BackpackExtension extension) {
        int offset = 3;
        for (BackpackExtension backpackExtension : this.extensions) {
            if (backpackExtension == extension) break;
            offset += extension.getIconHeight() + 2;
        }
        return offset;
    }

    protected boolean isExtensionRenderable(BackpackExtension extension) {
        if (this.extension == BackpackExtensions.NO.get()) {
            return true;
        }
        if (this.extensions.indexOf((Object)this.extension) > this.extensions.indexOf((Object)extension)) {
            return true;
        }
        return this.getExtensionOffset(extension) > this.getExtensionOffset(this.extension) + this.extension.getImageHeight();
    }

    protected boolean isInExtension(BackpackExtension extension, double mouseX, double mouseY) {
        if (this.extension == extension || this.isExtensionRenderable(extension)) {
            double topX = this.leftPos + this.imageWidth;
            double topY = this.topPos + this.getExtensionOffset(extension);
            if (topX + (double)extension.getIconWidth() >= mouseX && mouseX >= topX && topY + (double)extension.getIconHeight() >= mouseY && mouseY >= topY) {
                return true;
            }
        }
        return false;
    }

    protected ResourceLocation getTexture() {
        ResourceLocation location = BackpackExtensions.REGISTRY.get().getKey((IForgeRegistryEntry)this.extension);
        return new ResourceLocation(location.m_135827_(), "textures/gui/container/" + location.m_135815_() + "_extension.png");
    }

    public void render(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        int offset = this.getExtensionOffset(this.extension);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BackpackScreen.ICONS);
        GuiComponent.m_93160_((PoseStack)stack, (int)(this.leftPos + this.imageWidth), (int)(this.topPos + offset), (int)this.extension.getIconWidth(), (int)this.extension.getIconHeight(), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
        this.itemRenderer.m_115203_(this.extension.getIcon(), this.leftPos + this.imageWidth + 1, this.topPos + 3 + offset);
    }

    public void renderOpened(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        int offset = this.getExtensionOffset(this.extension);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTexture());
        this.screen.m_93228_(stack, this.leftPos + this.imageWidth - 3, this.topPos + offset, 0, 0, this.extension.getImageWidth(), this.extension.getImageHeight());
        this.itemRenderer.m_115203_(this.extension.getIcon(), this.leftPos + this.imageWidth + 1, this.topPos + 4 + offset);
        this.font.m_92889_(stack, this.extension.getTitle(), (float)(this.leftPos + this.imageWidth + 19), (float)(this.topPos + 9 + offset), 0x404040);
        if (this.minecraft != null) {
            this.renderAdditional(stack, partialTicks, mouseX, mouseY, true);
        }
    }

    protected void renderAdditional(PoseStack stack, float partialTicks, int mouseX, int mouseY, boolean open) {
    }

    public void renderTooltip(PoseStack stack, int mouseX, int mouseY, boolean open, Consumer<ItemStack> tooltipRenderer) {
        if (this.isInExtension(this.extension, mouseX, mouseY) && !open) {
            this.screen.m_96602_(stack, this.extension.getTooltip(), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        return false;
    }

    public BackpackExtension getExtension() {
        return this.extension;
    }
}

