/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.luis.xbackpack.server.commands.arguments.BackpackExtensionArgument;
import net.luis.xbackpack.server.commands.arguments.ExtensionStateArgument;
import net.luis.xbackpack.world.capability.BackpackProvider;
import net.luis.xbackpack.world.capability.IBackpack;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.extension.ExtensionState;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class BackpackCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"backpack").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"extension", (ArgumentType)BackpackExtensionArgument.extension()).then(Commands.m_82127_((String)"get").executes(command -> BackpackCommand.getExtensionState((CommandSourceStack)command.getSource(), Lists.newArrayList((Iterable)EntityArgument.m_91477_((CommandContext)command, (String)"players")), BackpackExtensionArgument.get(command, "extension"))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"state", (ArgumentType)ExtensionStateArgument.state()).executes(command -> BackpackCommand.setExtensionState((CommandSourceStack)command.getSource(), Lists.newArrayList((Iterable)EntityArgument.m_91477_((CommandContext)command, (String)"players")), BackpackExtensionArgument.get(command, "extension"), ExtensionStateArgument.get(command, "state"))))))));
    }

    private static int getExtensionState(CommandSourceStack source, List<ServerPlayer> players, BackpackExtension extension) {
        if (players.size() > 1) {
            source.m_81352_((Component)new TranslatableComponent("xbackpack.commands.backpack.get_failure"));
        } else {
            ServerPlayer player = players.get(0);
            source.m_81354_((Component)new TranslatableComponent("xbackpack.commands.backpack.get_success", new Object[]{extension, player.m_7755_().getString(), BackpackProvider.get((Player)player).getConfig().getState(extension).getName()}), false);
        }
        return 1;
    }

    private static int setExtensionState(CommandSourceStack source, List<ServerPlayer> players, BackpackExtension extension, ExtensionState state) {
        int i = 0;
        for (ServerPlayer player : players) {
            IBackpack backpack = BackpackProvider.get((Player)player);
            if (backpack.getConfig().setState(extension, state)) {
                ++i;
            }
            backpack.broadcastChanges();
        }
        if (players.size() > 0) {
            source.m_81354_((Component)new TranslatableComponent("xbackpack.commands.backpack.set_success", new Object[]{extension, i, state.getName()}), false);
        }
        return 1;
    }
}

