/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.server.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.extension.BackpackExtensions;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

public class BackpackExtensionArgument
implements ArgumentType<BackpackExtension> {
    private static final Dynamic2CommandExceptionType INVALID_BACKPACK_EXTENSION = new Dynamic2CommandExceptionType((name, dummyObject) -> new TranslatableComponent("xbackpack.commands.arguments.extension.invalid", new Object[]{name}));
    private final Supplier<IForgeRegistry<BackpackExtension>> registrySupplier = BackpackExtensions.REGISTRY;

    private BackpackExtensionArgument() {
    }

    public static BackpackExtensionArgument extension() {
        return new BackpackExtensionArgument();
    }

    public static <S> BackpackExtension get(CommandContext<S> context, String name) {
        return (BackpackExtension)((Object)context.getArgument(name, BackpackExtension.class));
    }

    public BackpackExtension parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation location = ResourceLocation.m_135818_((StringReader)reader);
        if (location != null && this.registrySupplier.get().containsKey(location)) {
            return (BackpackExtension)this.registrySupplier.get().getValue(location);
        }
        throw INVALID_BACKPACK_EXTENSION.create((Object)location, (Object)"");
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82981_(this.registrySupplier.get().getKeys().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return this.registrySupplier.get().getKeys().stream().map(ResourceLocation::toString).collect(Collectors.toList());
    }
}

