/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import net.luis.xbackpack.BackpackConstans;
import net.luis.xbackpack.XBackpack;
import net.luis.xbackpack.world.capability.BackpackProvider;
import net.luis.xbackpack.world.capability.IBackpack;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.extension.BackpackExtensions;
import net.luis.xbackpack.world.inventory.XBMenuTypes;
import net.luis.xbackpack.world.inventory.extension.AbstractExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.AnvilExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.BrewingStandExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.CraftingExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.EnchantmentTableExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.ExtensionMenuHolder;
import net.luis.xbackpack.world.inventory.extension.ExtensionMenuRegistry;
import net.luis.xbackpack.world.inventory.extension.FurnaceExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.GrindstoneExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.SmithingTableExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.StonecutterExtensionMenu;
import net.luis.xbackpack.world.inventory.handler.BrewingHandler;
import net.luis.xbackpack.world.inventory.handler.EnchantingHandler;
import net.luis.xbackpack.world.inventory.slot.BackpackArmorSlot;
import net.luis.xbackpack.world.inventory.slot.BackpackOffhandSlot;
import net.luis.xbackpack.world.inventory.slot.BackpackSlot;
import net.luis.xbackpack.world.inventory.slot.BackpackToolSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BackpackMenu
extends AbstractContainerMenu
implements ExtensionMenuHolder {
    private final List<AbstractExtensionMenu> extensionMenus = Lists.newArrayList();
    private BackpackExtension extension = (BackpackExtension)((Object)BackpackExtensions.NO.get());

    public BackpackMenu(int id, Inventory inventory, FriendlyByteBuf byteBuf) {
        this(id, inventory);
    }

    public BackpackMenu(int id, Inventory inventory) {
        super((MenuType)XBMenuTypes.BACKPACK_MENU.get(), id);
        int j;
        int i;
        Player player = inventory.f_35978_;
        IBackpack backpack = BackpackProvider.get(player);
        ItemStackHandler handler = backpack.getBackpackHandler();
        for (i = 0; i < handler.getSlots() / 9; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_((Slot)new BackpackSlot((IItemHandler)handler, j + i * 9, 30 + j * 18, 18 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 30 + j * 18, 138 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 30 + i * 18, 196));
        }
        this.m_38897_((Slot)new BackpackToolSlot((IItemHandler)backpack.getToolHandler(), 0, 196, 138));
        this.m_38897_((Slot)new BackpackToolSlot((IItemHandler)backpack.getToolHandler(), 1, 196, 156));
        this.m_38897_((Slot)new BackpackToolSlot((IItemHandler)backpack.getToolHandler(), 2, 196, 174));
        this.m_38897_(new BackpackArmorSlot(inventory, EquipmentSlot.HEAD, 39, 8, 18));
        this.m_38897_(new BackpackArmorSlot(inventory, EquipmentSlot.CHEST, 38, 8, 36));
        this.m_38897_(new BackpackArmorSlot(inventory, EquipmentSlot.LEGS, 37, 8, 54));
        this.m_38897_(new BackpackArmorSlot(inventory, EquipmentSlot.FEET, 36, 8, 72));
        this.m_38897_(new BackpackOffhandSlot((Container)inventory, 40, 8, 196));
        this.extensionMenus.add(ExtensionMenuRegistry.getExtensionMenu((BackpackExtension)((Object)BackpackExtensions.CRAFTING_TABLE.get()), this, player, CraftingExtensionMenu::new));
        this.extensionMenus.add(ExtensionMenuRegistry.getExtensionMenu((BackpackExtension)((Object)BackpackExtensions.FURNACE.get()), this, player, FurnaceExtensionMenu::new));
        this.extensionMenus.add(ExtensionMenuRegistry.getExtensionMenu((BackpackExtension)((Object)BackpackExtensions.ANVIL.get()), this, player, AnvilExtensionMenu::new));
        this.extensionMenus.add(ExtensionMenuRegistry.getExtensionMenu((BackpackExtension)((Object)BackpackExtensions.ENCHANTMENT_TABLE.get()), this, player, EnchantmentTableExtensionMenu::new));
        this.extensionMenus.add(ExtensionMenuRegistry.getExtensionMenu((BackpackExtension)((Object)BackpackExtensions.STONECUTTER.get()), this, player, StonecutterExtensionMenu::new));
        this.extensionMenus.add(ExtensionMenuRegistry.getExtensionMenu((BackpackExtension)((Object)BackpackExtensions.BREWING_STAND.get()), this, player, BrewingStandExtensionMenu::new));
        this.extensionMenus.add(ExtensionMenuRegistry.getExtensionMenu((BackpackExtension)((Object)BackpackExtensions.GRINDSTONE.get()), this, player, GrindstoneExtensionMenu::new));
        this.extensionMenus.add(ExtensionMenuRegistry.getExtensionMenu((BackpackExtension)((Object)BackpackExtensions.SMITHING_TABLE.get()), this, player, SmithingTableExtensionMenu::new));
        this.extensionMenus.forEach(extensionMenu -> extensionMenu.addSlots(x$0 -> this.m_38897_((Slot)x$0)));
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            if (872 >= index && index >= 0) {
                stack = slotStack.m_41777_();
                if (this.extension == BackpackExtensions.CRAFTING_TABLE.get() ? !this.m_38903_(slotStack, 917, 927, false) && !this.moveInventory(slotStack) : (this.extension == BackpackExtensions.FURNACE.get() ? (FurnaceExtensionMenu.canSmelt(player, slotStack) ? !this.m_38903_(slotStack, 931, 932, false) && !this.m_38903_(slotStack, 927, 931, false) && !this.moveInventory(slotStack) : (FurnaceExtensionMenu.isFuel(slotStack) || slotStack.m_150930_(Items.f_42446_)) && !this.m_38903_(slotStack, 932, 933, false) && !this.moveInventory(slotStack)) : (this.extension == BackpackExtensions.ANVIL.get() ? !this.m_38903_(slotStack, 938, 940, false) && !this.moveInventory(slotStack) : (this.extension == BackpackExtensions.ENCHANTMENT_TABLE.get() ? (slotStack.m_204117_(Tags.Items.BOOKSHELVES) || this.canQuickMoveBook(player) && slotStack.m_41720_() instanceof BookItem ? !this.m_38903_(slotStack, 941, 942, false) && !this.moveInventory(slotStack) : (slotStack.m_41792_() || slotStack.m_41720_() instanceof BookItem ? !this.m_38903_(slotStack, 942, 943, false) && !this.moveInventory(slotStack) : slotStack.m_204117_(Tags.Items.ENCHANTING_FUELS) && !this.m_38903_(slotStack, 943, 944, false) && !this.moveInventory(slotStack))) : (this.extension == BackpackExtensions.STONECUTTER.get() ? player.f_19853_.m_7465_().m_44015_(RecipeType.f_44112_, (Container)new SimpleContainer(new ItemStack[]{slotStack}), player.f_19853_).isPresent() && !this.m_38903_(slotStack, 944, 945, false) && !this.moveInventory(slotStack) : (this.extension == BackpackExtensions.BREWING_STAND.get() ? (slotStack.m_150930_(Items.f_42593_) && this.canQuickMovePowder(player) ? !this.m_38903_(slotStack, 947, 948, false) && !this.moveInventory(slotStack) : (BrewingRecipeRegistry.isValidIngredient((ItemStack)slotStack) ? !this.m_38903_(slotStack, 946, 947, false) && !this.moveInventory(slotStack) : BrewingRecipeRegistry.isValidInput((ItemStack)slotStack) && !this.m_38903_(slotStack, 948, 451, false) && !this.moveInventory(slotStack))) : (this.extension == BackpackExtensions.GRINDSTONE.get() ? (slotStack.m_41763_() || slotStack.m_150930_(Items.f_42690_) || slotStack.m_41793_()) && !this.m_38903_(slotStack, 951, 953, false) && !this.moveInventory(slotStack) : (this.extension == BackpackExtensions.SMITHING_TABLE.get() ? (this.canQuickMoveIngredient(player, slotStack) ? !this.m_38903_(slotStack, 955, 956, false) && !this.moveInventory(slotStack) : !this.m_38903_(slotStack, 954, 955, false) && !this.moveInventory(slotStack)) : !this.moveInventory(slotStack))))))))) {
                    return ItemStack.f_41583_;
                }
            } else if (908 >= index && index >= 873) {
                stack = slotStack.m_41777_();
                if (BackpackConstans.VALID_TOOL_SLOT_ITEMS.contains(slotStack.m_41720_())) {
                    if (!this.m_38903_(slotStack, 909, 912, false) && !this.m_38903_(slotStack, 0, 873, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (BackpackConstans.SHIFTABLE_OFFHAND_SLOT_ITEMS.contains(slotStack.m_41720_())) {
                    if (!this.m_38903_(slotStack, 916, 917, false) && !this.m_38903_(slotStack, 0, 873, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (BackpackConstans.VALID_ARMOR_SLOT_ITEMS.contains(slotStack.m_41720_())) {
                    if (!this.m_38903_(slotStack, 912, 916, false) && !this.m_38903_(slotStack, 0, 873, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (this.extension == BackpackExtensions.CRAFTING_TABLE.get()) {
                    if (!this.m_38903_(slotStack, 917, 927, false) && !this.m_38903_(slotStack, 0, 873, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (this.extension == BackpackExtensions.FURNACE.get()) {
                    if (FurnaceExtensionMenu.canSmelt(player, slotStack) ? !this.m_38903_(slotStack, 931, 932, false) && !this.m_38903_(slotStack, 927, 931, false) && !this.m_38903_(slotStack, 0, 873, false) : (FurnaceExtensionMenu.isFuel(slotStack) || slotStack.m_150930_(Items.f_42446_)) && !this.m_38903_(slotStack, 932, 933, false) && !this.m_38903_(slotStack, 0, 873, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (this.extension == BackpackExtensions.ANVIL.get()) {
                    if (!this.m_38903_(slotStack, 938, 940, false) && !this.m_38903_(slotStack, 0, 873, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (this.extension == BackpackExtensions.ENCHANTMENT_TABLE.get()) {
                    if (slotStack.m_204117_(Tags.Items.BOOKSHELVES) || this.canQuickMoveBook(player) && slotStack.m_41720_() instanceof BookItem ? !this.m_38903_(slotStack, 941, 942, false) && !this.m_38903_(slotStack, 0, 873, false) : (slotStack.m_41792_() || slotStack.m_41720_() instanceof BookItem ? !this.m_38903_(slotStack, 942, 943, false) && !this.m_38903_(slotStack, 0, 873, false) : slotStack.m_204117_(Tags.Items.ENCHANTING_FUELS) && !this.m_38903_(slotStack, 943, 944, false) && !this.m_38903_(slotStack, 0, 873, false))) {
                        return ItemStack.f_41583_;
                    }
                } else if (this.extension == BackpackExtensions.STONECUTTER.get()) {
                    if (player.f_19853_.m_7465_().m_44015_(RecipeType.f_44112_, (Container)new SimpleContainer(new ItemStack[]{slotStack}), player.f_19853_).isPresent() && !this.m_38903_(slotStack, 944, 945, false) && !this.m_38903_(slotStack, 0, 873, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (this.extension == BackpackExtensions.BREWING_STAND.get()) {
                    if (slotStack.m_150930_(Items.f_42593_) && this.canQuickMovePowder(player)) {
                        if (!this.m_38903_(slotStack, 947, 948, false) && !this.m_38903_(slotStack, 0, 873, false)) {
                            return ItemStack.f_41583_;
                        }
                    } else if (BrewingRecipeRegistry.isValidIngredient((ItemStack)slotStack)) {
                        if (!this.m_38903_(slotStack, 946, 947, false) && !this.m_38903_(slotStack, 0, 873, false)) {
                            return ItemStack.f_41583_;
                        }
                    } else if (BrewingRecipeRegistry.isValidInput((ItemStack)slotStack)) {
                        XBackpack.LOGGER.info("isValidInput");
                        if (!this.m_38903_(slotStack, 948, 451, false) && !this.m_38903_(slotStack, 0, 873, false)) {
                            return ItemStack.f_41583_;
                        }
                    }
                } else if (this.extension == BackpackExtensions.GRINDSTONE.get() ? (slotStack.m_41763_() || slotStack.m_150930_(Items.f_42690_) || slotStack.m_41793_()) && !this.m_38903_(slotStack, 951, 953, false) && !this.m_38903_(slotStack, 0, 873, false) : (this.extension == BackpackExtensions.SMITHING_TABLE.get() ? (this.canQuickMoveIngredient(player, slotStack) ? !this.m_38903_(slotStack, 955, 956, false) && !this.m_38903_(slotStack, 0, 873, false) : !this.m_38903_(slotStack, 954, 955, false) && !this.m_38903_(slotStack, 0, 873, false)) : !this.m_38903_(slotStack, 0, 873, false))) {
                    return ItemStack.f_41583_;
                }
            } else if (916 >= index && index >= 909) {
                stack = slotStack.m_41777_();
                if (!(this.m_38903_(slotStack, 900, 909, false) || this.m_38903_(slotStack, 873, 900, false) || this.m_38903_(slotStack, 0, 873, false))) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (index == 940) {
                    return ItemStack.f_41583_;
                }
                if (956 >= index && index >= 917) {
                    stack = slotStack.m_41777_();
                    if (!(this.m_38903_(slotStack, 0, 873, false) || this.m_38903_(slotStack, 873, 900, false) || this.m_38903_(slotStack, 900, 909, false))) {
                        return ItemStack.f_41583_;
                    }
                }
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_142406_(player, slotStack);
        }
        return stack;
    }

    private boolean moveInventory(ItemStack slotStack) {
        return this.m_38903_(slotStack, 900, 909, false) || this.m_38903_(slotStack, 873, 900, false);
    }

    private boolean canQuickMoveBook(Player player) {
        EnchantingHandler handler = BackpackProvider.get(player).getEnchantingHandler();
        if (!handler.getInputHandler().getStackInSlot(0).m_41619_()) {
            ItemStack stack = handler.getPowerHandler().getStackInSlot(0);
            return stack.m_41619_() || stack.m_150930_(Items.f_42517_) && stack.m_41741_() > stack.m_41613_();
        }
        return false;
    }

    private boolean canQuickMovePowder(Player player) {
        BrewingHandler handler = BackpackProvider.get(player).getBrewingHandler();
        ItemStack stack = handler.getFuelHandler().getStackInSlot(0);
        return stack.m_41619_() || stack.m_150930_(Items.f_42593_) && stack.m_41741_() > stack.m_41613_();
    }

    private boolean canQuickMoveIngredient(Player player, ItemStack stack) {
        return player.f_19853_.m_7465_().m_44013_(RecipeType.f_44113_).stream().anyMatch(recipe -> recipe.m_44535_(stack));
    }

    public boolean requiresTickUpdate() {
        return this.extensionMenus.stream().filter(AbstractExtensionMenu::requiresTickUpdate).findAny().isPresent();
    }

    public void tick() {
        this.extensionMenus.stream().filter(AbstractExtensionMenu::requiresTickUpdate).forEach(AbstractExtensionMenu::slotsChanged);
    }

    public void m_6199_(Container container) {
        super.m_6199_(container);
        this.extensionMenus.forEach(extensionMenu -> extensionMenu.slotsChanged(container));
    }

    public boolean m_6366_(Player player, int button) {
        AbstractExtensionMenu extensionMenu = this.getExtensionMenu(this.extension);
        if (extensionMenu != null) {
            return extensionMenu.clickMenuButton(player, button);
        }
        return super.m_6366_(player, button);
    }

    public BackpackExtension getExtension() {
        return this.extension;
    }

    public void setExtension(BackpackExtension extension) {
        AbstractExtensionMenu extensionMenu;
        if (this.extension != extension && (extensionMenu = this.getExtensionMenu(this.extension)) != null) {
            extensionMenu.close();
        }
        this.extension = extension;
        extensionMenu = this.getExtensionMenu(this.extension);
        if (extensionMenu != null) {
            extensionMenu.open();
        }
    }

    @Override
    public List<AbstractExtensionMenu> getExtensionMenus() {
        return ImmutableList.copyOf(this.extensionMenus);
    }

    @Override
    public AbstractExtensionMenu getExtensionMenu(BackpackExtension extension) {
        for (AbstractExtensionMenu extensionMenu : this.extensionMenus) {
            if (extensionMenu.getExtension() != extension) continue;
            return extensionMenu;
        }
        return null;
    }
}

