/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.inventory.extension;

import java.util.function.Consumer;
import net.luis.xbackpack.world.capability.BackpackProvider;
import net.luis.xbackpack.world.capability.IBackpack;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.extension.BackpackExtensions;
import net.luis.xbackpack.world.inventory.BackpackMenu;
import net.luis.xbackpack.world.inventory.extension.AbstractExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.slot.ExtensionSlot;
import net.luis.xbackpack.world.inventory.handler.BrewingHandler;
import net.luis.xbackpack.world.inventory.handler.progress.ProgressHandler;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;

public class BrewingStandExtensionMenu
extends AbstractExtensionMenu {
    private final BrewingHandler handler;
    private final ProgressHandler progressHandler;

    public BrewingStandExtensionMenu(BackpackMenu menu, Player player) {
        super(menu, player, (BackpackExtension)((Object)BackpackExtensions.BREWING_STAND.get()));
        IBackpack backpack = BackpackProvider.get(player);
        this.handler = backpack.getBrewingHandler();
        this.progressHandler = backpack.getBrewHandler();
    }

    @Override
    public void open() {
        this.progressHandler.broadcastChanges();
    }

    @Override
    public void addSlots(Consumer<Slot> consumer) {
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getInputHandler(), 0, 277, 146){

            public boolean m_5857_(ItemStack stack) {
                return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
            }
        });
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getFuelHandler(), 0, 225, 146){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42593_);
            }
        });
        for (int i = 0; i < 3; ++i) {
            consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getResultHandler(), i, 254 + i * 23, i == 1 ? 187 : 180){

                public boolean m_5857_(ItemStack stack) {
                    return BrewingRecipeRegistry.isValidInput((ItemStack)stack);
                }

                public int m_6641_() {
                    return 1;
                }

                public void m_142406_(Player player, ItemStack stack) {
                    BrewingStandExtensionMenu.this.onTake(player, stack);
                    super.m_142406_(player, stack);
                }
            });
        }
    }

    private void onTake(Player player, ItemStack stack) {
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ForgeEventFactory.onPlayerBrewedPotion((Player)player, (ItemStack)stack);
            CriteriaTriggers.f_10577_.m_19120_(serverPlayer, potion);
        }
    }
}

