/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.inventory.extension;

import com.google.common.collect.Maps;
import java.util.Map;
import net.luis.xbackpack.XBackpack;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.extension.BackpackExtensions;
import net.luis.xbackpack.world.inventory.BackpackMenu;
import net.luis.xbackpack.world.inventory.extension.AbstractExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.ExtensionMenuFactory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ExtensionMenuRegistry {
    private static final Map<BackpackExtension, ExtensionMenuFactory> EXTENSION_FACTORIES = Maps.newHashMap();

    public static AbstractExtensionMenu getExtensionMenu(BackpackExtension extension, BackpackMenu menu, Player player, ExtensionMenuFactory fallbackFactory) {
        return EXTENSION_FACTORIES.getOrDefault((Object)extension, fallbackFactory).create(menu, player);
    }

    public static void registerOverride(BackpackExtension extension, String modid, ExtensionMenuFactory factory) {
        if (EXTENSION_FACTORIES.containsKey((Object)extension)) {
            XBackpack.LOGGER.error("Fail to register Extension Menu override for Mod {} of type {}, since there is already a Extension Menu present", (Object)modid, (Object)BackpackExtensions.REGISTRY.get().getKey((IForgeRegistryEntry)extension));
        } else {
            EXTENSION_FACTORIES.put(extension, factory);
        }
    }
}

