/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.inventory.extension;

import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.luis.xbackpack.world.capability.BackpackProvider;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.extension.BackpackExtensions;
import net.luis.xbackpack.world.inventory.BackpackMenu;
import net.luis.xbackpack.world.inventory.extension.AbstractExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.slot.ExtensionSlot;
import net.luis.xbackpack.world.inventory.handler.CraftingHandler;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class GrindstoneExtensionMenu
extends AbstractExtensionMenu {
    private final CraftingHandler handler;

    public GrindstoneExtensionMenu(BackpackMenu menu, Player player) {
        super(menu, player, (BackpackExtension)((Object)BackpackExtensions.GRINDSTONE.get()));
        this.handler = BackpackProvider.get(this.player).getGrindstoneHandler();
    }

    @Override
    public void open() {
        this.createResult();
    }

    @Override
    public void addSlots(Consumer<Slot> consumer) {
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getInputHandler(), 0, 243, 172){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41763_() || stack.m_150930_(Items.f_42690_) || stack.m_41793_();
            }
        });
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getInputHandler(), 1, 243, 193){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41763_() || stack.m_150930_(Items.f_42690_) || stack.m_41793_();
            }
        });
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getResultHandler(), 0, 305, 187, false){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                GrindstoneExtensionMenu.this.onTake(player, stack);
            }
        });
    }

    private void onTake(Player player, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player.m_6756_(this.getExperienceAmount(player.f_19853_));
            this.playSound(serverPlayer, serverPlayer.m_183503_());
        }
        this.handler.getInputHandler().setStackInSlot(0, ItemStack.f_41583_);
        this.handler.getInputHandler().setStackInSlot(1, ItemStack.f_41583_);
    }

    private int getExperienceAmount(Level level) {
        int amount = 0;
        amount += this.getExperienceFromItem(this.handler.getInputHandler().getStackInSlot(0));
        if ((amount += this.getExperienceFromItem(this.handler.getInputHandler().getStackInSlot(1))) > 0) {
            int experience = (int)Math.ceil((double)amount / 2.0);
            return experience + level.f_46441_.nextInt(experience);
        }
        return 0;
    }

    private int getExperienceFromItem(ItemStack stack) {
        int experience = 0;
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Map.Entry entry : enchantments.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            if (enchantment.m_6589_()) continue;
            experience += enchantment.m_6183_(((Integer)entry.getValue()).intValue());
        }
        return experience;
    }

    private void playSound(ServerPlayer player, ServerLevel level) {
        player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_11998_, SoundSource.BLOCKS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, level.f_46441_.nextFloat() * 0.1f + 0.9f));
    }

    @Override
    public void slotsChanged() {
        this.createResult();
    }

    private void createResult() {
        boolean hasInputs;
        ItemStack topStack = this.handler.getInputHandler().getStackInSlot(0);
        ItemStack bottomStack = this.handler.getInputHandler().getStackInSlot(1);
        boolean hasInput = !topStack.m_41619_() || !bottomStack.m_41619_();
        boolean bl = hasInputs = !topStack.m_41619_() && !bottomStack.m_41619_();
        if (!hasInput) {
            this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
        } else {
            ItemStack resultStack;
            int damageValue;
            boolean hasEnchantedBook;
            boolean bl2 = hasEnchantedBook = !topStack.m_41619_() && !topStack.m_150930_(Items.f_42690_) && !topStack.m_41793_() || !bottomStack.m_41619_() && !bottomStack.m_150930_(Items.f_42690_) && !bottomStack.m_41793_();
            if (topStack.m_41613_() > 1 || bottomStack.m_41613_() > 1) {
                this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
                this.menu.m_38946_();
                return;
            }
            if (!hasInputs && hasEnchantedBook) {
                this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
                this.menu.m_38946_();
                return;
            }
            int count = 1;
            if (hasInputs) {
                if (!topStack.m_150930_(bottomStack.m_41720_())) {
                    this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
                    this.menu.m_38946_();
                    return;
                }
                int k = topStack.m_41776_() - topStack.m_41773_();
                int l = topStack.m_41776_() - bottomStack.m_41773_();
                int i1 = k + l + topStack.m_41776_() * 5 / 100;
                damageValue = Math.max(topStack.m_41776_() - i1, 0);
                resultStack = this.mergeEnchants(topStack, bottomStack);
                if (!resultStack.isRepairable()) {
                    damageValue = topStack.m_41773_();
                }
                if (!resultStack.m_41763_() || !resultStack.isRepairable()) {
                    if (!ItemStack.m_41728_((ItemStack)topStack, (ItemStack)bottomStack)) {
                        this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
                        this.menu.m_38946_();
                        return;
                    }
                    count = 2;
                }
            } else {
                boolean topEmpty = !topStack.m_41619_();
                damageValue = topEmpty ? topStack.m_41773_() : bottomStack.m_41773_();
                resultStack = topEmpty ? topStack : bottomStack;
            }
            this.handler.getResultHandler().setStackInSlot(0, this.removeNonCurses(resultStack, damageValue, count));
        }
        this.menu.m_38946_();
    }

    private ItemStack mergeEnchants(ItemStack firstStack, ItemStack secondStack) {
        ItemStack resultStack = firstStack.m_41777_();
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)secondStack);
        for (Map.Entry entry : enchantments.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            if (enchantment.m_6589_() && EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)resultStack) != 0) continue;
            resultStack.m_41663_(enchantment, ((Integer)entry.getValue()).intValue());
        }
        return resultStack;
    }

    private ItemStack removeNonCurses(ItemStack inputStack, int damageValue, int count) {
        ItemStack resultStack = inputStack.m_41777_();
        resultStack.m_41749_("Enchantments");
        resultStack.m_41749_("StoredEnchantments");
        if (damageValue > 0) {
            resultStack.m_41721_(damageValue);
        } else {
            resultStack.m_41749_("Damage");
        }
        resultStack.m_41764_(count);
        Map<Enchantment, Integer> enchantments = EnchantmentHelper.m_44831_((ItemStack)inputStack).entrySet().stream().filter(entry -> ((Enchantment)entry.getKey()).m_6589_()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.m_44865_(enchantments, (ItemStack)resultStack);
        resultStack.m_41742_(0);
        if (resultStack.m_150930_(Items.f_42690_) && enchantments.size() == 0) {
            resultStack = new ItemStack((ItemLike)Items.f_42517_);
            if (inputStack.m_41788_()) {
                resultStack.m_41714_(inputStack.m_41786_());
            }
        }
        for (int i = 0; i < enchantments.size(); ++i) {
            resultStack.m_41742_(AnvilMenu.m_39025_((int)resultStack.m_41610_()));
        }
        return resultStack;
    }
}

