/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.inventory.extension;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.luis.xbackpack.world.capability.BackpackProvider;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.extension.BackpackExtensions;
import net.luis.xbackpack.world.inventory.BackpackMenu;
import net.luis.xbackpack.world.inventory.extension.AbstractExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.slot.ExtensionSlot;
import net.luis.xbackpack.world.inventory.handler.CraftingHandler;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class SmithingTableExtensionMenu
extends AbstractExtensionMenu {
    private final CraftingHandler handler;
    private final Level level;
    private UpgradeRecipe selectedRecipe;

    public SmithingTableExtensionMenu(BackpackMenu menu, Player player) {
        super(menu, player, (BackpackExtension)((Object)BackpackExtensions.SMITHING_TABLE.get()));
        this.handler = BackpackProvider.get(this.player).getSmithingHandler();
        this.level = this.player.f_19853_;
    }

    @Override
    public void open() {
        this.createResult();
    }

    @Override
    public void addSlots(Consumer<Slot> consumer) {
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getInputHandler(), 0, 225, 193));
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getInputHandler(), 1, 260, 193));
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getResultHandler(), 0, 304, 193, false){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player player) {
                return SmithingTableExtensionMenu.this.mayPickup(player);
            }

            public void m_142406_(Player player, ItemStack stack) {
                SmithingTableExtensionMenu.this.onTake(player, stack);
                super.m_142406_(player, stack);
            }
        });
    }

    private boolean mayPickup(Player player) {
        return this.selectedRecipe != null && this.selectedRecipe.m_5818_((Container)this.asContainer(), this.level);
    }

    private void onTake(Player player, ItemStack stack) {
        stack.m_41678_(player.f_19853_, player, stack.m_41613_());
        if (this.selectedRecipe != null) {
            player.m_7281_(Collections.singleton(this.selectedRecipe));
        }
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.playSound(serverPlayer, serverPlayer.m_183503_());
        }
    }

    private void shrinkStackInSlot(int slot) {
        ItemStack stack = this.handler.getInputHandler().getStackInSlot(slot);
        stack.m_41774_(1);
        this.handler.getInputHandler().setStackInSlot(slot, stack);
    }

    private void playSound(ServerPlayer player, ServerLevel level) {
        player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12471_, SoundSource.BLOCKS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, level.f_46441_.nextFloat() * 0.1f + 0.9f));
    }

    @Override
    public void slotsChanged() {
        this.createResult();
    }

    private void createResult() {
        List recipes = this.level.m_7465_().m_44056_(RecipeType.f_44113_, (Container)this.asContainer(), this.level);
        if (recipes.isEmpty()) {
            this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
        } else {
            this.selectedRecipe = (UpgradeRecipe)recipes.get(0);
            ItemStack stack = this.selectedRecipe.m_5874_((Container)this.asContainer());
            this.handler.getResultHandler().setStackInSlot(0, stack);
        }
    }

    private SimpleContainer asContainer() {
        return new SimpleContainer(new ItemStack[]{this.handler.getInputHandler().getStackInSlot(0), this.handler.getInputHandler().getStackInSlot(1)});
    }
}

