/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.inventory.handler.progress;

import net.luis.xbackpack.network.XBNetworkHandler;
import net.luis.xbackpack.network.packet.extension.UpdateBrewingStandExtension;
import net.luis.xbackpack.world.inventory.handler.BrewingHandler;
import net.luis.xbackpack.world.inventory.handler.progress.ProgressHandler;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BrewingProgressHandler
implements ProgressHandler {
    private final Player player;
    private final BrewingHandler handler;
    private Item input;
    private int fuel;
    private int brewTime;

    public BrewingProgressHandler(Player player, BrewingHandler handler) {
        this.player = player;
        this.handler = handler;
    }

    @Override
    public void tick() {
        ItemStack fuelStack = this.getFuelItem();
        if (0 >= this.fuel && fuelStack.m_150930_(Items.f_42593_)) {
            this.fuel = 20;
            this.handler.getFuelHandler().extractItem(0, 1, false);
            this.broadcastChanges();
        }
        ItemStack inputStack = this.getInputItem();
        if (this.brewTime > 0) {
            --this.brewTime;
            if (this.brewTime == 0 && this.isBrewable()) {
                this.brewPotion();
            } else if (!this.isBrewable() || !inputStack.m_150930_(this.input)) {
                this.brewTime = 0;
            }
            this.broadcastChanges();
        } else if (this.isBrewable() && this.fuel > 0) {
            --this.fuel;
            this.brewTime = 400;
            this.input = inputStack.m_41720_();
            this.broadcastChanges();
        }
    }

    private boolean isBrewable() {
        ItemStack inputStack = this.getInputItem();
        if (!inputStack.m_41619_()) {
            for (int i = 0; i < 3; ++i) {
                if (!BrewingRecipeRegistry.hasOutput((ItemStack)this.getResultHandler().getStackInSlot(i), (ItemStack)inputStack)) continue;
                return true;
            }
        }
        return false;
    }

    private void brewPotion() {
        if (!this.onPotionAttemptBrew()) {
            ItemStack inputStack = this.getInputItem();
            for (int i = 0; i < 3; ++i) {
                this.getResultHandler().setStackInSlot(i, BrewingRecipeRegistry.getOutput((ItemStack)this.getResultHandler().getStackInSlot(i), (ItemStack)inputStack));
            }
            this.onPotionBrewed(this.asList());
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                this.playSound(player2, player2.m_183503_());
            }
            if (inputStack.hasContainerItem()) {
                ItemStack remainingStack = inputStack.getContainerItem();
                inputStack.m_41774_(1);
                if (inputStack.m_41619_()) {
                    inputStack = remainingStack;
                } else {
                    Containers.m_18992_((Level)this.player.f_19853_, (double)this.player.m_20185_(), (double)this.player.m_20186_(), (double)this.player.m_20189_(), (ItemStack)remainingStack);
                }
            } else {
                inputStack.m_41774_(1);
            }
            this.handler.getInputHandler().setStackInSlot(0, inputStack);
        }
    }

    private ItemStack getInputItem() {
        return this.handler.getInputHandler().getStackInSlot(0);
    }

    private NonNullList<ItemStack> getInputList() {
        NonNullList stacks = NonNullList.m_122780_((int)this.handler.getInputHandler().getSlots(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < stacks.size(); ++i) {
            stacks.set(i, (Object)this.handler.getInputHandler().getStackInSlot(i));
        }
        return stacks;
    }

    private ItemStack getFuelItem() {
        return this.handler.getFuelHandler().getStackInSlot(0);
    }

    private ItemStackHandler getResultHandler() {
        return this.handler.getResultHandler();
    }

    private void playSound(ServerPlayer player, ServerLevel level) {
        player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_11772_, SoundSource.BLOCKS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, level.f_46441_.nextFloat() * 0.1f + 0.9f));
    }

    private NonNullList<ItemStack> asList() {
        NonNullList stacks = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
        for (int i = 0; i < 3; ++i) {
            stacks.set(i, (Object)this.getResultHandler().getStackInSlot(i));
        }
        stacks.set(3, (Object)this.getInputItem());
        stacks.set(4, (Object)this.getFuelItem());
        return stacks;
    }

    private boolean onPotionAttemptBrew() {
        NonNullList<ItemStack> inputStacks = this.getInputList();
        NonNullList<ItemStack> eventStacks = this.getInputList();
        PotionBrewEvent.Pre event = new PotionBrewEvent.Pre(eventStacks);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            boolean changed = false;
            for (int x = 0; x < inputStacks.size(); ++x) {
                changed |= ItemStack.m_41728_((ItemStack)((ItemStack)eventStacks.get(x)), (ItemStack)((ItemStack)inputStacks.get(x)));
                inputStacks.set(x, (Object)event.getItem(x));
            }
            if (changed) {
                this.onPotionBrewed(inputStacks);
            }
            return true;
        }
        return false;
    }

    private void onPotionBrewed(NonNullList<ItemStack> stacks) {
        ForgeEventFactory.onPotionBrewed(stacks);
    }

    @Override
    public void broadcastChanges() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            XBNetworkHandler.sendToPlayer(player2, new UpdateBrewingStandExtension(this.fuel, this.brewTime));
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("input", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.input).toString());
        tag.m_128405_("fuel", this.fuel);
        tag.m_128405_("brew_time", this.brewTime);
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.input = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)tag.m_128461_("input")));
        this.fuel = tag.m_128451_("fuel");
        this.brewTime = tag.m_128451_("brew_time");
    }
}

