/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.client.gui.screens.extension;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.luis.xbackpack.client.gui.screens.BackpackScreen;
import net.luis.xbackpack.client.gui.screens.extension.AbstractExtensionScreen;
import net.luis.xbackpack.world.capability.IBackpack;
import net.luis.xbackpack.world.capability.XBackpackCapabilities;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.inventory.BackpackMenu;
import net.luis.xbackpack.world.inventory.extension.AbstractExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.AnvilExtensionMenu;
import net.luis.xbackpack.world.inventory.handler.CraftingHandler;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class AnvilExtensionScreen
extends AbstractExtensionScreen {
    private CraftingHandler handler;
    private int cost;

    public AnvilExtensionScreen(BackpackScreen screen, List<BackpackExtension> extensions) {
        super(screen, (BackpackExtension)BackpackExtension.ANVIL.get(), extensions);
    }

    @Override
    protected void init() {
        this.handler = ((IBackpack)this.minecraft.f_91074_.getCapability(XBackpackCapabilities.BACKPACK, null).orElseThrow(NullPointerException::new)).getAnvilHandler();
    }

    @Override
    protected void renderAdditional(PoseStack stack, float partialTicks, int mouseX, int mouseY, boolean open) {
        if (open) {
            if (this.shouldRenderCanceled()) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTexture());
                this.screen.m_93228_(stack, this.leftPos + this.imageWidth + 59, this.topPos + 71, 111, 0, 22, 21);
            }
            this.renderLabels(stack);
        }
    }

    private boolean shouldRenderCanceled() {
        if (!this.handler.getInputHandler().getStackInSlot(0).m_41619_() || !this.handler.getInputHandler().getStackInSlot(1).m_41619_()) {
            return this.handler.getResultHandler().getStackInSlot(0).m_41619_();
        }
        return false;
    }

    private void renderLabels(PoseStack stack) {
        RenderSystem.m_69461_();
        AbstractExtensionMenu abstractExtensionMenu = ((BackpackMenu)this.screen.m_6262_()).getExtensionMenu(this.extension);
        if (abstractExtensionMenu instanceof AnvilExtensionMenu) {
            AnvilExtensionMenu menu = (AnvilExtensionMenu)abstractExtensionMenu;
            if (this.cost > 0) {
                int color = 8453920;
                MutableComponent component = null;
                if (this.cost >= 40 && !this.minecraft.f_91074_.m_150110_().f_35937_) {
                    component = Component.m_237110_((String)"xbackpack.backpack_extension.anvil.cost", (Object[])new Object[]{"X"});
                    color = 0xFF6060;
                } else if (this.handler.getResultHandler().getStackInSlot(0).m_41619_()) {
                    component = null;
                } else if (this.minecraft != null) {
                    component = Component.m_237110_((String)"xbackpack.backpack_extension.anvil.cost", (Object[])new Object[]{this.cost});
                    if (!menu.mayPickup((Player)this.minecraft.f_91074_)) {
                        color = 0xFF6060;
                    }
                }
                if (component != null) {
                    int x = this.leftPos + this.imageWidth + 64;
                    int y = this.topPos + 9 + this.getExtensionOffset(this.extension);
                    if (this.cost >= 40 || 10 > this.cost) {
                        GuiComponent.m_93172_((PoseStack)stack, (int)(x - 2), (int)(y - 2), (int)(x + this.font.m_92852_((FormattedText)component) + 2), (int)(y + 10), (int)0x4F000000);
                        this.font.m_92763_(stack, (Component)component, (float)x, (float)y, color);
                    } else {
                        GuiComponent.m_93172_((PoseStack)stack, (int)(x - 8), (int)(y - 2), (int)(x + this.font.m_92852_((FormattedText)component) - 4), (int)(y + 10), (int)0x4F000000);
                        this.font.m_92763_(stack, (Component)component, (float)(x - 6), (float)y, color);
                    }
                }
            }
        }
    }

    public void update(int cost) {
        this.cost = cost;
    }
}

