/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.capability;

import net.luis.xbackpack.world.capability.BackpackHandler;
import net.luis.xbackpack.world.capability.IBackpack;
import net.luis.xbackpack.world.capability.XBackpackCapabilities;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class BackpackProvider
implements ICapabilitySerializable<CompoundTag> {
    private final Player player;
    private final BackpackHandler handler;
    private final LazyOptional<IBackpack> optional;

    public BackpackProvider(Player player) {
        this.player = player;
        this.handler = new BackpackHandler(this.player);
        this.optional = LazyOptional.of(() -> this.handler);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        return XBackpackCapabilities.BACKPACK.orEmpty(capability, this.optional);
    }

    public CompoundTag serializeNBT() {
        return this.handler.serialize();
    }

    public void deserializeNBT(CompoundTag tag) {
        this.handler.deserialize(tag);
    }
}

