/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.luis.xbackpack.client.gui.screens.AbstractScrollableContainerScreen;
import net.luis.xbackpack.client.gui.screens.extension.AbstractExtensionScreen;
import net.luis.xbackpack.client.gui.screens.extension.AnvilExtensionScreen;
import net.luis.xbackpack.client.gui.screens.extension.BrewingStandExtensionScreen;
import net.luis.xbackpack.client.gui.screens.extension.CraftingExtensionScreen;
import net.luis.xbackpack.client.gui.screens.extension.EnchantmentTableExtensionScreen;
import net.luis.xbackpack.client.gui.screens.extension.ExtensionScreenHolder;
import net.luis.xbackpack.client.gui.screens.extension.FurnaceExtensionScreen;
import net.luis.xbackpack.client.gui.screens.extension.GrindstoneExtensionScreen;
import net.luis.xbackpack.client.gui.screens.extension.SmithingTableExtensionScreen;
import net.luis.xbackpack.client.gui.screens.extension.StonecutterExtensionScreen;
import net.luis.xbackpack.network.XBackpackNetworkHandler;
import net.luis.xbackpack.network.packet.extension.UpdateBackpackExtension;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.inventory.BackpackMenu;
import net.luis.xbackpack.world.inventory.extension.slot.ExtensionResultSlot;
import net.luis.xbackpack.world.inventory.extension.slot.ExtensionSlot;
import net.luis.xbackpack.world.inventory.slot.MoveableSlot;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BackpackScreen
extends AbstractScrollableContainerScreen<BackpackMenu>
implements ExtensionScreenHolder {
    private static final ResourceLocation BACKPACK = new ResourceLocation("xbackpack", "textures/gui/container/backpack.png");
    public static final ResourceLocation ICONS = new ResourceLocation("xbackpack", "textures/gui/container/backpack_icons.png");
    private final List<BackpackExtension> extensions = List.of((BackpackExtension)BackpackExtension.CRAFTING_TABLE.get(), (BackpackExtension)BackpackExtension.FURNACE.get(), (BackpackExtension)BackpackExtension.ANVIL.get(), (BackpackExtension)BackpackExtension.ENCHANTMENT_TABLE.get(), (BackpackExtension)BackpackExtension.STONECUTTER.get(), (BackpackExtension)BackpackExtension.BREWING_STAND.get(), (BackpackExtension)BackpackExtension.GRINDSTONE.get(), (BackpackExtension)BackpackExtension.SMITHING_TABLE.get());
    private final List<AbstractExtensionScreen> extensionScreens = Lists.newArrayList();
    private BackpackExtension extension = (BackpackExtension)BackpackExtension.NO.get();

    public BackpackScreen(BackpackMenu menu, Inventory inventory, Component titleComponent) {
        super(menu, inventory, titleComponent);
        this.f_96546_ = false;
        this.f_97726_ = 220;
        this.f_97727_ = 220;
        this.f_97730_ += 22;
        this.f_97731_ = 127;
        this.extensionScreens.add(new CraftingExtensionScreen(this, this.extensions));
        this.extensionScreens.add(new FurnaceExtensionScreen(this, this.extensions));
        this.extensionScreens.add(new AnvilExtensionScreen(this, this.extensions));
        this.extensionScreens.add(new EnchantmentTableExtensionScreen(this, this.extensions));
        this.extensionScreens.add(new StonecutterExtensionScreen(this, this.extensions));
        this.extensionScreens.add(new BrewingStandExtensionScreen(this, this.extensions));
        this.extensionScreens.add(new GrindstoneExtensionScreen(this, this.extensions));
        this.extensionScreens.add(new SmithingTableExtensionScreen(this, this.extensions));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.extensionScreens.forEach(extensionScreen -> extensionScreen.init(this.f_96541_, this.f_96542_, this.f_96547_, this.f_97726_, this.f_97727_, this.f_97735_, this.f_97736_));
    }

    @Override
    protected boolean isSlotActive(Slot slot) {
        if (slot instanceof MoveableSlot) {
            MoveableSlot moveableSlot = (MoveableSlot)slot;
            int y = moveableSlot.getY(this.scrollOffset);
            return slot.m_6659_() && 174 >= slot.f_40220_ && slot.f_40220_ >= 30 && 108 >= y && y >= 18;
        }
        if (slot instanceof ExtensionSlot) {
            ExtensionSlot extensionSlot = (ExtensionSlot)slot;
            return this.extension == extensionSlot.getExtension();
        }
        if (slot instanceof ExtensionResultSlot) {
            ExtensionResultSlot extensionSlot = (ExtensionResultSlot)slot;
            return this.extension == extensionSlot.getExtension();
        }
        return slot.m_6659_();
    }

    @Override
    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
    }

    @Override
    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(stack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderExtensions(stack, partialTicks, mouseX, mouseY);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKPACK);
        this.m_93228_(stack, this.f_97735_, this.f_97736_, 0, 0, 238, 220);
        int scrollPosition = this.f_97736_ + 18 + this.scrollOffset;
        this.m_93228_(stack, this.f_97735_ + 198, scrollPosition, 244, 0, 12, 15);
    }

    private void renderExtensions(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        for (BackpackExtension extension : this.extensions) {
            AbstractExtensionScreen extensionScreen = this.getExtensionScreen(extension);
            if (extensionScreen == null) continue;
            if (this.extension == extension && this.extension != BackpackExtension.NO.get()) {
                extensionScreen.renderOpened(stack, partialTicks, mouseX, mouseY);
                continue;
            }
            if (!this.isExtensionRenderable(extension)) continue;
            extensionScreen.render(stack, partialTicks, mouseX, mouseY);
        }
    }

    protected void m_7025_(PoseStack stack, int mouseX, int mouseY) {
        super.m_7025_(stack, mouseX, mouseY);
        AbstractExtensionScreen extensionScreen = this.getExtensionScreen(this.extension);
        if (extensionScreen != null) {
            extensionScreen.renderTooltip(stack, mouseX, mouseY, itemStack -> this.m_6057_(stack, (ItemStack)itemStack, mouseX, mouseY));
        }
    }

    private boolean isExtensionRenderable(BackpackExtension extension) {
        if (this.extension == BackpackExtension.NO.get()) {
            return true;
        }
        if (this.extensions.indexOf(this.extension) > this.extensions.indexOf(extension)) {
            return true;
        }
        return this.getExtensionOffset(extension) > this.getExtensionOffset(this.extension) + this.extension.imageHeight();
    }

    private int getExtensionOffset(BackpackExtension extension) {
        int offset = 3;
        for (BackpackExtension backpackExtension : this.extensions) {
            if (backpackExtension == extension) break;
            offset += extension.iconHeight() + 2;
        }
        return offset;
    }

    @Override
    protected int getScrollbarWidth() {
        return 14;
    }

    @Override
    protected int getScrollbarHeight() {
        return 108;
    }

    @Override
    protected boolean isInScrollbar(double mouseX, double mouseY) {
        double topX = (double)this.f_97735_ + 198.0;
        double topY = (double)this.f_97736_ + 16.0;
        return topX + (double)this.getScrollbarWidth() >= mouseX && mouseX >= topX && topY + (double)this.getScrollbarHeight() >= mouseY && mouseY >= topY;
    }

    @Override
    protected int clampMouseMove(double mouseY) {
        return Mth.m_14045_((int)((int)(mouseY - (double)this.f_97736_ - 25.5)), (int)0, (int)(this.getScrollbarHeight() - 17));
    }

    @Override
    protected int clampMouseScroll(double delta) {
        return Mth.m_14045_((int)((int)((double)this.scrollOffset - delta)), (int)0, (int)(this.getScrollbarHeight() - 17));
    }

    private boolean isInExtension(BackpackExtension extension, double mouseX, double mouseY) {
        if (this.extension == extension || this.isExtensionRenderable(extension)) {
            double topX = this.f_97735_ + this.f_97726_;
            double topY = this.f_97736_ + this.getExtensionOffset(extension);
            if (topX + (double)extension.iconWidth() >= mouseX && mouseX >= topX && topY + (double)extension.iconHeight() >= mouseY && mouseY >= topY) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        AbstractExtensionScreen extensionScreen;
        for (BackpackExtension extension : this.extensions) {
            if (!this.isInExtension(extension, mouseX, mouseY)) continue;
            this.updateExtension(extension);
            break;
        }
        if ((extensionScreen = this.getExtensionScreen(this.extension)) != null && extensionScreen.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        AbstractExtensionScreen extensionScreen = this.getExtensionScreen(this.extension);
        if (extensionScreen != null && extensionScreen.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        AbstractExtensionScreen extensionScreen = this.getExtensionScreen(this.extension);
        if (extensionScreen != null && extensionScreen.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        AbstractExtensionScreen extensionScreen = this.getExtensionScreen(this.extension);
        if (extensionScreen != null && extensionScreen.mouseScrolled(mouseX, mouseY, delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void updateExtension(BackpackExtension extension) {
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        this.extension = this.extension == extension || extension == null ? (BackpackExtension)BackpackExtension.NO.get() : extension;
        XBackpackNetworkHandler.getChannel().sendToServer((Object)new UpdateBackpackExtension(this.extension));
    }

    protected boolean m_7467_(double mouseX, double mouseY, int leftPos, int topPos, int button) {
        int buttonOffset = 21;
        if (this.extension == BackpackExtension.NO.get()) {
            this.f_97726_ += buttonOffset;
            boolean flag = super.m_7467_(mouseX, mouseY, leftPos, topPos, button);
            this.f_97726_ -= buttonOffset;
            return flag;
        }
        if ((double)leftPos > mouseX) {
            return true;
        }
        if ((double)topPos > mouseY) {
            return true;
        }
        if (mouseY > (double)(topPos + this.f_97727_) && (double)(leftPos + this.f_97726_) > mouseX) {
            return true;
        }
        if (mouseX > (double)(leftPos + this.f_97726_)) {
            int extensionOffset = this.getExtensionOffset(this.extension);
            if ((double)(topPos + extensionOffset) > mouseY) {
                return true;
            }
            if (mouseX > (double)(leftPos + this.f_97726_ + this.extension.imageWidth())) {
                return true;
            }
            if (mouseY > (double)(topPos + extensionOffset + this.extension.imageHeight())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<AbstractExtensionScreen> getExtensionScreens() {
        return ImmutableList.copyOf(this.extensionScreens);
    }

    @Override
    public AbstractExtensionScreen getExtensionScreen(BackpackExtension extension) {
        for (AbstractExtensionScreen extensionScreen : this.extensionScreens) {
            if (extensionScreen.getExtension() != extension) continue;
            return extensionScreen;
        }
        return null;
    }
}

