/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.client.gui.screens.extension;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.luis.xbackpack.client.gui.screens.BackpackScreen;
import net.luis.xbackpack.client.gui.screens.extension.AbstractExtensionScreen;
import net.luis.xbackpack.world.capability.IBackpack;
import net.luis.xbackpack.world.capability.XBackpackCapabilities;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.inventory.BackpackMenu;
import net.luis.xbackpack.world.inventory.handler.EnchantingHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentTableExtensionScreen
extends AbstractExtensionScreen {
    private final Enchantment[] enchantments = new Enchantment[3];
    private final int[] enchantmentLevels = new int[3];
    private final int[] enchantingCosts = new int[3];
    private EnchantingHandler handler;
    private int enchantmentSeed = 0;

    public EnchantmentTableExtensionScreen(BackpackScreen screen, List<BackpackExtension> extensions) {
        super(screen, (BackpackExtension)BackpackExtension.ENCHANTMENT_TABLE.get(), extensions);
    }

    @Override
    protected void init() {
        this.handler = ((IBackpack)this.minecraft.f_91074_.getCapability(XBackpackCapabilities.BACKPACK, null).orElseThrow(NullPointerException::new)).getEnchantingHandler();
    }

    @Override
    protected void renderAdditional(PoseStack stack, float partialTicks, int mouseX, int mouseY, boolean open) {
        if (open) {
            for (int row = 0; row < 3; ++row) {
                this.renderRow(stack, mouseX, mouseY, row, this.minecraft.f_91074_, this.enchantments[row], this.enchantmentLevels[row], this.enchantingCosts[row]);
            }
        }
    }

    private void renderRow(PoseStack stack, int mouseX, int mouseY, int row, LocalPlayer player, Enchantment enchantment, int enchantmentLevel, int enchantingCost) {
        if (enchantment != null) {
            int costColor = 0;
            int enchantmentColor = 0;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTexture());
            if (player.f_36078_ >= enchantingCost && this.hasFuel(row) || player.m_150110_().f_35937_) {
                if (this.isHoveringRow(row, mouseX, mouseY)) {
                    this.screen.m_93228_(stack, this.leftPos + this.imageWidth + 47, this.topPos + 97 + row * 19, 136, 38, 78, 19);
                } else {
                    this.screen.m_93228_(stack, this.leftPos + this.imageWidth + 47, this.topPos + 97 + row * 19, 136, 0, 78, 19);
                }
                this.renderLevel(stack, row, true);
                costColor = 8453920;
                enchantmentColor = 6839882;
            } else {
                this.screen.m_93228_(stack, this.leftPos + this.imageWidth + 47, this.topPos + 97 + row * 19, 136, 19, 78, 19);
                this.renderLevel(stack, row, false);
                costColor = 4226832;
                enchantmentColor = 3419941;
            }
            this.renderLabels(stack, row, costColor, enchantmentColor);
        } else {
            this.screen.m_93228_(stack, this.leftPos + this.imageWidth + 47, this.topPos + 97 + row * 19, 136, 19, 78, 19);
        }
    }

    private void renderLevel(PoseStack stack, int row, boolean active) {
        if (active) {
            this.screen.m_93228_(stack, this.leftPos + this.imageWidth + 47, this.topPos + 97 + row * 19, 136 + row * 19, 57, 19, 19);
        } else {
            this.screen.m_93228_(stack, this.leftPos + this.imageWidth + 47, this.topPos + 97 + row * 19, 136 + row * 19, 76, 19, 19);
        }
    }

    private void renderLabels(PoseStack stack, int row, int costColor, int enchantmentColor) {
        String cost = Integer.toString(this.enchantingCosts[row]);
        this.font.m_92750_(stack, cost, (float)(this.leftPos + this.imageWidth + 123 - this.font.m_92895_(cost)), (float)(this.topPos + 106 + 19 * row), costColor);
        int length = 50 - this.font.m_92895_(cost);
        EnchantmentNames.m_98734_().m_98735_((long)(this.enchantmentSeed + row));
        FormattedText enchantmentName = EnchantmentNames.m_98734_().m_98737_(this.font, length);
        this.font.m_92857_(enchantmentName, this.leftPos + this.imageWidth + 67, this.topPos + 99 + 19 * row, length, enchantmentColor);
    }

    @Override
    public void renderTooltip(PoseStack stack, int mouseX, int mouseY, Consumer<ItemStack> tooltipRenderer) {
        for (int row = 0; row < 3; ++row) {
            this.renderTooltip(stack, mouseX, mouseY, row, this.minecraft.f_91074_, this.enchantments[row], this.enchantmentLevels[row], this.enchantingCosts[row]);
        }
    }

    private void renderTooltip(PoseStack stack, int mouseX, int mouseY, int row, LocalPlayer player, Enchantment enchantment, int enchantmentLevel, int enchantingCost) {
        int fuel = this.getFuel();
        int rowIndex = row + 1;
        if (this.isHoveringRow(row, mouseX, mouseY) && enchantingCost > 0) {
            ArrayList components = Lists.newArrayList();
            components.add(Component.m_237110_((String)"container.enchant.clue", (Object[])new Object[]{enchantment == null ? "" : enchantment.m_44700_(enchantmentLevel)}).m_130940_(ChatFormatting.WHITE));
            if (enchantment == null) {
                components.add(CommonComponents.f_237098_);
                components.add(Component.m_237115_((String)"forge.container.enchant.limitedEnchantability").m_130940_(ChatFormatting.RED));
            } else if (!player.m_150110_().f_35937_) {
                components.add(CommonComponents.f_237098_);
                if (enchantmentLevel >= player.f_36078_) {
                    components.add(Component.m_237110_((String)"container.enchant.level.requirement", (Object[])new Object[]{enchantmentLevel}).m_130940_(ChatFormatting.RED));
                } else {
                    MutableComponent mutablecomponent = rowIndex == 1 ? Component.m_237115_((String)"container.enchant.lapis.one") : Component.m_237110_((String)"container.enchant.lapis.many", (Object[])new Object[]{rowIndex});
                    components.add(mutablecomponent.m_130940_(fuel >= rowIndex ? ChatFormatting.GRAY : ChatFormatting.RED));
                    MutableComponent mutablecomponent1 = rowIndex == 1 ? Component.m_237115_((String)"container.enchant.level.one") : Component.m_237110_((String)"container.enchant.level.many", (Object[])new Object[]{rowIndex});
                    components.add(mutablecomponent1.m_130940_(ChatFormatting.GRAY));
                }
            }
            this.screen.m_96597_(stack, components, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.minecraft != null) {
            for (int row = 0; row < 3; ++row) {
                if (!this.isHoveringRow(row, mouseX, mouseY)) continue;
                this.minecraft.f_91072_.m_105208_(((BackpackMenu)this.screen.m_6262_()).f_38840_, row);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean isHoveringRow(int row, double mouseX, double mouseY) {
        int x = this.leftPos + this.imageWidth + 47;
        int y = this.topPos + 97 + row * 19;
        return (double)(x + 77) >= mouseX && mouseX >= (double)x && (double)(y + 18) >= mouseY && mouseY >= (double)y;
    }

    private int getFuel() {
        return this.handler.getFuelHandler().getStackInSlot(0).m_41613_();
    }

    private boolean hasFuel(int row) {
        return this.getFuel() >= row + 1;
    }

    public void update(ResourceLocation[] enchantments, int[] enchantmentLevels, int[] enchantingCosts, int enchantmentSeed) {
        int row;
        for (row = 0; row < this.enchantments.length; ++row) {
            this.enchantments[row] = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantments[row]);
        }
        for (row = 0; row < this.enchantmentLevels.length; ++row) {
            this.enchantmentLevels[row] = enchantmentLevels[row];
        }
        for (row = 0; row < this.enchantingCosts.length; ++row) {
            this.enchantingCosts[row] = enchantingCosts[row];
        }
        this.enchantmentSeed = enchantmentSeed;
    }
}

