/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.inventory.extension;

import java.util.List;
import java.util.function.Consumer;
import net.luis.xbackpack.network.XBackpackNetworkHandler;
import net.luis.xbackpack.network.packet.extension.UpdateEnchantmentTableExtension;
import net.luis.xbackpack.world.capability.IBackpack;
import net.luis.xbackpack.world.capability.XBackpackCapabilities;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.inventory.BackpackMenu;
import net.luis.xbackpack.world.inventory.extension.AbstractExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.slot.ExtensionSlot;
import net.luis.xbackpack.world.inventory.handler.EnchantingHandler;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentTableExtensionMenu
extends AbstractExtensionMenu {
    public static final ResourceLocation EMPTY_ENCHANTMENT = new ResourceLocation("enchantment_empty");
    private final EnchantingHandler handler;
    private final RandomSource rng = RandomSource.m_216327_();
    private final ResourceLocation[] enchantments = new ResourceLocation[]{EMPTY_ENCHANTMENT, EMPTY_ENCHANTMENT, EMPTY_ENCHANTMENT};
    private final int[] enchantmentLevels = new int[]{-1, -1, -1};
    private final int[] enchantingCosts = new int[]{0, 0, 0};
    private int enchantmentSeed;

    public EnchantmentTableExtensionMenu(BackpackMenu menu, Player player) {
        super(menu, player, (BackpackExtension)BackpackExtension.ENCHANTMENT_TABLE.get());
        this.handler = ((IBackpack)this.player.getCapability(XBackpackCapabilities.BACKPACK, null).orElseThrow(NullPointerException::new)).getEnchantingHandler();
        this.enchantmentSeed = player.m_36322_();
    }

    @Override
    public void open() {
        this.slotsChanged();
    }

    @Override
    public void addSlots(Consumer<Slot> consumer) {
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getPowerHandler(), 0, 235, 108){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(Tags.Items.BOOKSHELVES) || stack.m_41720_() instanceof BookItem;
            }
        });
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getInputHandler(), 0, 225, 130){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41792_() || stack.m_41720_() instanceof BookItem;
            }

            public int m_6641_() {
                return 1;
            }
        });
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getFuelHandler(), 0, 245, 130){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(Tags.Items.ENCHANTING_FUELS);
            }
        });
    }

    @Override
    public void slotsChanged() {
        Player player;
        ItemStack inputStack = this.handler.getInputHandler().getStackInSlot(0);
        if (!inputStack.m_41619_() && inputStack.m_41792_()) {
            int row;
            int power = this.calculatePower();
            this.rng.m_188584_((long)this.enchantmentSeed);
            for (row = 0; row < 3; ++row) {
                this.enchantingCosts[row] = EnchantmentHelper.m_220287_((RandomSource)this.rng, (int)row, (int)power, (ItemStack)inputStack);
                this.enchantments[row] = EMPTY_ENCHANTMENT;
                this.enchantmentLevels[row] = -1;
                if (this.enchantingCosts[row] < row + 1) {
                    this.enchantingCosts[row] = 0;
                }
                this.enchantingCosts[row] = ForgeEventFactory.onEnchantmentLevelSet((Level)this.player.f_19853_, (BlockPos)this.player.m_20183_(), (int)row, (int)power, (ItemStack)inputStack, (int)this.enchantingCosts[row]);
            }
            for (row = 0; row < 3; ++row) {
                List<EnchantmentInstance> enchantments;
                if (this.enchantingCosts[row] <= 0 || (enchantments = this.getEnchantmentList(inputStack, row, this.enchantingCosts[row])) == null || enchantments.isEmpty()) continue;
                EnchantmentInstance instance = (EnchantmentInstance)Util.m_214621_(enchantments, (RandomSource)this.rng);
                this.enchantments[row] = ForgeRegistries.ENCHANTMENTS.getKey((Object)instance.f_44947_);
                this.enchantmentLevels[row] = instance.f_44948_;
            }
        } else {
            for (int row = 0; row < 3; ++row) {
                this.enchantingCosts[row] = 0;
                this.enchantments[row] = EMPTY_ENCHANTMENT;
                this.enchantmentLevels[row] = -1;
            }
        }
        if ((player = this.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            XBackpackNetworkHandler.getChannel().send(PacketDistributor.PLAYER.with(() -> player2), (Object)new UpdateEnchantmentTableExtension(this.enchantments, this.enchantmentLevels, this.enchantingCosts, this.enchantmentSeed));
        }
    }

    private int calculatePower() {
        ItemStack stack = this.handler.getPowerHandler().getStackInSlot(0);
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_150930_(Items.f_41997_)) {
            return Mth.m_14045_((int)stack.m_41613_(), (int)0, (int)15);
        }
        if (stack.m_150930_(Items.f_42517_)) {
            return Mth.m_14045_((int)(stack.m_41613_() / 3), (int)0, (int)15);
        }
        return 0;
    }

    @Override
    public boolean clickMenuButton(Player player, int button) {
        if (2 >= button && button >= 0) {
            ItemStack inputStack = this.handler.getInputHandler().getStackInSlot(0);
            ItemStack fuelStack = this.handler.getFuelHandler().getStackInSlot(0);
            int requiredFuel = button + 1;
            if ((fuelStack.m_41619_() || fuelStack.m_41613_() < requiredFuel) && !player.m_150110_().f_35937_) {
                return false;
            }
            if (this.enchantingCosts[button] <= 0 || inputStack.m_41619_() || (player.f_36078_ < requiredFuel || player.f_36078_ < this.enchantingCosts[button]) && !player.m_150110_().f_35937_) {
                return false;
            }
            ItemStack resultStack = inputStack;
            List<EnchantmentInstance> enchantments = this.getEnchantmentList(inputStack, button, this.enchantingCosts[button]);
            if (!enchantments.isEmpty()) {
                player.m_7408_(inputStack, requiredFuel);
                boolean isBook = inputStack.m_150930_(Items.f_42517_);
                if (isBook) {
                    resultStack = new ItemStack((ItemLike)Items.f_42690_);
                    CompoundTag tag = inputStack.m_41783_();
                    if (tag != null) {
                        resultStack.m_41751_(tag.m_6426_());
                    }
                    this.handler.getInputHandler().setStackInSlot(0, resultStack);
                }
                for (int j = 0; j < enchantments.size(); ++j) {
                    EnchantmentInstance enchantment = enchantments.get(j);
                    if (isBook) {
                        EnchantedBookItem.m_41153_((ItemStack)resultStack, (EnchantmentInstance)enchantment);
                        continue;
                    }
                    resultStack.m_41663_(enchantment.f_44947_, enchantment.f_44948_);
                }
                if (!player.m_150110_().f_35937_) {
                    fuelStack.m_41774_(requiredFuel);
                    if (fuelStack.m_41619_()) {
                        this.handler.getFuelHandler().setStackInSlot(0, ItemStack.f_41583_);
                    }
                }
                player.m_36220_(Stats.f_12964_);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10575_.m_27668_(serverPlayer, resultStack, requiredFuel);
                    this.playSound(serverPlayer, serverPlayer.m_9236_());
                }
                this.enchantmentSeed = player.m_36322_();
                this.slotsChanged();
            }
            return true;
        }
        Util.m_143785_((String)(player.m_7755_() + " pressed invalid button id: " + button));
        return false;
    }

    private List<EnchantmentInstance> getEnchantmentList(ItemStack inputStack, int row, int enchantingCost) {
        this.rng.m_188584_((long)(this.enchantmentSeed + row));
        List enchantments = EnchantmentHelper.m_220297_((RandomSource)this.rng, (ItemStack)inputStack, (int)enchantingCost, (boolean)false);
        if (inputStack.m_150930_(Items.f_42517_) && enchantments.size() > 1) {
            enchantments.remove(this.rng.m_188503_(enchantments.size()));
        }
        return enchantments;
    }

    private void playSound(ServerPlayer player, ServerLevel level) {
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(SoundEvents.f_11887_, SoundSource.BLOCKS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f, level.f_46441_.m_188505_()));
    }
}

