/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.inventory.handler.progress;

import java.util.List;
import java.util.Optional;
import net.luis.xbackpack.network.XBackpackNetworkHandler;
import net.luis.xbackpack.network.packet.extension.UpdateFurnaceExtension;
import net.luis.xbackpack.world.inventory.handler.SmeltingHandler;
import net.luis.xbackpack.world.inventory.handler.progress.ProgressHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;

public class SmeltingProgressHandler
implements ProgressHandler {
    private final Player player;
    private final SmeltingHandler handler;
    private final List<RecipeType<? extends AbstractCookingRecipe>> recipeTypes;
    private int cookingProgress;
    private int cookingTime;
    private AbstractCookingRecipe progressingRecipe;
    private int fuelTime;
    private int maxFuel;

    public SmeltingProgressHandler(Player player, SmeltingHandler handler, List<RecipeType<? extends AbstractCookingRecipe>> recipeTypes) {
        this.player = player;
        this.handler = handler;
        this.recipeTypes = recipeTypes;
    }

    @Override
    public void tick() {
        AbstractCookingRecipe progressingRecipe;
        ItemStack stack;
        int oldcookingProgress = this.getCookingProgress();
        int oldFuelTime = this.getFuelProgress();
        this.checkRecipe();
        this.forceStorages();
        if (this.fuelTime > 0) {
            --this.fuelTime;
        }
        this.checkFuel();
        if (this.progressingRecipe == null && !this.getInputItem().m_41619_() && this.canSmelt(stack = this.getInputItem())) {
            this.progressingRecipe = this.getRecipe(stack);
            if (this.progressingRecipe != null) {
                this.cookingTime = this.progressingRecipe.m_43753_();
                this.cookingProgress = 0;
            }
        }
        if ((progressingRecipe = this.progressingRecipe) != null) {
            if (this.getInputItem().m_41619_()) {
                this.resetRecipe();
                this.broadcastChanges();
            } else if (this.fuelTime > 0) {
                ++this.cookingProgress;
            } else if (this.cookingProgress > 0) {
                --this.cookingProgress;
            }
            if (this.cookingProgress >= this.cookingTime && !this.handler.getInputHandler().extractItem(0, 1, false).m_41619_()) {
                ItemStack stack2 = this.handler.getResultHandler().insertItem(0, progressingRecipe.m_5874_((Container)new SimpleContainer(new ItemStack[0])), false);
                if (!stack2.m_41619_()) {
                    this.player.m_7197_(stack2, true, true);
                }
                this.giveExperience();
                this.resetRecipe();
                this.broadcastChanges();
            }
        }
        if (oldcookingProgress != this.getCookingProgress() || oldFuelTime != this.getFuelProgress()) {
            this.broadcastChanges();
        }
    }

    private void checkRecipe() {
        if (this.cookingProgress > 0 && this.cookingTime > 0 && this.progressingRecipe == null) {
            this.progressingRecipe = this.getRecipe(this.getInputItem());
            this.broadcastChanges();
        } else if (this.progressingRecipe == null) {
            this.resetRecipe();
        }
    }

    private void forceStorages() {
        this.forceInputStorage();
        this.forceResultStorage();
    }

    private void forceInputStorage() {
        ItemStackHandler handler = this.getInputStorage();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack input;
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            if (this.getInputItem().m_41619_()) {
                this.handler.getInputHandler().setStackInSlot(0, stack);
                handler.setStackInSlot(i, ItemStack.f_41583_);
            } else if (this.areMergable(this.getInputItem(), stack)) {
                input = this.getInputItem();
                int count = input.m_41613_() + stack.m_41613_();
                input.m_41764_(Math.min(count, input.m_41741_()));
                this.handler.getInputHandler().setStackInSlot(0, input);
                handler.setStackInSlot(i, ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)Math.max(count - input.m_41741_(), 0)));
            }
            input = this.getInputItem();
            if (input.m_41613_() >= input.m_41741_()) break;
        }
    }

    private void forceResultStorage() {
        ItemStack result;
        ItemStackHandler handler = this.getResultStorage();
        for (int i = 0; i < handler.getSlots() && !(result = this.getResultItem()).m_41619_(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_()) {
                handler.setStackInSlot(i, result);
                this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
                continue;
            }
            if (!this.areMergable(stack, result)) continue;
            int count = stack.m_41613_() + result.m_41613_();
            int remaining = Math.min(count, stack.m_41741_());
            result.m_41764_(Math.max(count - stack.m_41741_(), 0));
            this.handler.getResultHandler().setStackInSlot(0, result);
            handler.setStackInSlot(i, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remaining));
        }
    }

    private boolean areMergable(ItemStack toStack, ItemStack stack) {
        if (toStack.m_41613_() >= toStack.m_41741_()) {
            return false;
        }
        if (!toStack.m_150930_(stack.m_41720_())) {
            return false;
        }
        if (toStack.m_41782_() ^ stack.m_41782_()) {
            return false;
        }
        if (!toStack.areCapsCompatible((CapabilityProvider)stack)) {
            return false;
        }
        return !toStack.m_41782_() || toStack.m_41783_().equals((Object)stack.m_41783_());
    }

    private void checkFuel() {
        int fuelTime;
        if (0 >= this.fuelTime && !this.getInputItem().m_41619_() && (fuelTime = this.getFuelTime(this.getFuelItem())) > 0) {
            this.consumeFuel(fuelTime);
        }
    }

    private void consumeFuel(int fuelTime) {
        ItemStack stack = this.handler.getFuelHandler().extractItem(0, 1, false);
        if (!stack.m_41619_()) {
            if (this.getFuelItem().m_41619_() && stack.hasCraftingRemainingItem()) {
                this.handler.getFuelHandler().insertItem(0, stack.getCraftingRemainingItem(), false);
            }
            this.maxFuel = fuelTime;
            this.fuelTime = fuelTime;
        }
    }

    private void giveExperience() {
        RandomSource rng = this.player.m_217043_();
        float experience = this.progressingRecipe != null ? this.progressingRecipe.m_43750_() : rng.m_188501_() + rng.m_188501_();
        int usedRecipes = rng.m_188503_(3);
        this.player.m_6756_((int)(experience * (float)usedRecipes));
    }

    private void resetRecipe() {
        this.cookingProgress = 0;
        this.cookingTime = 0;
        this.progressingRecipe = null;
    }

    private AbstractCookingRecipe getRecipe(ItemStack stack) {
        AbstractCookingRecipe cookingRecipe = null;
        for (RecipeType<? extends AbstractCookingRecipe> recipeType : this.recipeTypes) {
            Optional optional = this.player.f_19853_.m_7465_().m_44015_(recipeType, (Container)new SimpleContainer(new ItemStack[]{stack}), this.player.f_19853_);
            if (!optional.isPresent()) continue;
            AbstractCookingRecipe recipe = (AbstractCookingRecipe)optional.get();
            if (cookingRecipe == null) {
                cookingRecipe = recipe;
                continue;
            }
            if (cookingRecipe.m_43753_() <= recipe.m_43753_()) continue;
            cookingRecipe = recipe;
        }
        return cookingRecipe;
    }

    private boolean canSmelt(ItemStack stack) {
        return 0 >= this.cookingProgress && 0 >= this.cookingTime && this.fuelTime > 0 && this.canProgress(stack);
    }

    private boolean canProgress(ItemStack stack) {
        AbstractCookingRecipe recipe = this.getRecipe(stack);
        if (recipe != null) {
            return ItemEntity.m_32026_((ItemStack)recipe.m_8043_(), (ItemStack)this.getResultItem()) || this.getResultItem().m_41619_();
        }
        return false;
    }

    private int getFuelTime(ItemStack stack) {
        int fuelTime = 0;
        for (RecipeType<? extends AbstractCookingRecipe> recipeType : this.recipeTypes) {
            fuelTime = Math.max(ForgeHooks.getBurnTime((ItemStack)stack, recipeType), fuelTime);
        }
        return fuelTime;
    }

    public ItemStack getInputItem() {
        return this.handler.getInputHandler().getStackInSlot(0);
    }

    public ItemStack getFuelItem() {
        return this.handler.getFuelHandler().getStackInSlot(0);
    }

    public ItemStack getResultItem() {
        return this.handler.getResultHandler().getStackInSlot(0);
    }

    public ItemStackHandler getInputStorage() {
        return this.handler.getInputStorageHandler();
    }

    public ItemStackHandler getResultStorage() {
        return this.handler.getResultStorageHandler();
    }

    public int getCookingProgress() {
        int cookingProgress = this.cookingProgress;
        int cookingTime = this.cookingTime;
        return cookingTime != 0 && cookingProgress != 0 ? cookingProgress * 24 / cookingTime : 0;
    }

    public int getFuelProgress() {
        int maxFuel = this.maxFuel == 0 ? 200 : this.maxFuel;
        return this.fuelTime * 13 / maxFuel;
    }

    @Override
    public void broadcastChanges() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            XBackpackNetworkHandler.getChannel().send(PacketDistributor.PLAYER.with(() -> player2), (Object)new UpdateFurnaceExtension(this.getCookingProgress(), this.getFuelProgress()));
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("cooking_progress", this.cookingProgress);
        tag.m_128405_("cooking_time", this.cookingTime);
        tag.m_128405_("fuel_time", this.fuelTime);
        tag.m_128405_("max_fuel", this.maxFuel);
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.cookingProgress = tag.m_128451_("cooking_progress");
        this.cookingTime = tag.m_128451_("cooking_time");
        this.fuelTime = tag.m_128451_("fuel_time");
        this.maxFuel = tag.m_128451_("max_fuel");
    }
}

